/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.util.ArrayList;
import org.apache.xml.security.signature.XMLSignature;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xades4j.production.SignerTestBase;
import xades4j.production.XadesBesSigningProfile;
import xades4j.production.XadesFormatExtenderProfile;
import xades4j.production.XadesSignatureFormatExtender;
import xades4j.production.XadesSignatureFormatExtenderImpl;
import xades4j.production.XadesSigner;
import xades4j.properties.ArchiveTimeStampProperty;
import xades4j.properties.CounterSignatureProperty;
import xades4j.properties.SignatureTimeStampProperty;
import xades4j.properties.UnsignedProperties;
import xades4j.properties.UnsignedSignatureProperty;

public class XadesSignatureFormatExtenderImplTest
extends SignerTestBase {
    @Test
    public void testEnrichSignatureWithNestedCounterSig() throws Exception {
        System.out.println("enrichSignatureWithNestedCounterSig");
        Document doc = XadesSignatureFormatExtenderImplTest.getDocument("document.signed.bes.cs.xml");
        NodeList signatures = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        Element signatureNode = (Element)signatures.item(signatures.getLength() - 1);
        XadesSigner signer = new XadesBesSigningProfile(keyingProviderMy).newSigner();
        XadesSignatureFormatExtender extender = new XadesFormatExtenderProfile().getFormatExtender();
        XMLSignature sig = new XMLSignature(signatureNode, signatureNode.getOwnerDocument().getBaseURI());
        ArrayList<UnsignedSignatureProperty> usp = new ArrayList<UnsignedSignatureProperty>(1);
        usp.add(new CounterSignatureProperty(signer));
        extender.enrichSignature(sig, new UnsignedProperties(usp));
        XadesSignatureFormatExtenderImplTest.outputDocument(doc, "document.signed.bes.cs.cs.xml");
    }

    @Test
    public void testEnrichSignatureWithT() throws Exception {
        System.out.println("enrichSignatureWithT");
        Document doc = XadesSignatureFormatExtenderImplTest.getDocument("document.signed.bes.xml");
        Element signatureNode = (Element)doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        XadesSignatureFormatExtenderImpl instance = (XadesSignatureFormatExtenderImpl)new XadesFormatExtenderProfile().getFormatExtender();
        XMLSignature sig = new XMLSignature(signatureNode, "");
        ArrayList<UnsignedSignatureProperty> usp = new ArrayList<UnsignedSignatureProperty>(1);
        usp.add(new SignatureTimeStampProperty());
        instance.enrichSignature(sig, new UnsignedProperties(usp));
        XadesSignatureFormatExtenderImplTest.outputDocument(doc, "document.signed.bes.enriched.t.xml");
    }

    @Test
    public void testEnrichSignatureWithA() throws Exception {
        System.out.println("enrichSignatureWithA");
        Document doc = XadesSignatureFormatExtenderImplTest.getDocument("document.verified.c.xl.xml");
        Element signatureNode = (Element)doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        XadesSignatureFormatExtenderImpl instance = (XadesSignatureFormatExtenderImpl)new XadesFormatExtenderProfile().getFormatExtender();
        XMLSignature sig = new XMLSignature(signatureNode, "");
        ArrayList<UnsignedSignatureProperty> usp = new ArrayList<UnsignedSignatureProperty>(1);
        usp.add(new ArchiveTimeStampProperty());
        instance.enrichSignature(sig, new UnsignedProperties(usp));
        XadesSignatureFormatExtenderImplTest.outputDocument(doc, "document.verified.c.xl.a.xml");
    }
}

