/*
 * Decompiled with CFR 0.152.
 */
package xades4j.properties;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import xades4j.properties.DataObjectDesc;
import xades4j.properties.PropertyTargetException;
import xades4j.properties.QualifyingProperty;

public abstract class DataObjectProperty
implements QualifyingProperty {
    private final Set<DataObjectDesc> targetDataObjs;
    private final TargetMultiplicity targetMultiplicity;

    protected DataObjectProperty(TargetMultiplicity targetMultiplicity) {
        if (targetMultiplicity == null) {
            throw new NullPointerException("Target multiplicity cannot be null");
        }
        this.targetMultiplicity = targetMultiplicity;
        this.targetDataObjs = new HashSet<DataObjectDesc>(targetMultiplicity.initialSize);
    }

    @Override
    public final boolean isSignature() {
        return false;
    }

    void appliesTo(DataObjectDesc dataObj) {
        if (dataObj == null) {
            throw new NullPointerException("Data object description cannot be null");
        }
        if (this.targetDataObjs.size() == this.targetMultiplicity.multiplicity) {
            throw new PropertyTargetException("Property cannot be applied to more data objects");
        }
        if (!this.targetDataObjs.add(dataObj)) {
            throw new PropertyTargetException("Property already applied to the specified data object");
        }
    }

    public Collection<DataObjectDesc> getTargetDataObjects() {
        if (this.targetDataObjs.isEmpty()) {
            throw new PropertyTargetException("Property wasn't applied to any data objects");
        }
        return Collections.unmodifiableCollection(this.targetDataObjs);
    }

    protected static enum TargetMultiplicity {
        ALL(0),
        ONE(1),
        N(Integer.MAX_VALUE, 2);

        private final int multiplicity;
        private final int initialSize;

        private TargetMultiplicity(int mult) {
            this(mult, mult);
        }

        private TargetMultiplicity(int mult, int size) {
            this.multiplicity = mult;
            this.initialSize = size;
        }
    }
}

