/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import java.io.FileInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import xades4j.providers.impl.DirectPasswordProvider;
import xades4j.providers.impl.FileSystemKeyStoreKeyingDataProvider;
import xades4j.providers.impl.FirstCertificateSelector;
import xades4j.utils.SignatureServicesTestBase;

public class FileSystemKeyStoreKeyingDataProviderTest {
    FileSystemKeyStoreKeyingDataProvider keyingProvider;
    X509Certificate signCert;

    @Before
    public void setUp() throws Exception {
        this.keyingProvider = new FileSystemKeyStoreKeyingDataProvider("pkcs12", SignatureServicesTestBase.toPlatformSpecificCertDirFilePath("my/LG.pfx"), new FirstCertificateSelector(), new DirectPasswordProvider("mykeypass"), new DirectPasswordProvider("mykeypass"), true);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        this.signCert = (X509Certificate)cf.generateCertificate(new FileInputStream(SignatureServicesTestBase.toPlatformSpecificCertDirFilePath("my/LG.cer")));
    }

    @Test
    public void testGetSigningKey() throws Exception {
        this.keyingProvider.getSigningKey(this.signCert);
    }

    @Test
    public void testGetSigningCertificateChain() throws Exception {
        List<X509Certificate> certChain = this.keyingProvider.getSigningCertificateChain();
        Assert.assertEquals((long)certChain.size(), (long)3L);
        Assert.assertEquals((Object)certChain.get(0), (Object)this.signCert);
    }
}

