/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import com.google.inject.Inject;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.providers.TimeStampTokenGenerationException;
import xades4j.providers.impl.AbstractTimeStampTokenProvider;
import xades4j.providers.impl.TSAHttpData;
import xades4j.utils.Base64;

public class HttpTimeStampTokenProvider
extends AbstractTimeStampTokenProvider {
    private final TSAHttpData tsaHttpData;
    private final String base64TsaUsrAndPwd;

    @Inject
    public HttpTimeStampTokenProvider(MessageDigestEngineProvider messageDigestProvider, TSAHttpData tsaHttpData) {
        super(messageDigestProvider);
        this.tsaHttpData = tsaHttpData;
        if (tsaHttpData.getUsername() != null) {
            String usrAndPwd = String.valueOf(tsaHttpData.getUsername()) + ":" + tsaHttpData.getPassword();
            this.base64TsaUsrAndPwd = Base64.encodeBytes(usrAndPwd.getBytes());
        } else {
            this.base64TsaUsrAndPwd = null;
        }
    }

    @Override
    protected byte[] getResponse(byte[] encodedRequest) throws TimeStampTokenGenerationException {
        HttpURLConnection connection = null;
        try {
            byte[] byArray;
            block12: {
                connection = this.createHttpConnection();
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-type", "application/timestamp-query");
                connection.setRequestProperty("Content-length", String.valueOf(encodedRequest.length));
                OutputStream out = connection.getOutputStream();
                out.write(encodedRequest);
                out.flush();
                if (connection.getResponseCode() != 200) {
                    throw new TimeStampTokenGenerationException(String.format("TSA returned HTTP %d %s", connection.getResponseCode(), connection.getResponseMessage()));
                }
                BufferedInputStream input = null;
                try {
                    int len;
                    input = new BufferedInputStream(connection.getInputStream());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((len = input.read(buffer)) > -1) {
                        baos.write(buffer, 0, len);
                    }
                    baos.flush();
                    byArray = baos.toByteArray();
                    if (input == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new TimeStampTokenGenerationException("Error when connecting to the TSA", ex);
                    }
                }
                input.close();
            }
            return byArray;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private HttpURLConnection createHttpConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.temporaryGetTSAUrl()).openConnection();
        if (this.base64TsaUsrAndPwd != null) {
            connection.setRequestProperty("Authorization", "Basic " + this.base64TsaUsrAndPwd);
        }
        return connection;
    }

    String temporaryGetTSAUrl() {
        return this.tsaHttpData.getUrl();
    }
}

