/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import xades4j.providers.impl.KeyStoreKeyingDataProvider;

public class PKCS11KeyStoreKeyingDataProvider
extends KeyStoreKeyingDataProvider {
    public PKCS11KeyStoreKeyingDataProvider(String nativeLibraryPath, String providerName, KeyStoreKeyingDataProvider.SigningCertSelector certificateSelector, KeyStoreKeyingDataProvider.KeyStorePasswordProvider keyStorePasswordProvider, KeyStoreKeyingDataProvider.KeyEntryPasswordProvider entryPasswordProvider, boolean returnFullChain) throws KeyStoreException {
        this(nativeLibraryPath, providerName, null, certificateSelector, keyStorePasswordProvider, entryPasswordProvider, returnFullChain);
    }

    public PKCS11KeyStoreKeyingDataProvider(final String nativeLibraryPath, final String providerName, final Integer slotId, KeyStoreKeyingDataProvider.SigningCertSelector certificateSelector, KeyStoreKeyingDataProvider.KeyStorePasswordProvider keyStorePasswordProvider, KeyStoreKeyingDataProvider.KeyEntryPasswordProvider entryPasswordProvider, boolean returnFullChain) throws KeyStoreException {
        super(new KeyStoreKeyingDataProvider.KeyStoreBuilderCreator(){

            @Override
            public KeyStore.Builder getBuilder(KeyStore.ProtectionParameter loadProtection) {
                Provider p = PKCS11KeyStoreKeyingDataProvider.getInstalledProvider(providerName);
                if (p == null) {
                    StringBuilder config = new StringBuilder("name = ").append(providerName);
                    config.append(System.getProperty("line.separator"));
                    config.append("library = ").append(nativeLibraryPath);
                    if (slotId != null) {
                        config.append(System.getProperty("line.separator"));
                        config.append("slot = ").append(slotId);
                    }
                    ByteArrayInputStream configStream = new ByteArrayInputStream(config.toString().getBytes());
                    p = PKCS11KeyStoreKeyingDataProvider.createPkcs11Provider(configStream);
                    Security.addProvider(p);
                }
                return KeyStore.Builder.newInstance("PKCS11", p, loadProtection);
            }
        }, certificateSelector, keyStorePasswordProvider, entryPasswordProvider, returnFullChain);
    }

    public PKCS11KeyStoreKeyingDataProvider(String nativeLibraryPath, String providerName, Integer slotId, KeyStoreKeyingDataProvider.SigningCertSelector certificateSelector) throws KeyStoreException {
        this(nativeLibraryPath, providerName, slotId, certificateSelector, null, null, false);
    }

    public PKCS11KeyStoreKeyingDataProvider(String nativeLibraryPath, String providerName, KeyStoreKeyingDataProvider.SigningCertSelector certificateSelector) throws KeyStoreException {
        this(nativeLibraryPath, providerName, null, certificateSelector);
    }

    @Override
    protected final KeyStore.ProtectionParameter getKeyProtection(final String entryAlias, final X509Certificate entryCert, final KeyStoreKeyingDataProvider.KeyEntryPasswordProvider entryPasswordProvider) {
        if (entryPasswordProvider == null) {
            return null;
        }
        return new KeyStore.CallbackHandlerProtection(new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                PasswordCallback c = (PasswordCallback)callbacks[0];
                c.setPassword(entryPasswordProvider.getPassword(entryAlias, entryCert));
            }
        });
    }

    private static Provider getInstalledProvider(String providerName) {
        Class pkcs11Class = PKCS11KeyStoreKeyingDataProvider.getPkcs11ProviderClass();
        Provider p = Security.getProvider("SunPKCS11-" + providerName);
        return (Provider)pkcs11Class.cast(p);
    }

    private static Provider createPkcs11Provider(InputStream configStream) {
        try {
            Class providerClass = PKCS11KeyStoreKeyingDataProvider.getPkcs11ProviderClass();
            Constructor ctor = providerClass.getConstructor(InputStream.class);
            return (Provider)ctor.newInstance(configStream);
        }
        catch (IllegalAccessException ex) {
            throw new ProviderException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ProviderException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ProviderException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ProviderException(ex);
        }
        catch (InstantiationException ex) {
            throw new ProviderException(ex);
        }
    }

    private static Class getPkcs11ProviderClass() {
        try {
            return Class.forName("sun.security.pkcs11.SunPKCS11");
        }
        catch (ClassNotFoundException ex) {
            throw new ProviderException("Cannot find SunPKCS11 provider", ex);
        }
    }

    public static boolean isProviderAvailable() {
        try {
            PKCS11KeyStoreKeyingDataProvider.getPkcs11ProviderClass();
            return true;
        }
        catch (ProviderException ex) {
            return false;
        }
    }
}

