/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xades4j.production.Enveloped;
import xades4j.production.PtCcAlgorithmsProvider;
import xades4j.production.SignerTestBase;
import xades4j.production.XadesBesSigningProfile;
import xades4j.production.XadesSigner;
import xades4j.providers.KeyingDataProvider;
import xades4j.providers.impl.FirstCertificateSelector;
import xades4j.providers.impl.PKCS11KeyStoreKeyingDataProvider;

public class PKCS11KeyStoreKeyingDataProviderTest
extends SignerTestBase {
    private static final int N_RETRIES = 3;

    @Test
    public void testCertAndKeyMatch() throws Exception {
        System.out.println("certAndKeyMatch");
        PKCS11KeyStoreKeyingDataProviderTest.assumePtCcPkcs11OnWindows();
        PKCS11KeyStoreKeyingDataProvider ptccKeyingDataProv = new PKCS11KeyStoreKeyingDataProvider(PTCC_PKCS11_LIB_PATH, "PT_CC", new FirstCertificateSelector());
        this.doTestWithJCA(ptccKeyingDataProv);
        ptccKeyingDataProv = new PKCS11KeyStoreKeyingDataProvider(PTCC_PKCS11_LIB_PATH, "PT_CC", new FirstCertificateSelector());
        this.doTestWithXades4j(ptccKeyingDataProv);
    }

    private void doTestWithJCA(KeyingDataProvider keyingDataProvider) throws Exception {
        int i = 0;
        while (i < 3) {
            List<X509Certificate> certChain = keyingDataProvider.getSigningCertificateChain();
            Assert.assertNotNull(certChain);
            Assert.assertEquals((long)1L, (long)certChain.size());
            X509Certificate cert = certChain.get(0);
            PrivateKey key = keyingDataProvider.getSigningKey(cert);
            Signature signatureProdEngine = Signature.getInstance("SHA1with" + key.getAlgorithm());
            signatureProdEngine.initSign(key);
            byte[] signatureData = UUID.randomUUID().toString().getBytes();
            signatureProdEngine.update(signatureData);
            byte[] signatureValue = signatureProdEngine.sign();
            Signature signatureVerifEngine = Signature.getInstance("SHA1with" + key.getAlgorithm());
            signatureVerifEngine.initVerify(cert);
            signatureVerifEngine.update(signatureData);
            Assert.assertTrue((boolean)signatureVerifEngine.verify(signatureValue));
            ++i;
        }
    }

    private void doTestWithXades4j(KeyingDataProvider keyingDataProvider) throws Exception {
        XadesSigner signer = new XadesBesSigningProfile(keyingDataProvider).withAlgorithmsProviderEx(PtCcAlgorithmsProvider.class).newSigner();
        int i = 0;
        while (i < 3) {
            Document doc = PKCS11KeyStoreKeyingDataProviderTest.getTestDocument();
            Element elemToSign = doc.getDocumentElement();
            new Enveloped(signer).sign(elemToSign);
            ++i;
        }
    }
}

