/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import com.google.inject.Inject;
import xades4j.UnsupportedAlgorithmException;
import xades4j.algorithms.Algorithm;
import xades4j.utils.CanonicalizerUtils;
import xades4j.utils.TimeStampDigestInput;
import xades4j.utils.TimeStampDigestInputFactory;
import xades4j.utils.TimeStampDigestInputImpl;
import xades4j.xml.marshalling.algorithms.AlgorithmsParametersMarshallingProvider;

class TimeStampDigestInputFactoryImpl
implements TimeStampDigestInputFactory {
    private final AlgorithmsParametersMarshallingProvider parametersMarshallingProvider;

    @Inject
    TimeStampDigestInputFactoryImpl(AlgorithmsParametersMarshallingProvider parametersMarshallingProvider) {
        this.parametersMarshallingProvider = parametersMarshallingProvider;
    }

    @Override
    public TimeStampDigestInput newTimeStampDigestInput(Algorithm c14n) throws UnsupportedAlgorithmException {
        if (c14n == null) {
            throw new NullPointerException("Canonicalization algorithm cannot be null");
        }
        CanonicalizerUtils.checkC14NAlgorithm(c14n);
        return new TimeStampDigestInputImpl(c14n, this.parametersMarshallingProvider);
    }
}

