/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import com.google.inject.Inject;
import xades4j.properties.IndividualDataObjsTimeStampProperty;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.data.IndividualDataObjsTimeStampData;
import xades4j.providers.TimeStampVerificationProvider;
import xades4j.utils.CannotAddDataToDigestInputException;
import xades4j.utils.TimeStampDigestInput;
import xades4j.utils.TimeStampDigestInputFactory;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.RawDataObjectDesc;
import xades4j.verification.TimeStampDigestInputException;
import xades4j.verification.TimeStampVerificationException;
import xades4j.verification.TimeStampVerifierBase;

class IndivDataObjsTimeStampVerifier
extends TimeStampVerifierBase<IndividualDataObjsTimeStampData> {
    @Inject
    public IndivDataObjsTimeStampVerifier(TimeStampVerificationProvider timeStampVerifier, TimeStampDigestInputFactory timeStampDigestInputFactory) {
        super(timeStampVerifier, timeStampDigestInputFactory, "IndividualDataObjectsTimeStamp");
    }

    @Override
    protected QualifyingProperty addPropSpecificTimeStampInputAndCreateProperty(IndividualDataObjsTimeStampData propData, TimeStampDigestInput digestInput, QualifyingPropertyVerificationContext ctx) throws CannotAddDataToDigestInputException, TimeStampVerificationException {
        QualifyingPropertyVerificationContext.SignedObjectsData dataObjsData = ctx.getSignedObjectsData();
        IndividualDataObjsTimeStampProperty prop = new IndividualDataObjsTimeStampProperty();
        for (String objRef : propData.getIncludes()) {
            RawDataObjectDesc o = dataObjsData.findSignedDataObject(objRef);
            if (o == null) {
                throw new TimeStampDigestInputException("IndividualDataObjectsTimeStamp");
            }
            digestInput.addReference(o.getReference());
            o.withDataObjectTimeStamp(prop);
        }
        return prop;
    }
}

