/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

public enum XAdESForm {
    BES("BES", "Basic electronic signature"),
    EPES("EPES", "Explicit policy electronic signature"),
    T("T", "Electronic signature with time"),
    C("C", "Electronic signature with complete validation data references"),
    X("X", "Extended signatures with time forms"),
    X_L("X-L", "Extended long electronic signatures with time"),
    A("A", "Archival electronic signatures");

    private final String alias;
    private final String fullName;

    private XAdESForm(String alias, String fullName) {
        this.alias = alias;
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean before(XAdESForm f) {
        return this.ordinal() < f.ordinal();
    }

    public boolean after(XAdESForm f) {
        return this.ordinal() > f.ordinal();
    }

    public String toString() {
        return "XAdES-" + this.alias;
    }
}

