/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.security.KeyStore;
import java.security.cert.CertStore;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import xades4j.providers.CannotSelectCertificateException;
import xades4j.providers.impl.PKIXCertificateValidationProvider;
import xades4j.verification.CompleteCertRefsCertNotFoundException;
import xades4j.verification.InvalidXAdESFormException;
import xades4j.verification.QualifyingPropertiesIncorporationException;
import xades4j.verification.ReferenceValueException;
import xades4j.verification.SignatureValueException;
import xades4j.verification.TimeStampDigestMismatchException;
import xades4j.verification.VerifierTestBase;
import xades4j.verification.XadesVerificationProfile;

public class XadesVerifierErrorsTest
extends VerifierTestBase {
    XadesVerificationProfile mySigsVerificationProfile;
    XadesVerificationProfile nistVerificationProfile;

    @Before
    public void initialize() {
        this.mySigsVerificationProfile = new XadesVerificationProfile(VerifierTestBase.validationProviderMySigs);
        this.nistVerificationProfile = new XadesVerificationProfile(VerifierTestBase.validationProviderNist);
    }

    @Test(expected=QualifyingPropertiesIncorporationException.class)
    public void testErrVerifySignedPropsIncorp() throws Exception {
        System.out.println("errVerifySignedPropsIncorp");
        XadesVerifierErrorsTest.verifyBadSignature("document.signed.t.bes.badsignedprops.xml", this.mySigsVerificationProfile);
    }

    @Test(expected=QualifyingPropertiesIncorporationException.class)
    public void testErrVerifySignedPropsIncorpNoRefType() throws Exception {
        System.out.println("errVerifySignedPropsIncorpNoRefType");
        Assume.assumeTrue((XadesVerifierErrorsTest.onWindowsPlatform() && validationProviderPtCc != null ? 1 : 0) != 0);
        XadesVerifierErrorsTest.verifyBadSignature("document.signed.bes.signedpropsrefnotype.xml", new XadesVerificationProfile(validationProviderPtCc));
    }

    @Test(expected=InvalidXAdESFormException.class)
    public void testErrVerifyIncorrectC() throws Exception {
        System.out.println("errVerifyIncorrectC");
        XadesVerifierErrorsTest.verifyBadSignature("document.signed.c.bad.xml", this.nistVerificationProfile);
    }

    @Test(expected=CannotSelectCertificateException.class)
    public void testErrVerifyNoSignCert() throws Exception {
        System.out.println("ErrVerifyNoSignCert");
        KeyStore ks = XadesVerifierErrorsTest.createAndLoadJKSKeyStore("be/beStore", "bestorepass");
        PKIXCertificateValidationProvider cvp = new PKIXCertificateValidationProvider(ks, false, new CertStore[0]);
        XadesVerifierErrorsTest.verifyBadSignature("TSL_BE.nocert.xml", new XadesVerificationProfile(cvp));
    }

    @Test(expected=ReferenceValueException.class)
    public void testErrVerifyChangedDataObj() throws Exception {
        System.out.println("errVerifyChangedDataObj");
        XadesVerifierErrorsTest.verifyBadSignature("document.signed.bes.invaliddataobj.xml", this.mySigsVerificationProfile);
    }

    @Test(expected=SignatureValueException.class)
    public void testErrVerifyChangedSigValue() throws Exception {
        System.out.println("errVerifyChangedSigValue");
        XadesVerifierErrorsTest.verifyBadSignature("document.signed.bes.invalidsigvalue.xml", this.mySigsVerificationProfile);
    }

    @Test(expected=CompleteCertRefsCertNotFoundException.class)
    public void testErrVerifyCMissingCertRef() throws Exception {
        System.out.println("errVerifyCMissingCertRef");
        XadesVerifierErrorsTest.verifyBadSignature("document.signed.c.missingcertref.xml", this.nistVerificationProfile);
    }

    @Test(expected=TimeStampDigestMismatchException.class)
    public void testErrVerifyUnmatchSigTSDigest() throws Exception {
        System.out.println("errVerifyUnmatchSigTSDigest");
        XadesVerifierErrorsTest.verifyBadSignature("document.signed.t.bes.badtsdigest.xml", this.mySigsVerificationProfile);
    }

    private static void verifyBadSignature(String sigFileName, XadesVerificationProfile p) throws Exception {
        XadesVerifierErrorsTest.verifySignature("bad/" + sigFileName, p);
    }
}

