/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.marshalling;

import java.util.EnumMap;
import java.util.List;
import xades4j.properties.IdentifierType;
import xades4j.properties.ObjectIdentifier;
import xades4j.properties.data.BaseCertRefsData;
import xades4j.properties.data.CertRef;
import xades4j.xml.bind.xades.XmlCertIDListType;
import xades4j.xml.bind.xades.XmlCertIDType;
import xades4j.xml.bind.xades.XmlDigestAlgAndValueType;
import xades4j.xml.bind.xades.XmlIdentifierType;
import xades4j.xml.bind.xades.XmlObjectIdentifierType;
import xades4j.xml.bind.xades.XmlQualifierType;
import xades4j.xml.bind.xmldsig.XmlDigestMethodType;
import xades4j.xml.bind.xmldsig.XmlX509IssuerSerialType;

class ToXmlUtils {
    private static final EnumMap<IdentifierType, XmlQualifierType> identifierTypeConv = new EnumMap(IdentifierType.class);

    static {
        identifierTypeConv.put(IdentifierType.OIDAsURI, XmlQualifierType.OID_AS_URI);
        identifierTypeConv.put(IdentifierType.OIDAsURN, XmlQualifierType.OID_AS_URN);
    }

    ToXmlUtils() {
    }

    static XmlObjectIdentifierType getXmlObjectId(ObjectIdentifier objId) {
        XmlObjectIdentifierType xmlObjId = new XmlObjectIdentifierType();
        XmlIdentifierType xmlId = new XmlIdentifierType();
        xmlId.setValue(objId.getIdentifier());
        xmlId.setQualifier(identifierTypeConv.get((Object)objId.getIdentifierType()));
        xmlObjId.setIdentifier(xmlId);
        xmlObjId.setDescription(objId.getDescription());
        return xmlObjId;
    }

    static XmlCertIDListType getXmlCertRefList(BaseCertRefsData certRefsData) {
        XmlCertIDListType xmlCertRefListProp = new XmlCertIDListType();
        List<XmlCertIDType> xmlCertRefList = xmlCertRefListProp.getCert();
        for (CertRef certRef : certRefsData.getCertRefs()) {
            XmlDigestMethodType certDigestMethod = new XmlDigestMethodType();
            certDigestMethod.setAlgorithm(certRef.digestAlgUri);
            XmlDigestAlgAndValueType certDigest = new XmlDigestAlgAndValueType();
            certDigest.setDigestMethod(certDigestMethod);
            certDigest.setDigestValue(certRef.digestValue);
            XmlX509IssuerSerialType issuerSerial = new XmlX509IssuerSerialType();
            issuerSerial.setX509IssuerName(certRef.issuerDN);
            issuerSerial.setX509SerialNumber(certRef.serialNumber);
            XmlCertIDType certID = new XmlCertIDType();
            certID.setCertDigest(certDigest);
            certID.setIssuerSerial(issuerSerial);
            xmlCertRefList.add(certID);
        }
        return xmlCertRefListProp;
    }
}

