<?php
require_once "vendor/autoload.php";
 

ob_start();
include "./invoice.php";
$html = ob_get_clean();
ob_end_clean();

use Dompdf\Dompdf;

define('DOMPDF_ENABLE_PHP', true);

$options = new \Dompdf\Options();
$options->setIsPhpEnabled(true);

// instantiate and use the dompdf class
$dompdf = new Dompdf($options);

$dompdf->loadHtml($html);
 
// (Optional) Setup the paper size and orientation
$dompdf->setPaper('A4', 'portrait');
 
$dompdf->set_option('isRemoteEnabled', true);

// Render the HTML as PDF
$dompdf->render();
 
// Output the generated PDF to Browser
$dompdf->stream('factura.pdf');

//Save to disk
//$output = $dompdf->output();
//file_put_contents("test.pdf", $output);


?>