<?php
namespace Hacienda;

require_once(dirname(__FILE__) . '/../xmlseclibs/xmlseclibs.php');

use RobRichards\XMLSecLibs\XMLSecurityDSig;
use RobRichards\XMLSecLibs\XMLSecurityKey;

class Firmador
{
    const FROM_XML_STRING = 1;
    const FROM_XML_FILE = 2;
    const TO_BASE64_STRING = 3;
    const TO_XML_STRING = 4;
    const TO_XML_FILE = 5;

    public function firmarXml($pfx, $pin, $input, $output, $path = null)
    {
        
        
        echo "CERTIFICADO : ". $pfx;
        echo "PPIN : ". $pin;
        
        
        $xml = new \DOMDocument();
        $xml->preserveWhiteSpace = false;
        $xml->formatOutput = false;

        // Cargar XML desde archivo o string
        if (file_exists($input)) {
            $input = file_get_contents($input);
        }

        if (!$xml->loadXML($input)) {
            throw new \Exception("Error cargando el XML");
        }

        // Preparar objeto firma
        $dsig = new XMLSecurityDSig();
        $dsig->setCanonicalMethod(XMLSecurityDSig::EXC_C14N);
        $dsig->xmlFirstChild = $xml->firstChild;
        
        // 🚨 AGREGAR ESTA LÍNEA:
        $dsig->setSignPolicy();
        
        
        // Leer certificado y clave desde .p12
        $certs = $dsig->loadCertInfo($pfx, $pin);
        $privateKey = $certs['privateKey'];
        $publicKey = $certs['publicKey'];

        $key = new XMLSecurityKey(XMLSecurityKey::RSA_SHA256, ['type' => 'private']);
        $key->loadKey($privateKey);

        // Agregar certificado a la firma
        $dsig->add509Cert($publicKey, true , false);
        $dsig->appendKeyValue($certs);

        // Agregar bloque XAdES
        $dsig->appendXades($certs);

        // Referencias:
        // 1. Documento raíz
        $dsig->addReference(
            $xml,
            XMLSecurityDSig::SHA256,
            ['http://www.w3.org/2000/09/xmldsig#enveloped-signature'],
            ['id_ref' => $dsig->reference0Id, 'force_uri' => true]
        );

        // 2. KeyInfo
        $dsig->addReference(
            $dsig->getKeyInfoNode(),
            XMLSecurityDSig::SHA256,
            null,
            ['id_ref' => $dsig->reference1Id, 'force_uri' => false, 'overwrite' => false]
        );

        // 3. XAdES SignedProperties
        $dsig->addReference(
            $dsig->getXadesNode(),
            XMLSecurityDSig::SHA256,
            null,
            [
                'force_uri' => false,
                'overwrite' => false,
                'type' => "http://uri.etsi.org/01903#SignedProperties"
            ],
            [[ 'qualifiedName' => 'xmlns:xades', 'value' => XMLSecurityDSig::XADES ]]
        );

        // Firmar y adjuntar
        $dsig->sign($key);
        $dsig->appendSignature($xml->documentElement);

        // Salida
        switch ($output) {
            case self::TO_BASE64_STRING:
                return base64_encode($xml->saveXML());
            case self::TO_XML_STRING:
                return $xml->saveXML();
            case self::TO_XML_FILE:
                return $path ? $xml->save($path) : false;
            default:
                throw new \Exception("Tipo de salida no reconocido");
        }
    }
}