<?php
ini_set('max_execution_time', 0);
if ( file_exists( "../conf/conf.php" ) ):
	require_once( "../conf/conf.php" ); 
elseif ( file_exists( "../../conf/conf.php" ) ):
	require_once( "../../conf/conf.php" ); 
elseif ( file_exists( "../../../conf/conf.php" ) ):
	require_once( "../../../conf/conf.php" ); 
endif; 

/**
* 
* Clase que permite realizar un logueo de las funciones que la instancie y ejecute la funcion 
* determinada para tales efectos.
* 
*/
class utilsTools 
{ 
	public $db;
	private $printNameFunctionStep; 
	private $printNameFunction; 
	private $printAllEcho; 
	private $printAllVarDump; 
	private $printAllPrintR; 
	private $printJson; 
	private $log_trace_instance; 
	private $doTracking; 

	function __construct() 
	{ 
		global $dbh, $debugThisCustomer; 
		$this->db 						= $dbh; 
		$this->printNameFunctionStep 	= 0; 
		$this->printNameFunction 		= true; 
		$this->printAllEcho 			= true; 
		$this->printAllVarDump 			= true; 
		$this->printAllPrintR 			= true; 
		$this->printJson 				= true; 
		$this->log_trace_instance 		= null; 
		$this->doTracking 				= false; 
		$this->enableTracking(); 
	} 

	public function enableTracking() 
	{ 
		if ( session_status() == PHP_SESSION_NONE ): 
			session_start();
		endif; 
		if ( empty( $_SESSION[ 'doTracking' ] ) || !$_SESSION[ 'doTracking' ] ): 
			$this->doTracking = false; 
		else: 
			$this->doTracking = true; 
		endif; 
	}

	/**
	 *
	 * Starts a trace.
	 * 
	 * Inicia el trackeo de una funcion o procedimiento, 
	 *
	 * @param      string  $notes  Notas adicionales que el usuario requiera enviar al trackeo.
	 * 
	 */
	public function startTrace( $notes = "" ) 
	{ 
		if( !$this->doTracking ) 
			return; 
		$this->sendStringToConsole( "Iniciando trace -- " . date( "Y-m-d H:i:s" ) );
		$this->log_trace_instance = new log_trace(); 
		$this->log_trace_instance->set_className( 
			isset( debug_backtrace()[ 1 ][ 'class' ] ) ? 
				debug_backtrace()[ 1 ][ 'class' ] : 
				"*** Not Class ***" 
		); 
		$this->log_trace_instance->set_functionName( 
			isset( debug_backtrace()[ 1 ][ 'function' ] ) ? 
				debug_backtrace()[ 1 ][ 'function' ] : "*** Not function ***" 
		); 
		$this->log_trace_instance->set_filePath( str_replace( basename( __FILE__ ), "", $_SERVER[ "SCRIPT_FILENAME" ] ) ); 
		$this->log_trace_instance->set_fileName( basename( __FILE__ ) ); 
		$this->log_trace_instance->set_notes( "Notas inicio: " . $notes ); 
		$this->log_trace_instance->set_datetimeStart( date( "Y-m-d H:i:s" ) ); 
		$this->log_trace_instance->set_datetimeEnd( "" ); 
		$this->log_trace_instance->set_args( 
			isset( debug_backtrace()[ 1 ][ 'args' ] ) ? 
				debug_backtrace()[ 1 ][ 'args' ] : "*** Not args ***" 
		); 
		$this->log_trace_instance->set_jsonArgs( 
			json_encode( 
				isset( debug_backtrace()[ 1 ][ 'args' ] ) ? 
					debug_backtrace()[ 1 ][ 'args' ] : "*** Not args ***" 
			) 
		); 
		$this->log_trace_instance->set_errorDetect( "" ); 
		$this->log_trace_instance->set_rowid( $this->saveLog() ); 
	} 

	/**
	 *
	 * Send String To Console
	 *
	 * envia a la consola del navegador los mensajes que el usuario necesite 
	 *
	 * @param      string  $str    Cadena a ser enviada
	 * 
	 */
	public function sendStringToConsole( $str ) 
	{ 
		echo 
			"<script>" . 
				"console.log( 'TrackingMsg: " . $str . "' )" . 
			"</script>";
	}

	/**
	 *
	 * Sends a json to console.
	 * 
	 * envia a la consola del navegador los mensajes que el usuario necesite en formato json
	 *
	 * @param      <obj>  $obj    Objeto a ser convertido en JSON y enviado
	 * 
	 */
	public function sendJsonToConsole( $obj ) 
	{ 
		echo 
			"<script>" . 
				"console.log( 'TrackingMsg: " . json_encode( $obj ) . "' )" . 
			"</script>";
	}

	/**
	 * 
	 * Register Error
	 * 
	 * Asigna al atributo error cualquier error que sea enviado. Se recomienda para try_cath
	 *
	 * @param      <JSON>  $error  Contenido del error
	 * 
	 */
	public function addNotes( $notes ) 
	{ 
		if( !$this->doTracking ) 
			return; 
		$this->log_trace_instance->set_notes( $this->log_trace_instance->get_notes() . " ----- Add Note: " . $notes ); 
		// echo $this->log_trace_instance->get_rowid();
		$sql = "
			UPDATE log_trace 
			SET notes 			= :notes 
			WHERE rowid 		= :rowid 
			"; 
		$dbConn = $this->db->prepare( $sql ); 
		$dbConn->bindValue( ":notes", 			$this->log_trace_instance->get_notes(), 			PDO::PARAM_LOB ); 
		$dbConn->bindValue( ":rowid", 			$this->log_trace_instance->get_rowid(), 			PDO::PARAM_LOB ); 
		$dbConn->execute(); 
		// print_r($dbConn->errorInfo()); 
		// print_r($this->db->errorInfo()); 
		$dbConn->closeCursor(); 
	} 

	/**
	 * 
	 * Register Error
	 * 
	 * Asigna al atributo error cualquier error que sea enviado. Se recomienda para try_cath
	 *
	 * @param      <JSON>  $error  Contenido del error
	 * 
	 */
	public function registerError( $error ) 
	{ 
		if( !$this->doTracking ) 
			return; 
		$this->log_trace_instance->set_errorDetect( $this->log_trace_instance->get_errorDetect() . " --- " . $error ); 
		$sql = "
			UPDATE log_trace 
			SET errorDetect 	= :errorDetect 
			WHERE rowid 		= :rowid 
			"; 
		$dbConn = $this->db->prepare( $sql ); 
		
		$dbConn->bindValue( ":errorDetect", 	$this->log_trace_instance->get_errorDetect(), 		PDO::PARAM_LOB ); 
		$dbConn->bindValue( ":rowid", 			$this->log_trace_instance->get_rowid(), 			PDO::PARAM_LOB ); 
		$dbConn->execute(); 
		// print_r($dbConn->errorInfo()); 
		// print_r($this->db->errorInfo()); 
		$dbConn->closeCursor(); 
	} 

	/**
	 * Ends a trace.
	 * 
	 * Finaliza el trackeo de la funcion que se esta trackeando y llama a la funcion que guarda el registro en la base de datos
	 * 
	 */
	public function endTrace( $notes = "" ) 
	{ 
		echo "xxxx";
		if( !$this->doTracking ) 
			return; 
		$this->log_trace_instance->set_notes( $this->log_trace_instance->get_notes() . " ----- Notas final: " . $notes ); 
		$this->sendStringToConsole( "Finalizando trace -- " . date( "Y-m-d H:i:s" ) );
		$this->log_trace_instance->set_datetimeEnd( date( "Y-m-d H:i:s" ) ); 
		// echo $this->getJsonFromObject( $this->log_trace_instance ); 
		$sql = "
			UPDATE log_trace 
			SET datetimeEnd 	= :datetimeEnd, 
				notes 			= :notes 
			WHERE rowid 		= :rowid 
			"; 
		$dbConn = $this->db->prepare( $sql ); 
		
		$dbConn->bindValue( ":datetimeEnd", 	$this->log_trace_instance->get_datetimeEnd(), 		PDO::PARAM_STR ); 
		$dbConn->bindValue( ":notes", 			$this->log_trace_instance->get_notes(), 			PDO::PARAM_LOB ); 
		$dbConn->bindValue( ":rowid", 			$this->log_trace_instance->get_rowid(), 			PDO::PARAM_LOB ); 
		$dbConn->execute(); 
		// print_r($dbConn->errorInfo()); 
		// print_r($this->db->errorInfo()); 
		$dbConn->closeCursor(); 
	} 

	/**
	 *
	 * Saves a log.
	 * 
	 * Guarda en la base de datos el registro que se esta trackeando
	 *
	 * @return     <Int>  Retorna el id del registro guardado
	 */
	public function saveLog() 
	{ 
		if( !$this->doTracking ) 
			return; 
		$sql = "
			INSERT INTO log_trace ( 
				className, 
				functionName, 
				filePath, 
				fileName, 
				notes, 
				datetimeStart, 
				datetimeEnd, 
				jsonArgs, 
				errorDetect 
			) VALUES ( 
				:className, 
				:functionName, 
				:filePath, 
				:fileName, 
				:notes, 
				:datetimeStart, 
				:datetimeEnd, 
				:jsonArgs, 
				:errorDetect 
			);"; 
		$dbConn = $this->db->prepare( $sql ); 
		$dbConn->bindValue( ":className" , 		$this->log_trace_instance->get_className(), 		PDO::PARAM_STR ); 
		$dbConn->bindValue( ":functionName" , 	$this->log_trace_instance->get_functionName(),		PDO::PARAM_STR ); 
		$dbConn->bindValue( ":filePath" , 		$this->log_trace_instance->get_filePath(), 			PDO::PARAM_STR ); 
		$dbConn->bindValue( ":fileName" , 		$this->log_trace_instance->get_fileName(), 			PDO::PARAM_STR ); 
		$dbConn->bindValue( ":notes", 			$this->log_trace_instance->get_notes(), 			PDO::PARAM_LOB ); 
		$dbConn->bindValue( ":datetimeStart", 	$this->log_trace_instance->get_datetimeStart(), 	PDO::PARAM_STR ); 
		$dbConn->bindValue( ":datetimeEnd", 	$this->log_trace_instance->get_datetimeEnd(), 		PDO::PARAM_STR ); 
		$dbConn->bindValue( ":jsonArgs", 		$this->log_trace_instance->get_jsonArgs(), 			PDO::PARAM_LOB ); 
		$dbConn->bindValue( ":errorDetect", 	$this->log_trace_instance->get_errorDetect(), 		PDO::PARAM_LOB ); 
		$dbConn->execute(); 
		$id = $this->db->lastInsertId(); 
		// print_r($dbConn->errorInfo()); 
		// print_r($this->db->errorInfo()); 
		$dbConn->closeCursor(); 
		return $id; 
	} 

	/**
	 *
	 * Gets the json from object.
	 * 
	 * Crea un json a partir de un objeto, limpiando los caracteres unicode y quitanto el nombre de la clase de todos los key.
	 *
	 * @param      <OBJ/CLASS>  $obj    Objeto a convertir
	 *
	 * @return     <String>  Cadena con salida del json
	 * 
	 */
	public function getJsonFromObject( $obj ) 
	{ 
		$out = preg_replace_callback( 
			"/\\\\u([a-f0-9]{4})/", 
			function( $v ) { 
				iconv( 'UCS-4LE', 'UTF-8', pack( 'V', hexdec( 'U$1' ) ) ); 
			}, 
			json_encode( 
				(array) $obj, 
				JSON_UNESCAPED_UNICODE 
			)
		); 
		return str_replace(get_class( $obj ), "", $out); 
	} 

	/**
	 * 
	 * Borrado recursivo
	 * 
	 * Borra un folder completo con todo el contenido que exista dentro de el.
	 *
	 * @param      string  $folder  Ruta del folder que se desea borrar 
	 * 
	 */
	public function borradoRecursivo( $folder ) 
	{ 
		foreach( glob( $folder . '/*' ) as $folderFiles ): 
			if ( is_dir( $folderFiles ) ): 
				$this->borradoRecursivo( $folderFiles ); 
			else: 
				unlink( $folderFiles ); 
			endif; 
		endforeach; 
		rmdir( $folder ); 
	} 

	/**
	 * 
	 * Compress To Zip
	 *
	 * Para comprimir carpetas con todo el contenido 
	 *
	 * @param      <type>  $pathDestino     Ruta donde se almacena el destino
	 * @param      <type>  $nombreZip       Nombre del archivo ZIP
	 * @param      <type>  $pathToCompress  Ruta que se desea comprimir
	 * 
	 */
	public function compressToZip( $pathDestino, $nombreZip, $pathToCompress ) 
	{ 
		$rPath 	= realpath( $pathToCompress ); 
		$zip 	= new ZipArchive(); 
		$zip->open( $pathDestino . $nombreZip, ZipArchive::CREATE | ZipArchive::OVERWRITE ); 
		$files = new RecursiveIteratorIterator( new RecursiveDirectoryIterator( $rPath ), RecursiveIteratorIterator::LEAVES_ONLY ); 
		foreach ($files as $name => $file): 
			if( !$file->isDir() ): 
				$fileRealPath 	= $file->getRealPath(); 
				$relPath 		= substr( $fileRealPath, strlen( $rPath ) + 1 ); 
				$zip->addFile( $fileRealPath, $relPath ); 
			endif; 
		endforeach; 
		$zip->close(); 
	} 

	/**
	 *
	 * Print Trace
	 *
	 * Imprime el nombre de la funcion que la invoca si el atributo de clase
	 * printNameFunction es verdadero o si forcePrintTrace es verdadero
	 *
	 * Se debe desactivar en produccion.
	 *
	 * @param      boolean  $forcePrintTrace  En caso de estar desactivada la ejecucion, verdadero la fuerza
	 * 
	 */
	public function printTrace( $forcePrintTrace = false ) 
	{ 
		if( $this->printNameFunction || $forcePrintTrace ): 
			$this->printNameFunctionStep++; 
			echo "<h3>" . $this->printNameFunctionStep . ". " . debug_backtrace()[1]['function'] . "</h3>"; 
		endif; 
	} 

	/**
	 * Print echo
	 *
	 * Imprime el contenido de la variable toEcho si el atributo de clase
	 * printEcho es verdadero o si forceEcho es verdadero
	 *
	 * Se debe desactivar en produccion.
	 *
	 * @param      string   $toEcho     Variable a imprimir
	 * @param      boolean  $forceEcho  En caso de estar desactivada la ejecucion, verdadero la fuerza
	 */
	public function printEcho( $toEcho, $forceEcho = false ) 
	{ 
		if( $this->printAllEcho || $forceEcho ): 
			echo "<p>" . $toEcho . "</p>"; 
		endif; 
	} 

	/**
	 * 
	 * Print VarDump
	 * 
	 * Hace un var_dump de la variable toVardump si el atributo de clase printVarDump es verdadero o si forceVarDump es verdadero
	 * 
	 * Se debe desactivar en produccion.
	 *
	 * @param      <type>   $toVardump     Variable a realizar el var_dump
	 * @param      boolean  $forceVarDump  En caso de estar desactivada la ejecucion, verdadero la fuerza
	 * 
	 */
	public function printVarDump( $toVardump, $forceVarDump = false ) 
	{ 
		if( $this->printAllVarDump || $forceVarDump ): 
			echo "<br>"; 
			var_dump( $toVardump ); 
			echo "<br>"; 
		endif; 
	} 

	/**
	 *
	 * Print printr
	 * 
	 * Imprime el contenido de la variable toPrintR si el atributo de clase printPrintR es verdadero o si forcePrintR es verdadero
	 * 
	 * Se debe desactivar en produccion.
	 *
	 * @param      <type>   $toPrintR     Variable a realizar el print_r
	 * @param      boolean  $forcePrintR  En caso de estar desactivada la ejecucion, verdadero la fuerza
	 * 
	 */
	public function printPrintR( $toPrintR, $forcePrintR = false ) 
	{ 
		if( $this->printAllPrintR || $forcePrintR ): 
			echo "<br>"; 
			print_r( $toPrintR ); 
			echo "<br>"; 
		endif; 
	} 

	/**
	 *
	 * Print var to Json
	 *
	 * Imprime el contenido de la variable toJson si el atributo de clase
	 * printJson es verdadero o si forceJson es verdadero
	 *
	 * Se debe desactivar en produccion.
	 *
	 * @param      <type>   $toJson     Variable a realizar la impresion del objeto en formato JSON
	 * @param      boolean  $forceJson  En caso de estar desactivada la ejecucion, verdadero la fuerza
	 * 
	 */
	public function printToJson( $toJson, $forceJson = false ) 
	{ 
		if( $this->printJson || $forceJson ): 
			echo "<br>"; 
			echo json_encode( $toJson ); 
			echo "<br>"; 
		endif; 
	} 

	/**
	 *
	 * Verifica el directorio y si no existe lo crea 
	 *
	 * @param      <type>  $path   Ruta completa del directorio a verificar o crear
	 * 
	 */
	public function checkDir( $path ) 
	{ 
		$tmpPath = ""; 
		foreach ( explode( '/', $path ) as $id => $route ): 
			$tmpPath .= $route . "/"; 
			if ( !file_exists( $tmpPath ) ): 
				mkdir( $tmpPath, 0777 ); 
			endif; 
		endforeach; 
	}

}

	// $classss = new utilsTools(); 
	// $classss->startTrace(); 
	// sleep(5);
	// $classss->endTrace(); 

class log_trace 
{ 
	private $rowid; 
	private $className; 
	private $functionName; 
	private $filePath; 
	private $fileName; 
	private $notes; 
	private $datetimeStart; 
	private $datetimeEnd; 
	private $args; 
	private $jsonArgs; 
	private $errorDetect; 

	function __construct() 
	{ }

	// Set & Gets

	public function set_rowid( $rowidP ) 
	{ 
		$this->rowid = $rowidP; 
	} 

	public function get_rowid() 
	{ 
		return $this->rowid; 
	} 

	public function set_className( $classNameP ) 
	{ 
		$this->className = $classNameP; 
	} 

	public function get_className() 
	{ 
		return $this->className; 
	} 

	public function set_functionName( $functionNameP ) 
	{ 
		$this->functionName = $functionNameP; 
	} 

	public function get_functionName() 
	{ 
		return $this->functionName; 
	} 

	public function set_filePath( $filePathP ) 
	{ 
		$this->filePath = $filePathP; 
	} 

	public function get_filePath() 
	{ 
		return $this->filePath; 
	} 

	public function set_fileName( $fileNameP ) 
	{ 
		$this->fileName = $fileNameP; 
	} 

	public function get_fileName() 
	{ 
		return $this->fileName; 
	} 

	public function set_notes( $notesP ) 
	{ 
		$this->notes = $notesP; 
	} 

	public function get_notes() 
	{ 
		return $this->notes; 
	} 

	public function set_datetimeStart( $datetimeStartP ) 
	{ 
		$this->datetimeStart = $datetimeStartP; 
	} 

	public function get_datetimeStart() 
	{ 
		return $this->datetimeStart; 
	} 

	public function set_datetimeEnd( $datetimeEndP ) 
	{ 
		$this->datetimeEnd = $datetimeEndP; 
	} 

	public function get_datetimeEnd() 
	{ 
		return $this->datetimeEnd; 
	} 

	public function set_args( $argsP ) 
	{ 
		$this->args = $argsP; 
	} 

	public function get_args() 
	{ 
		return $this->args; 
	} 

	public function set_jsonArgs( $jsonArgsP ) 
	{ 
		$this->jsonArgs = $jsonArgsP; 
	} 

	public function get_jsonArgs() 
	{ 
		return $this->jsonArgs; 
	} 

	public function set_errorDetect( $errorDetectP ) 
	{ 
		$this->errorDetect = $errorDetectP; 
	} 

	public function get_errorDetect() 
	{ 
		return $this->errorDetect; 
	} 
}
/*

CREATE TABLE `log_trace` 
( 
	`rowid` INT NOT NULL AUTO_INCREMENT, 
	`className` VARCHAR(100) NOT NULL, 
	`functionName` VARCHAR(100) NOT NULL, 
	`filePath` VARCHAR(200) NOT NULL, 
	`fileName` VARCHAR(100) NOT NULL, 
	`notes` TEXT NOT NULL, 
	`datetimeStart` DATETIME NOT NULL, 
	`datetimeEnd` DATETIME NOT NULL, 
	`jsonArgs` TEXT NOT NULL, 
	`errorDetect` TEXT NOT NULL, 
	PRIMARY KEY (`rowid`)
) ENGINE = MyISAM;

*/
?>