$.widget( "metro.charm" , {

    version: "3.0.0",

    options: {
        position: "right",
        opacity: 1,
        outside: false,
        timeout: 0,
        duration: 400
    },

    _create: function () {
        var that = this, element = this.element, o = this.options;

        $.each(element.data(), function(key, value){
            if (key in o) {
                try {
                    o[key] = $.parseJSON(value);
                } catch (e) {
                    o[key] = value;
                }
            }
        });


        this._createCharm();

        element.data('charm', this);
    },

    _createCharm: function(){
        var that = this, element = this.element, o = this.options;

        element.addClass("charm").addClass(o.position+"-side").css({opacity: o.opacity}).hide();

        var closer = $("<span/>").addClass("charm-closer").appendTo(element);
        closer.on('click', function(){
            that.close();
        });

        if (o.outside === true) {
            element.on('mouseleave', function(e){
                that.close();
            });
        }
    },

    _showCharm: function(){
        var that = this, element = this.element, o = this.options;
        var size;

        if (o.position === "left" || o.position === "right") {
            size = element.outerWidth();
            if (o.position === "left") {
                element.css({
                    left: -size,
                    right: 'auto',
                    top: 0,
                    bottom: 0
                }).show().animate({
                    left: 0
                }, o.duration, function(){
                    element.data("displayed", true);
                });
            } else {
                element.css({
                    right: -size,
                    left: 'auto',
                    top: 0,
                    bottom: 0
                }).show().animate({
                    right: 0
                }, o.duration, function(){
                    element.data("displayed", true);
                });
            }
        } else {
            size = element.outerHeight();
            if (o.position === "top") {
                element.css({
                    top: -size,
                    bottom: 'auto',
                    left: 0,
                    right: 0
                }).show().animate({
                    top: 0
                }, o.duration, function(){
                    element.data("displayed", true);
                });
            } else {
                element.css({
                    bottom: -size,
                    top: 'auto',
                    left: 0,
                    right: 0
                }).show().animate({
                    bottom: 0
                }, o.duration, function(){
                    element.data("displayed", true);
                });
            }
        }

        if (o.timeout > 0) {
            this._timeout_interval = setInterval(function(){
                if (!element.is(":hover")) {
                    that.close();
                    clearInterval(that._timeout_interval);
                }
            }, o.timeout);
        }
    },

    _hideCharm: function(){
        var that = this, element = this.element, o = this.options;
        var size;

        if (o.position === "left" || o.position === "right") {
            size = element.outerWidth();
            if (o.position === "left") {
                element.animate({
                    left: -size
                }, o.duration, function(){
                    element.hide();
                    element.data("displayed", false);
                });
            } else {
                element.animate({
                    right: -size
                }, o.duration, function(){
                    element.hide();
                    element.data("displayed", false);
                });
            }
        } else {
            size = element.outerHeight();
            if (o.position === "top") {
                element.animate({
                    top: -size
                }, o.duration, function(){
                    element.hide();
                    element.data("displayed", false);
                });
            } else {
                element.animate({
                    bottom: -size
                }, o.duration, function(){
                    element.hide();
                    element.data("displayed", false);
                });
            }
        }

        clearInterval(this._timeout_interval);
    },

    open: function(){
        var that = this, element = this.element, o = this.options;

        if (element.data("opened") === true) {
            return;
        }

        element.data("opened", true);
        this._showCharm();
    },

    close: function(){
        var that = this, element = this.element, o = this.options;

        if (element.data("opened") === false) {
            return;
        }

        element.data("opened", false);

        this._hideCharm();
    },

    _destroy: function () {
    },

    _setOption: function ( key, value ) {
        this._super('_setOption', key, value);
    }
});

$(document).on("click", ".charm", function(e){
    e.preventDefault();
    e.stopPropagation();
});

$(document).on('click', function(e){
    $('[data-role=charm]').each(function(i, el){
        if (!$(el).hasClass('keep-open') && $(el).data('displayed')===true) {
            $(el).data('charm').close();
        }
    });
});

window.metroCharmIsOpened = function(el){
    var charm = $(el), charm_obj;
    if (charm.length == 0) {
        console.log('Charm ' + el + ' not found!');
        return false;
    }

    charm_obj = charm.data('charm');

    if (charm_obj == undefined) {
        console.log('Element not contain role charm! Please add attribute data-role="charm" to element ' + el);
        return false;
    }

    return charm_obj.element.data('opened') === true;
};

window.showMetroCharm = function (el, position){
    var charm = $(el), charm_obj;
    if (charm.length == 0) {
        console.log('Charm ' + el + ' not found!');
        return false;
    }

    charm_obj = charm.data('charm');

    if (charm_obj == undefined) {
        console.log('Element not contain role charm! Please add attribute data-role="charm" to element ' + el);
        return false;
    }

    if (position != undefined) {

        charm.hide();
        charm.data("displayed", false);
        charm.data("opened", false);

        charm_obj.options.position = position;
    }

    charm_obj.open();

    return false;
};

window.hideMetroCharm = function(el){
    var charm = $(el), charm_obj;
    if (charm.length == 0) {
        console.log('Charm ' + el + ' not found!');
        return false;
    }

    charm_obj = charm.data('charm');

    if (charm_obj == undefined) {
        console.log('Element not contain role charm! Please add attribute data-role="charm" to element ' + el);
        return false;
    }

    charm_obj.close();
};

window.toggleMetroCharm = function(el, position){
    var charm = $(el), charm_obj;
    if (charm.length == 0) {
        console.log('Charm ' + el + ' not found!');
        return false;
    }

    charm_obj = charm.data('charm');

    if (charm_obj == undefined) {
        console.log('Element not contain role charm! Please add attribute data-role="charm" to element ' + el);
        return false;
    }

    if (charm_obj.element.data('opened') === true) {
        charm_obj.close();
    } else {
        if (position != undefined) {
            charm.hide();
            charm.data("displayed", false);
            charm.data("opened", false);

            charm_obj.options.position = position;
        }
        charm_obj.open();
    }
};
