        function add_notification(options) {
            Snackbar.show(options);
        }

        function showSnackbar(message, actionText, actionCallback) {
    // Preparar las opciones para el snackbar
    let options = {
        content: message, // El mensaje del snackbar
        actionText: actionText, // El texto del botón de acción
        actionTextColor: '#ffffff', // Color del texto del botón de acción
        backgroundColor: '#333333', // Color de fondo del snackbar
        width: 'auto', // Ancho del snackbar
        showAction: true, // Mostrar el botón de acción
        pos: 'bottom-left', // Posición del snackbar
        duration: 30000, // Duración del snackbar en milisegundos
    };

    // Si se proporciona un callback para la acción, lo asignamos al botón de acción
    if (actionCallback) {
        options.action = actionCallback;
    }

    // Mostrar el snackbar utilizando la API de Snackbar.js
    Snackbar.show(options);
}

//convertir precio a decimal
function numero_decimal(numero) {
    // Crear un formateador de número con opciones específicas
    const formatter = new Intl.NumberFormat('es-ES', {
        // style: 'currency',
        // currency: 'USD',
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    });

    // Formatear el número
    const formatted = formatter.format(numero);

    // Reemplazar el símbolo de moneda con el símbolo deseado
    return "₡ " + formatted;
}

function primeraLetraMayuscula(cadena) {
    return cadena.charAt(0).toUpperCase() + cadena.slice(1);
}

function calcularDescuento(precioOriginal, porcentajeDescuento) {
    // Calcular el valor del descuento
    let descuento = precioOriginal * (porcentajeDescuento / 100);

    // Calcular el precio final después del descuento
    let precioFinal = precioOriginal - descuento;

    // Devolver el precio final
    return precioFinal;
}

function numero(n) {
    // Implementación de la función para formatear números
    return n.toLocaleString('es-ES'); // Ejemplo de formateo
}

function numero_dolar(n) {
    // Intenta convertir n a un número
    let numero = Number(n);

    // Verifica si la conversión fue exitosa
    if (!isNaN(numero)) {
        // Formatea el número como un valor en dólares, con dos decimales y un símbolo de dólar
        return '$' + numero.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    } else {
        // Si n no es un número, devuelve un mensaje de error o un valor predeterminado
        console.error('numero_dolar() espera un número, pero recibió:', n);
        return 'Error: Valor no numérico';
    }
}

function generarSelectTipo(id) {
    let select = document.createElement("select");
    select.required = true;
    select.className = "form-control";
    select.name = id;
    select.id = id;

    // Opción por defecto
    let optionDefault = document.createElement("option");
    optionDefault.disabled = false;
    optionDefault.value = "";
    optionDefault.textContent = "Seleccione...";
    select.appendChild(optionDefault);

    // Opciones adicionales
    let options = [
        {value: "fisica", text: "Físico"},
        {value: "juridica", text: "Jurídico"} 
       
    ];

    options.forEach(function(optionData) {
        let option = document.createElement("option");
        option.value = optionData.value;
        option.textContent = optionData.text;
        select.appendChild(option);
    });

    return select;
}

function generarSelectEstatus(id) {
    let select = document.createElement("select");
    select.required = true;
    select.className = "form-control";
    select.name = id;
    select.id = id;

    // Opción por defecto
    let optionDefault = document.createElement("option");
    optionDefault.disabled = false;
    optionDefault.value = "";
    optionDefault.textContent = "Seleccione...";
    select.appendChild(optionDefault);

    // Opciones para estatus activo e inactivo
    let options = [
        {value: "1", text: "Activo"},
        {value: "0", text: "Inactivo"}
    ];

    options.forEach(function(optionData) {
        let option = document.createElement("option");
        option.value = optionData.value;
        option.textContent = optionData.text;
        select.appendChild(option);
    });

    return select;
}

function generarSelectSiNo(id) {
    let select = document.createElement("select");
    select.required = true;
    select.className = "form-control";
    select.name = id;
    select.id = id;

    // Opción por defecto
    let optionDefault = document.createElement("option");
    optionDefault.disabled = false;
    optionDefault.value = "";
    optionDefault.textContent = "Seleccione...";
    select.appendChild(optionDefault);

    // Opciones para estatus activo e inactivo
    let options = [
        {value: "1", text: "Si"},
        {value: "0", text: "No"}
    ];

    options.forEach(function(optionData) {
        let option = document.createElement("option");
        option.value = optionData.value;
        option.textContent = optionData.text;
        select.appendChild(option);
    });

    return select;
}

function checkall(clickchk, relChkbox) {

    var checker = $('#' + clickchk);
    var multichk = $('.' + relChkbox);


    checker.click(function () {
        multichk.prop('checked', $(this).prop('checked'));
    });
}


