<?php
SESSION_START();
if (empty($_SESSION['usuario'])) {exit(1);}
require '../../conf/conf.php';
header("Content-type: application/x-msexcel; charset=utf-8");
header("Pragma: no-cache");
header("Expires: 0");
$filename = 'Listado_Clientes_'.date('d-m-Y').'.xls';
header('Content-Disposition: attachment; filename=' . $filename);
echo pack("CCC", 0xef, 0xbb, 0xbf);
ob_start();
// QUERY
$sql = "SELECT rowid, cedula, (CASE WHEN tipo = 'fisica'THEN CONCAT_WS(' ',nombre,apellidos) ELSE nombre END) AS nombre, email, telefono, activo FROM fi_terceros WHERE cliente = 1 AND entidad =:entidad AND (CASE WHEN tipo = 'fisica'THEN CONCAT_WS(' ',nombre,apellidos) ELSE nombre END) != ''  ORDER BY (CASE WHEN tipo = 'fisica'THEN CONCAT_WS(' ',nombre,apellidos) ELSE nombre END) ASC;";
$db  = $dbh->prepare($sql);
$db->bindValue(":entidad", $_SESSION['Entidad'], PDO::PARAM_INT);
$db->execute();
// RUN RECORDS
while ($data = $db->fetch(PDO::FETCH_ASSOC)):
  // VALIS STATUS
  $status =  ((intval($data['activo'])) == 1)? 'activo': 'inactivo';
  $color  =  ((intval($data['activo'])) == 1)? 'color:green;font-weight: bold;': 'color:red;font-weight: bold;';
  // HTML
  $tr .= 
    "<tr>
      <td style='text-align:center;'>".$data['rowid']."</td>      
      <td style='text-align:left;'>".$data['nombre']."</td>
      <td style='text-align:center;'>".$data['cedula']."</td>
      <td style='text-align:left;'>".$data['email']."</td>
      <td style='text-align:center;'>".$data['telefono']."</td>
      <td style='text-align:center;".$color."'>".$status."</td>
   </tr>";
endwhile;
?>
<!-- HTML -->
<table class="table table-bordered table-striped dataTable" >
  <thead>
    <tr style="background-color:black;color:white;">
      <th style='text-align:center;'>Codigo</th>
      <th style='text-align:center;'>Nombre</th>
      <th style='text-align:center;'>Cedula</th>
      <th style='text-align:center;'>Correo</th>
      <th style='text-align:center;'>Telefono</th>      
      <th style='text-align:center;'>Estado</th>
    </tr>
  </thead>
  <tbody role="alert" aria-live="polite" aria-relevant="all">
    <?php echo $tr; ?>
  </tbody>
</table>

<?php
$content = ob_get_clean();

$data = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <!--[if gte mso 9]>
    <xml>
        <x:ExcelWorkbook>
            <x:ExcelWorksheets>
                <x:ExcelWorksheet>
                    <x:Name>Listado_Alfabético</x:Name>
                    <x:WorksheetOptions>
                        <x:Print>
                            <x:ValidPrinterInfo/>
                        </x:Print>
                    </x:WorksheetOptions>
                </x:ExcelWorksheet>
            </x:ExcelWorksheets>
        </x:ExcelWorkbook>
    </xml>
    <![endif]-->
</head>

<body>
   ' . $content . '
</body></html>';
echo $data;