<?php

class log_sistema {   
    private $db;
    // CONSTRUCT
    function __construct($dbh) {
    	$this->db = $dbh;
    }
    
    // FUNCTION VALID TRANSACTION RESUTL
	public function validTransactionResult($result, $file, $query, $error, $record, $process, $detail){
	    // VALID RESULT
	    if (($result) == 1):
	        $this->log_success($file, $record, $process, $detail);
	    else:
	        $this->sql_LogErrores($file, $query, $error, $process);
	   endif;
	}

	// INSERT RECORD SUCCESS TRANSACCION
	public function log_success($file, $record, $action, $detail,$fk_user=null){
		// QUERY
	  	$sql =
	  		"INSERT INTO log_sistema (fk_usuario, direccion_ip, record, archivo, fecha, accion, detalle) VALUES (:fk_usuario, :direccion_ip, :record, :archivo, NOW(), :accion, :detalle)";
		$db = $this->db->prepare($sql);
		$db->bindValue(':fk_usuario'   , (!isset($_SESSION['usuario']))?$fk_user:$_SESSION['usuario'], PDO::PARAM_INT); 
		$db->bindValue(':direccion_ip' , IP                     , PDO::PARAM_STR); 
		$db->bindValue(':record'       , $record                , PDO::PARAM_INT); 
		$db->bindValue(':archivo'      , $file                  , PDO::PARAM_STR);		
		$db->bindValue(':accion'       , $action                , PDO::PARAM_STR); 
		$db->bindValue(':detalle'      , $detail                , PDO::PARAM_STR); 
		$db->execute();
		$db->closeCursor();
	}

	// INSERT RECORD ERROR TRANSACCION
	public function sql_LogErrores($file, $query, $error, $process,$fk_user=null){
		// QUERY

		if($fk_user==0){
			$sql = "INSERT INTO sql_LogErrores (fk_usuario, fecha, sql_consulta, error, proceso, file) VALUES ( null , NOW(), '".trim($query)."', '".$error ."', '". $process."', '".$file."') ";
	    
		}else{
			$sql = "INSERT INTO sql_LogErrores (fk_usuario, fecha, sql_consulta, error, proceso, file) VALUES ( ".$_SESSION['usuario']." , NOW(), '".trim($query)."', '".$error ."', '". $process."', '".$file."') ";
	    
		}
	    $db = $this->db->prepare($sql); 
	    $db->execute();
	    $db->closeCursor();
	}
}
?>