<?php
// upload_image.php - Example script for CKEditor image upload with base64 inline
// Place this in include/mail/upload_image.php on your server
// Images are embedded inline in email as data URIs, no server storage needed

session_start();
require("../../conf/conf.php");

$allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
$mimeMap = [
    'image/jpeg' => 'image/jpeg',
    'image/jpg' => 'image/jpeg',
    'image/png' => 'image/png',
    'image/gif' => 'image/gif'
];
 
if (isset($_FILES['upload'])) {
    $file = $_FILES['upload'];

    // Validate file type
    if (!in_array($file['type'], $allowedTypes)) {
        echo json_encode(['uploaded' => 0, 'error' => ['message' => 'Invalid file type. Only JPG, PNG, GIF allowed.']]);
        exit;
    }

    // Validate file size (2MB max for email inline images)
    if ($file['size'] > 2 * 1024 * 1024) {
        echo json_encode(['uploaded' => 0, 'error' => ['message' => 'File too large. Max 2MB for inline images.']]);
        exit;
    }

    // Convert to base64
    $imageData = file_get_contents($file['tmp_name']);
    if ($imageData === false) {
        echo json_encode(['uploaded' => 0, 'error' => ['message' => 'Failed to read file.']]);
        exit;
    }

    $base64 = 'data:' . $mimeMap[$file['type']] . ';base64,' . base64_encode($imageData);

    echo json_encode([
        'uploaded' => 1,
        'fileName' => $file['name'],
        'url' => $base64
    ]);
} else {
    echo json_encode(['uploaded' => 0, 'error' => ['message' => 'No file uploaded.']]);
}
?>
