<?php



session_start();

require_once("conf/conf.php");

// Función para actualizar el estado de la factura
function actualizar_estado_factura($rowid, $nuevo_estado, $conexion) {
    try {
        $sql = "UPDATE fi_facturas SET estado = :estado WHERE rowid = :rowid";
        $stmt = $conexion->prepare($sql);
        $stmt->bindValue(":estado", $nuevo_estado, PDO::PARAM_INT);
        $stmt->bindValue(":rowid", $rowid, PDO::PARAM_INT);
        $stmt->execute();
        echo "<!-- Actualizado estado de factura {$rowid} a {$nuevo_estado} -->";
    } catch (Exception $e) {
        echo "<!-- ERROR actualizando factura {$rowid}: " . $e->getMessage() . " -->";
    }
}



if (empty($_SESSION['usuario'])) {
    exit(1);
}


// Habilitar reporte de errores para debugging
//error_reporting(E_ALL);
//ini_set('display_errors', '1');

// Obtener facturas validadas (estado = 1) de octubre y septiembre 2025 que NO hayan sido enviadas electrónicamente, ordenadas por referencia DESC
try {
    $sql = "SELECT * FROM fi_facturas
            WHERE estado = 1
            AND electronica_enviada = 0
            AND (fecha LIKE '2025-10-%' OR fecha LIKE '2025-09-%')
            ORDER BY referencia DESC
            LIMIT 200";
    $db = $dbh->prepare($sql);
    $db->execute();
    $facturas = $db->fetchAll(PDO::FETCH_OBJ);
} catch (Exception $e) {
    die("Error en consulta SQL: " . $e->getMessage());
}

// Array para facturas sin XML generado
$facturas_sin_xml = array();

foreach ($facturas as $factura) {
    // Determinar carpeta según tipo
    if ($factura->electronica_tipo == "factura") {
        $carpeta = "facturas";
    } else if ($factura->electronica_tipo == "tiquete") {
        $carpeta = "tiquetes";
    } else if ($factura->electronica_tipo == "factura_exportacion") {
        $carpeta = "exportacion";
    } else {
        continue; // Si no tiene tipo definido, saltar
    }

    // Determinar nombre del archivo según versión
    $version_nombre_descarga = ($factura->version == "4.2") ? $factura->rowid : $factura->consecutivo;

    // Construir ruta completa del archivo
    $ruta_archivo = "/home/facturac6/facturacion_electronica_documentos/" . $carpeta . "/" . $_SESSION['Entidad'] . "/" . $version_nombre_descarga . ".xml";

    // Verificar si el archivo existe y está vacío (tamaño = 0)
    if (file_exists($ruta_archivo)) {
        $tamaño_archivo = filesize($ruta_archivo);
        if ($tamaño_archivo === 0) {
            $facturas_sin_xml[] = $factura;
            // Actualizar estado a 0 para reprocesamiento
            actualizar_estado_factura($factura->rowid, 0, $dbh);
        }
    } else {
        // Si el archivo no existe también lo incluimos
        $facturas_sin_xml[] = $factura;
        // Actualizar estado a 0 para reprocesamiento
        actualizar_estado_factura($factura->rowid, 0, $dbh);
    }
}

// Mostrar información de debugging - todas las facturas procesadas con sus rutas
echo "<h2>DEBUGGING: Todas las facturas procesadas (200 validadas NO enviadas electrónicamente - Oct/Sep 2025)</h2>";
echo "<table border='1'>";
echo "<tr><th>#</th><th>Row ID</th><th>Referencia</th><th>Tipo Electrónico</th><th>Ruta</th><th>Archivo Existe</th><th>Tamaño</th><th>Estado</th></tr>";

$item = 0;
foreach ($facturas as $factura) {
    $item++;
    // Determinar carpeta según tipo
    if ($factura->electronica_tipo == "factura") {
        $carpeta = "facturas";
    } else if ($factura->electronica_tipo == "tiquete") {
        $carpeta = "tiquetes";
    } else if ($factura->electronica_tipo == "factura_exportacion") {
        $carpeta = "exportacion";
    } else {
        continue;
    }

    $version_nombre_descarga = ($factura->version == "4.2") ? $factura->rowid : $factura->consecutivo;
    $ruta_archivo = "/home/facturac6/facturacion_electronica_documentos/" . $carpeta . "/" . $_SESSION['Entidad'] . "/" . $version_nombre_descarga . ".xml";

    $existe = file_exists($ruta_archivo) ? "SÍ" : "NO";
    $tamaño = file_exists($ruta_archivo) ? filesize($ruta_archivo) . " bytes" : "N/A";

    echo "<tr>";
    echo "<td>{$item}</td>";
    echo "<td>{$factura->rowid}</td>";
    echo "<td>{$factura->referencia}</td>";
    echo "<td>{$factura->electronica_tipo}</td>";
    echo "<td>{$ruta_archivo}</td>";
    echo "<td style='color: " . ($existe == "SÍ" ? "green" : "red") . ";'>{$existe}</td>";
    echo "<td>{$tamaño}</td>";
    echo "<td>{$factura->version}</td>";
    echo "</tr>";
}
echo "</table><br><br>";

// Mostrar resultados en tabla HTML - Solo facturas con XML vacío o inexistente
echo "<h2>Facturas Validadas Sin XML o con XML Vacío (" . count($facturas_sin_xml) . ")</h2>";
echo "<table border='1'>";
echo "<tr><th>Row ID</th><th>Referencia</th><th>Cliente</th><th>Fecha</th><th>Estado</th><th>Versión</th><th>Tipo Electrónico</th><th>Ruta Esperada</th></tr>";

foreach ($facturas_sin_xml as $fact) {
    // Determinar carpeta según tipo
    if ($fact->electronica_tipo == "factura") {
        $carpeta = "facturas";
    } else if ($fact->electronica_tipo == "tiquete") {
        $carpeta = "tiquetes";
    } else if ($fact->electronica_tipo == "factura_exportacion") {
        $carpeta = "exportacion";
    }

    $version_nombre_descarga = ($fact->version == "4.2") ? $fact->rowid : $fact->consecutivo;
    $ruta_archivo = "/home/facturac6/facturacion_electronica_documentos/" . $carpeta . "/" . $_SESSION['Entidad'] . "/" . $version_nombre_descarga . ".xml";

// Actualizar estado de la factura a 0 para reprocesamiento
    actualizar_estado_factura($fact->rowid, 0, $dbh);

    echo "<tr>";
    echo "<td>{$fact->rowid}</td>";
    echo "<td>{$fact->referencia}</td>";
    echo "<td>{$fact->nombre_cliente}</td>";
    echo "<td>{$fact->fecha}</td>";
    echo "<td style='color: blue;'>REVERTIDO A 0 (Borrador)</td>";
    echo "<td>{$fact->version}</td>";
    echo "<td>{$fact->electronica_tipo}</td>";
    echo "<td style='color: red;'>{$ruta_archivo}</td>";
    echo "</tr>";
}

echo "</table>";
?>
