<?php

session_start();

// Verificar permisos de acceso
if (!isset($_SESSION['Entidad']) || !isset($_SESSION['usuario'])) {
    die("Acceso denegado. Debe iniciar sesión y tener una entidad válida.");
}

include 'conf/conf.php';

require ENLACE_SERVIDOR.'mod_usuarios/object/usuarios_class.php';
require_once(ENLACE_SERVIDOR.'mod_configuracion/class/configuracion_class.php');

$usuario = new usuario($dbh);
$usuario->fetch($_SESSION['usuario']);

if ($_SESSION['Entidad'] == 449) {
    echo "API API ";
    $xml_object_php = ENLACE_SERVIDOR . 'mod_electronica43/object/xml.object.exonerar.php2';
} else {
    $xml_object_php = ENLACE_SERVIDOR . 'mod_electronica44/object/xml.object.exonerar.php';
}

if ($_SESSION['Entidad'] == 296) {
    $xml_object_php = ENLACE_SERVIDOR . 'mod_electronica43/object/xml.object.exonerar_ofg.php';
}

$xml_object_php = 'mod_electronica44/object/xml.object.4_4.php'; // Forced for all

require_once ENLACE_SERVIDOR . 'mod_facturacion/class/factura.class.php';
require_once ENLACE_SERVIDOR . 'mod_terceros/class/terceros.class.php';
require_once ENLACE_SERVIDOR . 'mod_stock/object/bodegas.class.php';
require_once ENLACE_SERVIDOR . 'mod_facturacion/class/pagos.class.php';

$comunica_hacienda_background = 0;

$factura  = new Factura($dbh);
$tercero  = new Terceros($dbh);
$pago     = new pago($dbh);

$disabled = "";

// Configurar cantidad de facturas a procesar (por defecto 20, máximo 100)
$cantidad_limite = isset($_GET['cantidad']) ? (int)$_GET['cantidad'] : 20;
$cantidad_limite = min(max($cantidad_limite, 1), 100);

// Aumentar límite de tiempo de ejecución para procesamientos largos
ini_set('max_execution_time', 300); // 5 minutos

// Contar facturas pendientes en el rango de fechas para información
$sql_count = "SELECT COUNT(*) AS total_facturas FROM fi_facturas WHERE entidad = ? AND estado = 0 AND fecha BETWEEN '2025-09-01' AND '2025-10-31'";
$db_count = $dbh->prepare($sql_count);
$db_count->bindParam(1, $_SESSION['Entidad'], PDO::PARAM_INT);
$db_count->execute();
$conteo = $db_count->fetch(PDO::FETCH_ASSOC);
echo "<h3>Total de facturas pendientes en Sep-Oct 2025: " . $conteo['total_facturas'] . "</h3>";

// SQL query with entity filter to prevent cross-entity processing
$sql = "SELECT rowid, entidad, fecha, referencia, tipo, fk_tercero, subtotal, impuesto, total, estado, electronica_enviada, version, consecutivo
        FROM fi_facturas
        WHERE entidad = ? AND estado = 0 AND version = '4.4' AND referencia NOT LIKE 'Borrador %'
        ORDER BY referencia DESC
        LIMIT ?";
$db = $dbh->prepare($sql);
$db->bindParam(1, $_SESSION['Entidad'], PDO::PARAM_INT);
$db->bindParam(2, $cantidad_limite, PDO::PARAM_INT);
$db->execute();
$facturas = $db->fetchAll(PDO::FETCH_OBJ);

// Mostrar resultados en una tabla HTML
echo "<table border='1'>";
$total_facturas = count($facturas);
echo "<h2>Procesando {$total_facturas} facturas electrónicas optimizadas</h2>";
echo "<div style='margin-bottom: 20px;'><strong>Progreso:</strong> <span id='progreso'>0</span>/{$total_facturas}</div>";

echo "<tr><th>Row ID</th><th>Entidad</th><th>Fecha</th><th>Referencia</th><th>Consecutivo</th><th>Tipo</th><th>Subtotal</th><th>Impuesto</th><th>Total</th><th>Estado</th><th>Enviada</th><th>Versión</th><th>Enlace</th><th>Estado Proceso</th></tr>";

$procesadas = 0;
foreach($facturas as $fact) {
    $procesadas++;
    $estado_proceso = "Iniciando...";

    try {
        // Simular $_REQUEST y procesar de manera más eficiente
        $_REQUEST = array("accion" => "validar_factura", "fiche" => $fact->rowid);

        $factura->factura_exportacion = ($_REQUEST['accion'] == "validar_factura_exportacion") ? 1 : 0;

        $estado_proceso = "Validando una vez...";
        $factura->fetch($_REQUEST['fiche']); // Single fetch
        $factura->validar($usuario->id, $_REQUEST); // No extra fetch after validate

        $estado_proceso = "Moviendo bodega...";
        $bodega = new bodega($dbh);
        $bodega->mover_bodega_en_venta($factura, 'factura_venta', $usuario->id);

        $estado_proceso = "Creando XML...";
        require_once $xml_object_php;
        require_once ENLACE_SERVIDOR . 'mod_electronica/object/comunicacion.object.php';

        $xml = new XML_Hacienda($dbh, $_SESSION['Entidad']);
        $Comunicacion = new Comunicacion($dbh, $_SESSION['Entidad']);

        $xml->crear($factura);
        $estado_proceso = "Guardando y Firmando...";
        $xml->salvar();
        $xml->firmar();

        $estado_proceso = "Enviando correo...";
        $comunica_hacienda_background = true;
        require ENLACE_SERVIDOR . "mod_tareas_programadas/correo_FE_directo.php"; // Processo sincrono, pero optimizado

        $estado_proceso = "Completado ✓";

    } catch (Exception $e) {
        $estado_proceso = "ERROR: " . $e->getMessage();
    }

    echo "<tr>";
    echo "<td>{$fact->rowid}</td>";
    echo "<td>{$fact->entidad}</td>";
    echo "<td>{$fact->fecha}</td>";
    echo "<td>{$fact->referencia}</td>";
    echo "<td>{$fact->consecutivo}</td>";
    echo "<td>{$fact->tipo}</td>";
    echo "<td>{$fact->subtotal}</td>";
    echo "<td>{$fact->impuesto}</td>";
    echo "<td>{$fact->total}</td>";
    echo "<td>{$fact->estado}</td>";
    echo "<td>{$fact->electronica_enviada}</td>";
    echo "<td>{$fact->version}</td>";
    echo "<td><a href='https://facturacionpymes.tk/sistema/factura/{$fact->rowid}' target='_blank'>Ver Factura</a></td>";
    echo "<td style='color: " . (strpos($estado_proceso, 'ERROR') !== false ? 'red' : 'green') . ";'>{$estado_proceso}</td>";
    echo "</tr>";

    // Actualizar progreso en tiempo real
    if (ob_get_level()) {
        ob_flush();
        flush();
    }
    echo "<script>document.getElementById('progreso').textContent = '{$procesadas}';</script>";
    if (ob_get_level()) {
        ob_flush();
        flush();
    }
}
echo "</table>";

// Recargar la página automáticamente cuando termine todo el proceso
echo "<script>
console.log('Proceso completado. Recargando página en 3 segundos...');
setTimeout(function() {
    window.location.reload();
}, 3000);
</script>";

?>
