<?php

class Agenda
{
    private $dbh;
    public $rowid;
    public $descripcion;
    public $fk_tipo_evento;
    public $fecha_inicio;
    public $fecha_final;
    public $fk_usuario_asignado;
    public $fk_usuario_crear;
    public $fk_usuario_editar;
    public $fk_usuario_eliminar;
    public $fecha_creacion;
    public $fecha_edicion;
    public $fecha_eliminacion;
    public $leido;

    public function __construct(PDO $db)
    {
        $this->db = $db;
    }
    
    
    public function listadoEventosAgenda($obj)
    {   
        $sql = "SELECT a.rowid, 
        a.descripcion as evento, 
        dte.descripcion as tipo_evento, 
        a.fk_tipo_evento,
        a.fecha_inicio, 
        a.fecha_final, 
        a.estado, fu.usuario, 
        a.fk_usuario_crear
        FROM fi_agenda a 
        INNER JOIN diccionario_tipo_evento dte ON a.fk_tipo_evento = dte.rowid 
        INNER JOIN fi_usuarios fu ON fu.rowid = a.fk_usuario_crear
        WHERE a.estado != 2 AND fk_usuario_crear = ".$_SESSION['usuario'];
    
        $db = $this->db->prepare($sql);
        $db->execute();
        $eventosData = $db->fetchAll(PDO::FETCH_OBJ);
        
        try{
            
        $eventos = [];
        
        foreach ($eventosData as $events_info) {
      
       
            $eventos[] = [
                'title' => $events_info->evento,
                'start' =>  $events_info->fecha_inicio ,
                'end' =>  $events_info->fecha_final ,
                'rowid' => $events_info->rowid,
                'user' => $events_info->usuario,
                'estado' => $events_info->estado,
                'tipo_evento' => $events_info->tipo_evento,
                'fk_tipo_evento' => $events_info->fk_tipo_evento,
                'duration' => 8,
                'fk_usuario_crear' => $events_info->fk_usuario_crear
            ];
        }

        return $eventos;
            
            
        }catch(Exception $e){
            echo $e->getMessage();
        }
        
    }
    
    public function tiposEventos()
    {
        $sql = "SELECT 
        dte.rowid, 
        dte.descripcion
        FROM diccionario_tipo_evento dte";
    
        $db = $this->db->prepare($sql);
        $db->execute();
        $tiposEventos = $db->fetchAll(PDO::FETCH_OBJ);
        return $tiposEventos;
    }
    
    public function usuarios()
    {
        $sql = "SELECT 
        fu.rowid, 
        fu.usuario
        FROM fi_usuarios fu";
    
        $db = $this->db->prepare($sql);
        $db->execute();
        $usuarios = $db->fetchAll(PDO::FETCH_OBJ);
        return $usuarios;
    }
    
    public function estadosEventos()
    {
       $estadosEventos = [
           0 => 'Inactivo',
           1 => 'Activo',
           2 => 'Eliminado',
           3 => 'Leido'
           ];
        return json_decode(json_encode($estadosEventos));
    }
    
    public function guardarEvento()
    {
        
        try{
        $sql = "INSERT INTO fi_agenda SET  
        descripcion = :descripcion, 
        fk_tipo_evento = :fk_tipo_evento, 
        fecha_inicio = :fecha_inicio, 
        fecha_final = :fecha_final, 
        estado = 1, 
        fk_usuario_crear = :fk_usuario_crear,
        fecha_creacion = now()
        ";
        
            $db = $this->db->prepare($sql);

            $db->bindValue(":descripcion",              $this->descripcion, PDO::PARAM_STR);
            $db->bindValue(":fk_tipo_evento",           $this->fk_tipo_evento, PDO::PARAM_INT);
            $db->bindValue(":fecha_inicio",             $this->fecha_inicio, PDO::PARAM_STR);
            $db->bindValue(":fecha_final",              $this->fecha_final, PDO::PARAM_STR);
            $db->bindValue(":fk_usuario_crear",         $this->fk_usuario_crear, PDO::PARAM_INT);
            
             $result = $db->execute();
             return $result;
        }catch(Exception $e){
            echo $e->getMessage();
        }
    } 
    
    public function actualizarEvento()
    {
        
        try{
        $sql = "UPDATE fi_agenda SET  
        descripcion = :descripcion, 
        fk_tipo_evento = :fk_tipo_evento, 
        fecha_inicio = :fecha_inicio, 
        fecha_final = :fecha_final, 
        estado = :estado, 
        fk_usuario_editar = :fk_usuario_editar,
        fecha_edicion = now() 
        where rowid = :rowid
        ";
           
            $db = $this->db->prepare($sql);
        
            $db->bindValue(":rowid",                    $this->rowid, PDO::PARAM_INT);
            $db->bindValue(":descripcion",              $this->descripcion, PDO::PARAM_STR);
            $db->bindValue(":fk_tipo_evento",           $this->fk_tipo_evento, PDO::PARAM_INT);
            $db->bindValue(":fecha_inicio",             $this->fecha_inicio, PDO::PARAM_STR);
            $db->bindValue(":fecha_final",              $this->fecha_final, PDO::PARAM_STR);
            $db->bindValue(":estado",                   $this->estado, PDO::PARAM_INT);
            $db->bindValue(":fk_usuario_editar",        $this->fk_usuario_editar, PDO::PARAM_INT);
            
             $result = $db->execute();
             return $result;
        }catch(Exception $e){
            echo $e->getMessage();
        }
    }
    
    public function eliminarEvento()
    {
        $sql = "UPDATE fi_agenda SET  
        estado = 2, 
        fk_usuario_eliminar = :fk_usuario_eliminar,
        fecha_eliminacion = now() 
        where rowid = :rowid
        ";
           
            $db = $this->db->prepare($sql);
        
            $db->bindValue(":rowid",                    $this->rowid, PDO::PARAM_INT);
            $db->bindValue(":fk_usuario_eliminar",        $this->fk_usuario_eliminar, PDO::PARAM_INT);
            $result = $db->execute();
             return $result;
    }
    
    public function obtenerDetalleNotificacion()
    {
        $sql = "SELECT a.rowid, 
        a.descripcion as evento, 
        dte.descripcion as tipo_evento, 
        a.fk_tipo_evento,
        a.fecha_inicio, 
        a.fecha_final, 
        a.estado, fu.usuario, 
        a.fk_usuario_crear,
        a.leido,
        n.fk_agenda,
        n.estado,
        n.rowid as id_notificacion
        FROM fi_agenda a 
        INNER JOIN diccionario_tipo_evento dte ON a.fk_tipo_evento = dte.rowid 
        INNER JOIN fi_usuarios fu ON fu.rowid = a.fk_usuario_crear
        INNER JOIN tbl_notificaciones n ON n.fk_agenda = a.rowid
        WHERE a.rowid = :rowid";
    
        $db = $this->db->prepare($sql);
        $db->bindValue(":rowid",                    $this->rowid, PDO::PARAM_INT);
        $db->execute();
        $notificacion = $db->fetch(PDO::FETCH_OBJ);
      
        return $notificacion;
    }
    
     public function marcarLeido()
    {
        $sql = "UPDATE tbl_notificaciones SET  
        estado = 2,
        fecha_leido = now()
        where rowid = :rowid
        ";
           
            $db = $this->db->prepare($sql);
            $db->bindValue(":rowid",                    $this->rowid, PDO::PARAM_INT);
            
            $result = $db->execute();
             return $result;
    }
    
    public function notificacionesPendientes()
    {
        $sql = "SELECT count(*) as pendientes
        FROM tbl_notificaciones n 
        WHERE n.estado = 1 
        AND n.fecha_notificacion <= '".date("Y-m-d 00:00:00")."' 
        AND fk_usuario_leido = ".$_SESSION['usuario'];
        
        $db = $this->db->prepare($sql);
        $db->execute();
        $pendientes = $db->fetch();
        
        return $pendientes;
    }
    
    
    
}