<?php 
/*------------------ BY JAMP 13-11-2021 ------------------------------*/

class Empresa {

    public $db;
    
    public function __construct ($db){         
        $this->db=$db;
    }


    public function getEmpresa(){
        /* PARA CONSULTAR LAS EMPRESAS */

        $sql="";
        $process = "Consultar Empresa";

        try{

            $sql = "SELECT * FROM crm_empresas";

            $db=$this->db->prepare($sql); 
   
            $db->execute();
     
            
            
            while($datos = $db->fetch(PDO::FETCH_ASSOC)){
                $this->rowid    = $datos['rowid'];
                $this->nombre   = $datos['nombre'];
                
                echo '<option value="'.$datos['rowid'].'">'.$datos['nombre'].'</option>
                    ';
            }
            // return $datos;

        }catch(PDOException $e){

            return $e->getMessage();
        }

    }

    public function getBodegas($business){
        /* MOSTRAR LAS BODEGAS DE LA EMPRESA SELECCIONADA */
        // var_dump($business);
        $sql="";
        $process = "Consultar Bodegas de una Empresa";

        try{

            $sql = "SELECT c.*
                    FROM fi_bodegas c 
                    INNER JOIN crm_empresas e 
                    ON e.rowid = c.fk_empresa 
                    WHERE e.rowid = :empresa";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':empresa', $business, PDO::PARAM_INT);
            $db->execute();

            // echo "prueba para imprimir en el contenido de la tabla";

            while($bodegas = $db->fetch(PDO::FETCH_ASSOC)){

                if($bodegas['principal_facturar']==1){
                    $estado = "Activa";
                    $button = '<button type="button" class="btn btn-danger" onclick="habilitarBodega('.$bodegas['rowid'].', '.$bodegas['principal_facturar'].');"><i class="fa fa-edit"></i> Deshabilitar</button>';
                }else{
                    $estado = "Inactiva";
                    $button = '<button type="button" class="btn btn-info" onclick="habilitarBodega('.$bodegas['rowid'].', '.$bodegas['principal_facturar'].');"><i class="fa fa-edit"></i> Habilitar</button>';
                    
                }

                if($bodegas['principal_facturar'] == "1"){
                    echo '<tr style="background: #90e2b6;">
                    <td>'.$bodegas['rowid'].'</td>
                    <td>'.$bodegas['label'].'</td>
                    <td>'.$estado.'</td>
                    <td>'.$button.'</td>
                </tr>';
                }else{
                    echo '<tr>
                        <td>'.$bodegas['rowid'].'</td>
                        <td>'.$bodegas['label'].'</td>
                        <td>'.$estado.'</td>
                        <td>'.$button.'</td>
                    </tr>';
                }
                
                // echo $data;
                // echo "prueba para imprimir en el contenido de la tabla";
            }

            

            

        }catch(PDOException $e){

            return $e->getMessage();
        }
    }


    public function habilitarBodegaVenta($bodegaId, $entidad){

        $sql="";
        $process = "Habilitar / Deshabilitar bodega como Principal";

        try{

            // // DESHABILITAMOS LAS BODEGA QUE ESTEN ACTIVAS
            $sql = "UPDATE fi_bodegas 
                            SET principal_facturar = 0 
                            WHERE fk_empresa = :empresa";
            $db=$this->db->prepare($sql);
            $db->bindValue(':empresa', $entidad, PDO::PARAM_INT);
            $desact = $db->execute();
            // VALIDAMOS QUE SE HAYA DESACTIVADO
            // if($desact == true){

                // HABILITAMOS LA BODEGA QUE SE HAYA SELECCIONADO
               
                $sql2 = "UPDATE fi_bodegas 
                    SET principal_facturar = '1'
                    WHERE rowid = :bodega AND fk_empresa = :empresa";
                $db=$this->db->prepare($sql2); 
                $db->bindValue(':bodega', $bodegaId, PDO::PARAM_INT);
                $db->bindValue(':empresa', $entidad, PDO::PARAM_INT);
                $db->execute();
                 // HABILITAMOS LA BODEGA QUE SE HAYA SELECCIONADO



            // }

            return 1;

        }catch(PDOException $e){

            return $e->getMessage();
        }

    }
    
    
 public function eliminarContacto($id){
        $sql="";
        $process = "eliminarContacto";
        $fk_usuario = $_SESSION['usuario'];
$fk_entidad = $_SESSION['Entidad'];

        try{

             $sql = "DELETE FROM configuracion_whatsapp_lista WHERE rowid = :rowid AND fk_usuario = :fk_usuario AND fk_entidad = :fk_entidad";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':rowid', $id, PDO::PARAM_INT);
            $db->bindValue(':fk_usuario', $fk_usuario, PDO::PARAM_INT);
            $db->bindValue(':fk_entidad', $fk_entidad, PDO::PARAM_INT);
            $db->execute();

            $errores = $db->errorInfo();
            return 1;

        }catch(PDOException $e){
           

            return $errores;
        }
    }


 
 public function eliminarContactoRechazada($id){
        $sql="";
        $process = "eliminarContacto";
        $fk_usuario = $_SESSION['usuario'];
$fk_entidad = $_SESSION['Entidad'];

        try{
  
             $sql = "DELETE FROM configuracion_whatsapp_lista_rechazadas WHERE rowid = :rowid AND fk_usuario = :fk_usuario AND fk_entidad = :fk_entidad";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':rowid', $id, PDO::PARAM_INT);
            $db->bindValue(':fk_usuario', $fk_usuario, PDO::PARAM_INT);
            $db->bindValue(':fk_entidad', $fk_entidad, PDO::PARAM_INT);
            $db->execute();

            $errores = $db->errorInfo();
                    return 1;
         

        }catch(PDOException $e){
           

            return $errores;
        }
    }
 public function agregarContacto($codigo_extension, $telefono){
        $sql="";
        $process = "agregarContacto";
        $fk_usuario = $_SESSION['usuario'];
$fk_entidad = $_SESSION['Entidad'];

        try{

             $sql = "INSERT INTO configuracion_whatsapp_lista  SET fk_usuario = :fk_usuario,
             fk_entidad = :fk_entidad,
             codigo_extension = :codigo_extension,
               telefono = :telefono";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':codigo_extension', $codigo_extension, PDO::PARAM_STR);
            $db->bindValue(':telefono', $telefono, PDO::PARAM_STR);
            $db->bindValue(':fk_usuario', $fk_usuario, PDO::PARAM_INT);
            $db->bindValue(':fk_entidad', $fk_entidad, PDO::PARAM_INT);
            $db->execute();

            $errores = $db->errorInfo();
            return $errores;

        }catch(PDOException $e){
           

            return $errores;
        }
    }
    
    
    public function agregarContactoRechazada($codigo_extension, $telefono){
        $sql="";
        $process = "agregarContacto";
        $fk_usuario = $_SESSION['usuario'];
$fk_entidad = $_SESSION['Entidad'];

        try{

             $sql = "INSERT INTO configuracion_whatsapp_lista_rechazadas SET fk_usuario = :fk_usuario,
             fk_entidad = :fk_entidad,
             codigo_extension = :codigo_extension,
               telefono = :telefono";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':codigo_extension', $codigo_extension, PDO::PARAM_STR);
            $db->bindValue(':telefono', $telefono, PDO::PARAM_STR);
            $db->bindValue(':fk_usuario', $fk_usuario, PDO::PARAM_INT);
            $db->bindValue(':fk_entidad', $fk_entidad, PDO::PARAM_INT);
            $db->execute();

            $errores = $db->errorInfo();
            return $errores;

        }catch(PDOException $e){
           

            return $errores;
        }
    }
    public function agregarBodega(){
        $sql="";
        $process = "Agregar bodega";

        try{

            // $sql = "SELECT * FROM fi_bodegas
            //         INNER JOIN crm_empresas
            //         ON rowid = :empresa";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':bodega', $bodegaId, PDO::PARAM_INT);
            $db->execute();


            return 1;

        }catch(PDOException $e){

            return $e->getMessage();
        }
    }

    public function eliminarBodega(){

        $sql="";
        $process = "Eliminar bodega";

        try{

            // $sql = "SELECT * FROM fi_bodegas
            //         INNER JOIN crm_empresas
            //         ON rowid = :empresa";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':bodega', $bodegaId, PDO::PARAM_INT);
            $db->execute();


            return 1;

        }catch(PDOException $e){

            return $e->getMessage();
        }
    }

    public function guardarNota($notaBanco, $entidad){
        
        
        // var_dump($notaBanco);
        
        
        $sql="";
        $process = "Guardar Nota";

        try{

            $sql = "INSERT INTO fi_configuracion (entidad, configuracion, valor) 
            VALUES (:entidad, 'notas_pdf', :valor)";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':entidad', $entidad, PDO::PARAM_INT);
            $db->bindValue(':valor', $notaBanco, PDO::PARAM_STR);
            $db->execute();


            return 1;

        }catch(PDOException $e){

            return $e->getMessage();
        }
    }

    public function getCamposExtra(){

        $sql ="";


        try{

            $sql = "SELECT * FROM diccionario_campos_extra";
            $db=$this->db->prepare($sql); 
            $db->execute();

            while($campos = $db->fetch(PDO::FETCH_ASSOC)){
                
                echo '<option value="'.$campos["rowid"].'">'.$campos["label"].'</option>';

            }

        }catch(PDOException $e){

            return $e->getMessage();

        }
    }


    public function guardarCampoBodega($tipoCampo, $nomCampo, $entidad){
        
        $sql="";
        $process = "Guardar Campo extra de Bodega";

        try{

            $sql = "INSERT INTO campos_extra_detalle (fk_tipo_campo, fk_modulo, fk_empresa, valor) 
            VALUES (:tipo_campo, '15', :entidad, :valor)";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':tipo_campo', $tipoCampo, PDO::PARAM_INT);
            $db->bindValue(':entidad', $entidad, PDO::PARAM_INT);
            $db->bindValue(':valor', $nomCampo, PDO::PARAM_STR);
            $db->execute();

            return 1;

        }catch(PDOException $e){

            return $e->getMessage();
        }
    }


    public function eliminarCampoBodega($idCampo, $entidad){
        
        $sql="";
        $process = "Eliminar Campo extra de Bodega";

        try{

            $sql = "DELETE FROM campos_extra_detalle WHERE rowid =:idCampo AND fk_empresa= :entidad";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':idCampo', $idCampo, PDO::PARAM_INT);
            $db->bindValue(':entidad', $entidad, PDO::PARAM_INT);
            
            $db->execute();

            return $db->execute();;

        }catch(PDOException $e){

            return $e->getMessage();
        }
    }


    public function guardarCampoClientes($tipoCampo, $nomCampo, $entidad){
        
        $sql="";
        $process = "Guardar Campo extra de Clientes";

        try{

            $sql = "INSERT INTO campos_extra_detalle (fk_tipo_campo, fk_modulo, fk_empresa, valor) 
            VALUES (:tipo_campo, '11', :entidad, :valor)";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':tipo_campo', $tipoCampo, PDO::PARAM_INT);
            $db->bindValue(':entidad', $entidad, PDO::PARAM_INT);
            $db->bindValue(':valor', $nomCampo, PDO::PARAM_STR);
            $db->execute();

            return 1;

        }catch(PDOException $e){

            return $e->getMessage();
        }
    }

    public function eliminarCampoClientes($idCampo, $entidad){
        
        $sql="";
        $process = "Eliminar Campo extra de Clientes";

        try{

            $sql = "DELETE FROM campos_extra_detalle WHERE rowid =:idCampo AND fk_empresa= :entidad";
            
            $db=$this->db->prepare($sql); 
            $db->bindValue(':idCampo', $idCampo, PDO::PARAM_INT);
            $db->bindValue(':entidad', $entidad, PDO::PARAM_INT);
            $db->execute();

            return 1; 
            
            

        }catch(PDOException $e){

            return $e->getMessage();
        }
    }
    


    public function guardarCampoFacturacion($tipoCampo, $nomCampo, $entidad){
        
        $sql="";
        $process = "Guardar Campo extra de Facturacion";
        
        

        try{

            $sql = "INSERT INTO campos_extra_detalle (fk_tipo_campo, fk_modulo, fk_empresa, valor) 
            VALUES (:tipo_campo, '4', :entidad, :valor)";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':tipo_campo', $tipoCampo, PDO::PARAM_INT);
            $db->bindValue(':entidad', $entidad, PDO::PARAM_INT);
            $db->bindValue(':valor', $nomCampo, PDO::PARAM_STR);
            $db->execute();

            return 1;

        }catch(PDOException $e){

            return $e->getMessage();
        }
    }


    public function eliminarCampoFacturacion($idCampo, $entidad){
        
        $sql="";
        $process = "Eliminar Campo extra de Facturacion";

        try{
            
            $sql = "DELETE FROM campos_extra_detalle WHERE rowid =:idCampo AND fk_empresa= :entidad";
            
            $db=$this->db->prepare($sql); 
            $db->bindValue(':idCampo', $idCampo, PDO::PARAM_INT);
            $db->bindValue(':entidad', $entidad, PDO::PARAM_INT);
            $db->execute();

            return 1;

        }catch(PDOException $e){

            return $e->getMessage();
        }
    }
    
    
    

    public function guardarCampoProductos($tipoCampo, $nomCampo, $entidad){
        
        $sql="";
        $process = "Guardar Campo extra de Productos";

        try{

            $sql = "INSERT INTO campos_extra_detalle (fk_tipo_campo, fk_modulo, fk_empresa, valor) 
            VALUES (:tipo_campo, '14', :entidad, :valor)";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':tipo_campo', $tipoCampo, PDO::PARAM_INT);
            $db->bindValue(':entidad', $entidad, PDO::PARAM_INT);
            $db->bindValue(':valor', $nomCampo, PDO::PARAM_STR);
            $db->execute();

            return 1;

        }catch(PDOException $e){

            return $e->getMessage();


        }
    }

    public function eliminarCampoProductos($idCampo, $entidad){
        
        $sql="";
        $process = "Eliminar Campo extra de Productos";
        
        
        // return $idCampo;

        try{

            $sql = "DELETE FROM campos_extra_detalle WHERE rowid =:idCampo AND fk_empresa= :entidad";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':idCampo', $idCampo, PDO::PARAM_INT);
            $db->bindValue(':entidad', $entidad, PDO::PARAM_INT);
            $db->execute();

            return 1;

        }catch(PDOException $e){

            return $e->getMessage();


        }
    }
    
    
        public function guardarCampoCotizacion($tipoCampo, $nomCampo, $entidad){
        
        $sql="";
        $process = "Guardar Campo extra de Productos";

        try{

            $sql = "INSERT INTO campos_extra_detalle (fk_tipo_campo, fk_modulo, fk_empresa, valor) 
            VALUES (:tipo_campo, '2', :entidad, :valor)";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':tipo_campo', $tipoCampo, PDO::PARAM_INT);
            $db->bindValue(':entidad', $entidad, PDO::PARAM_INT);
            $db->bindValue(':valor', $nomCampo, PDO::PARAM_STR);
            $db->execute();

            return 1;

        }catch(PDOException $e){

            return $e->getMessage();


        }
    }
    
    public function eliminarCampoCotizacion($idCampo, $entidad){
        
        $sql="";
        $process = "Eliminar Campo extra de Productos";

        try{

            $sql = "DELETE FROM campos_extra_detalle WHERE rowid =:idCampo AND fk_empresa= :entidad";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':idCampo', $idCampo, PDO::PARAM_INT);
            $db->bindValue(':entidad', $entidad, PDO::PARAM_INT);
            $db->execute();

            return 1;

        }catch(PDOException $e){

            return $e->getMessage();


        }
    }
    
    public function crearPerfilUsuario($nombre, $descripcion, $activo){

        $sql="";
        $process = "Crear un perfil de Usuario";

        try{

            $sql = "INSERT INTO fi_usuarios_perfiles (fk_entidad, nombre, descripcion, activo) 
                    VALUES (:fk_entidad, :nombre, :descripcion, :activo)";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':fk_entidad', $_SESSION['Entidad'], PDO::PARAM_INT);
            $db->bindValue(':nombre', $nombre, PDO::PARAM_STR);
            
            $db->bindValue(':descripcion', $descripcion, PDO::PARAM_STR);
            $db->bindValue(':activo', $activo, PDO::PARAM_INT);

            $db->execute();

            return 1;

        }catch(PDOException $e){

            return $e->getMessage();


        }
    }

    

}


/*------------------ BY JAMP 13-11-2021 ------------------------------*/