<?php


class Estado{

public $db;
public $nombre;
public $rowid;
public $label;



public function __construct ($db){         
        $this->db=$db;
}



public function fetch($rowid){

    //echo $rowid;
 $sql="";
    $process = "Consultar el registro Actividades";

    try{


            $sql = 
            "SELECT 
            rowid,
            nombre,
            label, 
            activo  
            FROM crm_estado_cotizaciones 
            WHERE rowid =:rowid ;";

            

            $db=$this->db->prepare($sql); 
            $db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
            $db->execute();
            $datos = $db->fetch(PDO::FETCH_ASSOC);
            //var_dump($datos);

            $this->nombre              = $datos['nombre'];
            $this->label               = $datos['label'];
            $this->rowid               = $datos['rowid'];

            
            //Registros en log success
            $detail  =  'Registro ' . $rowid . ' consultado en la tabla crm_estado_cotizaciones';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $datos['rowid'];

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}


public function guardarEstado(){

  

  $sql="";
        $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la crm_estado_cotizaciones' : 'Actualización del Registro de crm_estado_cotizacioness';

        try{
                    //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                    
                    // COLUMNS
                    $columns = " 
                    nombre              =   :nombre  , 
                    label               =   :label   
                     
                    
                    ";

                    // QUERY
                    $sql = (strlen($this->rowid) == 0) ? "INSERT INTO crm_estado_cotizaciones SET  " . $columns : "UPDATE crm_estado_cotizaciones SET " . $columns . " WHERE rowid =:rowid";
                    $db  = $this->db->prepare($sql);

                    $db->bindValue(":nombre"                ,       $this->nombre , PDO::PARAM_STR);
                    $db->bindValue(":label"                 ,       $this->label  , PDO::PARAM_STR);                                   


                    // Si lleva ID lo tomamos como que es UPDATE 
                    if (strlen($this->rowid) > 0):
                         $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                    endif;
              

                    // EXECUTE
                    $result = $db->execute();

                    //Registros en log success
                    $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                    $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla crm_estado_cotizaciones' : 'Registro ' . $record . ' actualizado en la tabla crm_estado_cotizaciones';
                    //$this->log_success($this->file,$record,$process,$detail);
                    
                    // RETURN
                    return 1;

        }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
            return 0;
        
        }

}


 // FUNCTION CAMBIAR STATUS DEL REGISTRO CLIENTE
    public function changeStatus($status)
    {
        $sql="";
        $process = "Actualización del Estado en el Registro Estado Cotizaciones";

        try{

            // QUERY
            $sql = "UPDATE crm_estado_cotizaciones SET activo =:activo WHERE rowid =:rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $this->rowid, PDO::PARAM_INT);
            $db->bindValue(":activo", $status, PDO::PARAM_INT);
            $result = $db->execute();

            //Registros en log success
            $record  = $this->rowid;
            $detail  = 'Registro ' . $record . ' actualizado en la tabla crm_estado_cotizaciones';
            //$this->log_success($this->file,$record,$process,$detail);

            // RETURN
            return 1;

        }catch(PDOException $e){

            //$this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
            return 0;
        }
    }


} //FIN DE LA CLASE


?>
