<?php


class Actividad{

public $db;
public $nombre;
public $rowid;
public $color;
public $icono;



public function __construct ($db){         
        $this->db=$db;
}



public function fetch($rowid){

    //echo $rowid;
 $sql="";
    $process = "Consultar el registro Actividades";

    try{


            $sql = 
            "SELECT 
            rowid,
            nombre,
            color,
            icono
            FROM diccionario_crm_actividades 
            WHERE rowid =:rowid ;";

            

            $db=$this->db->prepare($sql); 
            $db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
            $db->execute();
            $datos = $db->fetch(PDO::FETCH_ASSOC);
            //var_dump($datos);

            $this->nombre              = $datos['nombre'];
            $this->color               = $datos['color'];
            $this->icono               = $datos['icono'];
            $this->rowid               = $datos['rowid'];

            
            //Registros en log success
            $detail  =  'Registro ' . $rowid . ' consultado en la tabla diccionario_crm_actividades';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $datos['rowid'];

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}


public function guardarActividad(){

  

  $sql="";
        $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la diccionario_crm_actividades' : 'Actualización del Registro de diccionario_crm_actividadess';

        try{
                    //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                    
                    // COLUMNS
                    $columns = " 
                    nombre              =   :nombre  , 
                    color               =   :color   ,
                    icono               =   :icono  ,
                     fk_entidad               =   :fk_entidad  
                    
                    ";

                    // QUERY
                    $sql = (strlen($this->rowid) == 0) ? "INSERT INTO diccionario_crm_actividades SET  " . $columns : "UPDATE diccionario_crm_actividades SET " . $columns . " WHERE rowid =:rowid";
                    $db  = $this->db->prepare($sql);

                    $db->bindValue(":nombre"                ,       $this->nombre , PDO::PARAM_STR);
                    $db->bindValue(":color"                 ,       $this->color  , PDO::PARAM_STR);
                    $db->bindValue(":icono"                 ,       $this->icono  , PDO::PARAM_STR);  
                    $db->bindValue(":fk_entidad"                 ,       $this->fk_entidad  , PDO::PARAM_STR);  


                    // Si lleva ID lo tomamos como que es UPDATE 
                    if (strlen($this->rowid) > 0):
                         $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                    endif;
              

                    // EXECUTE
                    $result = $db->execute();

                    //Registros en log success
                    $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                    $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla diccionario_crm_actividades' : 'Registro ' . $record . ' actualizado en la tabla diccionario_crm_actividades';
                    //$this->log_success($this->file,$record,$process,$detail);
                    
                    // RETURN
                    return 1;

        }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
            return 0;
        
        }

}


 // FUNCTION CAMBIAR STATUS DEL REGISTRO CLIENTE
    public function changeStatus($status)
    {
        $sql="";
        $process = "Actualización del Estado en el Registro Actividades";

        try{

            // QUERY
            $sql = "UPDATE diccionario_crm_actividades SET activo =:activo WHERE rowid =:rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $this->rowid, PDO::PARAM_INT);
            $db->bindValue(":activo", $status, PDO::PARAM_INT);
            $result = $db->execute();

            //Registros en log success
            $record  = $this->rowid;
            $detail  = 'Registro ' . $record . ' actualizado en la tabla diccionario_crm_actividades';
            //$this->log_success($this->file,$record,$process,$detail);

            // RETURN
            return 1;

        }catch(PDOException $e){

            //$this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
            return 0;
        }
    }


} //FIN DE LA CLASE


?>
