<?php


class Flujo{

public $db;
public $nombre;
public $rowid;
public $color;
public $icono;



public function __construct ($db){         
        $this->db=$db;
}



public function fetch($rowid){

    //echo $rowid;
 $sql="";
    $process = "Consultar el registro Flujos";

    try{

            //consulta datos del flujo
            $sql = 
            "SELECT 
            rowid,
            nombre,
            activo,
            fk_usuario,
            entidad,
            fecha_registro
            FROM crm_flujo 
            WHERE rowid =:rowid;";

            

            $db=$this->db->prepare($sql); 
            $db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
            $db->execute();
            $datos = $db->fetch(PDO::FETCH_ASSOC);

          


            
            //var_dump($datos);
            $this->rowid               = $datos['rowid'];
            $this->nombre              = $datos['nombre'];
            $this->activo              = $datos['activo'];
            $this->fk_usuario              = $datos['fk_usuario'];
            $this->entidad              = $datos['entidad'];
            $this->fecha_registro              = $datos['fecha_registro'];
       
        //consultar datos de actividades para este flujo
        $sql = 
            "SELECT 
            rowid,
            descripcion,
            descripcion,
            fk_flujo,
            fk_diccionario_actividad,
            dias,
            activo
            FROM crm_flujo_actividad 
            WHERE fk_flujo =:fk_flujo;";

$db=$this->db->prepare($sql); 
$db->bindValue(':fk_flujo', $rowid, PDO::PARAM_INT);
$db->execute();
$actividad = $db->fetch(PDO::FETCH_ASSOC);





//var_dump($datos);
$this->descripcion                 = $actividad['descripcion'];
$this->fk_flujo                    = $actividad['fk_flujo'];
$this->fk_diccionario_actividad    = $actividad['fk_diccionario_actividad'];
$this->dias                        = $actividad['dias'];
$this->activo                      = $actividad['activo'];



            
            //Registros en log success
            $detail  =  'Registro ' . $rowid . ' consultado en la tabla crm_flujo';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $datos['rowid'];
           

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}



public function MostrarActividades(){

    //echo $rowid;
 $sql="";
    $process = "Consultar el registro Diccionario de actividades";

    try{

            //consulta datos del flujo
            $sql = 
            "SELECT 
            rowid,
            nombre
            FROM diccionario_crm_actividades";

            

            $db=$this->db->prepare($sql); 
            $db->execute();
            $results = $db -> fetchAll(PDO::FETCH_OBJ);

          
       
      



            
            //Registros en log success
            $detail  =  'Consulta en la tabla diccionario_crm_actividades';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $results;
           

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}


public function ultimoFlujo($entidad){
   // $data = $entidad;
   $entidad = $_SESSION['Entidad'];
   // return $data;

   //Devolver el ultimo flujo de la entidad para que le agregue actividades
   
    //echo $rowid;
 $sql="";
 $process = "Consultar el ultimo flujo de la entidad";

 try{

         //consulta datos del flujo
         $sql = "SELECT rowid FROM crm_flujo WHERE entidad = $entidad ORDER BY rowid DESC LIMIT 1";
         $db  = $this->db->prepare($sql);
         $db->execute();
         $results = ($db->fetch(PDO::FETCH_OBJ));
       //  echo $sql;
         //$this->log_success( $this->file,$rowid,$process,$detail);

         // RETURN el ultimo rowid registrado en la tabla crm_flujo
     if ($db) {
       return $results->rowid;
     }else{
         return "no se pudo";
     }
        

 }catch(PDOException  $e){
         //Registros en log error
         //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
         return $e->getMessage();
         
 }
}


public function saludo(){
    return "saludo desde la clase en crm configuracion";
}

public function guardarFlujo(){

  

  $sql="";
        $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la crm_flujo' : 'Actualización del Registro de crm_flujos';

        try{
                    //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                    
                    // COLUMNS
                    $columns = " 
                    nombre              =   :nombre,
                    activo              =   :activo,
                    fk_usuario          =   :fk_usuario,
                    entidad             =   :entidad, 
                    fecha_registro      =   :fecha_registro
                   
                    
                    ";

                    // QUERY
                    $sql = (strlen($this->rowid) == 0) ? "INSERT INTO crm_flujo SET  " . $columns : "UPDATE crm_flujo SET " . $columns . " WHERE rowid =:rowid";
                    $db  = $this->db->prepare($sql);

                    $db->bindValue(":nombre"                ,       $this->nombre, PDO::PARAM_STR);
                    $db->bindValue(":activo"        ,       $this->activo, PDO::PARAM_STR);
                    $db->bindValue(":fk_usuario"        ,       $this->fk_usuario, PDO::PARAM_STR);
                    $db->bindValue(":entidad"        ,       $this->entidad, PDO::PARAM_STR);
                    $db->bindValue(":fecha_registro"        ,       $this->fecha_registro, PDO::PARAM_STR);
                                    


                    // Si lleva ID lo tomamos como que es UPDATE 
                    if (strlen($this->rowid) > 0):
                         $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                    endif;
              

                    // EXECUTE
                    $result = $db->execute();

                    //Registros en log success
                    $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                    $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla diccionario_crm_actividades' : 'Registro ' . $record . ' actualizado en la tabla diccionario_crm_actividades';
                    //$this->log_success($this->file,$record,$process,$detail);
                    
                    // RETURN
                    return 1;

        }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
            return 0;
        
        }

}

public function guardarActividadFlujo(){

  

    $sql="";
          $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la tabla crm_flujo_actividad' : 'Actualización del Registro de la tabla crm_flujo_actividad';
  
          try{
                      //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                      
                      // COLUMNS
                      $columns = " 
                      descripcion                =   :descripcion,
                      fk_flujo                   =   :fk_flujo,
                      fk_diccionario_actividad   =   :fk_diccionario_actividad,
                      dias                       =   :dias, 
                      activo                     =   :activo
                     
                      
                      ";
  
                      // QUERY
                      $sql = (strlen($this->rowid) == 0) ? "INSERT INTO crm_flujo_actividad SET  " . $columns : "UPDATE crm_flujo_actividad SET " . $columns . " WHERE rowid =:rowid";
                      $db  = $this->db->prepare($sql);
  
                      $db->bindValue(":descripcion"                ,       $this->descripcion, PDO::PARAM_STR);
                      $db->bindValue(":fk_flujo"        ,       $this->fk_flujo, PDO::PARAM_STR);
                      $db->bindValue(":fk_diccionario_actividad"        ,       $this->fk_diccionario_actividad, PDO::PARAM_STR);
                      $db->bindValue(":dias"        ,       $this->dias, PDO::PARAM_STR);
                      $db->bindValue(":activo"        ,       $this->activo, PDO::PARAM_STR);
                                      
  
  
                      // Si lleva ID lo tomamos como que es UPDATE 
                      if (strlen($this->rowid) > 0):
                           $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                      endif;
                
  
                      // EXECUTE
                      $result = $db->execute();
  
                      //Registros en log success
                      $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                      $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla crm_flujo_actividad' : 'Registro ' . $record . ' actualizado en la tabla crm_flujo_actividad';
                      //$this->log_success($this->file,$record,$process,$detail);
                      
                      // RETURN
                      return 1;
  
          }catch(PDOException  $e){
              //Registros en log error
              //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
              return 0;
          
          }
  
  }




  
public function guardarInfoForecast(){

  

    $sql="";
          $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la tabla crm_flujo_actividad' : 'Actualización del Registro de la tabla crm_flujo_actividad';
  
          try{
                      //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                      
                      // COLUMNS
                      $columns = " 
                      nombre                =   :nombre
                     
                      
                      ";
  
                      // QUERY
                      $sql = (strlen($this->rowid) == 0) ? "INSERT INTO fi_crm_forecast SET  " . $columns : "UPDATE fi_crm_forecast SET " . $columns . " WHERE rowid =:rowid";
                      $db  = $this->db->prepare($sql);
  
                      $db->bindValue(":nombre"                ,       $this->nombre, PDO::PARAM_STR);
  
                                      
  
  
                      // Si lleva ID lo tomamos como que es UPDATE 
                      if (strlen($this->rowid) > 0):
                           $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                      endif;
                
  
                      // EXECUTE
                      $result = $db->execute();
  
                      //Registros en log success
                      $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                      $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla crm_flujo_actividad' : 'Registro ' . $record . ' actualizado en la tabla crm_flujo_actividad';
                      //$this->log_success($this->file,$record,$process,$detail);
                      
                      // RETURN
                      return 1;
  
          }catch(PDOException  $e){
              //Registros en log error
              //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
              return 0;
          
          }
  
  }


  


 // FUNCTION CAMBIAR STATUS DEL REGISTRO CLIENTE
    public function cambiarEstatus($activo)
    {
        $sql="";
        $process = "Actualización del Estado en el Registro Actividades";

        try{

            // QUERY
            $sql = "UPDATE crm_flujo SET activo =:activo WHERE rowid =:rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $this->rowid, PDO::PARAM_INT);
            $db->bindValue(":activo", $activo, PDO::PARAM_INT);
            $result = $db->execute();

            //Registros en log success
            $record  = $this->rowid;
            $detail  = 'Registro ' . $record . ' actualizado en la tabla diccionario_crm_actividades';
            //$this->log_success($this->file,$record,$process,$detail);

            // RETURN
            return 1;

        }catch(PDOException $e){

            //$this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
            return 0;
        }
    }


} //FIN DE LA CLASE


?>
