<?php

session_start();
require "../../conf/conf.php";

header("Content-type:   application/x-msexcel; charset=utf-8");
header("Pragma: no-cache");
header("Expires: 0");
$filename = 'Listado_Productos_al_dia_' . date('d-m-Y') . '.xls';
header('Content-Disposition: attachment; filename=' . $filename);
echo pack("CCC", 0xef, 0xbb, 0xbf);
ob_start();

//fecha actual server
$fecha_actual = date("Y-m-d");
//resto 30 día
$fecha_pasado = date("Y-m-d", strtotime($fecha_actual . "- 30 days"));


$where = '';
//Obtener el nombre en base al rowid
$where .= ($_POST['id'] !="") ? " AND rowid = ".$_POST['id']." " : "";
$where .= (!empty($_GET['nombre_empresa'])) ? " AND ce.nombre LIKE '%".$_GET['nombre_empresa']."%' "   : "";
$where .= (!empty($_GET['creacion_fecha'])) ? " AND cp.creacion_fecha  LIKE '%".$_GET['creacion_fecha']."%' "   : "";
$where .= (!empty($_POST['estatus'])) ? " AND estatus     LIKE '%".$_POST['estatus']."%' "   : "";
$where .= (!empty($_POST['fk_entidad'])) ? " AND fk_entidad     LIKE '%".$_POST['fk_entidad']."%' "   : "";

//consulta principal
$sql = 
"SELECT
cp.rowid,
cp.fk_empresa,
cp.fk_contacto,
cp.fk_entidad,
cp.fk_flujo, 
cp.creacion_usuario,
cp.creacion_fecha,
cp.activo,
cp.estatus,
cp.comentario as detalle,
ce.nombre as nombre_empresa
FROM crm_prospeccion cp
INNER JOIN crm_empresas ce ON ce.rowid = cp.fk_empresa
WHERE 1 $where";
$db = $dbh->prepare($sql);

$db->execute();

$contado = 0;
$class   = "add";

while ($obj = $db->fetch(PDO::FETCH_OBJ)) {


    //Mostrar fecha en formato Humano
    $format_fecha = date("d-m-Y", strtotime($obj->creacion_fecha));

    //Query para consultar la cantidad de productos y el precio total usando el rowid del flujo en la tabla forecast
    $gsent = $dbh->prepare("SELECT COUNT(cps.rowid) as cantidad, fp.label as nombre_producto, sum(fp.tosell) as total
    FROM crm_prospeccion_servicios cps 
    INNER JOIN fi_productos fp on fp.rowid = cps.fk_servicio
    WHERE fk_forecast = $obj->rowid");
    $gsent->execute();
    $result = $gsent->fetch(PDO::FETCH_OBJ);
    if ($result->cantidad > 1) {
        $result->nombre_producto = 'Varios';
    }
    if ($result->cantidad < 1) {
        $result->nombre_producto = 'Sin productos';
    }

 

    //Query para consutar el nombre del vendedor con su fk
    $gsent3 = $dbh->prepare("SELECT nombre FROM fi_usuarios WHERE entidad = $obj->fk_entidad");
    $gsent3->execute();
    $result3 = $gsent3->fetch(PDO::FETCH_OBJ);

    //Query para consutar el nombre del estatus con su fk
    $gsent4 = $dbh->prepare("SELECT nombre FROM crm_estado_cotizaciones WHERE rowid = $obj->estatus");
    $gsent4->execute();
    $result4 = $gsent4->fetch(PDO::FETCH_OBJ);

    $tr .=
        '<tr class="gradeX odd" role="row"  style="cursor:pointer;">
    
       
            <td style="text-align: center;">' . $format_fecha . '</td>
            <td style="text-align: center;">' . $obj->nombre_empresa . '</td>
            <td style="text-align: center;">' . $result->nombre_producto . '</td>
          
            <td style="text-align: center;">' . $result->total . '</td>
           
            <td style="text-align: center;">' . $obj->detalle . '</td>
           
        </tr>';
}

?>


<table id="example1" class="table table-bordered table-striped dataTable" aria-describedby="example1_info">
    <thead style="background-color:blue;color:white;">
        <tr style="background-color:black;color:white;">
            <th>Fecha</th>
            <th>Cliente</th>
            <th>Equipo</th>
            <th>Monto</th>
            <th>Detalle</th>
        
        </tr>
    </thead>
    <tbody role="alert" aria-live="polite" aria-relevant="all">
        <?php echo $tr; ?>
    </tbody>
</table>
<?php

$content = ob_get_clean();

$data = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
    <!--[if gte mso 9]>
    <xml>
        <x:ExcelWorkbook>
            <x:ExcelWorksheets>
                <x:ExcelWorksheet>
                    <x:Name>Listado_Productos</x:Name>
                    <x:WorksheetOptions>
                        <x:Print>
                            <x:ValidPrinterInfo/>
                        </x:Print>
                    </x:WorksheetOptions>
                </x:ExcelWorksheet>
            </x:ExcelWorksheets>
        </x:ExcelWorkbook>
    </xml>
    <![endif]-->
</head>

<body>
   ' . $content . '
</body></html>';

echo $data;
