<?php


class Contacto{

public $db;
public $nombre;
public $rowid;
public $apellidos;
public $cedula;
public $telefono;
public $correo;
public $whatsapp;
public $likedin;
public $facebook;
public $direccion;
public $latitud;
public $longitud;
public $activo;



public function __construct ($db){         
        $this->db=$db;
}



public function fetch($rowid){

    //echo $rowid;
 $sql="";
    $process = "Consultar el registro Contactos";

    try{


            $sql = 
            "SELECT 
            rowid,
            nombre,
            apellidos,
            cedula, 
            telefono,
            correo,
            whatsapp,
            likedin,
            facebook,
            direccion,
            latitud,
            longitud,
            activo   
            FROM crm_contactos 
            WHERE rowid =:rowid ;";

            

            $db=$this->db->prepare($sql); 
            $db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
            $db->execute();
            $datos = $db->fetch(PDO::FETCH_ASSOC);
            //var_dump($datos);

            $this->rowid               = $datos['rowid'];
            $this->nombre              = $datos['nombre'];
            $this->apellidos           = $datos['apellidos'];
            $this->cedula              = $datos['cedula'];
            $this->telefono            = $datos['telefono'];
            $this->correo              = $datos['correo'];
            $this->whatsapp            = $datos['whatsapp'];
            $this->likedin             = $datos['likedin'];
            $this->facebook            = $datos['facebook'];
            $this->direccion           = $datos['direccion'];
            $this->latitud             = $datos['latitud'];
            $this->longitud            = $datos['longitud'];
            $this->activo              = $datos['activo'];
            

            
            //Registros en log success
            $detail  =  'Registro ' . $rowid . ' consultado en la tabla crm_contactos';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $datos['rowid'];

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}


public function guardarContacto(){

  

  $sql="";
        $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la crm_contactos' : 'Actualización del Registro de crm_contactos';

        try{
                    //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                    
                    // COLUMNS
                    $columns = "
                               
                                nombre              = :nombre,
                                apellidos           = :apellidos,
                                cedula              = :cedula, 
                                telefono            = :telefono,
                                correo              = :correo,
                                whatsapp            = :whatsapp,
                                likedin             = :likedin,
                                facebook            = :facebook,
                                direccion           = :direccion
                                
                                
                    
                    ";

                    // QUERY
                    $sql = (strlen($this->rowid) == 0) ? "INSERT INTO crm_contactos SET  " . $columns : "UPDATE crm_contactos SET " . $columns . " WHERE rowid =:rowid";
                    $db  = $this->db->prepare($sql);

                    $db->bindValue(":nombre"                    ,       $this->nombre , PDO::PARAM_STR);
                    $db->bindValue(":apellidos"                 ,       $this->apellidos  , PDO::PARAM_STR);
                    $db->bindValue(":cedula"                    ,       $this->cedula  , PDO::PARAM_STR);
                    $db->bindValue(":telefono"                  ,       $this->telefono  , PDO::PARAM_STR);  
                    $db->bindValue(":correo"                    ,       $this->correo  , PDO::PARAM_STR);  
                    $db->bindValue(":whatsapp"                  ,       $this->whatsapp  , PDO::PARAM_STR);  
                    $db->bindValue(":likedin"                   ,       $this->likedin  , PDO::PARAM_STR);  
                    $db->bindValue(":facebook"                  ,       $this->facebook  , PDO::PARAM_STR);  
                    $db->bindValue(":direccion"                 ,       $this->direccion  , PDO::PARAM_STR);
                    

                    // Si lleva ID lo tomamos como que es UPDATE 
                    if (strlen($this->rowid) > 0):
                         $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                    endif;
              

                    // EXECUTE
                    $result = $db->execute();

                    //Registros en log success
                    $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                    $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla crm_contactos' : 'Registro ' . $record . ' actualizado en la tabla crm_contactos';
                    //$this->log_success($this->file,$record,$process,$detail);
                    
                    // RETURN
                    return 1;

        }catch(PDOException  $e){
                    //Registros en log error
                    //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
                    return 0;
        
        }

}


 // FUNCTION CAMBIAR STATUS DEL REGISTRO CLIENTE
    public function changeStatus($status)
    {
        $sql="";
        $process = "Actualización del Estado en el Registro Actividades";

        try{

            // QUERY
            $sql = "UPDATE crm_contactos SET activo =:activo WHERE rowid =:rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $this->rowid, PDO::PARAM_INT);
            $db->bindValue(":activo", $status, PDO::PARAM_INT);
            $result = $db->execute();

            //Registros en log success
            $record  = $this->rowid;
            $detail  = 'Registro ' . $record . ' actualizado en la tabla crm_contactos';
            //$this->log_success($this->file,$record,$process,$detail);

            // RETURN
            return 1;

        }catch(PDOException $e){

            //$this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
            return 0;
        }
    }


} //FIN DE LA CLASE


?>
