<?php


class Empresa{

public $db;
public $nombre;
public $rowid;
public $fk_tipo;
public $identificacion;
public $telefono;
public $correo;
public $direccion;
public $activo;



public function __construct ($db){         
        $this->db=$db;
}



public function fetch($rowid){

    //echo $rowid;
 $sql="";
    $process = "Consultar el registro Contactos";

    try{


            $sql = 
                "SELECT
                E.rowid,
                TE.rowid,
                E.nombre,
                E.fk_tipo,
                E.telefono, 
                E.direccion,
                E.identificacion,
                E.email,
                E.activo,
                TE.tipo   
                FROM crm_empresas E
                LEFT JOIN diccionario_tipo_empresa TE ON TE.rowid = E.fk_tipo
                WHERE E.rowid =:rowid ;";

            

            $db=$this->db->prepare($sql); 
            $db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
            $db->execute();
            $datos = $db->fetch(PDO::FETCH_ASSOC);
            //var_dump($datos);

            $this->rowid               = $datos['rowid'];
            $this->nombre              = $datos['nombre'];
            $this->identificacion      = $datos['identificacion'];
            $this->telefono            = $datos['telefono'];
            $this->email               = $datos['email'];
            $this->fk_tipo             = $datos['fk_tipo'];
            $this->direccion           = $datos['direccion'];
            $this->activo              = $datos['activo'];
            

            
            //Registros en log success
            $detail  =  'Registro ' . $rowid . ' consultado en la tabla crm_contactos';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $datos['rowid'];

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}


public function guardarEmpresa(){

  

  $sql="";
        $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la crm_empresas' : 'Actualización del Registro de crm_empresas';

        try{
                    //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                    
                    // COLUMNS
                    $columns = "
                               
                                nombre              = :nombre,
                                fk_tipo             = :fk_tipo,
                                identificacion      = :identificacion, 
                                telefono            = :telefono,
                                email               = :email,
                                direccion           = :direccion
                                
                                
                    
                    ";

                    // QUERY
                    $sql = (strlen($this->rowid) == 0) ? "INSERT INTO crm_empresas SET  " . $columns : "UPDATE crm_empresas SET " . $columns . " WHERE rowid =:rowid";
                    $db  = $this->db->prepare($sql);

                    $db->bindValue(":nombre"                    ,       $this->nombre , PDO::PARAM_STR);
                    $db->bindValue(":fk_tipo"                   ,       $this->fk_tipo  , PDO::PARAM_INT);
                    $db->bindValue(":identificacion"            ,       $this->identificacion  , PDO::PARAM_STR);
                    $db->bindValue(":telefono"                  ,       $this->telefono  , PDO::PARAM_STR);  
                    $db->bindValue(":email"                     ,       $this->email  , PDO::PARAM_STR);  
                    $db->bindValue(":direccion"                 ,       $this->direccion  , PDO::PARAM_STR);
                    

                    // Si lleva ID lo tomamos como que es UPDATE 
                    if (strlen($this->rowid) > 0):
                         $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                    endif;
              

                    // EXECUTE
                    $result = $db->execute();

                    //Registros en log success
                    $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                    $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla crm_empresas' : 'Registro ' . $record . ' actualizado en la tabla crm_empresas';
                    //$this->log_success($this->file,$record,$process,$detail);
                    
                    // RETURN
                    return 1;

        }catch(PDOException  $e){
                    //Registros en log error
                    //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
                    return 0;
        
        }

}


 // FUNCTION CAMBIAR STATUS DEL REGISTRO CLIENTE
    public function changeStatus($status)
    {
        $sql="";
        $process = "Actualización del Estado en el Registro Actividades";

        try{

            // QUERY
            $sql = "UPDATE crm_empresas SET activo =:activo WHERE rowid =:rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $this->rowid, PDO::PARAM_INT);
            $db->bindValue(":activo", $status, PDO::PARAM_INT);
            $result = $db->execute();

            //Registros en log success
            $record  = $this->rowid;
            $detail  = 'Registro ' . $record . ' actualizado en la tabla crm_empresas';
            //$this->log_success($this->file,$record,$process,$detail);

            // RETURN
            return 1;

        }catch(PDOException $e){

            //$this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
            return 0;
        }
    }


} //FIN DE LA CLASE


?>
