<?php


class Flujo{

public $db;
public $nombre;
public $rowid;
public $color;
public $icono;



public function __construct ($db){         
        $this->db=$db;
}



public function fetch($rowid){

    //echo $rowid;
 $sql="";
    $process = "Consultar el registro Flujos";

    try{

            //consulta datos del flujo
            $sql = 
            "SELECT 
            rowid,
            nombre,
            activo,
            fk_usuario,
            entidad,
            fecha_registro
            FROM crm_flujo 
            WHERE rowid =:rowid;";

            

            $db=$this->db->prepare($sql); 
            $db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
            $db->execute();
            $datos = $db->fetch(PDO::FETCH_ASSOC);

          


            
            //var_dump($datos);
            $this->rowid               = $datos['rowid'];
            $this->nombre              = $datos['nombre'];
            $this->activo              = $datos['activo'];
            $this->fk_usuario              = $datos['fk_usuario'];
            $this->entidad              = $datos['entidad'];
            $this->fecha_registro              = $datos['fecha_registro'];
       
        //consultar datos de actividades para este flujo
        $sql = 
            "SELECT 
            rowid,
            descripcion,
            descripcion,
            fk_flujo,
            fk_diccionario_actividad,
            dias,
            activo
            FROM crm_flujo_actividad 
            WHERE fk_flujo =:fk_flujo;";

$db=$this->db->prepare($sql); 
$db->bindValue(':fk_flujo', $rowid, PDO::PARAM_INT);
$db->execute();
$actividad = $db->fetch(PDO::FETCH_ASSOC);





//var_dump($datos);
$this->descripcion                 = $actividad['descripcion'];
$this->fk_flujo                    = $actividad['fk_flujo'];
$this->fk_diccionario_actividad    = $actividad['fk_diccionario_actividad'];
$this->dias                        = $actividad['dias'];
$this->activo                      = $actividad['activo'];



            
            //Registros en log success
            $detail  =  'Registro ' . $rowid . ' consultado en la tabla crm_flujo';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $datos['rowid'];
           

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}



public function DetallesActividad($rowid){
    //echo $rowid;
 $sql="";
    $process = "Consultar el detalle de una actividad crm_prospeccion_actividades";

    try{

            //consulta datos del flujo
            $sql ="SELECT
            rowid,
             fecha,
              descripcion,
               fk_estado,
               fk_actividad
                FROM crm_prospeccion_actividades WHERE rowid =:rowid";

            

            $db=$this->db->prepare($sql); 
            $db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
            $db->execute();
            $datos = $db->fetch(PDO::FETCH_ASSOC);

          


            
            //var_dump($datos);
            $this->rowid                   = $datos['rowid'];
            $this->fecha                   = $datos['fecha'];
            $this->descripcion             = $datos['descripcion'];
            $this->fk_estado               = $datos['fk_estado'];
            $this->fk_actividad            = $datos['fk_actividad'];
            
      


            
            //Registros en log success
            $detail  =  'Registro ' . $rowid . ' consultado en la tabla crm_flujo';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $datos['rowid'];
           

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}



public function forecastDetalle($rowid){

    //echo $rowid;
 $sql="";
    $process = "Consultar el detalle forecast";

    try{

            //consulta datos del flujo
            $sql = 
            "SELECT 
            rowid,
            fk_empresa,
            fk_contacto,
            fk_entidad,
            fk_flujo,
            creacion_usuario,
            creacion_fecha,
            activo,
            comentario,
            estatus,
            fk_vendedor
            FROM crm_prospeccion 
            WHERE rowid =:rowid;";

            

            $db=$this->db->prepare($sql); 
            $db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
            $db->execute();
            $datos = $db->fetch(PDO::FETCH_ASSOC);

          


            
            //var_dump($datos);
            $this->rowid                   = $datos['rowid'];
            $this->fk_empresa              = $datos['fk_empresa'];
            $this->fk_contacto             = $datos['fk_contacto'];
            $this->fk_entidad              = $datos['fk_entidad'];
            $this->fk_flujo                = $datos['fk_flujo'];
            $this->creacion_usuario        = $datos['creacion_usuario'];
            $this->creacion_fecha          = $datos['creacion_fecha'];
            $this->activo                  = $datos['activo'];
            $this->estatus                  = $datos['estatus'];
            $this->comentario              = $datos['comentario'];
            
      // fin de la consulta general

      //obtener informacion detallada del contacto
$fk_contacto_forecast = $datos['fk_contacto'];
       
        //consultar el datos del contacto
        $sql = 
            "SELECT 
            rowid,
            fk_empresa,
            nombre,
            apellidos,
            telefono
            FROM crm_contactos 
            WHERE rowid =:fk_contacto;";

$db=$this->db->prepare($sql); 
$db->bindValue(':fk_contacto', $fk_contacto_forecast, PDO::PARAM_INT);
$db->execute();
$contacto = $db->fetch(PDO::FETCH_ASSOC);





//var_dump($datos);
$this->nombre_contacto                 = $contacto['nombre'].' '.$contacto['apellidos'];
$this->telefono_contacto                 = $contacto['telefono'];

// fin de obtener datos del contacto


  //obtener informacion detallada del vendedor
  $fk_vendedor_forecast = $datos['fk_vendedor'];
       
  //consultar el datos del contacto
  $sql = 
      "SELECT 
      rowid,
      entidad,
      nombre,
      apellidos,
      telefono
      FROM fi_usuarios 
      WHERE rowid =:fk_vendedor_forecast;";

$db=$this->db->prepare($sql); 
$db->bindValue(':fk_vendedor_forecast', $fk_vendedor_forecast, PDO::PARAM_INT);
$db->execute();
$vendedor = $db->fetch(PDO::FETCH_ASSOC);





//var_dump($datos);
$this->nombre_vendedor                 = $vendedor['nombre'].' '.$vendedor['apellidos'];
$this->telefono_vendedor                 = $vendedor['telefono'];
$this->rowid_vendedor                 = $vendedor['rowid'];

// fin de obtener datos del contacto



  //obtener informacion detallada de la empresa
  $fk_empresa_forecast = $datos['fk_empresa'];
       
  //consultar el datos del contacto
  $sql = 
      "SELECT 
      rowid,
      nombre,
      identificacion,
      telefono,
      email
      FROM crm_empresas 
      WHERE rowid =:fk_empresa;";

$db=$this->db->prepare($sql); 
$db->bindValue(':fk_empresa', $fk_empresa_forecast, PDO::PARAM_INT);
$db->execute();
$empresa = $db->fetch(PDO::FETCH_ASSOC);





//var_dump($datos);
$this->nombre_empresa                = $empresa['nombre'];
$this->telefono_empresa              = $empresa['telefono'];
$this->identificacion_empresa        = $empresa['identificacion'];
$this->telefono_empresa              = $empresa['telefono'];
$this->email_empresa                 = $empresa['email'];




            
            //Registros en log success
            $detail  =  'Registro ' . $rowid . ' consultado en la tabla crm_flujo';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $datos['rowid'];
           

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}




    function getEstados($rowid){

        $sql = "";

        $process = "Obtener Estados del Forecast";

        try{

            $sql = "SELECT c.rowid, e.nombre 
                    FROM crm_prospeccion c 
                    INNER JOIN crm_estado_cotizaciones e 
                    ON e.rowid = c.estatus 
                    WHERE c.rowid = :rowid";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
            $db->execute();

            $datos = $db->fetch(PDO::FETCH_ASSOC);

            // var_dump($datos);

            $this->estado     =       $datos['nombre'];
            return $this->estado;


        }catch(PDOException  $e){

            return $e->getMessage();

        }
    }
    
     function obtenerEstados(){

        $sql = "";

        $process = "Obtener Estados del Forecast";

        try{

            $sql = "SELECT * FROM crm_estado_cotizaciones";

            $db=$this->db->prepare($sql); 
            $db->execute();

            $datos = $db->fetchAll(PDO::FETCH_ASSOC);

            return $datos;


        }catch(PDOException  $e){

            return $e->getMessage();

        }
    }


    function updateEstadoForecast($id, $estado){

        $sql = "";

        $process = "Actualizar Estados del Forecast";

        try{

            $sql = "UPDATE crm_prospeccion 
                    SET estatus = :estado 
                    WHERE rowid = :rowid";

            $db=$this->db->prepare($sql); 
            $db->bindValue(':rowid', $id, PDO::PARAM_INT);
            $db->bindValue(':estado', $estado, PDO::PARAM_INT);
            $datos = $db->execute();

            // var_dump($datos);

            return 1;

        }catch(PDOException  $e){

            return $e->getMessage();

        }


    }
    
    
    
    
    
      function actualizarMultiple($estado, $lista){

        $sql = "";

        $process = "Actualizar Estados a una lista de prospecciones";

        foreach ($lista as $key => $value) {
        
if($value > 0){
    
    try{

                $sql = "UPDATE crm_prospeccion 
                        SET estatus = :estado 
                        WHERE rowid = :rowid";
    
                $db=$this->db->prepare($sql); 
                $db->bindValue(':rowid', $value, PDO::PARAM_STR);
                $db->bindValue(':estado', $estado, PDO::PARAM_STR);
                $datos = $db->execute();
    
                // var_dump($datos);
    
          
    
            }catch(PDOException  $e){
    
                echo $e->getMessage();
    
            }
            
                
    
}
            
         
          
        }
        
          return 1;

       


    }

/* ------------------ BY JAMP 12-11-2021 ------------------------- */



public function MostrarActividades(){

    //echo $rowid;
 $sql="";
    $process = "Consultar el registro Diccionario de actividades";

    try{

            //consulta datos del flujo
            $sql = 
            "SELECT 
            rowid,
            nombre
            FROM diccionario_crm_actividades";

            

            $db=$this->db->prepare($sql); 
            $db->execute();
            $results = $db -> fetchAll(PDO::FETCH_OBJ);

          
       
      



            
            //Registros en log success
            $detail  =  'Consulta en la tabla diccionario_crm_actividades';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $results;
           

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}




public function NombreFlujo($fk_flujo){

    //echo $rowid;
 $sql="";
    $process = "Consultar el registro Diccionario de actividades";

    try{

            //consulta datos del flujo
            $sql = 
            "SELECT 
            rowid,
            nombre
            FROM crm_flujo where rowid = $fk_flujo";

            

            $db=$this->db->prepare($sql); 
            $db->execute();
            $results = $db -> fetchAll(PDO::FETCH_OBJ);

          
       
      



            
            //Registros en log success
            $detail  =  'Consulta en la tabla crm_flujo';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $results;
           

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}




public function MostrarServicios($rowid_prospeccion){

    //echo $rowid;
 $sql="";
    $process = "Consultar el registro servicios asignadas para una prospeccion";

    try{

            //consulta servicios
            $sql = 
            "SELECT 
            rowid,
            fk_forecast,
            fk_servicio,
            dias
            FROM crm_prospeccion_servicios WHERE fk_forecast = $rowid_prospeccion";

            

            $db=$this->db->prepare($sql); 
            $db->execute();
            $results = $db -> fetchAll(PDO::FETCH_OBJ);

            

          
       
      



            
            //Registros en log success
            $detail  =  'Consulta en la tabla diccionario_crm_actividades';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $results;
           

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}



public function MostrarNombreServicio($rowid_servicio){

    //echo $rowid;
 $sql="";
    $process = "Consultar el nombre del fk servicios asignadas para una prospeccion";

    try{

            //consulta servicios
            $sql = 
            "SELECT 
            rowid,
            label
            FROM fi_productos WHERE rowid = $rowid_servicio";

            

            $db=$this->db->prepare($sql); 
            $db->execute();
            $results = $db -> fetchAll(PDO::FETCH_OBJ);
            
            //Registros en log success
            $detail  =  'Consulta en la tabla diccionario_crm_actividades';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $results;
           

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}



public function actividadesPendientes($rowid){
   
    //echo $rowid;
 $sql="";
 $process = "Consultar el registro servicios asignadas para una prospeccion";

 try{

         //consultar activides pendientes
         $sql = 
         "SELECT
         COUNT(*) as total_pendiente  
         FROM crm_prospeccion_actividades where fk_forecast = $rowid and fk_actividad > 0 and fk_estado = 1";

         

         $db=$this->db->prepare($sql); 
         $db->execute();
         $results = $db -> fetchAll(PDO::FETCH_OBJ);
         
         //Registros en log success
         $detail  =  'Consulta en la tabla diccionario_crm_actividades';
         //$this->log_success( $this->file,$rowid,$process,$detail);

         // RETURN
         return $results;
        

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}




public function actividadesRealizado($rowid){
   
    //echo $rowid;
 $sql="";
 $process = "Consultar el registro servicios asignadas para una prospeccion";

 try{

         //consultar activides realizado
         $sql = 
         "SELECT
         COUNT(*) as total_realizado  
         FROM crm_prospeccion_actividades where fk_forecast = $rowid and fk_actividad > 0 and fk_estado = 2";

         

         $db=$this->db->prepare($sql); 
         $db->execute();
         $results = $db -> fetchAll(PDO::FETCH_OBJ);


         
         //Registros en log success
         $detail  =  'Consulta en la tabla diccionario_crm_actividades';
         //$this->log_success( $this->file,$rowid,$process,$detail);

         // RETURN
         return $results;
        

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}




public function totalForecastEmpresa($rowid_forecast){

    //echo $rowid;
 $sql="";
    $process = "Consultar el total actividades asignadas para un forecast";

    try{

            //consulta servicios
            $sql = 
            "SELECT COUNT(*) as total FROM crm_prospeccion_actividades WHERE fk_forecast = $rowid_forecast";

            

            $db=$this->db->prepare($sql); 
            $db->execute();
            $results = $db -> fetchAll(PDO::FETCH_OBJ);
            
            //Registros en log success
            $detail  =  'Consultar el total forecast asignadas para una empresa';
            //$this->log_success( $this->file,$rowid,$process,$detail);

            // RETURN
            return $results;
           

    }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return $e->getMessage();
            
    }

}



public function ultimoFlujo($entidad){
   // $data = $entidad;
   // return $data;

   //Devolver el ultimo flujo de la entidad para que le agregue actividades
   
    //echo $rowid;
 $sql="";
 $process = "Consultar la ultima activiidad de la entidad";

 try{

         //consulta datos del flujo
         $sql = "SELECT rowid FROM crm_flujo WHERE entidad = $entidad ORDER BY rowid DESC LIMIT 1";
         $db  = $this->db->prepare($sql);
         $db->execute();
         $results = ($db->fetch(PDO::FETCH_OBJ));
         //$this->log_success( $this->file,$rowid,$process,$detail);

         // RETURN el ultimo rowid registrado en la tabla crm_flujo
     if ($db) {
       return $results->rowid;
     }else{
         return "no se pudo";
     }
        

 }catch(PDOException  $e){
         //Registros en log error
         //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
         return $e->getMessage();
         
 }
}



public function ultimoForecast($entidad){
    // $data = $entidad;
    // return $data;
 
    //Devolver el ultimo flujo de la entidad para que le agregue actividades
    
     //echo $rowid;
  $sql="";
  $process = "Consultar la ultima actividad de la entidad";
 
  try{
 
          //consulta datos del flujo
          $sql = "SELECT rowid FROM crm_prospeccion WHERE fk_entidad = $entidad ORDER BY rowid DESC LIMIT 1";
          $db  = $this->db->prepare($sql);
          $db->execute();
          $results = ($db->fetch(PDO::FETCH_OBJ));
          //$this->log_success( $this->file,$rowid,$process,$detail);
 
          // RETURN el ultimo rowid registrado en la tabla crm_flujo
      if ($db) {
        return $results->rowid;
      }else{
          return "no se pudo";
      }
         
 
  }catch(PDOException  $e){
          //Registros en log error
          //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
          return $e->getMessage();
          
  }
 }
 

public function saludo(){
    return "saludo desde la clase en crm configuracion";
}

public function guardarFlujo(){

  

  $sql="";
        $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la crm_flujo' : 'Actualización del Registro de crm_flujos';

        try{
                    //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                    
                    // COLUMNS
                    $columns = " 
                    nombre              =   :nombre,
                    activo              =   :activo,
                    fk_usuario          =   :fk_usuario,
                    entidad             =   :entidad, 
                    fecha_registro      =   :fecha_registro
                   
                    
                    ";

                    // QUERY
                    $sql = (strlen($this->rowid) == 0) ? "INSERT INTO crm_flujo SET  " . $columns : "UPDATE crm_flujo SET " . $columns . " WHERE rowid =:rowid";
                    $db  = $this->db->prepare($sql);

                    $db->bindValue(":nombre"                ,       $this->nombre, PDO::PARAM_STR);
                    $db->bindValue(":activo"        ,       $this->activo, PDO::PARAM_STR);
                    $db->bindValue(":fk_usuario"        ,       $this->fk_usuario, PDO::PARAM_STR);
                    $db->bindValue(":entidad"        ,       $this->entidad, PDO::PARAM_STR);
                    $db->bindValue(":fecha_registro"        ,       $this->fecha_registro, PDO::PARAM_STR);
                                    


                    // Si lleva ID lo tomamos como que es UPDATE 
                    if (strlen($this->rowid) > 0):
                         $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                    endif;
              

                    // EXECUTE
                    $result = $db->execute();

                    //Registros en log success
                    $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                    $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla diccionario_crm_actividades' : 'Registro ' . $record . ' actualizado en la tabla diccionario_crm_actividades';
                    //$this->log_success($this->file,$record,$process,$detail);
                    
                    // RETURN
                    return 1;

        }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
            return 0;
        
        }

}

public function guardarActividadFlujo(){

  

    $sql="";
          $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la tabla crm_flujo_actividad' : 'Actualización del Registro de la tabla crm_flujo_actividad';
  
          try{
                      //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                      
                      // COLUMNS
                      $columns = " 
                      descripcion                =   :descripcion,
                      fk_flujo                   =   :fk_flujo,
                      fk_diccionario_actividad   =   :fk_diccionario_actividad,
                      dias                       =   :dias, 
                      activo                     =   :activo
                     
                      
                      ";
  
                      // QUERY
                      $sql = (strlen($this->rowid) == 0) ? "INSERT INTO crm_flujo_actividad SET  " . $columns : "UPDATE crm_flujo_actividad SET " . $columns . " WHERE rowid =:rowid";
                      $db  = $this->db->prepare($sql);
  
                      $db->bindValue(":descripcion"                ,       $this->descripcion, PDO::PARAM_STR);
                      $db->bindValue(":fk_flujo"        ,       $this->fk_flujo, PDO::PARAM_STR);
                      $db->bindValue(":fk_diccionario_actividad"        ,       $this->fk_diccionario_actividad, PDO::PARAM_STR);
                      $db->bindValue(":dias"        ,       $this->dias, PDO::PARAM_STR);
                      $db->bindValue(":activo"        ,       $this->activo, PDO::PARAM_STR);
                                      
  
  
                      // Si lleva ID lo tomamos como que es UPDATE 
                      if (strlen($this->rowid) > 0):
                           $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                      endif;
                
  
                      // EXECUTE
                      $result = $db->execute();
  
                      //Registros en log success
                      $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                      $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla crm_flujo_actividad' : 'Registro ' . $record . ' actualizado en la tabla crm_flujo_actividad';
                      //$this->log_success($this->file,$record,$process,$detail);
                      
                      // RETURN
                      return 1;
  
          }catch(PDOException  $e){
              //Registros en log error
              //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
              return 0;
          
          }
  
  }


  public function GuardarEmpresa(){

  

    $sql="";
          $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la tabla crm_empresas' : 'Actualización del Registro de la tabla crm_empresas';
  
          try{
                      //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                      
                      // COLUMNS
                      $columns = " 
                    
                      nombre                       =   :nombre,
                      identificacion               =   :identificacion,
                      telefono                     =   :telefono,
                      email                        =   :email,
                        fk_entidad                        =   :fk_entidad
                     
                      
                      ";
  
                      // QUERY
                      $sql = (strlen($this->rowid) == 0) ? "INSERT INTO crm_empresas SET  " . $columns : "UPDATE crm_empresas SET " . $columns . " WHERE rowid =:rowid";
                      $db  = $this->db->prepare($sql);
  
                    
                      $db->bindValue(":nombre"        ,       $this->nombre, PDO::PARAM_STR);
                      $db->bindValue(":identificacion"        ,       $this->identificacion, PDO::PARAM_STR);
                      $db->bindValue(":telefono"        ,       $this->telefono, PDO::PARAM_STR);
                      $db->bindValue(":email"        ,       $this->email, PDO::PARAM_STR);
                      $db->bindValue(":fk_entidad"        ,       $this->fk_entidad, PDO::PARAM_STR);
                     
                                      
  
  
                      // Si lleva ID lo tomamos como que es UPDATE 
                      if (strlen($this->rowid) > 0):
                           $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                      endif;
                
  
                      // EXECUTE
                      $result = $db->execute();
  
                      //Registros en log success
                      $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                      $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla crm_flujo_actividad' : 'Registro ' . $record . ' actualizado en la tabla crm_flujo_actividad';
                      //$this->log_success($this->file,$record,$process,$detail);
                      
                      // RETURN el ultimo id
                      return 1;
  
          }catch(PDOException  $e){
              //Registros en log error
              //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
              return 0;
          
          }
  
  }




  public function guardarInfoForecastServicio(){

  // funcion pra guaradr la informacion enviada referente a la tabla

    $sql="";
          $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la tabla crm_prospeccion_servicios' : 'Actualización del Registro de la tabla crm_prospeccion_servicios';
  
          try{
                      //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                      
                      // COLUMNS
                      $columns = " 
                    
                      fk_forecast                =   :fk_forecast,
                      fk_servicio                =   :fk_servicio,
                      dias                       =   :dias
                     
                      
                      ";
  
                      // QUERY
                      $sql = (strlen($this->rowid) == 0) ? "INSERT INTO crm_prospeccion_servicios SET  " . $columns : "UPDATE crm_prospeccion_servicios SET " . $columns . " WHERE rowid =:rowid";
                      $db  = $this->db->prepare($sql);
  
                    
                      $db->bindValue(":fk_forecast"        ,       $this->fk_forecast, PDO::PARAM_STR);
                      $db->bindValue(":fk_servicio"        ,       $this->fk_servicio, PDO::PARAM_STR);
                      $db->bindValue(":dias"        ,       $this->dias, PDO::PARAM_STR);
                     
                                      
  
  
                      // Si lleva ID lo tomamos como que es UPDATE 
                      if (strlen($this->rowid) > 0):
                           $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                      endif;
                
  
                      // EXECUTE
                      $result = $db->execute();
  
                      //Registros en log success
                      $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                      $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla crm_prospeccion_servicios' : 'Registro ' . $record . ' actualizado en la tabla crm_prospeccion_servicios';
                      //$this->log_success($this->file,$record,$process,$detail);
                      
                      // RETURN
                      return 1;
  
          }catch(PDOException  $e){
              //Registros en log error
              //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
              return 0;
          
          }
  
  }


  
  public function guardarInfoActividadForecast(){

    // funcion pra guaradr la informacion enviada referente a la tabla crm_prospeccion_actividades

  
      $sql="";
            $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la tabla crm_prospeccion_actividades' : 'Actualización del Registro de la tabla crm_prospeccion_actividades';
    
            try{
                        //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                        
                        // COLUMNS
                        $columns = " 
                      
                        fk_forecast                =   :fk_forecast,
                        fk_entidad                 =   :fk_entidad,
                        fk_flujo                   =   :fk_flujo,
                        fk_usuario                 =   :fk_usuario,
                        fk_actividad               =   :fk_actividad,
                        fecha                      =   :fecha,
                        descripcion                =   :descripcion,
                        fk_estado                  =   :fk_estado
                       
                        
                        ";
    
                        // QUERY
                        $sql = (strlen($this->rowid) == 0) ? "INSERT INTO crm_prospeccion_actividades SET  " . $columns : "UPDATE crm_prospeccion_actividades SET " . $columns . " WHERE rowid =:rowid";
                        $db  = $this->db->prepare($sql);
    
                      
                        $db->bindValue(":fk_forecast"        ,      $this->fk_forecast, PDO::PARAM_STR);
                        $db->bindValue(":fk_entidad"        ,       $this->fk_entidad, PDO::PARAM_STR);
                        $db->bindValue(":fk_flujo"        ,         $this->fk_flujo, PDO::PARAM_STR);
                        $db->bindValue(":fk_usuario"        ,       $this->fk_usuario, PDO::PARAM_STR);
                        $db->bindValue(":fk_actividad"        ,     $this->fk_actividad, PDO::PARAM_STR);
                        $db->bindValue(":fecha"        ,            $this->fecha, PDO::PARAM_STR);
                        $db->bindValue(":descripcion"        ,      $this->descripcion, PDO::PARAM_STR);
                        $db->bindValue(":fk_estado"        ,        $this->fk_estado, PDO::PARAM_STR);
                        
                       
                                        
    
    
                        // Si lleva ID lo tomamos como que es UPDATE 
                        if (strlen($this->rowid) > 0):
                             $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                        endif;
                  
    
                        // EXECUTE
                        $result = $db->execute();
    
                        //Registros en log success
                        $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                        $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla crm_prospeccion_servicios' : 'Registro ' . $record . ' actualizado en la tabla crm_prospeccion_servicios';
                        //$this->log_success($this->file,$record,$process,$detail);
                        
                        // RETURN
                        return 1;
    
            }catch(PDOException  $e){
                //Registros en log error
                //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
                return 0;
            
            }
    
    }
  

  




  
public function guardarInfoForecast(){

  

    $sql="";
          $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la tabla crm_prospeccion' : 'Actualización del Registro de la tabla crm_prospeccion';
  
          try{
                      //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                      
                      // COLUMNS
                      $columns = " 
                     
                      fk_empresa            =   :fk_empresa,
                      fk_contacto           =   :fk_contacto,
                      fk_entidad            =   :fk_entidad,
                      
                      creacion_usuario      =   :creacion_usuario,
                      creacion_fecha        =   :creacion_fecha
                   
                     
                      
                      ";
  
                      // QUERY
                      $sql = (strlen($this->rowid) == 0) ? "INSERT INTO crm_prospeccion SET  " . $columns : "UPDATE crm_prospeccion SET " . $columns . " WHERE rowid =:rowid";
                      $db  = $this->db->prepare($sql);
  
                    
                      $db->bindValue(":fk_empresa"            ,       $this->fk_empresa, PDO::PARAM_STR);
                      $db->bindValue(":fk_contacto"            ,       $this->fk_contacto, PDO::PARAM_STR);
                      $db->bindValue(":fk_entidad"            ,       $this->fk_entidad, PDO::PARAM_STR);
                     
                      $db->bindValue(":creacion_usuario"            ,       $this->creacion_usuario, PDO::PARAM_STR);
                      $db->bindValue(":creacion_fecha"            ,       $this->creacion_fecha, PDO::PARAM_STR);
                     
                     
  
                                      
  
  
                      // Si lleva ID lo tomamos como que es UPDATE 
                      if (strlen($this->rowid) > 0):
                           $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                      endif;
                
  
                      // EXECUTE
                      $result = $db->execute();
  
                      //Registros en log success
                      $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                      $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla crm_flujo_actividad' : 'Registro ' . $record . ' actualizado en la tabla crm_flujo_actividad';
                      //$this->log_success($this->file,$record,$process,$detail);
                      
                      // RETURN
                      return 1;
  
          }catch(PDOException  $e){
              //Registros en log error
              //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
              return 0;
          
          }
  
  }



    
public function guardarContactoNuevo(){

  // Registrar un nuevo contacto 



    $sql="";
          $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro de la tabla crm_contacto' : 'Actualización del Registro de la tabla crm_contacto';
  
          try{
                      //OBTENER DATOS DESDE ELUSUARIO LOGEADO
                      
                      // COLUMNS
                      $columns = " 
                     
                      fk_empresa            =   :fk_empresa,
                      nombre                =   :nombre,
                      apellidos             =   :apellidos,
                      telefono              =   :telefono,
                      correo                =   :correo,
                       fk_entidad                =   :fk_entidad
                   
                     
                      
                      ";
  
                      // QUERY
                      $sql = (strlen($this->rowid) == 0) ? "INSERT INTO crm_contactos SET  " . $columns : "UPDATE crm_contactos SET " . $columns . " WHERE rowid =:rowid";
                      $db  = $this->db->prepare($sql);
  
                    
                      $db->bindValue(":fk_empresa"            ,       $this->fk_empresa, PDO::PARAM_STR);
                      $db->bindValue(":nombre"            ,       $this->nombre, PDO::PARAM_STR);
                      $db->bindValue(":apellidos"            ,       $this->apellidos, PDO::PARAM_STR);
                      $db->bindValue(":telefono"            ,       $this->telefono, PDO::PARAM_STR);
                      $db->bindValue(":correo"            ,       $this->correo, PDO::PARAM_STR);
                      $db->bindValue(":fk_entidad"            ,       $this->fk_entidad, PDO::PARAM_STR);
                     
                     
  
                                      
  
  
                      // Si lleva ID lo tomamos como que es UPDATE 
                      if (strlen($this->rowid) > 0):
                           $db->bindValue(":rowid"            ,      $this->rowid        , PDO::PARAM_INT);
                      endif;
                
  
                      // EXECUTE
                      $result = $db->execute();
  
                      //Registros en log success
                      $record  = (strlen($this->rowid) == 0) ? $this->db->lastInsertId() : $this->rowid;
                      $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla crm_flujo_actividad' : 'Registro ' . $record . ' actualizado en la tabla crm_flujo_actividad';
                      //$this->log_success($this->file,$record,$process,$detail);
                      
                      // RETURN
                      return 1;
  
          }catch(PDOException  $e){
              //Registros en log error
              //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
              return 0;
          
          }
  
  }

    
  public function ultimoEmpresaInsertado(){

    //Devolver el ultimo empresa
    
     //echo $rowid;
  $sql="";
  $process = "Consultar el id ultimo empresa intertado";
 
  try{
 
          //consulta datos del flujo
          $sql = "SELECT rowid, nombre FROM crm_empresas ORDER BY rowid DESC LIMIT 1";
          $db  = $this->db->prepare($sql);
          $db->execute();
          $results = ($db->fetch(PDO::FETCH_OBJ));
          //$this->log_success( $this->file,$rowid,$process,$detail);
 
          // RETURN el ultimo rowid registrado en la tabla crm_flujo
      if ($db) {
        return json_encode($results);
      }else{
          return "no se pudo";
      }
         
 
  }catch(PDOException  $e){
          //Registros en log error
          //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
          return $e->getMessage();
          
  }
 }
    
public function ultimoContactoInsertado($fk_empresa){
    // $data = $entidad;
    // return $data;
 
    //Devolver el ultimo flujo de la entidad para que le agregue actividades
    
     //echo $rowid;
  $sql="";
  $process = "Consultar el id ultimo contacto intertado";
 
  try{
 
          //consulta datos del flujo
          $sql = "SELECT rowid FROM crm_contactos WHERE fk_empresa = $fk_empresa ORDER BY rowid DESC LIMIT 1";
          $db  = $this->db->prepare($sql);
          $db->execute();
          $results = ($db->fetch(PDO::FETCH_OBJ));
          //$this->log_success( $this->file,$rowid,$process,$detail);
 
          // RETURN el ultimo rowid registrado en la tabla crm_flujo
      if ($db) {
        return $results->rowid;
      }else{
          return "no se pudo";
      }
         
 
  }catch(PDOException  $e){
          //Registros en log error
          //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
          return $e->getMessage();
          
  }
 }
  


 // FUNCTION CAMBIAR STATUS DEL REGISTRO CLIENTE
    public function cambiarEstatus($activo)
    {
        $sql="";
        $process = "Actualización del Estado en el Registro Actividades";

        try{

            // QUERY
            $sql = "UPDATE crm_prospeccion SET activo =:activo WHERE rowid =:rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $this->rowid, PDO::PARAM_INT);
            $db->bindValue(":activo", $activo, PDO::PARAM_INT);
            $result = $db->execute();

            //Registros en log success
            $record  = $this->rowid;
            $detail  = 'Registro ' . $record . ' actualizado en la tabla crm_prospeccion';
            //$this->log_success($this->file,$record,$process,$detail);

            // RETURN
            return 1;

        }catch(PDOException $e){

            //$this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
            return 0;
        }
    }


    
 // FUNCTION CAMBIAR STATUS DEL REGISTRO CLIENTE
 public function cambiarActividadEstatus($rowid)
 {
     $sql="";
     $process = "Actualización del Estado en la tabla crm_prospeccion_actividades";

     try{

        //consultar el estatus de la actividad
         $sql = "SELECT fk_estado from crm_prospeccion_actividades WHERE rowid =:rowid;";
         $db  = $this->db->prepare($sql);
         $db->bindValue(":rowid", $rowid, PDO::PARAM_INT);
         $result = $db->execute();
         $data = $db->fetch(PDO::FETCH_OBJ);
         if ($data->fk_estado == 1) {
        
            //aplicar estaus realizado
         // QUERY
         $sql = "UPDATE crm_prospeccion_actividades SET fk_estado=2 WHERE rowid =:rowid;";
         $db  = $this->db->prepare($sql);
         $db->bindValue(":rowid", $rowid, PDO::PARAM_INT);
         $result = $db->execute();

         }elseif($data->fk_estado == 2){

        //aplicar estaus pendente
         // QUERY
         $sql = "UPDATE crm_prospeccion_actividades SET fk_estado=1 WHERE rowid =:rowid;";
         $db  = $this->db->prepare($sql);
         $db->bindValue(":rowid", $rowid, PDO::PARAM_INT);
         $result = $db->execute();
         }


        

         //Registros en log success
         $record  = $this->rowid;
         $detail  = 'Registro ' . $record . ' actualizado en la tabla crm_prospeccion';
         //$this->log_success($this->file,$record,$process,$detail);

         // RETURN
         return 1;

     }catch(PDOException $e){

         //$this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
         return 0;
     }
 }


} //FIN DE LA CLASE
