<?php
  
class XML_Recepcion{

    public $certificado;
    public $clave;
    public $documento_clave; // numero lago
    public $documento_consecutivo;  // numero corto

      public function __construct ($db, $Empresa){  
 
      $this->db = $db;   
  
      $dbi = $db->prepare("select   c.* ,
                                    ( select siguiente_recepcion_aceptada  from fi_facturas_configuracion where entidad =c.entidad ) as siguiente_recepcion_aceptada    ,
                                    ( select siguiente_recepcion_rechazada  from fi_facturas_configuracion where entidad =c.entidad ) as siguiente_recepcion_rechazada  ,
                                    (select   	aaa.codigo 
                                         from  fi_empresa_actividad aa 
                                         left  join fi_configuracion_empresa_actividad aaa on aaa.rowid =aa.fk_actividad
                                            where 
                                 		            aa.fk_cliente = c.entidad   
                                                and aa.tipo = 1 
                                        limit 1) as actividad_codigo
                                     from fi_configuracion_empresa c where c.entidad = :rowid  
                                     ");
                                     
      $dbi->bindValue(":rowid", $Empresa  ,PDO::PARAM_INT);
      $dbi->execute();
 
 
      
     $d=$dbi->fetch(PDO::FETCH_OBJ);
    
     $this->certificado             = $d->electronica_certificado;
     $this->certificado_clave                   = $d->electronica_certificado_clave;
     $this->certificado_encriptado  = $d->electronica_certificado_encriptado;
     $this->empresaIDCarpeta        = $Empresa;
     $this->empresa                 = $Empresa;
     
     // Multiple consecutivo Dependiendo de la respuesta
     
     $this->siguiente_recepcion_aceptada     = $d->siguiente_recepcion_aceptada;
     $this->siguiente_recepcion_rechazada     = $d->siguiente_recepcion_rechazada;
     
      
      
     // Necesarios para el XML
     $this->electronica_nombre                  = $d->electronica_nombre;  
     $this->electronica_identificacion_numero   = $d->electronica_identificacion_numero;
     $this->electronica_identificacion_tipo     = $d->electronica_identificacion_tipo;
     $this->electronica_nombre_comercial        = $d->electronica_nombre_comercial ;
     $this->electronica_provincia               = $d->electronica_provincia ;
     $this->electronica_canton                  = $d->electronica_canton ;
     $this->electronica_distrito                = $d->electronica_distrito ;
     $this->electronica_barrio                  = $d->electronica_barrio ;
     $this->electronica_otras_senas             = $d->electronica_otras_senas ;
     $this->electronica_telefono                = $d->electronica_telefono ;
     $this->electronica_fax                     = $d->electronica_fax ;
     $this->electronico_correo                  = $d->electronico_correo ;
     $this->direccion_PDF                       = $d->nombre_direccion;
      
     $this->actividad_codigo                    = $d->actividad_codigo;
     
  return true;
      
} 

 
 ///-------------------------------------------------------
 //
 //
 //--------------------------------------------------------
 public function fetch($id){
 
      $dbi = $this->db->prepare("select * from documentos_recibidos  where rowid = :rowid ");
      $dbi->bindValue(":rowid", $id  ,PDO::PARAM_INT);
      $dbi->execute();
      $datos = $dbi->fetch(PDO::FETCH_OBJ);

       
      $this->recepcion_estado       = $datos->recepcion_estado;
      $this->id                     = $datos->rowid;
      $this->consecutivo_recepcion  = $datos->recepcion_consecutivo;
      $this->emisor_cedula          = $datos->emisor_cedula;
      $this->emisor_tipo            = $datos->emisor_tipo;
      $this->emisor_tipo            = $datos->emisor_tipo;
      $this->emisor_FechaEmision    = $datos->FechaEmision;
      $this->emisor_clave           = $datos->clave;
      $this->fk_entidad             = $datos->fk_entidad;
      $this->estado_hacienda        = $datos->estado_hacienda;

      

      $recepcion_firmada = file_get_contents( '/home/facturac6/facturacion_electronica_documentos/recepcion/'.$this->empresaIDCarpeta.'/'.$this->consecutivo_recepcion.'.xml'  , FILE_USE_INCLUDE_PATH);

      $this->xml=$recepcion_firmada;
      return $datos->rowid;
      
 }
 
 


public function enviado($location){
  
        $sql=" update documentos_recibidos 
                  set location        = :location ,
                      estado_hacienda = 'Enviado' ,
                      location_date   = NOW() 
                      
                      where rowid = :rowid
             ";              
    $db = $this->db->prepare($sql);
    $db->bindValue(":rowid"                 , $this->id                , PDO::PARAM_INT);
    $db->bindValue(":location"              , $location                , PDO::PARAM_STR);
    $db->execute();

}

public function enviado_comprobante(){
  
        $sql="  update documentos_recibidos 
                set estado_hacienda = 'Enviado'
                where rowid = :rowid
             ";              
    $db = $this->db->prepare($sql);
    $db->bindValue(":rowid"                 , $this->id                , PDO::PARAM_INT);
    $db->execute();

}

public function en_espera(){
  
        $sql="  update documentos_recibidos 
                set estado_hacienda = 'Espera' 
                where rowid = :rowid
             ";              
    $db = $this->db->prepare($sql);
    $db->bindValue(":rowid", $this->id, PDO::PARAM_INT);
    $db->execute();

}



 ///-------------------------------------------------------
 //
 //
 //--------------------------------------------------------
 public function recepcion(){
     

     
    
        $sql=" update 
                    documentos_recibidos 
                    set 

                    recepcion_fecha     =   NOW()                     ,
                    recepcion_usuario   =  '".$_SESSION['Usuario']."' ,



                    CodigoMoneda        = :CodigoMoneda               ,
                    TipoCambio          = :TipoCambio                 ,
                    TotalServGravados   = :TotalServGravados          ,
                    TotalServExentos    = :TotalServExentos           ,
                    TotalMercanciasGravadas     = :TotalMercanciasGravadas   ,
                    TotalMercanciasExentas      = :TotalMercanciasExentas    ,
                    TotalGravado                = :TotalGravado              ,
                    TotalExento                 = :TotalExento               ,
                    TotalVenta                  = :TotalVenta                ,
                    TotalDescuentos             = :TotalDescuentos           ,
                    TotalVentaNeta              = :TotalVentaNeta            ,
                    TotalImpuesto               = :TotalImpuesto             ,
                    TotalComprobante            = :TotalComprobante          ,
                    FechaEmision_date           = :FechaEmision_date         ,
                    FechaEmision                = :FechaEmision    
                    
                    
                    
                    where rowid = :rowid ";
    
    
    $db = $this->db->prepare($sql);
     $db->bindValue(":rowid"                    , $this->id               , PDO::PARAM_INT);
    $db->bindValue(":CodigoMoneda"              , $this->CodigoMoneda                , PDO::PARAM_STR);
    $db->bindValue(":TipoCambio"                , $this->TipoCambio                  , PDO::PARAM_STR);
    $db->bindValue(":TotalServGravados"         , $this->TotalServGravados           , PDO::PARAM_STR);
    $db->bindValue(":TotalServExentos"          , $this->TotalServExentos            , PDO::PARAM_STR);
    $db->bindValue(":TotalMercanciasGravadas"   , $this->TotalMercanciasGravadas               , PDO::PARAM_STR);
    $db->bindValue(":TotalMercanciasExentas"    , $this->TotalMercanciasExentas               , PDO::PARAM_STR);
    $db->bindValue(":TotalGravado"              , $this->TotalGravado               , PDO::PARAM_STR);
    $db->bindValue(":TotalExento"               , $this->TotalExento               , PDO::PARAM_STR);
    $db->bindValue(":TotalVenta"                , $this->TotalVenta               , PDO::PARAM_STR);
    $db->bindValue(":TotalDescuentos"              , $this->TotalDescuentos               , PDO::PARAM_STR);
    $db->bindValue(":TotalVentaNeta"               , $this->TotalVentaNeta               , PDO::PARAM_STR);
    $db->bindValue(":TotalImpuesto"                , $this->TotalImpuesto               , PDO::PARAM_STR);
    $db->bindValue(":TotalComprobante"             , $this->TotalComprobante               , PDO::PARAM_STR);
    $db->bindValue(":FechaEmision_date"             , $this->FechaEmision_date               , PDO::PARAM_STR);
    $db->bindValue(":FechaEmision"                  , $this->FechaEmision               , PDO::PARAM_STR);

    $db->execute();
    
    
    // print_r($this->db->errorInfo());
    // print_r($db->errorInfo());
 
     return true;
     
     
 }
    
    
 

public function crear_consecutivo_recepcion( ){

 
    //-----------------------------------------------------------------------------
    //
    //  Guarda Consecutivo
    //
    
     
    $sql=" update  documentos_recibidos set 
    
           consecutivo_matriz           = :consecutivo_matriz           ,
           consecutivo_terminal         = :consecutivo_terminal         ,
           consecutivo_tipo_doc         = :consecutivo_tipo_doc         ,
           consecutivo_consecutivo      = :consecutivo_consecutivo      ,
           recepcion_consecutivo = :recepcion_consecutivo                
           
           
           where rowid = :rowid          ";
            
           
    $consecutivo_matriz      = "001";           
    $consecutivo_terminal    = "00001";
    $consecutivo_tipo_doc    = $this->consecutivo_tipo_documento;
    $consecutivo_consecutivo = mb_substr("0000000000". $this->consecutivo_utilizar ,-10);  
    $consecutivo = $consecutivo_matriz.$consecutivo_terminal.$consecutivo_tipo_doc.$consecutivo_consecutivo;

   
    
    $db= $this->db->prepare($sql);
    $db->bindValue(":consecutivo_matriz",       $consecutivo_matriz     ,   PDO::PARAM_STR);
    $db->bindValue(":consecutivo_terminal",     $consecutivo_terminal   ,   PDO::PARAM_STR);
    $db->bindValue(":consecutivo_tipo_doc",     $consecutivo_tipo_doc   ,   PDO::PARAM_STR);
    $db->bindValue(":consecutivo_consecutivo",  $consecutivo_consecutivo,   PDO::PARAM_STR);
    $db->bindValue(":recepcion_consecutivo",  $consecutivo ,   PDO::PARAM_STR);
    $db->bindValue(":rowid",  $this->id,   PDO::PARAM_INT);
    $db->execute();        


     //print_r($this->db->errorInfo());
     //print_r($db->errorInfo());

        
    //-----------------------------------------------------------------------------
    //
    //  Actualiza Consecutivo
    //
    $sql="update fi_facturas_configuracion set ".$this->campo." = (".$this->campo."  + 1)  where entidad  = :fk_entidad ";
    $db = $this->db->prepare($sql);
    $db->bindValue(":fk_entidad", $this->empresa , PDO::PARAM_INT); 
    $db->execute();
    $id=$this->db->lastInsertId(); 

  
    $this->clave  = $clave;
    $this->consecutivo  = $consecutivo;

     
    return $clave;
    
} 




    public function crear(   ){

       if (empty($this->consecutivo)) { $this->crear_consecutivo_recepcion();  } 
 
        $fecha_ahora=date('Y-m-d H:i:s');

        $impuesto=($this->MontoTotalImpuesto > 0 ) ? '<MontoTotalImpuesto>'.$this->MontoTotalImpuesto.'</MontoTotalImpuesto>' : '';
        
        $CodigoActividad   = (!empty($this->CodigoActividad)) 
          ? "<CodigoActividad>".$this->CodigoActividad."</CodigoActividad>" 
          :'' ;
 
        $CondicionImpuesto = (!empty($this->CondicionImpuesto)) 
        ? "<CondicionImpuesto>".$this->CondicionImpuesto."</CondicionImpuesto>" 
        : '';

       $MontoTotalImpuestoAcreditar = (!empty($this->MontoTotalImpuesto)) 
        ? "<MontoTotalImpuestoAcreditar>".$this->MontoTotalImpuesto."</MontoTotalImpuestoAcreditar>" 
        : '';

       $MontoTotalDeGastoAplicable = (!empty($this->MontoTotalDeGastoAplicable)) 
        ? "<MontoTotalDeGastoAplicable>".$this->MontoTotalDeGastoAplicable."</MontoTotalDeGastoAplicable>" 
        : '';
        


       $DetalleMensaje  = (!empty($this->DetalleMensaje)) 
        ? "<DetalleMensaje>".$this->DetalleMensaje."</DetalleMensaje>" 
        : '';
       


        
       /* 
        $xml='<?xml version="1.0" encoding="UTF-8"?><MensajeReceptor  xmlns="https://tribunet.hacienda.go.cr/docs/esquemas/2017/v4.2/mensajeReceptor" ><Clave>'.$this->emisor_clave.'</Clave><NumeroCedulaEmisor>'.$this->emisor_cedula.'</NumeroCedulaEmisor><FechaEmisionDoc>'.date('Y-m-d', strtotime($fecha_ahora)).'T'.date('H:i:s',strtotime($fecha_ahora)).'-06:00</FechaEmisionDoc><Mensaje>'.$this->Mensaje.'</Mensaje>'.$impuesto.'<TotalFactura>'.$this->TotalFactura.'</TotalFactura><NumeroCedulaReceptor>'. mb_substr("000000000000".  ($this->electronica_identificacion_numero)  ,-12)  .'</NumeroCedulaReceptor><NumeroConsecutivoReceptor>'.$this->consecutivo.'</NumeroConsecutivoReceptor></MensajeReceptor>';
        */
        
                $xml='<?xml version="1.0" encoding="UTF-8"?>'
            . '<MensajeReceptor xmlns="https://cdn.comprobanteselectronicos.go.cr/xml-schemas/v4.4/mensajeReceptor"  >'
            . '<Clave>'.$this->emisor_clave.'</Clave>'
            . '<NumeroCedulaEmisor>'.$this->emisor_cedula.'</NumeroCedulaEmisor>'
            . '<FechaEmisionDoc>'.date('Y-m-d', strtotime($fecha_ahora)).'T'.date('H:i:s',strtotime($fecha_ahora)).'-06:00</FechaEmisionDoc>'
            . '<Mensaje>'.$this->Mensaje.'</Mensaje>'
            . $DetalleMensaje
            . $impuesto
            . $CodigoActividad
            . $CondicionImpuesto
            . $MontoTotalImpuestoAcreditar
            . $MontoTotalDeGastoAplicable
            . '<TotalFactura>'.$this->TotalFactura.'</TotalFactura>'
            . '<NumeroCedulaReceptor>'. mb_substr("000000000000".  ($this->electronica_identificacion_numero)  ,-12) 
            . '</NumeroCedulaReceptor>'
            . '<NumeroConsecutivoReceptor>'.$this->consecutivo.'</NumeroConsecutivoReceptor>'
            . '</MensajeReceptor>';
        
        
        
        $this->xml = $xml ;
        $this->salvar(  );
        return   $xml;

    }

    
    public function crear_para_cron(){


       // $this->crear_consecutivo_recepcion();

        $fecha_ahora=date('Y-m-d H:i:s');

        $impuesto=($this->MontoTotalImpuesto > 0 ) ? '<MontoTotalImpuestoAcreditar>'.$this->MontoTotalImpuesto.'</MontoTotalImpuestoAcreditar>' : '';
        
        
        $xml='<?xml version="1.0" encoding="UTF-8"?><MensajeReceptor    xmlns="https://cdn.comprobanteselectronicos.go.cr/xml-schemas/v4.4/mensajeReceptor" ><Clave>'.$this->emisor_clave.'</Clave><NumeroCedulaEmisor>'.$this->emisor_cedula.'</NumeroCedulaEmisor><FechaEmisionDoc>'.date('Y-m-d', strtotime($fecha_ahora)).'T'.date('H:i:s',strtotime($fecha_ahora)).'-06:00</FechaEmisionDoc><Mensaje>'.$this->Mensaje.'</Mensaje>'.$impuesto.'<TotalFactura>'.$this->TotalFactura.'</TotalFactura><NumeroCedulaReceptor>'. mb_substr("000000000000".  ($this->electronica_identificacion_numero)  ,-12)  .'</NumeroCedulaReceptor><NumeroConsecutivoReceptor>'.$this->consecutivo_recepcion.'</NumeroConsecutivoReceptor></MensajeReceptor>';
        $this->xml = $xml ;
         $this->salvar(  );
        return   $xml;

    }


    function salvar(    ){
    
        $BASE    = "/home/facturac6/facturacion_electronica_documentos/recepcion_temporal/".$this->empresaIDCarpeta;
        $archivo = $this->consecutivo.".sinfirmar.xml";
        $this->base=$BASE;
       
        $this->archivo = $BASE."/".$archivo;
        if(!is_dir($BASE )) {         mkdir($BASE , 0777); }
        $fp = fopen($BASE."/".$archivo, "w");
        fputs($fp, $this->xml);
        fclose($fp);
       
        
        $BASE    = "/home/facturac6/facturacion_electronica_documentos/recepcion/".$this->empresaIDCarpeta;
        if(!is_dir($BASE )) {         mkdir($BASE , 0777); }
        $java='php /home/facturac6/public_html/firmado.php --certificate "/home/facturac6/facturacion_electronica_documentos/certificados/'.$this->empresaIDCarpeta.'/'.$this->certificado.'" --password "'.$this->certificado_clave.'" --input "'.$this->archivo.'" --output "/home/facturac6/facturacion_electronica_documentos/recepcion/'.$this->empresaIDCarpeta.'/'.$this->consecutivo.'.xml"';
        $a=shell_exec($java);

   	    $recepcion_firmada = file_get_contents( '/home/facturac6/facturacion_electronica_documentos/recepcion/'.$this->empresaIDCarpeta.'/'.$this->consecutivo.'.xml'  , FILE_USE_INCLUDE_PATH);

        $this->xml =  (!empty($recepcion_firmada)) ?  $recepcion_firmada  : $this->xml ;
        return $this->xml;
    }


    public function decimal($x) { return   number_format($x, 2, '.', ''); }



    public function decimalDinero($x) { return number_format($x, 5 ,  '.' ,''); } 





 function sanitizar($txt){ 

 
    $txt = strip_tags($txt); // fuera <b>
    $strip = array( "@"," ","=", "?", "~", "`", "!",  "^", "&",   "\\", "|", ";", ":", "\"", "'", "&#8216;", "&#8217;", "&#8220;", "&#8221;", "&#8211;", "&#8212;",  "â€”", "â€“", ",", "<",   ">", "/");
    $txt = trim(str_replace($strip, "", $txt));  
 
    return  $txt;
 }



function _log($tipo , $descripcion ){

        $sql="insert into documentos_recibidos_log 
                      ( fk_documento   ,
                        fk_entidad     ,
                        tipo           ,
                        descripcion    ,
                        hora     )  
                      values                   
                      
                      ( :fk_documento     ,
                        :fk_entidad       ,                        
                        :tipo             ,
                        :descripcion      ,
                         NOW()          )  ";

        $db = $this->db->prepare($sql);
        $db->bindValue(":fk_documento"      ,$this->id        , PDO::PARAM_INT);
        $db->bindValue(":fk_entidad"        ,$this->fk_entidad, PDO::PARAM_INT);
        $db->bindValue(":tipo"              ,$tipo            , PDO::PARAM_STR);
        $db->bindValue(":descripcion"       ,$descripcion     , PDO::PARAM_STR);
        $db->execute();
        $db->closeCursor();



       // print_r($this->db->errorInfo());
       // print_r($db->errorInfo());


}




}