<?php
/**
 * Created by PhpStorm.
 * User: xavier
 * Date: 1/10/18
 * Time: 10:37 PM
 */

require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/getToken.php';
require_once __DIR__ . '/getClave.php';

$dia = '27';
$mes = '12';
$ano = '17';



echo $clave = getClave($ano, $mes, $dia);
echo "<br>";
$recepcionPath = 'https://api.comprobanteselectronicos.go.cr/recepcion-sandbox/v1/recepcion';
$access_token = getToken();

try {
    $client = new \GuzzleHttp\Client([
        'timeout' => 4.0,
    ]);

    $response = $client->request(
        'GET',
        $recepcionPath . '/' . $clave,
        [
            'headers' =>
                [
                    'Authorization' => "Bearer {$access_token}",
                    'Content-Type' => 'application/json',
                ]
        ]
    );

    $content = $response->getBody()->getContents();
    $contentObj = json_decode($content);
    
    $respuestaXmlBase64 = $contentObj->{'respuesta-xml'};
    $respuestaXmlTxt = base64_decode($respuestaXmlBase64);
    $respuestaXml = new SimpleXMLElement($respuestaXmlTxt);
    
    print_r($respuestaXml);

    if ((int) $respuestaXml->Mensaje === 3) {
        throw new Exception((string) $respuestaXml->DetalleMensaje);
    }
} catch(Exception $E) {
    echo 'Errores:' . "\n";
    echo $E->getMessage(). "\n";
}

