<?php
/**
 * Created by PhpStorm.
 * User: xavier
 * Date: 10/28/17
 * Time: 8:17 PM
 */

require __DIR__ . '/vendor/autoload.php';

setlocale (LC_CTYPE, 'es_ES');
ini_set ("memory_limit","-1");
ini_set('allow_url_fopen',1);

// funciones compartidas
include __DIR__ . '/getClave.php';
include __DIR__ . '/getToken.php';

$dia = '22';
$mes = '01';
$ano = '18';
$facturaRuta = 'output-1.xml';
$claveFactura = getClave($ano, $mes, $dia);
$receptor = '3101123456';
$emisor = '115010959';
$fechaEmision = '20' . $ano . '-' . $mes . '-' . $dia . 'T10:16:00-0600';
$recepcionUrl = 'https://api.comprobanteselectronicos.go.cr/recepcion-sandbox/v1/recepcion';

// Termina obtención de token
$access_token = getToken();

/**
 * Preparar la factura para ser enviada
 */

$facturaFirmada = file_get_contents($facturaRuta, FILE_USE_INCLUDE_PATH);
$facturaBase64 = base64_encode($facturaFirmada);


/**
 * Enviar Factura
 */


$mockBody = sprintf('
{
  "clave": "%s",
  "fecha": "%s",
  "emisor": {
    "tipoIdentificacion": "01",
    "numeroIdentificacion": "%s"
  },
  "receptor": {
    "tipoIdentificacion": "02",
    "numeroIdentificacion": "%s"
  },
  "comprobanteXml":"%s"
}',  $claveFactura, $fechaEmision, $emisor, $receptor, $facturaBase64);


$body = json_decode($mockBody);
try {
    $client = new \GuzzleHttp\Client([
        'timeout' => 4.0,
    ]);
    $response = $client->request(
        'POST',
        $recepcionUrl,
        [
            'json' => $body,
            'headers' =>
                [
                    'Authorization' => "Bearer {$access_token}",
                    'Content-Type' => 'application/json',
                ]
        ]
    );


    var_dump($response);


    $content = $response->getBody()->getContents();
    $contentObj = json_decode($content);
} catch(Exception $E) {

    var_dump($response);


    $headers = $response = $E->getResponse()->getHeaders();
    var_dump($headers);

    $errores = 'Errores:' . "\n";
    foreach ($headers['X-Error-Cause'] as $error) {
        $errores .= $error . "\n";
    }

    die($errores);
}

