<?php
  SESSION_START();
  include_once("../../conf/conf.php");
  $product = (!empty($_POST['product']))? $_POST['product']: null;
?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.10.22/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.10.22/datatables.min.js"></script>
<!-- HTML -->
<div class="modal-content" style="width:700px;">
    <!-- HEADER -->
    <div class="modal-header">
      <h3 class="modal-title" style="color:#f06725;font-family:Helvetica;font-size:25px;">Herramienta Cabys</h3>
    </div>
    <!-- BODY -->
    <div class="modal-body">
        <div class="table-responsive">
            <!-- TABLE CABYS -->
            <table id="tableDetialsCabys" class="table table-striped" style="width:100%;">
                <thead>                        
                  <tr style="background-color:grey;color:white;">
                    <th class="text-center">CODIGO</th>
                    <th class="text-center">DESCRIPCION</th>
                    <th class="text-center">%I.V.A</th>
                    <th class="text-center"></th>
                  </tr>
                </thead>
                <tbody id="tbodyDetialsCabys"></tbody>
            </table>
            <!-- TABLE INFO -->
            <input type="hidden" id="cod_cabys" value="">
            <a id="por_cabys" style="display:none;color:#ff0000;font-family:Helvetica;font-size:20px;"></a><br>
            <a id="des_cabys" style="display:none;font-family:Helvetica;font-size:18px;"></a><br>
            <table id="tableInfoCabys" class="table table-striped" style="display:none;width:100%;">
                <thead>                        
                  <tr>
                    <th class="text-center" style="color:#f06725;font-family:Helvetica;font-size:18px;">Nivel</th>
                    <th class="text-center" style="color:#f06725;font-family:Helvetica;font-size:18px;">Descripci&oacute;n</th>
                  </tr>
                </thead>
                <tbody id="tbodyInfoCabys"></tbody>
            </table>
        </div>   
    </div>
    <!-- FOOTER -->
    <div class="modal-footer">
      <!-- LAST -->
      <button class="btn btn-success notika-btn-success waves-effect" id="btnLast" style="display:none;" onclick="viewOptionListCabys()">Atr&aacute;s</button>
      <!-- SAVE -->
      <button class="btn btn-warning notika-btn-warning waves-effect" id="bntUse" style="display:none;" onclick="addCabysCodeProduct()">Uitlizar C&oacute;digo</button>
      <!-- CLOSE -->
      <button class="btn btn-danger notika-btn-danger waves-effect" id="btnClose" onclick="hideModalProducts()">Cerrar</button>
    </div>
</div>
<!-- SCRIPT -->
<script type="text/javascript">
  // OPTION READY WINDOW
  $(document).ready(function() {
    // FUNCTION LOAD INFO CABYS DETAILS
    loadInfoCabysDetails('');
  }); 

  // FUNCTION LOAD INFO CABYS DETAILS
  function loadInfoCabysDetails(search){
    $("#tbodyDetialsCabys").empty().html('<center style="margin-top:10%;"><img src="<?php echo ENLACE_WEB; ?>images/salvando.gif" width="30px"></center>');
    // DTATABLE
    tableDetialsCabys =
    $('#tableDetialsCabys').DataTable({
      'Processing' : true,
      'serverSide' : true,"bSort": false, "pageLength": 25,
      "language": {
        "lengthMenu": "Mostrar _MENU_ registros",
        "zeroRecords": "No se encontraron resultados",
        "info": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
        "infoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
        "infoFiltered": "(filtrado de un total de _MAX_ registros)",
        "sSearch": "Buscar:",
        "oPaginate": {
        "sFirst": "Primero",
        "sLast":"03ltimo",
        "sNext":"Siguiente",
        "sPrevious": "Anterior"
        },
      "sProcessing":"Procesando...",
      },
      'ajax': {
      'url':'<?php echo ENLACE_WEB; ?>mod_CABYS_CESOFT/get_cabys.php', 
      'Method': 'POST'
             },retrieve: true,  deferRender:    true, 
      
      //scrollY:        200,
      //scrollCollapse: true,
      scroller: true,responsive: true,
      'columns': [
          { data: 'codcabys' },
          { data: 'descabys' },
          { data: 'ivacabys' },

          {render: function ( data, type, row, meta ) {
            var descabys = row.descabys;
            descabys = descabys.replace(/[_\W]+/g, " ");            
           return '<button title="Detalle" type="button" class="btn btn-info" onclick="viewDetailCabys('+row.codcabys+','+row.ivacabys+',\''+descabys+'\')"><i class="fa fa-fw fa-circle-o"></i></button>';
           
            }}   
          ]
      }); 
  }   
  // FUNCTION VIEW DETAIL CABYS
  function viewOptionListCabys(){
    $("#tableDetialsCabys").empty().html('');
    tableDetialsCabys.destroy();
    $(".modal-title").text('Herramienta Cabys');
    $("#cod_cabys").val('');
    $("#por_cabys").hide();
    $("#des_cabys").hide();    
    $("#btnLast").hide();
    $("#bntUse").hide();
    $("#tbodyInfoCabys").html('');
    $("#tableInfoCabys").hide();
    // FUNCTION LOAD INFO CABYS DETAILS
    loadInfoCabysDetails();
  }
  // FUNCTION VIEW OBSERVATION CABYS
  function viewDetailCabys(code, tax, description){
    var tax = parseFloat(tax).toFixed(2);   
    $(".modal-title").text(code);
    $("#cod_cabys").val(code);
    $("#por_cabys").text(tax+' %');
    $("#des_cabys").text(description);

    $("#tableDetialsCabys").empty().html('');
    tableDetialsCabys.destroy();
    $("#tableDetialsCabys").hide();
    $("#por_cabys").show();
    $("#des_cabys").show();    
    $("#btnLast").show();
    $("#bntUse").show();
    // $("#btnLast").attr('onclick', 'viewOptionConsultCabys()');

    $("#tbodyInfoCabys").empty().html('<center style="margin-top:10%;><img src="<?php echo ENLACE_WEB; ?>images/salvando.gif" width="30px"></center>');
    // POST
    $.ajax({
        method: "POST",
        url: "<?php echo ENLACE_WEB; ?>mod_facturacion/class/clases.php",        
        beforeSend: function(xhr) { },
        data: 
        {  
            action  : 'loadInfoCabysByCode',
            code    : code
        },
    }).done(function(data) {          
        $("#tbodyInfoCabys").html(data);
        $("#tableInfoCabys").show();
    });
  }  
  // FUNCTION ADD CABYS CODE TO PRODUCT
  function addCabysCodeProduct(){
    var product  = '<?php echo $product; ?>';
    var cabys    = $("#cod_cabys").val();
          // CONFIRM
    if (confirm('Esta seguro(a) que desea asociar la informacion del codigo cabys "'+cabys+'" al producto.')){
      // POST
      $.ajax({
          method: "POST",
          url: "<?php echo ENLACE_WEB; ?>mod_facturacion/class/clases.php",        
          beforeSend: function(xhr) { },
          data: 
          {  
              action  : 'addCabysCodeProduct',
              cabys   : cabys,
              product : product
          },
      }).done(function(data) { 
        data = JSON.parse(data);      
        // VALID RESULT
        switch(Number(data.result)) {
            case 0:
              $.notify("Se presento un error en proceso de asociacion la informacio;n del codigo cabys al producto.", "warn");
            break;
            case 1:
              $.notify("Proceso de asociacion la informacion del codigo cabys al producto, realizado con exito.","success");
              // HIDE MODAL PRODUCTS
              hideModalProducts();
              // FUNCTION LOAD INFO PRODUCT
              loadInfoProduct(product);
            break;
            case 2:
              $.notify(data.message, "warn");
            break;
        }
      });
    }
  }
</script>