<?php

class Object {
    
    public function __construct ($db){    $this->db = $db; }
      
      
    public function guardarFacturaPeriodica($rowid, $modo, $txt_inicio=NULL, $txt_fin=NULL, $dia_mes=NULL, $id_factura, $txt_repeticiones=NULL, $etiqueta)  {  
        
          try{
              $id_=0;
            $columnas = " 
                    modo =:modo , 
                    fecha_inicio =:fecha_inicio, 
                    fecha_fin =:fecha_fin ,
                    numero_repeticion =:numero_repeticion ,
                    dia_mes =:dia_mes, 
                    fk_factura =:fk_factura, 
                    fecha_registro =:fecha_registro, 
                    usuario_registro =:usuario_registro, 
                    entidad =:entidad,
                    etiqueta =:etiqueta";
            $columnas2 = " 
                    modo =:modo , 
                    fecha_inicio =:fecha_inicio, 
                    fecha_fin =:fecha_fin ,
                    numero_repeticion =:numero_repeticion ,
                    dia_mes =:dia_mes, 
                    etiqueta =:etiqueta,
                    activo=1";

            $sql = ($rowid == 0) ? "INSERT INTO facturas_periodicas SET  " . $columnas : "UPDATE facturas_periodicas SET " . $columnas2. " WHERE rowid =:rowid ";
            $db  = $this->db->prepare( $sql );
            
             if($rowid == 0){
                $db->bindValue(":modo",             $modo, PDO::PARAM_INT);
                $db->bindValue(":fecha_inicio",     ($txt_inicio=="")? NULL:$txt_inicio, PDO::PARAM_STR);
                $db->bindValue(":fecha_fin",        ($txt_fin=="")? NULL:$txt_fin , PDO::PARAM_STR);
                $db->bindValue(":numero_repeticion", ($txt_repeticiones=="")? NULL:$txt_repeticiones , PDO::PARAM_INT);
                $db->bindValue(":dia_mes",          ($dia_mes=="")? NULL:$dia_mes , PDO::PARAM_INT);
                $db->bindValue(":fk_factura",       $id_factura, PDO::PARAM_INT);
                $db->bindValue(":fecha_registro",   date("Y-m-d H:i:s") , PDO::PARAM_STR);
                $db->bindValue(":usuario_registro", $_SESSION['usuario'] , PDO::PARAM_INT);
                $db->bindValue(":entidad",          $_SESSION['Entidad'], PDO::PARAM_INT);
                $db->bindValue(":etiqueta",          $etiqueta, PDO::PARAM_STR);
             }
            if($rowid > 0){
                 $db->bindValue(":rowid",          $rowid, PDO::PARAM_INT);
                 $db->bindValue(":modo",             $modo, PDO::PARAM_INT);
                $db->bindValue(":fecha_inicio",     ($txt_inicio=="")? NULL:$txt_inicio, PDO::PARAM_STR);
                $db->bindValue(":fecha_fin",        ($txt_fin=="")? NULL:$txt_fin , PDO::PARAM_STR);
                $db->bindValue(":numero_repeticion", ($txt_repeticiones=="")? NULL:$txt_repeticiones , PDO::PARAM_INT);
                $db->bindValue(":dia_mes",          ($dia_mes=="")? NULL:$dia_mes , PDO::PARAM_INT);
                $db->bindValue(":etiqueta",          $etiqueta, PDO::PARAM_STR);
                  $id_=$rowid;
            }
            
            $resultado=$db->execute();
            
            if($rowid == 0){
                $lid=$this->db->lastInsertId();
                $id_=$lid;
            }
            
            
            if($resultado>0 || $resultado==true && $rowid == 0){
                
                //generar detalles porque es nuevo
                $df=$this->crearDetalle($lid,$modo,$txt_inicio,$txt_fin,$txt_repeticiones,$dia_mes);
                
               
            }
             if($resultado>0 || $resultado==true && $rowid > 0){
                
                //generar detalles porque es edicion
                $delete =$this->eliminarDetallesPendiente($rowid);
                $df=$this->crearDetalle($rowid,$modo,$txt_inicio,$txt_fin,$txt_repeticiones,$dia_mes);
                
               
            }
            
            return $array=array('error'=>0,'registrado'=>$resultado,'error_txt'=>'', 'idcabecera'=>$lid,'delete_detalles'=>$delete, 'detalle'=>$df);
          

          }catch(PDOException  $e){
            //Registros en log error
            //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
           $this->errores(clear_string($e->getMessage()),$id_,"guardarFacturaPeriodica");
            return $array=array('error'=>1,'error_txt'=>clear_string($e->getMessage()));
          
        
        }
    }
    
    public function eliminarDetallesPendiente($rowid){
           try{
    
                // QUERY
                $sql = "delete from facturas_periodicas_detalle WHERE fk_factura_periodica =:rowid and procesado=0;";
                $db  = $this->db->prepare($sql);
                $db->bindValue(":rowid", $rowid, PDO::PARAM_INT);
                $result = $db->execute();
                
                return $result;
    
            }catch(PDOException $e){
                $this->errores(clear_string($e->getMessage()),$rowid,"eliminarDetallesPendiente");
                return 0;
            }
    }
      
    public function crearDetalle($fk_factura_periodica,$modo,$txt_inicio,$txt_fin,$txt_repeticiones,$dia_mes_inicial){
        
      
        if($modo==1){
            //rango fechas
            //$meses=  $this->obtenerCantidadMeses(array($txt_inicio, $txt_fin ) );
             $meses=  $this->obtenerCantidadMeses2($txt_inicio, $txt_fin );
            $numeroDia = date('d', strtotime($txt_inicio));
            
            if($meses > 0){
                for($i = 1; $i <= $meses; $i++){
                    
                   if($i==1 ){
                       if($numeroDia>1){
                            $txt_inicio=date("Y-m-01",strtotime($txt_inicio."+ 1 month"));
                       }
                       
                   }else{
                        $txt_inicio=date("Y-m-01",strtotime($txt_inicio."+ 1 month"));
                   }
                   //if($i>1){
                       //$txt_inicio=date("Y-m-d H:i",strtotime($txt_inicio."+ 1 month"));
                        
                   //}
                   
                    $txt_inicio = date("Y-m-d 08:00", strtotime($txt_inicio));
                    
                    $sql =  "INSERT INTO facturas_periodicas_detalle SET  fk_factura_periodica =:fk_factura_periodica, fecha_procesar =:fecha_procesar,fecha_registro =:fecha_registro, entidad=:entidad ";
                    $db  = $this->db->prepare($sql);
                    $db->bindValue(":fk_factura_periodica", $fk_factura_periodica, PDO::PARAM_INT);
                    $db->bindValue(":fecha_procesar",       $txt_inicio, PDO::PARAM_STR);
                    $db->bindValue(":fecha_registro",       date("Y-m-d H:i:s") , PDO::PARAM_STR);
                    $db->bindValue(":entidad",              $_SESSION['Entidad'], PDO::PARAM_INT);
                    $resultado=$db->execute();
                    
                }
                
            }
            
        }else{
            //numero de veces
             if($txt_repeticiones > 0){
             
                  $fecha_actual= date("Y-m-d H:m");
                  $anio = date("Y");
                  $mes = date("m");
                  $contador_meses = 1;
                  
                  for ($i = 1; $i <= $txt_repeticiones; $i++) {
                        $dia_mes = $dia_mes_inicial;
                        $anio = date("Y", strtotime("+" . $contador_meses . " month"));
                        $mes = date("m", strtotime("+" . $contador_meses . " month"));
                        $ultimo_dia_mes = date("t", strtotime($anio . '-' . $mes));
                    
                        if ($dia_mes > $ultimo_dia_mes) {
                            $dia_mes = $ultimo_dia_mes;
                        }
                    
                        $fecha_envio = date("Y-m-d H:i", strtotime($anio . '-' . $mes . '-' . $dia_mes . ' 08:00'));
                    
                        if (date("Y-m-d", strtotime($fecha_envio)) <= date("Y-m-d", strtotime($fecha_actual))) {
                            $fecha_envio = date("Y-m-d H:i", strtotime($fecha_envio . "+ 1 month"));
                        }
                    
                        // Verificar si el día no existe en el mes actual
                        while (!checkdate($mes, $dia_mes, $anio)) {
                            $dia_mes--;
                        }
                    
                        $fecha_envio = date("Y-m-d H:i", strtotime($anio . '-' . $mes . '-' . $dia_mes . ' 08:00'));
                    
                        //echo $fecha_envio . "\n";
                            $sql =  "INSERT INTO facturas_periodicas_detalle SET fk_factura_periodica =:fk_factura_periodica, fecha_procesar =:fecha_procesar,fecha_registro =:fecha_registro, entidad=:entidad ";
                            $db  = $this->db->prepare($sql);
                            $db->bindValue(":fk_factura_periodica", $fk_factura_periodica, PDO::PARAM_INT);
                            $db->bindValue(":fecha_procesar",       $fecha_envio, PDO::PARAM_STR);
                            $db->bindValue(":fecha_registro",       date("Y-m-d H:i:s") , PDO::PARAM_STR);
                            $db->bindValue(":entidad",              $_SESSION['Entidad'], PDO::PARAM_INT);
                            $resultado=$db->execute();
                    
                        // Verificar si se ha generado una fecha en cada mes
                        $contador_meses++;
                    }

                   
                  
             }
            
            
        }
        
        
                
        return $resultado;
    }
    
    public function obtenerCantidadMeses($a){

       $f1 = new DateTime( $a[0] );
       $f2 = new DateTime( $a[1] );
    
      // mostrara las fechas
      //echo "valor f1 : " . $f1->format('d-m-Y') . "\n";
      //echo "valor f2 : " . $f2->format('d-m-Y') . "\n";
    
      // obtener la diferencia de fechas
      $d = $f1->diff($f2);
      $difmes =  $d->format('%m');
    
      //echo " Cantidad de meses " . $difmes . "\n";
    
      $impf = $f1;
      for($i = 1; $i <= $difmes; $i++){
          // despliega los meses
          $impf->add(new DateInterval('P1M'));
          //echo  $impf->format('d-m-Y') . " - " .$i.  "\n";
      }
      
      return $difmes;
      
    }
    
    public function obtenerCantidadMeses2($fechaInicio, $fechaFin) {
            $inicio = new DateTime($fechaInicio);
            $fin = new DateTime($fechaFin);
            $meses = array();
            $i = 0;
            while ($inicio <= $fin) {
                if ($inicio->format('d') == '01') {
                    $meses[] = $inicio->format('m');
                    $i++;
                }
                $inicio->modify('first day of next month');
            }
            return $i;
        
    }
        
    public function cambiarStatus($rowid,$status){
            
            try{
    
                // QUERY
                $sql = "UPDATE facturas_periodicas SET activo =:activo WHERE rowid =:rowid;";
                $db  = $this->db->prepare($sql);
                $db->bindValue(":rowid", $rowid, PDO::PARAM_INT);
                $db->bindValue(":activo", $status, PDO::PARAM_INT);
                $result = $db->execute();
                
                if($status==0){
                    
                $sql = "UPDATE facturas_periodicas_detalle SET activo =0, fecha_anulado=now() WHERE fk_factura_periodica =:rowid and activo=1 and procesado=0;";
                $db  = $this->db->prepare($sql);
                $db->bindValue(":rowid", $rowid, PDO::PARAM_INT);
                $db->execute();
                    
                }
                return 1;
    
            }catch(PDOException $e){
                $this->errores(clear_string($e->getMessage()),$rowid,"cambiarStatus");
                return 0;
            }
    
    }
  
  
    public function cargarConfiguracion($rowid){
        
        try{
            $sql ="Select 
                    fp.*,
                    f.referencia,
                    f.electronica_tipo,
                    e.electronico_correo,
                    IFNULL('Cliente Genérico', CONCAT('',c.nombre,c.apellidos)) as cliente
                    from facturas_periodicas fp
                    left JOIN fi_facturas f on f.rowid=fp.fk_factura
                    left join fi_configuracion_empresa e on e.rowid=fp.entidad
                    left JOIN fi_terceros c on c.rowid=f.fk_tercero
                    where fp.rowid=:rowid";
            $db  = $this->db->prepare($sql);
            $db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
            $db->execute();
            $data = $db->fetch(PDO::FETCH_ASSOC);

            /*$this->rowid                    = $data['rowid'];
            $this->etiqueta              = $data['etiqueta'];
            $this->modo               = $data['modo'];
            */

                // RETURN
            return $data;

        }catch(PDOException  $e){
                //Registros en log error
                //$this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
                return 0;     
        }
        
    }

    
    public function borrar_configuracion($rowid){
        
        try{
    
                // QUERY
                $sql = "UPDATE facturas_periodicas SET activo =0, borrado=1 WHERE rowid =:rowid;";
                $db  = $this->db->prepare($sql);
                $db->bindValue(":rowid", $rowid, PDO::PARAM_INT);
                $result = $db->execute();
                
                if($result==1){
                    
                $sql = "UPDATE facturas_periodicas_detalle SET activo =0, fecha_anulado=:fecha WHERE fk_factura_periodica =:rowid and activo=1 and procesado=0;";
                $db  = $this->db->prepare($sql);
                $db->bindValue(":rowid", $rowid, PDO::PARAM_INT);
                $db->bindValue(":fecha", date("Y-m-d"), PDO::PARAM_STR);
                $db->execute();
                    
                }
                return 1;
    
            }catch(PDOException $e){
                $this->errores(clear_string($e->getMessage()),$rowid,"borrar_configuracion");
                return 0;
            }
    
    }
    
    public function pausar($rowid){
        
         try{
    
                // QUERY
                $sql = "UPDATE facturas_periodicas SET activo =:activo WHERE rowid =:rowid;";
                $db  = $this->db->prepare($sql);
                $db->bindValue(":rowid", $rowid, PDO::PARAM_INT);
                $db->bindValue(":activo", 0, PDO::PARAM_INT);
                $result = $db->execute();
                
                if($status==0){
                    
                $sql = "UPDATE facturas_periodicas_detalle SET activo =0, fecha_anulado=:fecha WHERE fk_factura_periodica =:rowid and activo=1 and procesado=0;";
                $db  = $this->db->prepare($sql);
                $db->bindValue(":rowid", $rowid, PDO::PARAM_INT);
                $db->bindValue(":fecha", date("Y-m-d"), PDO::PARAM_STR);
                $db->execute();
                    
                }
                return 1;
    
            }catch(PDOException $e){
                $this->errores(clear_string($e->getMessage()),$rowid,"pausar");
                return 0;
            }
    
        
    }
    
    public function errores($errores,$fk_factura_periodica, $proceso){
        
         
         try{
    
                // QUERY
                $sql = "INSERT INTO facturas_periodicas_errores  SET fecha_creacion =:fecha_creacion, detalle_error=:detalle_error, fk_factura_periodica=:fk_factura_periodica, entidad=:entidad, proceso=:proceso;";
                $db  = $this->db->prepare($sql);
                $db->bindValue(":fecha_creacion", date("Y-m-d H:i:s"), PDO::PARAM_STR);
                $db->bindValue(":detalle_error", $errores, PDO::PARAM_STR);
                $db->bindValue(":fk_factura_periodica", $fk_factura_periodica, PDO::PARAM_INT);
                $db->bindValue(":entidad", $_SESSION['Entidad'], PDO::PARAM_INT); 
                $db->bindValue(":proceso", $proceso, PDO::PARAM_STR);  
                $result = $db->execute();
                
                
                return 1;
    
            }catch(PDOException $e){
                $this->errores(clear_string($e->getMessage()),null,"errores");
                return 0;
            }
    }
    
} // fin de la clase 
?>