<?php
/**
 * Created by PhpStorm.
 * User: xavier
 * Date: 10/28/17
 * Time: 8:17 PM
 */

require __DIR__ . '/vendor/autoload.php';
require 'Facturae.php';

define ("EXP",6000000);
setlocale (LC_CTYPE, 'es_ES');
ini_set ("display_errors","1");
ini_set ("memory_limit","-1");


define('OAUTH2_CLIENT_ID', 'api-stag');
define('OAUTH_CONSUMER_KEY', 'cpf-01-1501-0959@stag.comprobanteselectronicos.go.cr' );
define('OAUTH_CONSUMER_SECRET', "cpf-01-1501-0959@stag.comprobanteselectronicos.go.cr" );
define('grant_type' , 'authorization_code');
define('Response_Type' , 'token');

define('Authorization_Grants' , 'password');
define('Client_Id' ,'api-stag');
define('Client_Secret' ,'');
define('Scope' , '');
define('content-type' , 'application/x-www-form-urlencoded');

define('Username' , 'cpf-01-1501-0959@stag.comprobanteselectronicos.go.cr');
define('Password' , ')a+_;6=dSm|Zd&WW:M)+');

define('Staging_Auth_Url',
    'https://idp.comprobanteselectronicos.go.cr/auth/realms/rut-stag/protocol/openid-connect/token');
define('Staging_Recepcion_Url',
    'https://api.comprobanteselectronicos.go.cr/recepcion-sandbox/v1/recepcion');

ini_set('allow_url_fopen',1);


//Invalid protected resource url, unable to generate signature base string
echo "Iniciando..." . "\n";


// Creamos la factura
$fac = new Facturae();

// Ya solo queda firmar la factura ...
$policy = array(
    "name" => "Resolucion_Comprobantes_Electronicos_DGT-R-48-2016",
    "url" => "https://tribunet.hacienda.go.cr/docs/esquemas/2016/v4.1/Resolucion_Comprobantes_Electronicos_DGT-R-48-2016.pdf",
    "digest" => "NmI5Njk1ZThkNzI0MmIzMGJmZDAyNDc4YjUwNzkzODM2NTBiOWUxNTBkMmI2YjgzYzZjM2I5NTZlNDQ4OWQzMQ=="
);

// ... y exportarlo a un archivo
// establecimiento (001) + punto de venta (00001) + tipo documento (01) "factura electrónica" + número consecutivo (0000000001)
$consecutivo = '001' . '00001' . '01' . '0000000018';
// Prepare document
// país (506) + día (01) + mes(12) + año (17) + cédula del emisor (000115010959) + consecutivo (00000000000000000001) + tipo (1) 'normal' + código de seguridad (12345678)

$pais = '506';
$dia = '26';
$mes = '12';
$ano = '17';
$emisor = '115010959';
$emisorConCeros = str_pad($emisor, 12, '0', STR_PAD_LEFT);
$tipo = '1';
$seguridad = '12345678';
$clave = $pais . $dia . $mes . $ano . '000' . $emisor . $consecutivo . $tipo . $seguridad;
$xml = '<FacturaElectronica xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:etsi="http://uri.etsi.org/01903/v1.3.2#" xmlns="https://tribunet.hacienda.go.cr/docs/esquemas/2016/v4.1/facturaElectronica"><Clave>' . $clave .'</Clave><NumeroConsecutivo>' . $consecutivo . '</NumeroConsecutivo><FechaEmision>20' . $ano .'-' . $mes . '-' . $dia . 'T10:16:00</FechaEmision><Emisor><Nombre>David Bermejo Porras</Nombre><Identificacion><Tipo>01</Tipo><Numero>' . $emisor . '</Numero></Identificacion><NombreComercial>NAVARRA DESARROLLO DE SOFTWARE</NombreComercial><Ubicacion><Provincia>1</Provincia><Canton>01</Canton><Distrito>09</Distrito><Barrio>01</Barrio><OtrasSenas>ALFA</OtrasSenas></Ubicacion><Telefono><CodigoPais>' . $pais . '</CodigoPais><NumTelefono>22096000</NumTelefono></Telefono><Fax><CodigoPais>' . $pais . '</CodigoPais><NumTelefono>22096174</NumTelefono></Fax><CorreoElectronico>tu@email.com</CorreoElectronico></Emisor><Receptor><Nombre>COVIDIEN MANUFACTURING SOLUTIONS S.A.</Nombre><Identificacion><Tipo>02</Tipo><Numero>3101587185</Numero></Identificacion><NombreComercial>COVIDIEN MANUFACTURING SOLUTIONS S.A.</NombreComercial><Telefono><CodigoPais>506</CodigoPais><NumTelefono>24365700</NumTelefono></Telefono></Receptor><CondicionVenta>02</CondicionVenta><PlazoCredito>30</PlazoCredito><MedioPago>02</MedioPago><DetalleServicio><LineaDetalle><NumeroLinea>1</NumeroLinea><Codigo><Tipo>04</Tipo><Codigo>P</Codigo></Codigo><Cantidad>1.00</Cantidad><UnidadMedida>kg</UnidadMedida><Detalle>DHL EXPRESS WORLDWIDE- NON DOC</Detalle><PrecioUnitario>54.59000</PrecioUnitario><MontoTotal>54.59000</MontoTotal><SubTotal>54.59000</SubTotal><MontoTotalLinea>54.59000</MontoTotalLinea></LineaDetalle></DetalleServicio><ResumenFactura><CodigoMoneda>USD</CodigoMoneda><TipoCambio>569.83</TipoCambio><TotalServGravados>54.59000</TotalServGravados><TotalServExentos>0.00</TotalServExentos><TotalMercanciasGravadas>0.00</TotalMercanciasGravadas><TotalMercanciasExentas>0.00</TotalMercanciasExentas><TotalGravado>54.59000</TotalGravado><TotalExento>0.00</TotalExento><TotalVenta>54.59000</TotalVenta><TotalDescuentos>0.00</TotalDescuentos><TotalVentaNeta>54.59000</TotalVentaNeta><TotalImpuesto>0.00</TotalImpuesto><TotalComprobante>54.59000</TotalComprobante></ResumenFactura><Normativa><NumeroResolucion>DGT-R-48-2016</NumeroResolucion><FechaResolucion>07-10-2016 08:00:00</FechaResolucion></Normativa></FacturaElectronica>';

$fac->sign(
    __DIR__ . "/Keys/011501095914-1.p12",
    '5357'
);
$fac->export($xml, "factura.xml.xsig");

$client = new \GuzzleHttp\Client([
    'timeout' => 4.0,
]);

$body = [
    'client_id' => Client_Id,
    'username' => Username,
    'password' => Password,
    'client_secret' => Client_Secret,
    'scope' => Scope,
    'grant_type' => Authorization_Grants,
];

$contentObj = null;

try {
    echo 'Obteniendo credenciales:';
    $response = $client->request('POST', Staging_Auth_Url, ['form_params' => $body]);

    $content = $response->getBody()->getContents();
    $contentObj = json_decode($content);

    echo  "OK!\n";

} catch(Exception $E) {
    echo "Error!\n";
}

$access_token = $contentObj->access_token;

// para el payload
$facturaBase64 = file_get_contents('./base64.txt', FILE_USE_INCLUDE_PATH);
$fechaEmision = '2016-01-01T00:00:00-0600';

$mockBody = sprintf('
{
  "clave": "%s",
  "fecha": "%s",
  "emisor": {
    "tipoIdentificacion": "01",
    "numeroIdentificacion": "%s"
  },
  "receptor": {
    "tipoIdentificacion": "02",
    "numeroIdentificacion": "3101123456"
  },
  "comprobanteXml":"%s"
}', $clave, $fechaEmision, $emisor, $facturaBase64);

$body = json_decode($mockBody);
try {
    echo 'Enviando comprobante:';
    $response = $client->request(
        'POST',
        Staging_Recepcion_Url,
        [
            'json' => $body,
            'headers' =>
                [
                    'Authorization' => "Bearer {$access_token}",
                    'Content-Type' => 'application/json',
                ]
        ]
    );

    $content = $response->getBody()->getContents();
    $contentObj = json_decode($content);

    echo  "OK!\n";
} catch(Exception $E) {

    $headers = $response = $E->getResponse()->getHeaders();

    echo 'Errores:' . "\n";
    foreach ($headers['X-Error-Cause'] as $error) {
        echo $error . "\n";
    }
}
sleep(5);
try {
    echo 'Recibiendo resultado de comprobante:';
    $response = $client->request(
        'GET',
        Staging_Recepcion_Url . '/' . $clave,
        [
            'headers' =>
                [
                    'Authorization' => "Bearer {$access_token}",
                    'Content-Type' => 'application/json',
                ]
        ]
    );

    $content = $response->getBody()->getContents();
    $contentObj = json_decode($content);
    $respuestaXmlBase64 = $contentObj->{'respuesta-xml'};
    $respuestaXmlTxt = base64_decode($respuestaXmlBase64);
    $respuestaXml = new SimpleXMLElement($respuestaXmlTxt);
    echo  "OK!\n";
    echo  "Resultado: \n";
    if ((int) $respuestaXml->Mensaje === 3) {
        throw new Exception((string) $respuestaXml->DetalleMensaje);
    }
    echo $respuestaXmlTxt;
} catch(Exception $E) {
    echo 'Errores:' . "\n";
    echo $E->getMessage(). "\n";
}
