<?php
require_once ENLACE_SERVIDOR . "global/object/log.sistema.php";

class Importacion extends log_sistema{

private $db;


public function __construct ($db){   

                        $this->db=$db;
                        parent::__construct($db);
                        $this->file=basename(__FILE__);
}


 // FUNCTION PARA GUARDAR 
 public function guardar($archivo){

     $sql="";
     $process = 'Ingreso del Registro de importacion' ;

     try{

                 // COLUMNAS EDITABLES
                 $columnas = " 
                            fecha_importacion =:fecha_importacion, 
                            archivo =:archivo, 
                            estado =:estado,
                            fk_usuario =:fk_usuario
                            ";

                  // QUERY
                $sql = "INSERT INTO archivo_importacion_xls SET  " . $columnas;
                $db  = $this->db->prepare($sql);
                $db->bindValue(":fecha_importacion",    date("Y-m-d H:i:s"), PDO::PARAM_STR);
                $db->bindValue(":archivo",              $archivo, PDO::PARAM_STR);
                $db->bindValue(":estado",               1, PDO::PARAM_INT);
                $db->bindValue(":fk_usuario",           $_SESSION['usuario'], PDO::PARAM_INT);
                $result = $db->execute();
                $errores = $db->errorInfo();

                 //Registros en log success
                 $record  = $this->db->lastInsertId();
                 $detail  =  'Registro ' . $record . ' insertado en la tabla archivo_importacion_xls';
                 $this->log_success($this->file,$record,$process,$detail);
                 
                 // RETURN
                 $array = array(
                        'registrado'  => $result,
                        'error'       => ""
                      );
                 return $array;

     }catch(PDOException  $e){
         //Registros en log error
         $this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
         $array = array(
                'registrado'  => 0,
                'error'       => clear_string($e->getMessage())
              );

         return $array;
     
     }
     
 }

  



}  // Fin de la Clase 
