<?php
SESSION_START();
include_once "../../conf/conf.php";

header("Content-type:   application/x-msexcel; charset=utf-8");
header("Pragma: no-cache");
header("Expires: 0");
$filename = 'ventas.xls';
header('Content-Disposition: attachment; filename=' . $filename);
echo pack("CCC", 0xef, 0xbb, 0xbf);
ob_start();

include_once ENLACE_SERVIDOR . "mod_iva/object/iva.calculos.php";
$IVA       = new ReportesIVA($dbh, $_SESSION['Entidad']);
$resultado = $IVA->ventas_por_impuesto();

$fecha_inicio = substr(("0" . $_GET['mes']), -2);
$fecha_inicio = date("Y") . "-" . $fecha_inicio . "-01";

$fecha_inicio;
$fecha_fin = $IVA->ultimo_dia_mes($fecha_inicio);

$IVA->diccionario_datos();
$resultados = $IVA->ventas_por_impuesto($fecha_inicio, $fecha_fin, $_GET['actividad']);

foreach ($resultados['ACTIVIDAD_FECHA_SOLO_ACEPTADOS_RESUMEN_DETALLADO'] as $ACTIVIDAD => $RESULTADOS) {

    echo "<table>";
    echo "<tr style='font-weight:bold;'><td colspan='7'> Actividad : $ACTIVIDAD </td></tr> ";

    echo "<tr style='background-color:grey;color:black;font-weight: bold;'>";
    echo "<td align='center'>#</td>";
    echo "<td align='center'>Fecha</td>";
    echo "<td align='center'>Consecutivo</td>";
    echo "<td align='center'>Detalle</td>";
    echo "<td align='center'>Moneda</td>";
    echo "<td align='center'>Tipo Cambio BCCR</td>";
    echo "<td align='center'>Tipo</td>";
    echo "<td align='center'>SubTotal</td>";
    echo "<td align='center'>Imp. %</td>";
    echo "<td align='center'>Impuesto</td>";
    echo "<td align='center'>Descuento</td>";
    echo "<td align='center'>Total</td>";
    echo "<td align='center'>Colonizado</td>";
    echo "</tr>";

    $gran_total = 0;

    foreach ($RESULTADOS as $i => $data) {

        $simbolo[1] = "₡";
        $simbolo[2] = "$";

        $MONEDA[1] = "Colones";
        $MONEDA[2] = "Dolares";

        $tipo_actividad[1] = "Producto";
        $tipo_actividad[2] = "Servicio";

        $tipo_cambio = ($data['moneda'] == 2) ? $data['tipo_cambio'] : "";

        echo "<tr>";
        echo "<td align='center'>" . ($i + 1) . "</td>";
        echo "<td align='center'>" . date('d-m-Y', strtotime($data['fecha'])) . "</td>";
        echo "<td align='center'>'" . $data['consecutivo'] . "'</td>";
        echo "<td align='center'>" . $data['detalle'] . "</td>";
        echo "<td align='center'>" . $MONEDA[$data['moneda']] . "</td>";
        echo "<td align='center'>" . numero_simple($tipo_cambio) . "</td>";
        echo "<td align='center'><small>".$tipo_actividad[$data['tipo']]."</small></td>";
        echo "<td align='right'>" . numero_simple($data['subtotal']) . "</td>";
        echo "<td align='center'>" . numero_simple($data['tipo_impuesto']) . "</td>";
        echo "<td align='right'>" . numero_simple($data['impuesto']) . "</td>";
        echo "<td align='right'>" . numero_simple($data['monto_descuento']) . "</td>";
        echo "<td align='right'>" . numero_simple($data['total']) . "</td>";
        echo "<td align='right'>" . numero_simple($data['COLONIZADO']) . "</td>";
        echo "</tr>";

        $gran_total += $data['COLONIZADO'];

    }

    echo "<tr style='background-color:grey;color:white;' >";
    echo "<td align='center' colspan='12'> </td>";
    echo "<td align='right'> " . numero($gran_total) . "       </td>";

    echo "</tr>";

}

echo "<table>";

$content = ob_get_clean();

$data = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
    <!--[if gte mso 9]>
    <xml>
        <x:ExcelWorkbook>
            <x:ExcelWorksheets>
                <x:ExcelWorksheet>
                    <x:Name>Reporte_Ventas</x:Name>
                    <x:WorksheetOptions>
                        <x:Print>
                            <x:ValidPrinterInfo/>
                        </x:Print>
                    </x:WorksheetOptions>
                </x:ExcelWorksheet>
            </x:ExcelWorksheets>
        </x:ExcelWorkbook>
    </xml>
    <![endif]-->
</head>

<body>
   ' . $content . '
</body></html>';

echo $data;