<?php
SESSION_START();
include_once "../../conf/conf.php";

if (isset($_POST['inicio']) and isset($_POST['fin'])) {
    $start_date = date('Y-m-d', strtotime($_POST['inicio']));
    $end_date   = date('Y-m-d', strtotime($_POST['fin']));
}

$today = getdate();
// VALID EXPORT
if ($_POST['exportar'] == "1") {
    header("Content-type:   application/x-msexcel; charset=utf-8");
    header("Pragma: no-cache");
    header("Expires: 0");

    $filename = 'Informe_de_Impuestos_Ventas_' . $today[mday] . '-' . $today[mon] . '-' . $today[year] . '_' . $today[hours] . '-' . $today[minutes] . '-' . $today[seconds] . '.xls';
    header('Content-Disposition: attachment; filename=' . $filename);
    echo pack("CCC", 0xef, 0xbb, 0xbf);
    ob_start();
}
// INCLUDE
include_once ENLACE_SERVIDOR . "mod_iva/object/iva.calculos.php";
$IVA        = new ReportesIVA($dbh, $_SESSION['Entidad']);
$resultados = $IVA->ventas_por_impuesto($start_date, $end_date);
$html = "<table border=1 width='100%'>";
$cont = 1;
// RUN RECORDS
foreach ($resultados['ACTIVIDAD_FECHA_SOLO_ACEPTADOS_RESUMEN_DETALLADO'] as $ACTIVIDAD => $RESULTADOS):
    $html.= 
        "<tr style='font-weight:bold;'><td colspan='13'> Actividad : $ACTIVIDAD </td></tr> ";
    $html.= "<tr style='color:black;font-weight:bold;'>";
    $html.= "<td align='center'>#</td>";
    $html.= "<td align='center'>Fecha</td>";
    $html.= "<td align='center'>Consecutivo</td>";
    $html.= "<td align='center'>Detalle</td>";
    $html.= "<td align='center'>Moneda</td>";
    $html.= "<td align='center'>Tipo Cambio BCCR</td>";
    $html.= "<td align='center'>Tipo</td>";
    $html.= "<td align='center'>SubTotal</td>";
    $html.= "<td align='center'>Imp. %</td>";
    $html.= "<td align='center'>Impuesto</td>";
    $html.= "<td align='center'>Descuento</td>";
    $html.= "<td align='center'>Total</td>";
    $html.= "<td align='center'>Colonizado</td>";
    $html.= "</tr>";

    $gran_total = 0;

    foreach ($RESULTADOS as $i => $data):
        $simbolo[1] = "₡";
        $simbolo[2] = "$";

        $MONEDA[1] = "Colones";
        $MONEDA[2] = "Dolares";

        $tipo_actividad[1] = "Producto";
        $tipo_actividad[2] = "Servicio";

        $tipo_cambio = ($data['moneda'] == 2) ? $data['tipo_cambio'] : "";
        // CONSECUTIVE
        $consecutive = (($_POST['exportar']) == "1")? "'".$data['consecutivo']."'": $data['consecutivo'];
        // HTML
        $html.= "<tr>";
        $html.= "<td align='center'>" . ($i + 1) . "</td>";
        $html.= "<td align='center'>" . date('d-m-Y', strtotime($data['fecha'])) . "</td>";
        $html.= "<td align='center'>" . $consecutive. "</td>";
        $html.= "<td align='center'>" . $data['detalle'] . "</td>";
        $html.= "<td align='center'>" . $MONEDA[$data['moneda']] . "</td>";
        $html.= "<td align='center'>" . numero_simple($tipo_cambio) . "</td>";
        $html.= "<td align='center'><small>".$tipo_actividad[$data['tipo']]."</small></td>";
        $html.= "<td align='right'>" . numero_simple($data['subtotal']) . "</td>";
        $html.= "<td align='center'>" . numero_simple($data['tipo_impuesto']) . "</td>";
        $html.= "<td align='right'>" . numero_simple($data['impuesto']) . "</td>";
        $html.= "<td align='right'>" . numero_simple($data['monto_descuento']) . "</td>";
        $html.= "<td align='right'>" . numero_simple($data['total']) . "</td>";
        $html.= "<td align='right'>" . numero_simple($data['COLONIZADO']) . "</td>";
        $html.= "</tr>";

        $gran_total += $data['COLONIZADO'];
        $cont++;
    endforeach;

    $html.= "<tr style='color:black;font-weight:bold;'>";
    $html.= "<td align='center' colspan='12'> </td>";
    $html.= "<td align='right'>".numero($gran_total)."</td>";

    $html.= "</tr>";
endforeach;
$html.= "</table>";
// VALID EXPORT
if ($_POST['exportar'] != "1"):
echo 
"<center>
    <Strong>Informe Impuestos por Ventas del ".date('d-m-Y', strtotime($start_date))." al ".date('d-m-Y', strtotime($end_date))."</strong>

        <br><br>
        <!-- HEADER -->
        <table>
            <tr style='background-color:#3c8dbc; color:white;'>
                <td align='center'>Detalles de Facturas</td>
            </tr>
            <tr>
                <td></td>
            </tr>
            <tr>
                <td align='center'>".$cont."</td>
            </tr>
        </table>
        <br>
        <!-- HEADER -->
        <table>
            <tr>
                <td align='center'><i><b>Nota</b>: Para ver toda la información del Reporte, por favor, desplazarse a la derecha.</i></td>
            </tr>
        </table>
        <br><br>
        <br>
        <div>
            <!-- HTML -->
            ".$html."
        </div>
        <br><br><hr><small>Informe Generado el día ".date('d-m-Y')."</small>
    </center>
<br><hr><br>";
else:
    echo $html;
endif;
// VALID EXPORT
if ($_POST['exportar'] == "1"):
    $content = ob_get_contents();

    $data = 
    '<html xmlns:x="urn:schemas-microsoft-com:office:excel">
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <!--[if gte mso 9]>
            <xml>
                <x:ExcelWorkbook>
                    <x:ExcelWorksheets>
                        <x:ExcelWorksheet>
                            <x:Name>Reporte-Ventas </x:Name>
                            <x:WorksheetOptions>
                                <x:Print>
                                    <x:ValidPrinterInfo/>
                                </x:Print>
                            </x:WorksheetOptions>
                        </x:ExcelWorksheet>
                    </x:ExcelWorksheets>
                </x:ExcelWorkbook>
            </xml>
            <![endif]-->
        </head>
<body>
   ' . $content . '
</body></html>';
    echo $data;
endif;