
<!DOCTYPE html>
<!--
//
// StarWebPRNT Sample(Canvas Handwriting)
//
// Version 1.2.0
//
// Copyright (C) 2012-2015 STAR MICRONICS CO., LTD. All Rights Reserved.
//
-->
<html>
<head>
<meta charset="UTF-8">
<meta http-equiv="Expires" content="86400">
<meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no">
 

 <script type='text/javascript' src='js/StarWebPrintBuilder.js'></script>
<script type='text/javascript' src='js/StarWebPrintTrader.js'></script>





<script
  src="https://code.jquery.com/jquery-3.2.1.slim.js"
  integrity="sha256-tA8y0XqiwnpwmOIl3SGAcFl2RvxHjA8qp0+1uCGmRmg="
  crossorigin="anonymous"></script>



<script>

var builder     = new StarWebPrintBuilder();
var request     = '';
var sampleCode  = '';


$( document ).ready(function() {
alert("... Iniciar Impresion");

 
    var url              = "http://localhost:8001/StarWebPRNT/SendMessage";
    var papertype        = "";
    var trader = new StarWebPrintTrader({url:url, papertype:papertype});



        var characterspace = 0;
        var linespace      = 32;
        var width          = 1;
        var height         = 1;
        var emphasis  = 'true';
        var underline = 'false';
        var invert    = 'false';
        var binary    = 'false';
        var codepage      = 'utf8';
        var international = 'usa';
        var font          = 'font_a';



        var data          = document.getElementById("texty").value;


        request += builder.createAlignmentElement({position:"center"});



        request += builder.createTextElement({characterspace:characterspace, linespace:linespace, codepage:codepage, international:international, font:font, width:width, height:height, emphasis:emphasis, underline:underline, invert:invert, binary:binary, data:encodeEscapeSequence(data)});

 

        var type = "partial";
        var feed = true;
        request += builder.createCutPaperElement({feed:feed, type:type});



    trader.onReceive = function (response) {
 
        var msg = '- onReceive -\n\n';

        msg += 'TraderSuccess : [ ' + response.traderSuccess + ' ]\n';

//      msg += 'TraderCode : [ ' + response.traderCode + ' ]\n';

        msg += 'TraderStatus : [ ' + response.traderStatus + ',\n';

        if (trader.isCoverOpen            ({traderStatus:response.traderStatus})) {msg += '\tCoverOpen,\n';}
        if (trader.isOffLine              ({traderStatus:response.traderStatus})) {msg += '\tOffLine,\n';}
        if (trader.isCompulsionSwitchClose({traderStatus:response.traderStatus})) {msg += '\tCompulsionSwitchClose,\n';}
        if (trader.isEtbCommandExecute    ({traderStatus:response.traderStatus})) {msg += '\tEtbCommandExecute,\n';}
        if (trader.isHighTemperatureStop  ({traderStatus:response.traderStatus})) {msg += '\tHighTemperatureStop,\n';}
        if (trader.isNonRecoverableError  ({traderStatus:response.traderStatus})) {msg += '\tNonRecoverableError,\n';}
        if (trader.isAutoCutterError      ({traderStatus:response.traderStatus})) {msg += '\tAutoCutterError,\n';}
        if (trader.isBlackMarkError       ({traderStatus:response.traderStatus})) {msg += '\tBlackMarkError,\n';}
        if (trader.isPaperEnd             ({traderStatus:response.traderStatus})) {msg += '\tPaperEnd,\n';}
        if (trader.isPaperNearEnd         ({traderStatus:response.traderStatus})) {msg += '\tPaperNearEnd,\n';}

        msg += '\tEtbCounter = ' + trader.extractionEtbCounter({traderStatus:response.traderStatus}).toString() + ' ]\n';

//      msg += 'Status : [ ' + response.status + ' ]\n';
//
//      msg += 'ResponseText : [ ' + response.responseText + ' ]\n';

        alert(msg);
    }

    trader.onError = function (response) {

        var msg = '- onError -\n\n';
        msg += '\tStatus:' + response.status + '\n';
        msg += '\tResponseText:' + response.responseText;
        alert(msg);
    }




    trader.sendMessage({request:request});


 });

</script>






<script>

function encodeEscapeSequence(data) {
    var regexp = /\\[tnr\\]/g;

    if (regexp.test(data)) {
        data = data.replace(regexp, function (match) {
            switch (match) {
                case '\\t' : return '\\x09';
                case '\\n' : return '\\x0a';
                case '\\r' : return '\\x0d';
            }

            return '\\x5c';
        });
    }

    var regexp = /\\[Xx][0-9A-Fa-f]{2}/g;

    if (regexp.test(data)) {
        data = data.replace(regexp, function (match) {
            return String.fromCharCode(parseInt(match.slice(2), 16));
        });
    }

    return data;
}
</script>

<body>
    <textarea id="texty" name="texty"> Esto es una prueba desde un datos directo \n Prueba de salto a ver si hace algo</textarea>
</body>
</html>
