<?php

class Consideraciones
{
	private $dbh;
	public $rowid;
	public $descripcion;
	public $texto;
	public $estado;
	public $creado_fk_usuario;
	public $creado_fecha;
	public $editado_fk_usuario;
	public $editado_fecha;

	public function __construct($db)
	{
		$this->dbh = $db;
		    $currentYear = date('Y');
	}

	public function fetch($id)
	{
		$query = "SELECT cc.*,
		fu.usuario as usuario_creador
		FROM a_medida_cctravel_consideraciones_cancelaciones cc 
		left join fi_usuarios fu on fu.rowid = cc.creado_fk_usuario 
		WHERE cc.rowid = :rowid";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(":rowid", $id);
		$stmt->execute();
		$row = $stmt->fetch(PDO::FETCH_ASSOC);

		$this->rowid = $row['rowid'];
		$this->descripcion = $row['descripcion'];
		$this->texto = $row['texto'];
		$this->estado = $row['estado'];
		$this->creado_fk_usuario = $row['creado_fk_usuario'];
		$this->creado_fecha = $row['creado_fecha'];
		
		return $this;
	
	}

	public function obtenerEstadosCotizacion()
	{

		$sql = "SELECT * FROM a_medida_cctravel_sitios_turisticos_diccionario_cotizaciones_v20  where activo = 1";

		$db = $this->dbh->prepare($sql);

		$db->execute();
		$data                              = $db->fetchAll(PDO::FETCH_OBJ);

		return $data;
	}



	public function guardarAdjunto()
	{

		$sql = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20 SET img_boleto = :img_boleto WHERE rowid = :rowid ";

		$db = $this->dbh->prepare($sql);
		$db->bindParam(':rowid', $this->rowid, PDO::PARAM_INT);
		$db->bindParam(':img_boleto', $this->img_boleto, PDO::PARAM_INT);
		$result                              = $db->execute();

		return $result;
	}
	
	

public function save()
{
    try {
        // Prepare query
        $query = "INSERT INTO a_medida_cctravel_consideraciones_cancelaciones SET 
            descripcion = :descripcion,
            texto = :texto,
            estado = :estado,
            creado_fk_usuario = :creado_fk_usuario,
            creado_fecha = now()";

        // Prepare statement
        $stmt = $this->dbh->prepare($query);

        // Bind parameters
    
        $stmt->bindParam(':descripcion', $this->descripcion, PDO::PARAM_STR);
        $stmt->bindParam(':texto', $this->texto, PDO::PARAM_STR);
        $stmt->bindParam(':estado', $this->estado, PDO::PARAM_INT);
        $stmt->bindParam(':creado_fk_usuario',$this->creado_fk_usuario, PDO::PARAM_INT);
        
        // Execute query
        $result = $stmt->execute();

        // Get record ID
        $record_id = $this->dbh->lastInsertId();

        // Return status and record ID
        return [
            'status' => $result,
            'id' => $record_id
        ];
    } catch (PDOException $e) {
        // Handle exception
        return "Error: " . $e->getMessage();
    }
}

        /******************************************************************
         * *
         * 
         * 
         * 
         * 
         * Funciones para BOLETO AEREOS
        *
        * 
        * 
        ******************************************************************/
        public function fetch_boleto($id)
                {
                    $query = "SELECT *
                                FROM a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos
                                WHERE rowid = ?";
                    $stmt = $this->dbh->prepare($query);
                    $stmt->bindParam(1, $id);
                    $stmt->execute();
                    $row = $stmt->fetch(PDO::FETCH_ASSOC);
                
                    $this->rowid = $row['rowid'];
                    $this->fk_cotizacion = $row['fk_cotizacion'];
                    $this->aerolinea = $row['aerolinea'];
                    $this->vuelo = $row['vuelo'];
                    $this->origen = $row['origen'];
                    $this->destino = $row['destino'];
                    $this->fecha_saliendo = $row['fecha_saliendo'];
                    $this->fecha_llegando = $row['fecha_llegando'];
                    $this->vuelo_duracion_en_horas = $row['vuelo_duracion_en_horas'];
                    $this->vuelo_escalas = $row['vuelo_escalas'];
                    $this->creado_fecha = $row['creado_fecha'];
                    $this->creado_fk_usuario = $row['creado_fk_usuario'];
                    $this->borrado = $row['borrado'];
                    $this->borrado_fecha = $row['borrado_fecha'];
                    $this->borrado_fk_usuario = $row['borrado_fk_usuario'];
                }
                
                

          public function traer_boletos_aereos($id, $rowid = null )
            {     $where = ($rowid !== NULL) ? " AND b.rowid = :rowid" : "";
                  
                  $query = "SELECT b.* , c.number  from a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos b
                  left join a_medida_cctravel_sitios_turisticos_cotizaciones_v20 c on c.rowid = b.fk_cotizacion 
                  
                  where b.fk_cotizacion = :id and b.borrado = 0  $where  
               ";
                $stmt = $this->dbh->prepare($query);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                
                if ($rowid !== NULL){
                    $stmt->bindParam(':rowid', $rowid, PDO::PARAM_INT);
                }
                
                $accion=$stmt->execute();
        
                if ($accion){
                        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        $consulta['error'] = 0;
                        $consulta['datos'] = $result;
            
                    } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error'] = 1;
                        $consulta['datos'] = $a;

                }
                
               return $consulta;
            }
            
            
            
            
              public function borrado_boleto()
                {
                    $query = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos
                              SET borrado = 1 ,
                                  borrado_fecha =  NOW(),
                                  borrado_fk_usuario = :borrado_fk_usuario
                              WHERE rowid = :rowid";
                
                    $stmt = $this->dbh->prepare($query);
                
                    $stmt->bindParam(':rowid', $this->rowid_boleto);
                    $stmt->bindParam(':borrado_fk_usuario', $this->borrado_fk_usuario);
                
                    $accion = $stmt->execute();
                    
                    
               if ($accion){
                        $consulta['error_eliminado'] = 0;
             
                        } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error_eliminado'] = 1;
                        $consulta['error_eliminado_txt'] = $a;
                }
                
               return $consulta;
               
               
                }

            
            public function save_boleto()
{
        // Prepare query
        $query = ($this->rowid_boleto > 0) ?
            "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos SET 
                fk_cotizacion = :fk_cotizacion,
                aerolinea = :aerolinea,
                vuelo = :vuelo,
                origen = :origen,
                destino = :destino,
                fecha_saliendo = :fecha_saliendo,
                fecha_llegando = :fecha_llegando,
                vuelo_duracion_en_horas = :vuelo_duracion_en_horas,
                vuelo_escalas = :vuelo_escalas,
                creado_fecha = NOW(),
                creado_fk_usuario = :creado_fk_usuario
            WHERE rowid = :rowid" :
            "INSERT INTO a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos SET 
                fk_cotizacion = :fk_cotizacion,
                aerolinea = :aerolinea,
                vuelo = :vuelo,
                origen = :origen,
                destino = :destino,
                fecha_saliendo = :fecha_saliendo,
                fecha_llegando = :fecha_llegando,
                vuelo_duracion_en_horas = :vuelo_duracion_en_horas,
                vuelo_escalas = :vuelo_escalas,
                creado_fecha = NOW(),
                creado_fk_usuario = :creado_fk_usuario";

        // Prepare statement
        $stmt = $this->dbh->prepare($query);

        // Bind parameters
        $stmt->bindParam(':fk_cotizacion', $this->fk_cotizacion, PDO::PARAM_INT);
        $stmt->bindParam(':aerolinea', $this->aerolinea, PDO::PARAM_STR);
        $stmt->bindParam(':vuelo', $this->vuelo, PDO::PARAM_STR);
        $stmt->bindParam(':origen', $this->origen, PDO::PARAM_STR);
        $stmt->bindParam(':destino', $this->destino, PDO::PARAM_STR);
        $stmt->bindParam(':fecha_saliendo', $this->fecha_saliendo, PDO::PARAM_STR);
        $stmt->bindParam(':fecha_llegando', $this->fecha_llegando, PDO::PARAM_STR);
        $stmt->bindParam(':vuelo_duracion_en_horas', $this->vuelo_duracion_en_horas, PDO::PARAM_INT);
        $stmt->bindParam(':vuelo_escalas', $this->vuelo_escalas, PDO::PARAM_INT);
        $stmt->bindParam(':creado_fk_usuario', $this->creado_fk_usuario, PDO::PARAM_INT);

        if ($this->rowid_boleto > 0) {
            $stmt->bindParam(':rowid', $this->rowid_boleto, PDO::PARAM_INT);
        }

        // Execute query
        $accion = $stmt->execute();

        // Get record ID
        $record_id = ($this->rowid_boleto > 0) ? $this->rowid_boleto : $this->dbh->lastInsertId();



            if ($accion){
                        $consulta['error_agregado'] = 0;
             
                        } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error_agregado'] = 1;
                        $consulta['error_agregado_txt'] = $a;
                }
                
                return $consulta;


    
}
            
            
            
            
            
            
            
            
            
            /*
            
             Funciones para los servicios de la cotizacion 
            
            */
            
          public function traer_servicios($id)
            {
                
                  $query = "SELECT b.* , c.nombre, c.descripcion  from a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios  b
                  left join a_medida_cctravel_sitios_turisticos c on c.rowid = b.fk_centro 
                  
                  where b.fk_cotizacion = :id  and b.borrado=  0
               ";
                $stmt = $this->dbh->prepare($query);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                $accion=$stmt->execute();
        
                if ($accion){
                        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        $consulta['error'] = 0;
                        $consulta['datos'] = $result;
            
                    } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error'] = 1;
                        $consulta['datos'] = $a;

                }
                
               return $consulta;
            }
            
            
            
            
            public function fetch_servicio($id)
                {
                    $query = "SELECT *
                        FROM a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios
                        WHERE rowid = ?";
                    $stmt = $this->dbh->prepare($query);
                    $stmt->bindParam(1, $id);
                    $stmt->execute();
                    $row = $stmt->fetch(PDO::FETCH_ASSOC);
                
                    $this->rowid_servicio = $row['rowid'];
                    $this->fk_cotizacion = $row['fk_cotizacion'];
                    $this->fk_centro = $row['fk_centro'];
                    $this->codigo = $row['codigo'];
                    $this->comentario = $row['comentario'];
                    $this->fk_servicio = $row['fk_servicio'];
                    $this->activo = $row['activo'];
                    $this->precio = $row['precio'];
                    $this->moneda = $row['moneda'];
                    $this->descuento = $row['descuento'];
                    $this->precio_final = $row['precio_final'];
                    $this->creado_fk_usuario = $row['creado_fk_usuario'];
                    $this->creado_fecha = $row['creado_fecha'];
                    $this->borrado = $row['borrado'];
                    $this->borrado_fecha = $row['borrado_fecha'];
                    $this->borrado_fk_usuario = $row['borrado_fk_usuario'];
                }


                public function borrado_servicio()
                {
                    $query = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios
                              SET borrado = 1 ,
                                  borrado_fecha =  NOW(),
                                  borrado_fk_usuario = :borrado_fk_usuario
                              WHERE rowid = :rowid";
                
                    $stmt = $this->dbh->prepare($query);
                
                    $stmt->bindParam(':rowid', $this->rowid_servicio);
                    $stmt->bindParam(':borrado_fk_usuario', $this->borrado_fk_usuario);
                
                    $accion = $stmt->execute();
                    
                    
               if ($accion){
                        $consulta['error_eliminado'] = 0;
             
                        } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error_eliminado'] = 1;
                        $consulta['error_eliminado_txt'] = $a;
                }
                
               return $consulta;
               
               
                }

            

} // fin de la clase