<?php

class CotizacionesV20
{
	private $dbh;
	public $rowid;
	public $number;
	public $fk_tercero;
	public $cantidad_adultos;
	public $cantidad_menores;
	public $fecha_entrada;
	public $fecha_salida;
	public $monto_oferta;
	public $monto_visible_pdf;
	public $descripcion;
	public $destino;
	public $fk_diccionario_cotizaciones_estado;
	public $creado_fk_usuario;
	public $creado_fecha;
	public $borrado;
	public $borrado_fk_usuario;
	public $borrado_fecha;
	public $tags;
	public $consideraciones;

    public $siguiente_consecutivo;

	public function __construct($db)
	{
		$this->dbh = $db;
		    $currentYear = date('Y');

    // Consultar el número de cotizaciones para el año actual
    $query = "SELECT COUNT(*) as count FROM 	a_medida_cctravel_sitios_turisticos_cotizaciones_v20  WHERE YEAR(creado_fecha) = :year";
    $stmt = $this->dbh->prepare($query);
    $stmt->bindParam(':year', $currentYear, PDO::PARAM_INT);
    $stmt->execute();

    // Obtener el resultado
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // Calcular el siguiente consecutivo
    $this->siguiente_consecutivo = "Cot-".$currentYear."-".($result['count'] + 1);
	}

	public function fetch($id)
	{
		$query = "SELECT cv.*,
		fu.usuario as usuario_creador,
    	concat_ws(' ',ft.nombre, ft.apellidos) as nombre_cliente,
    	ft.email as correo_cliente,
    	ft.telefono as telefono_cliente
		
		FROM a_medida_cctravel_sitios_turisticos_cotizaciones_v20  cv 
		
		left join fi_usuarios fu on fu.rowid = cv.creado_fk_usuario 
		left join fi_terceros ft on ft.rowid = cv.fk_tercero 
		
		WHERE cv.rowid = ?";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $id);
		$stmt->execute();
		$row = $stmt->fetch(PDO::FETCH_ASSOC);

		$this->rowid = $row['rowid'];
		$this->number = $row['number'];
		$this->fk_tercero = $row['fk_tercero'];
		$this->cantidad_adultos = $row['cantidad_adultos'];
		$this->cantidad_menores = $row['cantidad_menores'];
		$this->fecha_entrada = $row['fecha_entrada'];
		$this->fecha_salida = $row['fecha_salida'];
		$this->monto_oferta = $row['monto_oferta'];
		$this->monto_final = $row['monto_final'];
		$this->moneda = $row['moneda'];
		$this->entidad = $row['entidad'];
		$this->descuento_porcentaje = $row['descuento_porcentaje'];
		$this->monto_visible_pdf = $row['monto_visible_pdf'];
		$this->descripcion = $row['descripcion'];
		$this->destino = $row['destino'];
		$this->fk_diccionario_cotizaciones_estado = $row['fk_diccionario_cotizaciones_estado'];
		$this->creado_fk_usuario = $row['creado_fk_usuario'];
		$this->creado_fecha = $row['creado_fecha'];
		$this->borrado = $row['borrado'];
		$this->borrado_fk_usuario = $row['borrado_fk_usuario'];
		$this->borrado_fecha = $row['borrado_fecha'];
		$this->tags = $row['tags'];
		$this->img_path = $row['img_path'];
		$this->usuario_creador = $row['usuario_creador'];
		$this->nombre_cliente = $row['nombre_cliente'];
		$this->img_boleto = $row['img_boleto'];
		$this->acomodacion = $row['acomodacion'];
		$this->servicios_turisticos = $row['servicios_turisticos'];
    	$this->regimen = $row['regimen'];
		$this->acomodacion = $row['acomodacion'];
		$this->si_incluye = $row['si_incluye'];
		$this->no_incluye = $row['no_incluye'];
		$this->vuelo_internacional = $row['vuelo_internacional'];
		$this->correo_cliente = $row['correo_cliente'];
		$this->telefono_cliente = $row['telefono_cliente'];
		$this->consideraciones = $row['consideraciones'];
		
		
	}

	public function obtenerEstadosCotizacion()
	{

		$sql = "SELECT * FROM a_medida_cctravel_sitios_turisticos_diccionario_cotizaciones_v20  where activo = 1";

		$db = $this->dbh->prepare($sql);

		$db->execute();
		$data                              = $db->fetchAll(PDO::FETCH_OBJ);

		return $data;
	}
	
	
		public function obtenerServiciosTuristicos()
	{
	    $entidad = $_SESSION['Entidad'];

		$sql = "SELECT * FROM a_medida_cctravel_sitios_turisticos  where activo = 1 AND entidad = $entidad";

		$db = $this->dbh->prepare($sql);

		$db->execute();
		$data                              = $db->fetchAll(PDO::FETCH_OBJ);

		return $data;
	}
	
		public function enviar_whatsapp()
	{
		$sql = "INSERT INTO facturac_Licencias.whatsapp_mensajes set texto = :texto,
		telefonos_destinatario = :telefonos_destinatario, 
		fk_cotizacion = :fk_cotizacion";
   try {
		$db = $this->dbh->prepare($sql);
		$db->bindParam(':texto', $this->texto, PDO::PARAM_STR);
		$db->bindParam(':telefonos_destinatario', $this->telefonos_destinatario, PDO::PARAM_STR);
		$db->bindParam(':fk_cotizacion', $this->fk_cotizacion, PDO::PARAM_STR);
		
		$result                              = $db->execute();
   return $db->errorInfo();
		if(!$result){
		       return $db->errorInfo();
		}else{
		    	return $result;
		}
		
		
   } catch (PDOException $e) {
        // Handle exception
        return "Error: " . $e->getMessage();
    }
	}

	public function guardarCliente()
	{
// metodo para guardar clientes en fi_terceros
		$sql = "INSERT INTO fi_terceros set entidad = :entidad,
		tipo = :tipo,
		nombre = :nombre,
		apellidos = :apellidos,
		fecha_nacimiento = :fecha_nacimiento,
		email = :email,
		telefono = :telefono";
   try {
		$db = $this->dbh->prepare($sql);
		$db->bindParam(':entidad', $this->entidad, PDO::PARAM_INT);
		$db->bindParam(':tipo', $this->tipo, PDO::PARAM_INT);
		$db->bindParam(':nombre', $this->nombre, PDO::PARAM_STR);
		$db->bindParam(':apellidos', $this->apellidos, PDO::PARAM_STR);
		$db->bindParam(':fecha_nacimiento', $this->fecha_nacimiento, PDO::PARAM_STR);
		$db->bindParam(':email', $this->email, PDO::PARAM_STR);
		$db->bindParam(':telefono', $this->telefono, PDO::PARAM_STR);
		$result                              = $db->execute();
  
	
		
		if(!$result){
		       return $db->errorInfo();
		}else{
		    	return $result;
		}
		
		
		
   } catch (PDOException $e) {
        // Handle exception
        return "Error: " . $e->getMessage();
    }
	}

	public function guardarAdjunto()
	{

		$sql = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20 SET img_boleto = :img_boleto WHERE rowid = :rowid ";

		$db = $this->dbh->prepare($sql);
		$db->bindParam(':rowid', $this->rowid, PDO::PARAM_INT);
		$db->bindParam(':img_boleto', $this->img_boleto, PDO::PARAM_INT);
		$result                              = $db->execute();

		return $result;
	}
	
	
	
	
			public function delete_servicios($array, $record_id)
	{


foreach ($array as $item) {
    
    	$sql = "DELETE FROM a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios
WHERE fk_centro = :fk_centro AND fk_cotizacion = :fk_cotizacion";
		$db = $this->dbh->prepare($sql);
		$db->bindParam(':fk_cotizacion', $record_id, PDO::PARAM_INT);
		$db->bindParam(':fk_centro', $item, PDO::PARAM_INT);
	  $result =  $db->execute();
	  
	  if($result){
	      $borrados++;
	  }

}	    
	

	

		return $borrados;
	}
	
		public function copiar_servicios($array, $record_id)
	{


foreach ($array as $item) {
    
    	$sql = "INSERT INTO a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios
(fk_cotizacion, fk_centro, codigo, comentario, fk_servicio, activo, precio, moneda, descuento, precio_final, creado_fk_usuario, creado_fecha, borrado, borrado_fecha, borrado_fk_usuario, fk_icono, nombre_servicio)
SELECT :fk_cotizacion, fk_centro, codigo, comentario, fk_servicio, activo, precio, moneda, descuento, precio_final, creado_fk_usuario, creado_fecha, borrado, borrado_fecha, borrado_fk_usuario, fk_icono, nombre_servicio
FROM a_medida_cctravel_sitios_turisticos_servicios
WHERE fk_centro = :fk_centro";
		$db = $this->dbh->prepare($sql);
		$db->bindParam(':fk_cotizacion', $record_id, PDO::PARAM_INT);
		$db->bindParam(':fk_centro', $item, PDO::PARAM_INT);
	  $result =  $db->execute();
	  
	  if($result){
	      $clonados++;
	  }

}	    
	

	

		return $clonados;
	}
	
	

public function save()
{
  
  $editar = false;
     $array_input = explode(",", $this->servicios_turisticos);
     
    try {
if ($this->rowid > 0) {
      $editar = true;
    $current_data = new CotizacionesV20($this->dbh);
    $current_data->fetch($this->rowid);
    $array_current = explode(",", $current_data->servicios_turisticos);    
 

    // obtener un array con los valores nuevos que tiene $array_input vs $array_current
    $diferencias = array_diff($array_input, $array_current);
    
    //otro array con los ids que ya no estaran (inverso)
    $diferencias_delete = array_diff($array_current, $array_input);

    if(count($diferencias) > 0){
        $copiar_servicios = $this->copiar_servicios($diferencias, $this->rowid);
    }
    
     if(count($diferencias_delete) > 0){
        $delete_servicios = $this->delete_servicios($diferencias_delete, $this->rowid);
    }
}
       
        // Prepare query
        $query = ($this->rowid > 0) ? 
            "UPDATE 	a_medida_cctravel_sitios_turisticos_cotizaciones_v20  SET 
             
            fk_tercero = :fk_tercero,
            cantidad_adultos = :cantidad_adultos,
            cantidad_menores = :cantidad_menores,
            fecha_entrada = :fecha_entrada,
            fecha_salida = :fecha_salida,
            monto_oferta = :monto_oferta,
            monto_final = :monto_final,
            moneda = :moneda,
            descuento_porcentaje = :descuento_porcentaje,
            monto_visible_pdf = :monto_visible_pdf,
            descripcion = :descripcion,
            destino = :destino,
            fk_diccionario_cotizaciones_estado = :fk_diccionario_cotizaciones_estado,
            img_path = :img_path,
            tags = :tags,
             regimen = :regimen,
              acomodacion = :acomodacion,
               si_incluye = :si_incluye,
                no_incluye = :no_incluye,
                     entidad = :entidad,
                 vuelo_internacional = :vuelo_internacional,
            servicios_turisticos = :servicios_turisticos WHERE rowid = :rowid" :
            "INSERT INTO a_medida_cctravel_sitios_turisticos_cotizaciones_v20 SET 
            number = :number,
            fk_tercero = :fk_tercero,
            cantidad_adultos = :cantidad_adultos,
            cantidad_menores = :cantidad_menores,
            fecha_entrada = :fecha_entrada,
            fecha_salida = :fecha_salida,
            monto_oferta = :monto_oferta,
            monto_final = :monto_final,
            moneda = :moneda,
            descuento_porcentaje = :descuento_porcentaje,
            monto_visible_pdf = :monto_visible_pdf,
            descripcion = :descripcion,
            destino = :destino,
            img_path = :img_path,
            fk_diccionario_cotizaciones_estado = :fk_diccionario_cotizaciones_estado,
            creado_fk_usuario = :creado_fk_usuario,
            creado_fecha = now(),
            tags = :tags,
            regimen = :regimen,
            acomodacion = :acomodacion,
            si_incluye = :si_incluye,
            no_incluye = :no_incluye,
            vuelo_internacional = :vuelo_internacional,
             servicios_turisticos = :servicios_turisticos,
             entidad = :entidad ";

        // Prepare statement
        $stmt = $this->dbh->prepare($query);

        // Bind parameters
    
        $stmt->bindParam(':fk_tercero', $this->fk_tercero, PDO::PARAM_INT);
        $stmt->bindParam(':cantidad_adultos', $this->cantidad_adultos, PDO::PARAM_INT);
        $stmt->bindParam(':cantidad_menores', $this->cantidad_menores, PDO::PARAM_INT);
        $stmt->bindParam(':fecha_entrada', $this->fecha_entrada, PDO::PARAM_STR);
        $stmt->bindParam(':fecha_salida', $this->fecha_salida, PDO::PARAM_STR);
        $stmt->bindParam(':monto_oferta', $this->monto_oferta, PDO::PARAM_STR);
        $stmt->bindParam(':monto_final', $this->monto_final, PDO::PARAM_STR);
        $stmt->bindParam(':descuento_porcentaje', $this->descuento_porcentaje, PDO::PARAM_STR);
        $stmt->bindParam(':monto_visible_pdf', $this->monto_visible_pdf, PDO::PARAM_INT);
        $stmt->bindParam(':descripcion', $this->descripcion, PDO::PARAM_STR);
        $stmt->bindParam(':img_path', $this->img_path, PDO::PARAM_STR);
        $stmt->bindParam(':destino', $this->destino, PDO::PARAM_STR);
        $stmt->bindParam(':moneda', $this->moneda, PDO::PARAM_STR);
        $stmt->bindParam(':fk_diccionario_cotizaciones_estado', $this->fk_diccionario_cotizaciones_estado, PDO::PARAM_INT);
        $stmt->bindParam(':tags', $this->tags, PDO::PARAM_STR);
        $stmt->bindParam(':servicios_turisticos', $this->servicios_turisticos, PDO::PARAM_STR);
        $stmt->bindParam(':regimen', $this->regimen, PDO::PARAM_STR);
        $stmt->bindParam(':acomodacion', $this->acomodacion, PDO::PARAM_STR);
        $stmt->bindParam(':si_incluye', $this->si_incluye, PDO::PARAM_STR);
        $stmt->bindParam(':no_incluye', $this->no_incluye, PDO::PARAM_STR);
        $stmt->bindParam(':entidad', $_SESSION['Entidad'], PDO::PARAM_STR);
         $stmt->bindParam(':vuelo_internacional', $this->vuelo_internacional, PDO::PARAM_STR);

        if ($this->rowid > 0) {
            $stmt->bindParam(':rowid', $this->rowid, PDO::PARAM_INT);
              
        } else {
            $stmt->bindParam(':creado_fk_usuario', $this->creado_fk_usuario, PDO::PARAM_INT);
              $stmt->bindParam(':number', $this->number, PDO::PARAM_STR);
        }

        // Execute query
        $result = $stmt->execute();

        // Get record ID
        $record_id = ($this->rowid > 0) ? $this->rowid : $this->dbh->lastInsertId();
        
        
//sino se edito, cargar servicios
      if(!$editar){
          $copiar_servicios = $this->copiar_servicios($array_input, $record_id);
      }
        
        // Return status and record ID
        return [
            'status' => $result,
            'id' => $record_id,
            'cargar_servicios' => $copiar_servicios,
             'servicios_borrados' => $delete_servicios,
            'diferencias_servicios' => $diferencias
            
        ];
    } catch (PDOException $e) {
        // Handle exception
        return "Error: " . $e->getMessage();
    }
}

        /******************************************************************
         * *
         * 
         * 
         * 
         * 
         * Funciones para BOLETO AEREOS
        *
        * 
        * 
        ******************************************************************/
        public function fetch_boleto($id)
                {
                    $query = "SELECT *
                                FROM a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos
                                WHERE rowid = ?";
                    $stmt = $this->dbh->prepare($query);
                    $stmt->bindParam(1, $id);
                    $stmt->execute();
                    $row = $stmt->fetch(PDO::FETCH_ASSOC);
                
                    $this->rowid = $row['rowid'];
                    $this->fk_cotizacion = $row['fk_cotizacion'];
                    $this->aerolinea = $row['aerolinea'];
                    $this->vuelo = $row['vuelo'];
                    $this->origen = $row['origen'];
                    $this->destino = $row['destino'];
                    $this->fecha_saliendo = $row['fecha_saliendo'];
                    $this->fecha_llegando = $row['fecha_llegando'];
                    $this->vuelo_duracion_en_horas = $row['vuelo_duracion_en_horas'];
                    $this->vuelo_escalas = $row['vuelo_escalas'];
                    $this->creado_fecha = $row['creado_fecha'];
                    $this->creado_fk_usuario = $row['creado_fk_usuario'];
                    $this->borrado = $row['borrado'];
                    $this->borrado_fecha = $row['borrado_fecha'];
                    $this->borrado_fk_usuario = $row['borrado_fk_usuario'];
                }
                
                

          public function traer_boletos_aereos($id, $rowid = null )
            {     $where = ($rowid !== NULL) ? " AND b.rowid = :rowid" : "";
                  
                  $query = "SELECT b.* , c.number  from a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos b
                  left join a_medida_cctravel_sitios_turisticos_cotizaciones_v20 c on c.rowid = b.fk_cotizacion 
                  
                  where b.fk_cotizacion = :id and b.borrado = 0  $where  
               ";
                $stmt = $this->dbh->prepare($query);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                
                if ($rowid !== NULL){
                    $stmt->bindParam(':rowid', $rowid, PDO::PARAM_INT);
                }
                
                $accion=$stmt->execute();
        
                if ($accion){
                        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        $consulta['error'] = 0;
                        $consulta['datos'] = $result;
            
                    } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error'] = 1;
                        $consulta['datos'] = $a;

                }
                
               return $consulta;
            }
            
            
            
            
              public function borrado_boleto()
                {
                    $query = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos
                              SET borrado = 1 ,
                                  borrado_fecha =  NOW(),
                                  borrado_fk_usuario = :borrado_fk_usuario
                              WHERE rowid = :rowid";
                
                    $stmt = $this->dbh->prepare($query);
                
                    $stmt->bindParam(':rowid', $this->rowid_boleto);
                    $stmt->bindParam(':borrado_fk_usuario', $this->borrado_fk_usuario);
                
                    $accion = $stmt->execute();
                    
                    
               if ($accion){
                        $consulta['error_eliminado'] = 0;
             
                        } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error_eliminado'] = 1;
                        $consulta['error_eliminado_txt'] = $a;
                }
                
               return $consulta;
               
               
                }

            
            public function save_boleto()
{
        // Prepare query
        $query = ($this->rowid_boleto > 0) ?
            "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos SET 
                fk_cotizacion = :fk_cotizacion,
                aerolinea = :aerolinea,
                vuelo = :vuelo,
                origen = :origen,
                destino = :destino,
                fecha_saliendo = :fecha_saliendo,
                fecha_llegando = :fecha_llegando,
                vuelo_duracion_en_horas = :vuelo_duracion_en_horas,
                vuelo_escalas = :vuelo_escalas,
                creado_fecha = NOW(),
                creado_fk_usuario = :creado_fk_usuario
            WHERE rowid = :rowid" :
            "INSERT INTO a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos SET 
                fk_cotizacion = :fk_cotizacion,
                aerolinea = :aerolinea,
                vuelo = :vuelo,
                origen = :origen,
                destino = :destino,
                fecha_saliendo = :fecha_saliendo,
                fecha_llegando = :fecha_llegando,
                vuelo_duracion_en_horas = :vuelo_duracion_en_horas,
                vuelo_escalas = :vuelo_escalas,
                creado_fecha = NOW(),
                creado_fk_usuario = :creado_fk_usuario";

        // Prepare statement
        $stmt = $this->dbh->prepare($query);

        // Bind parameters
        $stmt->bindParam(':fk_cotizacion', $this->fk_cotizacion, PDO::PARAM_INT);
        $stmt->bindParam(':aerolinea', $this->aerolinea, PDO::PARAM_STR);
        $stmt->bindParam(':vuelo', $this->vuelo, PDO::PARAM_STR);
        $stmt->bindParam(':origen', $this->origen, PDO::PARAM_STR);
        $stmt->bindParam(':destino', $this->destino, PDO::PARAM_STR);
        $stmt->bindParam(':fecha_saliendo', $this->fecha_saliendo, PDO::PARAM_STR);
        $stmt->bindParam(':fecha_llegando', $this->fecha_llegando, PDO::PARAM_STR);
        $stmt->bindParam(':vuelo_duracion_en_horas', $this->vuelo_duracion_en_horas, PDO::PARAM_INT);
        $stmt->bindParam(':vuelo_escalas', $this->vuelo_escalas, PDO::PARAM_INT);
        $stmt->bindParam(':creado_fk_usuario', $this->creado_fk_usuario, PDO::PARAM_INT);

        if ($this->rowid_boleto > 0) {
            $stmt->bindParam(':rowid', $this->rowid_boleto, PDO::PARAM_INT);
        }

        // Execute query
        $accion = $stmt->execute();

        // Get record ID
        $record_id = ($this->rowid_boleto > 0) ? $this->rowid_boleto : $this->dbh->lastInsertId();



            if ($accion){
                        $consulta['error_agregado'] = 0;
             
                        } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error_agregado'] = 1;
                        $consulta['error_agregado_txt'] = $a;
                }
                
                return $consulta;


    
}
            
            
            
            
            
            
            
            
            
            /*
            
             Funciones para los servicios de la cotizacion 
            
            */
            
          public function traer_servicios($id)
            {
                
                  $query = "SELECT b.* , c.nombre, c.descripcion  from a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios  b
                  left join a_medida_cctravel_sitios_turisticos c on c.rowid = b.fk_centro 
                  
                  where b.fk_cotizacion = :id  and b.borrado=  0
               ";
                $stmt = $this->dbh->prepare($query);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                $accion=$stmt->execute();
        
                if ($accion){
                        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        $consulta['error'] = 0;
                        $consulta['datos'] = $result;
            
                    } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error'] = 1;
                        $consulta['datos'] = $a;

                }
                
               return $consulta;
            }
            
            
            
            
            public function fetch_servicio($id)
                {
                    $query = "SELECT cs.*, c.nombre as nombre_sitio 
                    FROM a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios cs 
                    left JOIN a_medida_cctravel_sitios_turisticos c on c.rowid = cs.fk_centro 
                    WHERE cs.rowid = ?";
                    $stmt = $this->dbh->prepare($query);
                    $stmt->bindParam(1, $id);
                    $stmt->execute();
                    $row = $stmt->fetch(PDO::FETCH_ASSOC);
                    $this->rowid_servicio = $row['rowid'];
                    $this->fk_cotizacion = $row['fk_cotizacion'];
                    $this->fk_centro = $row['fk_centro'];
                    $this->nombre_sitio = $row['nombre_sitio'];
                    $this->codigo = $row['codigo'];
                    $this->comentario = $row['comentario'];
                    $this->fk_servicio = $row['fk_servicio'];
                    $this->activo = $row['activo'];
                    $this->precio = $row['precio'];
                    $this->moneda = $row['moneda'];
                    $this->descuento = $row['descuento'];
                    $this->precio_final = $row['precio_final'];
                    $this->creado_fk_usuario = $row['creado_fk_usuario'];
                    $this->creado_fecha = $row['creado_fecha'];
                    $this->borrado = $row['borrado'];
                    $this->borrado_fecha = $row['borrado_fecha'];
                     $this->nombre_servicio = $row['nombre_servicio'];
                    $this->borrado_fk_usuario = $row['borrado_fk_usuario'];
                }


                public function borrado_servicio()
                {
                    $query = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios
                              SET borrado = 1 ,
                                  borrado_fecha =  NOW(),
                                  borrado_fk_usuario = :borrado_fk_usuario
                              WHERE rowid = :rowid";
                
                    $stmt = $this->dbh->prepare($query);
                
                    $stmt->bindParam(':rowid', $this->rowid_servicio);
                    $stmt->bindParam(':borrado_fk_usuario', $this->borrado_fk_usuario);
                
                    $accion = $stmt->execute();
                    
                    
               if ($accion){
                        $consulta['error_eliminado'] = 0;
             
                        } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error_eliminado'] = 1;
                        $consulta['error_eliminado_txt'] = $a;
                }
                
               return $consulta;
               
               
                }
                
                
                
                
                public function actualizarServicio()
                {
                   
                     
                    $query = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios
                        
                          set
                              comentario = :comentario,
                              nombre_servicio = :nombre_servicio,
                              activo = :activo,
                              precio = :precio,
                              moneda = :moneda,
                              descuento = :descuento,
                              precio_final = :precio_final
                            
                              WHERE rowid = :rowid";
                
                    $stmt = $this->dbh->prepare($query);
                
            
                    $stmt->bindParam(':rowid', $this->rowid, PDO::PARAM_STR);
           
                
                    $stmt->bindParam(':comentario', $this->comentario, PDO::PARAM_STR);
                    $stmt->bindParam(':nombre_servicio', $this->nombre_servicio, PDO::PARAM_STR);
                    $stmt->bindParam(':activo', $this->activo, PDO::PARAM_INT);
                    $stmt->bindParam(':precio', $this->precio, PDO::PARAM_STR);
                    $stmt->bindParam(':moneda', $this->moneda, PDO::PARAM_STR);
                    $stmt->bindParam(':descuento', $this->descuento, PDO::PARAM_STR);
                    $stmt->bindParam(':precio_final', $this->precio_final, PDO::PARAM_STR);
             
                  
                
                    $accion = $stmt->execute();
                    
                    
                
               return $accion;
               
               
                }
                
                public function actualizarConsideraciones()
                {
                      $query = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20
                          set
                              consideraciones = :consideraciones
                              WHERE rowid = :rowid";
                
                    $stmt = $this->dbh->prepare($query);
                    $stmt->bindParam(':rowid', $this->rowid, PDO::PARAM_INT); 
                    $stmt->bindParam(':consideraciones', $this->consideraciones, PDO::PARAM_STR); 
                    
                     $accion = $stmt->execute();
                    
               return $accion;
               
                }

            

} // fin de la clase
