<?php
// 12-01-2024 Julio Alvarado
//Esto es una vista para editar/crear cotizaciones
//incluir objeto
require_once(ENLACE_SERVIDOR . "mod_medida_cctravel_cotizaciones/object/cotizacion.object.php");
$cotizacion = new CotizacionesV20($dbh);
$cotizacion->fetch($_GET['id']);
$diccionario_estatus = $cotizacion->obtenerEstadosCotizacion();
$diccionario_servicios = $cotizacion->obtenerServiciosTuristicos();

if ($cotizacion->moneda == 1) {
  $selected_moneda_colones = '';
  $selected_moneda_dolares = 'selected';
} else {
  $selected_moneda_colones = 'selected';
  $selected_moneda_dolares = '';
}


if ($cotizacion->vuelo_internacional == 1) {
  $selected_si_internacional = 'selected';
  $selected_no_internacional = '';
} else {
  $selected_no_internacional = 'selected';
  $selected_si_internacional = '';
}




$editar = false;

foreach ($diccionario_estatus as $item) {
  if ($item->rowid == $cotizacion->fk_diccionario_cotizaciones_estado) {
    $opciones_estatus .= '
                        <option selected value="' . $item->rowid . '">' . $item->etiqueta . '</td>';
  } else {
    $opciones_estatus .= '
                        <option value="' . $item->rowid . '">' . $item->etiqueta . '</td>';
  }
}

foreach ($diccionario_servicios as $item) {
  $opciones_servicios .= '
                        <option value="' . $item->rowid . '">' . $item->nombre . '</td>';
}



//validar si estamos editando o creando
if ($cotizacion->rowid > 0) {
  $titulo = "Modificar cotizacion";
  $editar = true;

  if ($cotizacion->monto_visible_pdf == 1) {
    $selected_visible = 'selected';
    $selected_no_visible = '';
  } else {
    $selected_visible = '';
    $selected_no_visible = 'selected';
  }



  $arrayRecuperado = explode(",", $cotizacion->tags);
  $arrayRecuperado2 = explode(",", $cotizacion->servicios_turisticos);
} else {
  //estamos creando
  $titulo = "Nueva Cotizaci&oacute;n";
}
?>

<style>
  span.select2.select2-container.select2-container--default {
    z-index: auto;
  }
</style>
<form name="miFormulario" id="miFormulario">

  <div class="pcoded-inner-content">
    <div class="page-bar">
      <div class="page-title-breadcrumb">
        <div class=" pull-left">

          <div class="page-title">
            <h2><?php echo "Detalle " . $titulo;  ?></h2>
          </div>
          <?php

          ?>


        </div>
        <ol class="breadcrumb page-breadcrumb pull-right">
          <li><i class="fa fa-home"></i>&nbsp;<a class="parent-item" href="<?php echo ENLACE_WEB; ?>"><?php echo $Lan->lang('global.inicio'); ?></a>&nbsp;<i class="fa fa-angle-right"></i>
          </li>
          <li><a class="parent-item" href="<?php echo ENLACE_WEB; ?>cotizaciones_listado "> Cotizaciones </a>&nbsp;<i class="fa fa-angle-right"></i>
          </li>
          <li class="active"><?php echo $titulo; ?></li>
        </ol>
      </div>
    </div>


    <div class="row">
      <div class="col-md-12 col-xl-12">
        <div class="card sale-card">
          <div class="card-header">

            <div id="details" class="panel panel-default">



              <div class="panel-body">
                <div class="row">
                  <div class="col-md-10">
                    <input type="hidden" name="editar" value="1">
                    <input type="hidden" name="id" value="<?php echo $cotizacion->rowid; ?>">
                    <input type="hidden" name="action" value="<?php echo (($cotizacion->rowid > 0) ? 'modificarCotizacion' : 'crearCotizacion'); ?>">

                    <div class="row">
                      <div class="col-md-3">
                        ID Cotización :
                      </div>
                      <div class="col-md-3">

                        <label for=""><?php echo $cotizacion->rowid; ?></label>
                      </div>
                    </div>


                    <div class="row">
                      <div class="col-md-3">
                        Nombre Cliente :
                      </div>
                      <div class="col-md-3">
                        <div class="input-group">
                          <input placeholder="Buscar por nombre" type="text" id="nombre_cliente" name="nombre_cliente" value="<?php echo $cotizacion->nombre_cliente ?>" class="form-control">
                          <span class="input-group-btn">
                            <button onclick='nuevoCliente();' title='Agregar Nuevo Cliente' class='btn btn-primary' id='btn_add_client'>+</button>
                          </span>
                        </div>
                        <input type="hidden" id="fk_tercero" name="fk_tercero" value="<?php echo $cotizacion->fk_tercero ?>" class="form-control">
                      </div>

                      <div class="col-md-3">
                        TAGS
                      </div>
                      <div class="col-md-3">
                        <select class="form-control select2" name="tags" multiple='multiple' id="tags">

                        </select>
                      </div>


                    </div>


                    <div class="row">
                      <div class="col-md-3">
                        Destino
                      </div>
                      <div class="col-md-3">

                        <input placeholder='Destino' type='text' class='form-control' id='destino' name='destino' value='<?= $cotizacion->destino ?>'>

                      </div>


                      <div class="col-md-3">
                        Servicios Turísticos
                      </div>
                      <div class="col-md-3">
                        <select class="form-control select2" name="servicios" multiple='multiple' id="servicios">
                          <?= $opciones_servicios ?>

                        </select>
                      </div>



                    </div>


                    <div class="row">
                      <div class="col-md-3">
                        Pasajeros Adultos :
                      </div>
                      <div class="col-md-3">

                        <input placeholder='Cantidad adultos' type="text" id="cantidad_adultos" name="cantidad_adultos" value="<?php echo $cotizacion->cantidad_adultos ?>" class="form-control">


                      </div>





                      <div class="col-md-3">
                        Pasajeros Menores Edad :
                      </div>
                      <div class="col-md-3">

                        <input placeholder='Cantidad menores edad' type="text" id="cantidad_menores" name="cantidad_menores" value="<?php echo $cotizacion->cantidad_menores ?>" class="form-control">


                      </div>
                    </div>






                    <div class="row">
                      <div class="col-md-3">
                        Fecha/Hora Entrada :
                      </div>
                      <div class="col-md-3">

                        <input type="datetime-local" id="fecha_entrada" name="fecha_entrada" value="<?php echo $cotizacion->fecha_entrada ?>" class="form-control">


                      </div>





                      <div class="col-md-3">
                        Fecha/Hora Salida :
                      </div>
                      <div class="col-md-3">

                        <input type="datetime-local" id="fecha_salida" name="fecha_salida" value="<?php echo $cotizacion->fecha_salida ?>" class="form-control">


                      </div>
                    </div>






                    <div class="row">
                      <div class="col-md-3">
                        Monto oferta :
                      </div>
                      <div class="col-md-3">
                        <div class="row">

                          <div class='col-md-4'>
                            <select onchange='calcularPrecio();' class='form-control' style='width:max-content;' id='moneda' name='moneda'>
                              <option <?= $selected_moneda_colones ?> value='0'>₡</option>
                              <option <?= $selected_moneda_dolares ?> value='1'>$</option>
                            </select>
                          </div>

                          <div class='col-md-8'>
                            <input onkeyup='calcularPrecio();' placeholder='Monto oferta' type="number" id="monto_oferta" name="monto_oferta" value="<?php echo $cotizacion->monto_oferta ?>" class="form-control">
                          </div>


                        </div>

                      </div>





                      <div class="col-md-3">
                        Mostrar monto total en PDF? :
                      </div>
                      <div class="col-md-3">

                        <select class='form-control' id='monto_visible_pdf' name='monto_visible_pdf'>

                          <option <?= $selected_visible ?> value='1'>SI</option>
                          <option <?= $selected_no_visible ?> value='0'>NO</option>
                        </select>

                      </div>
                    </div>

                    <div class="row">
                      <div class="col-md-3">
                      </div>
                      <div class="col-md-3">
                      </div>
                      <div class="col-md-3">
                        Es un vuelo internacional? :
                      </div>
                      <div class="col-md-3">

                        <select class='form-control' id='vuelo_internacional' name='vuelo_internacional'>
                          <option <?= $selected_si_internacional ?> value='1'>SI</option>
                          <option <?= $selected_no_internacional ?> value='0'>NO</option>
                        </select>

                      </div>



                    </div>

                    <div class="row">
                      <div class="col-md-3">
                        Descuento :
                      </div>
                      <div class="col-md-3">
                        <input onkeyup="calcularPrecio();" type='number' placeholder='Porcentaje descuento' class='form-control' id='descuento_porcentaje' name='descuento_porcentaje' value='<?= $cotizacion->descuento_porcentaje ?>'>
                      </div>

                      <div class="col-md-3">
                        <label for="">Monto final:</label>
                        <input type='hidden' id='monto_final' name='monto_final' value='<?= $cotizacion->monto_final ?>'>
                        <label for=""><strong id='monto_final_txt'>0.00</strong></label>
                      </div>



                    </div>



                    <div class="row">
                      <div class="col-md-3">
                        Descripcion :
                      </div>
                      <div class="col-md-3">
                        <textarea id="descripcion" name="descripcion" class="form-control" placeholder="Comentarios"><?php echo $cotizacion->descripcion ?></textarea>

                      </div>

                      <div class="col-md-3">
                        Imagen (opcional) :
                      </div>

                      <div class="col-md-3">
                        <form id="uploadForm" enctype="multipart/form-data">
                          <input id="imagen" type="file" name="imagen" />
                          <br>
                          <img id='preview_img' src='<?= $cotizacion->img_path ?>' class="img-responsive img-rounded">
                          <input value='<?= $cotizacion->img_path ?>' id="img_path" type="hidden" name="img_path" />

                        </form>

                      </div>



                    </div>


                    <div class="row">
                      <div class="col-md-3">
                        Acomodacion :
                      </div>
                      <div class="col-md-3">
                        <input placeholder='Acomodacion' class='form-control' id='acomodacion' name='acomodacion' value='<?php echo $cotizacion->acomodacion ?>'>
                      </div>

                      <div class="col-md-3">
                        Regimen :
                      </div>

                      <div class="col-md-3">
                        <input placeholder='Regimen' class='form-control' id='regimen' name='regimen' value='<?php echo $cotizacion->regimen ?>'>

                      </div>



                    </div>

                    <div class="row">
                      <div class="col-md-3">
                        Informacion de lo que incluye :
                      </div>
                      <div class="col-md-3">
                        <textarea id="si_incluye" name="si_incluye" class="form-control" placeholder="Comentarios"><?php echo $cotizacion->si_incluye ?></textarea>

                      </div>

                      <div class="col-md-3">
                        Informacion de lo que no incluye :
                      </div>

                      <div class="col-md-3">
                        <textarea id="no_incluye" name="no_incluye" class="form-control" placeholder="Comentarios"><?php echo $cotizacion->no_incluye ?></textarea>


                      </div>



                    </div>

                    <div class="row">
                      <div class="col-md-3">
                        Estatus :
                      </div>
                      <div class="col-md-3">

                        <select class='form-control' id='fk_diccionario_cotizaciones_estado' name='fk_diccionario_cotizaciones_estado'>
                          <?= $opciones_estatus ?>
                        </select>


                      </div>




                    </div>













                    <div class="row" style="margin-top:50px;">
                      <div class="col-md-3">
                        <i class="fa fa-user"></i> User :
                      </div>
                      <div class="col-md-3">
                        <label for=""><?= $cotizacion->usuario_creador ?></label>

                      </div>

                      <div class="col-md-3"></div>
                      <div class="col-md-3"></div>
                    </div>


                    <div class="row">
                      <div class="col-md-3">
                        Creado :
                      </div>
                      <div class="col-md-3">
                        <label for=""><?= $cotizacion->creado_fecha ?></label>

                      </div>
                      <div class="col-md-3"></div>
                      <div class="col-md-3"></div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-md-12 col-xl-12">
                <a class="btn btn-warning" style="cursor:pointer;" href="<?= ENLACE_WEB ?>dashboard.php?accion=cotizaciones_listado&tipo=proveedores">
                  Volver al Listado
                </a>
                <input type='Submit' class="btn btn-success" style="cursor:pointer;" value='Guardar'>

              </div>
            </div>
</form>

<style>
  .row {
    margin-bottom: 10px;
    /* Puedes ajustar este valor según tus necesidades */
  }
</style>



<script>
  $(document).ready(function() {

    calcularPrecio();

    $('#miFormulario').submit(function(event) {

      error = false;

      // Evitar el envío del formulario por defecto
      event.preventDefault();

      // Realizar validaciones aquí
      $("#nombre_cliente").removeClass("input_error");
      if ($("#nombre_cliente").val() == '') {
        $("#nombre_cliente").addClass("input_error");
        error = true;
      }

      $("#destino").removeClass("input_error");
      if ($("#destino").val() == '') {
        $("#destino").addClass("input_error");
        error = true;
      }


      $("#cantidad_adultos").removeClass("input_error");
      if ($("#cantidad_adultos").val() == '') {
        $("#cantidad_adultos").addClass("input_error");
        error = true;
      }

      $("#cantidad_menores").removeClass("input_error");
      if ($("#cantidad_menores").val() == '') {
        $("#cantidad_menores").addClass("input_error");
        error = true;
      }


      $("#fecha_entrada").removeClass("input_error");
      if ($("#fecha_entrada").val() == '') {
        $("#fecha_entrada").addClass("input_error");
        error = true;
      }

      $("#fecha_salida").removeClass("input_error");
      if ($("#fecha_salida").val() == '') {
        $("#fecha_salida").addClass("input_error");
        error = true;
      }


      $("#monto_oferta").removeClass("input_error");
      if ($("#monto_oferta").val() == '') {
        $("#monto_oferta").addClass("input_error");
        error = true;
      }


      $("#descripcion").removeClass("input_error");
      if ($("#descripcion").val() == '') {
        $("#descripcion").addClass("input_error");
        error = true;
      }


      //fin validaciones




      if (error) {
        $.toast({
          heading: 'Error',
          text: "Faltan Datos para Actualizar",
          icon: 'error',
          position: 'top-right',
        });
        return false;
      }



      // Si las validaciones pasan, puedes enviar el formulario
      // Puedes agregar aquí tu lógica para enviar el formulario mediante AJAX o submit().

      $.ajax({
        url: '<?php echo ENLACE_WEB; ?>mod_medida_cctravel_cotizaciones/class/clases.php',
        type: 'POST',
        data: $('#miFormulario').serialize() + "&etiquetas=" + encodeURIComponent($("#tags").val()) + "&servicios_turisticos=" + encodeURIComponent($("#servicios").val()),
        success: function(response) {
          // Manejar la respuesta del servidor
          console.log(response);
          var objetoJSON = JSON.parse(response);


          if (objetoJSON.error == 1) {
            $.toast({
              heading: 'Error',
              text: objetoJSON.error_txt,
              icon: 'error',
              position: 'top-right',
            });

          } else {
            window.location.href = '<?php echo ENLACE_WEB;  ?>turistico_ver_cotizacion/' + objetoJSON.id; // Reemplaza con la URL que desees

          }

        },
        error: function(error) {
          // Manejar errores
          alert(error);
        }
      });

    });
  });




  function traerRegiones(int) {


    // traerRegiones
    $.ajax({
      method: "POST",
      url: "<?= ENLACE_WEB ?>mod_medida_cctravel_sitios_turisticos/class/clases.php",
      beforeSend: function(xhr) {},
      data: {
        action: 'traerRegiones',
        ubicacionpaisid: int,

      },
    }).done(function(data) {
      //let respuesta = JSON.parse(data);
      console.log(data);

    });

  }




  $(document).ready(function() {

    //conf tags
    var listaDeOpciones = <?= json_encode($arrayRecuperado) ?>;
    var selectedOptions = <?= json_encode($arrayRecuperado) ?>;

    // Initialize Select2 with options
    $('#tags').select2({
      data: listaDeOpciones,
      multiple: true,
      tags: true,
      tokenSeparators: [',', ' ']
    });
    // Set selected options
    $('#tags').val(selectedOptions);
    $('#tags').trigger('change');


    //conf servicios
    var listaDeOpciones = <?= json_encode($arrayRecuperado2) ?>;
    var selectedOptions = <?= json_encode($arrayRecuperado2) ?>;

    // Initialize Select2 with options
    $('#servicios').select2({
      data: listaDeOpciones,
      multiple: true,
      tokenSeparators: [',', ' ']
    });
    // Set selected options
    $('#servicios').val(selectedOptions);
    $('#servicios').trigger('change');



  });


  $(document).ready(function() {
    $('#imagen').on('change', function() {
      var file_data = $('#imagen').prop('files')[0];
      var form_data = new FormData();
      form_data.append('file', file_data);
      $.ajax({
        url: '<?= ENLACE_WEB ?>mod_medida_cctravel_sitios_turisticos/ajax/upload_imagen.php',
        dataType: 'text',
        cache: false,
        contentType: false,
        processData: false,
        data: form_data,
        type: 'post',
        success: function(response) {

          data = JSON.parse(response);

          if (data.error == 1) {
            $.toast({
              heading: 'Error',
              text: "Ocurrio un error al subir la imagen",
              icon: 'warning',
              position: 'top-right',
              bgColor: '#f00'
            });
          } else {
            $("#preview_img").attr('src', data.message);
            $("#img_path").val(data.message);
          }


        }
      });
    });
  });


  $(document).ready(function() {
    $("#nombre_cliente").autocomplete({
      source: "<?= ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/ajax/autocompletado_tercero.ajax.php",
      minLength: 2,
      select: function(event, ui) {
        event.preventDefault();
        //    alert('Seleccionado: ' + ui.item.value); // Add this line
        $.toast({
          heading: 'Agregado',
          text: "Agregado cliente a cotización: " + ui.item.value,
          icon: 'success',
          position: 'top-right',
        });
        $("#nombre_cliente").val(ui.item.value);
        $("#fk_tercero").val(ui.item.id);
      }
    });
  });


  function calcularPrecio() {

    precio = $("#monto_oferta").val();
    descuento_porcentaje = $("#descuento_porcentaje").val();
    descuento = precio * (descuento_porcentaje / 100);
    precio_final = precio - descuento;

    $("#monto_final_txt").text(precio_final + ' ' + $("#moneda option:selected").text());
    $("#monto_final").val(precio_final);
  }



  function nuevoCliente() {


    event.preventDefault();

    $("#modal_cliente").addClass('borroso');

    $.ajax({
      type: "POST",
      url: "<?php echo ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/ajax/cotizacion_ajax_nuevo_cliente.php",
      data: {

      },
      success: function(html) {

        $("#modal_cliente").empty().html(html).removeClass('borroso');
        $("#modal_cliente").modal('show');

      }
    });


  }
</script>


<!-- Modal clientes -->
<div class="modal fade" id="modal_cliente" tabindex="-1" role="dialog" aria-labelledby="modalLabelLarge" aria-hidden="true">

</div>


<!-- The modal -->
<div class="modal fade" id="modal_completo" tabindex="-1" role="dialog" aria-labelledby="modalLabelLarge" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>

        <h3 class="modal-title" id="modal_titulo"></h3>
      </div>
      <div class="modal-body" id="modal_body"></div>

      <div class="modal-footer" id="modal_footer">
        <button type="button" class="btn btn-dark" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>