<?php
// 12-01-2024 Julio Alvarado
//Esto es una vista para editar/crear cotizaciones

//incluir objeto
require_once(ENLACE_SERVIDOR . "mod_medida_cctravel_cotizaciones/object/cotizacion.object.php");
$cotizacion = new CotizacionesV20($dbh);
$editar = false;
$cotizacion->fetch($_GET['id']);
$diccionario_estatus = $cotizacion->obtenerEstadosCotizacion();
$diccionario_servicios = $cotizacion->obtenerServiciosTuristicos();



$arrayRecuperado = explode(",", $cotizacion->tags);
$arrayRecuperado2 = explode(",", $cotizacion->servicios_turisticos);

if ($cotizacion->monto_visible_pdf == 1) {
  $selected_visible = 'selected';
  $selected_no_visible = '';
} else {
  $selected_visible = '';
  $selected_no_visible = 'selected';
}
if ($cotizacion->moneda == 1) {
$cotizacion->moneda = '$';
} else {
$cotizacion->moneda = '₡';
}

foreach ($diccionario_estatus as $item) {
  if ($item->rowid == $cotizacion->fk_diccionario_cotizaciones_estado) {
    $opciones_estatus .= '
                        <option selected value="' . $item->rowid . '">' . $item->etiqueta . '</td>';
  } else {
    $opciones_estatus .= '
                        <option value="' . $item->rowid . '">' . $item->etiqueta . '</td>';
  }
}

foreach ($diccionario_servicios as $item) {
  $opciones_servicios .= '
                        <option value="' . $item->rowid . '">' . $item->nombre . '</td>';
}


$titulo = "Ver Cotizaci&oacute;n " . $cotizacion->number;
?>


<form name="miFormulario" id="miFormulario">

  <div class="pcoded-inner-content">
    <div class="page-bar">
      <div class="page-title-breadcrumb">
        <div class=" pull-left">

          <div class="page-title">
            <h2><?php echo "Detalle " . $titulo;  ?></h2>
          </div>



        </div>
        <ol class="breadcrumb page-breadcrumb pull-right">
          <li><i class="fa fa-home"></i>&nbsp;<a class="parent-item" href="<?php echo ENLACE_WEB; ?>"><?php echo $Lan->lang('global.inicio'); ?></a>&nbsp;<i class="fa fa-angle-right"></i>
          </li>
          <li><a class="parent-item" href="<?php echo ENLACE_WEB; ?>cotizaciones_listado "> Cotizaciones </a>&nbsp;<i class="fa fa-angle-right"></i>
          </li>
          <li class="active"><?php echo $titulo; ?></li>
        </ol>
      </div>
    </div>


    <div class="row">
      <div class="col-md-12 col-xl-12">
        <div class="card sale-card">
          <div class="card-header">

            <div id="details" class="panel panel-default">

              <div class="panel-body">
                <div class="row">
                  <div class="col-md-10">
                   

                  

                  


                <input type="hidden" name="editar" value="1">
                    <input type="hidden" name="id" value="<?php echo $cotizacion->rowid; ?>">
                    <input type="hidden" name="action" value="<?php echo (($cotizacion->rowid > 0) ? 'modificarCotizacion' : 'crearCotizacion'); ?>">

                    <div class="row">
                      <div class="col-md-3">
                        ID Cotización :
                      </div>
                      <div class="col-md-3">

                        <label for=""><?php echo $cotizacion->rowid; ?></label>
                      </div>
                    </div>


                  <div class="row">
    <div class="col-md-3">
        Nombre Cliente :
    </div>
    <div class="col-md-3">
        <div class="input-group">
            <label id="nombre_cliente" name="nombre_cliente"><?php echo $cotizacion->nombre_cliente ?></label>
        
        </div>
        <label id="fk_tercero" name="fk_tercero" style="display:none;"><?php echo $cotizacion->fk_tercero ?></label>
    </div>

    <div class="col-md-3">
        TAGS
    </div>
    <div class="col-md-3">
        <select class="form-control select2" name="tags" multiple='multiple' id="tags">

        </select>
    </div>
</div>


                    <div class="row">
    <div class="col-md-3">
        Destino
    </div>
    <div class="col-md-3">
        <label id='destino' name='destino'><?= $cotizacion->destino ?></label>
    </div>

    <div class="col-md-3">
        Servicios Turísticos
    </div>
    <div class="col-md-3">
        <select class="form-control select2" name="servicios" multiple='multiple' id="servicios">
            <?= $opciones_servicios ?>
        </select>
    </div>
</div>


               <div class="row">
    <div class="col-md-3">
        Pasajeros Adultos :
    </div>
    <div class="col-md-3">
        <label id="cantidad_adultos" name="cantidad_adultos"><?php echo $cotizacion->cantidad_adultos ?></label>
    </div>

    <div class="col-md-3">
        Pasajeros Menores Edad :
    </div>
    <div class="col-md-3">
        <label id="cantidad_menores" name="cantidad_menores"><?php echo $cotizacion->cantidad_menores ?></label>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Fecha/Hora Entrada :
    </div>
    <div class="col-md-3">
     <label id="fecha_entrada" name="fecha_entrada"><?php echo date("d/m/y g:i A", strtotime($cotizacion->fecha_entrada)); ?></label>
    </div>

    <div class="col-md-3">
        Fecha/Hora Salida :
    </div>
    <div class="col-md-3">
     <label id="fecha_salida" name="fecha_salida"><?php echo date("d/m/y g:i A", strtotime($cotizacion->fecha_salida)); ?></label>
    </div>
</div>





                 <div class="row">
    <div class="col-md-3">
        Monto oferta :
    </div>
    <div class="col-md-3">
        <div class="row">
          
            <div class='col-md-8'>
                <label id="monto_oferta" name="monto_oferta"><?=$cotizacion->moneda.' '.$cotizacion->monto_oferta ?></label>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        Mostrar monto total en PDF? :
    </div>
    <div class="col-md-3">
        <select disabled class='form-control' id='monto_visible_pdf' name='monto_visible_pdf'>
            <option  <?= $selected_visible ?> value='1'>SI</option>
            <option  <?= $selected_no_visible ?> value='0'>NO</option>
        </select>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
    </div>
    <div class="col-md-3">
    </div>
    <div class="col-md-3">
        Es un vuelo internacional? :
    </div>
    <div class="col-md-3">
        <select disabled class='form-control' id='vuelo_internacional' name='vuelo_internacional'>
            <option <?= $selected_si_internacional ?> value='1'>SI</option>
            <option <?= $selected_no_internacional ?> value='0'>NO</option>
        </select>
    </div>
</div>

                    <div class="row">
    <div class="col-md-3">
        Descuento (porcentaje) :
    </div>
    <div class="col-md-3">
        <label id="descuento_porcentaje" name="descuento_porcentaje"><?= $cotizacion->descuento_porcentaje ?>%</label>
    </div>

    <div class="col-md-3">
        <label for="">Monto final:</label>
        <label id="monto_final" name="monto_final"><?= $cotizacion->monto_final ?></label>
       
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Descripcion :
    </div>
    <div class="col-md-3">
        <label id="descripcion" name="descripcion"><?php echo $cotizacion->descripcion ?></label>
    </div>

    <div class="col-md-3">
        Imagen (opcional) :
    </div>

    <div class="col-md-3">
        <form id="uploadForm" enctype="multipart/form-data">
       
            <br>
            <img id='preview_img' src='<?= $cotizacion->img_path ?>' class="img-responsive img-rounded">
            <input value='<?= $cotizacion->img_path ?>' id="img_path" type="hidden" name="img_path" />
        </form>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Acomodacion :
    </div>
    <div class="col-md-3">
        <label id="acomodacion" name="acomodacion"><?php echo $cotizacion->acomodacion ?></label>
    </div>

    <div class="col-md-3">
        Regimen :
    </div>

    <div class="col-md-3">
        <label id="regimen" name="regimen"><?php echo $cotizacion->regimen ?></label>
    </div>
</div>

                <div class="row">
    <div class="col-md-3">
        Informacion de lo que incluye :
    </div>
    <div class="col-md-3">
        <label id="si_incluye" name="si_incluye"><?php echo $cotizacion->si_incluye ?></label>
    </div>

    <div class="col-md-3">
        Informacion de lo que no incluye :
    </div>

    <div class="col-md-3">
        <label id="no_incluye" name="no_incluye"><?php echo $cotizacion->no_incluye ?></label>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Estatus :
    </div>
    <div class="col-md-3">
        <select disabled class='form-control' id='fk_diccionario_cotizaciones_estado' name='fk_diccionario_cotizaciones_estado'>
            <?= $opciones_estatus ?>
        </select>
        
    </div>
</div>










                    <div class="row" style="margin-top:50px;">
                      <div class="col-md-3">
                        <i class="fa fa-user"></i> User :
                      </div>
                      <div class="col-md-3">
                        <label for=""><?= $cotizacion->usuario_creador ?></label>

                      </div>

                      <div class="col-md-3"></div>
                      <div class="col-md-3"></div>
                    </div>


                    <div class="row">
                      <div class="col-md-3">
                        Creado :
                      </div>
                      <div class="col-md-3">
                   
 <label id="creado_fecha" name="creado_fecha"><?php echo date("d/m/y g:i A", strtotime($cotizacion->creado_fecha)); ?></label>
                      </div>
                      <div class="col-md-3"></div>
                      <div class="col-md-3"></div>
                    </div>

                  



                   

               



                    <ul class="nav nav-tabs">
                      <li class="active"><a data-toggle="tab" href="#home">Servicios</a></li>
                      <li><a data-toggle="tab" href="#menu1"><i class="fas fa-plane"></i> Boletos A&eacute;reos </a></li>
                      <li><a data-toggle="tab" href="#menu2"><i class="fas fa-edit"></i> Consideraciones </a></li>

                    </ul>

                    <div class="tab-content">

                      <div id="menu2" class="tab-pane fade">
                       
                        <h3>Consideraciones o anotaciones documento PDF </h3> <button type="button" class="btn btn-primary pull-right" onclick="actualizarConsideraciones(<?php echo $cotizacion->rowid ?>)">Guardar</button>
                        <textarea class="textarea" id="consideraciones" placeholder="Place some text here" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">
                            <?php echo $cotizacion->consideraciones != null? $cotizacion->consideraciones: "<h4> Rogamos tomar en consideraci&oacute;n los siguientes puntos importantes</h4>
            <div>
               <ol>
          <li>La puntualidad es primordial (por itinerario y respeto a los dem&aacute;s participantes no 
                podemos</li>
                   <li>El ingreso de cualquier tipo de bebidas y/o hieleras no est&aactue; permitido</li>
                       <li>**RECOMENDAMOS LLEVAR: BA&Ntilde;ADOR, ROPA ADICIONAL, TOALLA, BLOQUEADOR, 
                            SOMBRERO & C&Aacute;MARA FOTOGR&Aacute;FICA. **</li>
           </ol>
            </div>
            <h4> POLITICAS DE CANCELACI&Oacute;N</h4>
           <div>
            <ul>
                    <li>Individuales 48 horas antes: 100% devoluci&oacute;n & menos de 24 horas: NO HAY DEVOLUCI&Oacute;N</li>
                   <li>*NO SHOW (NO SE PRESENTA EN LA FECHA, LUGAR & HORA ACORDADOS): NO HAY 
                    DEVOLUCI&Oacute;N **En caso de tener que cancelar el tour por mal tiempo o cualquier causa fuera 
                    de nuestro control, se reprogramar&aacute; <br> NO se proceder&aacute; con devoluciones de dinero**</li>
                       
            </ul>"; ?>
                        </textarea>
                       
                      </div>


                      <div id="menu1" class="tab-pane fade">


                        <h3><i class="fas fa-plane"></i> Boletos A&eacute;reos </h3>


                        <img style='max-width: 100%;' id='img_vuelos' src='<?= $cotizacion->img_boleto ?>' class='img-responsive'>

                        <!-- esta tabla ya no se usara para este proyecto-->
                        <table style='display:none;' id="listing-table" class="table table-striped">
                          <thead>
                            <tr>
                              <th></th> <!-- Para el número consecutivo -->
                              <th>Cotizaci&oacute;n</th>
                              <th>aerolinea</th>
                              <th>vuelo</th>
                              <th>origen</th>
                              <th>destino</th>
                              <th>fecha_saliendo</th>
                              <th>fecha_llegando</th>
                              <th>vuelo_duracion_en_horas</th>
                              <th>vuelo_escalas</th>
                              <!-- Otros títulos según tus necesidades -->
                              <th></th> <!-- Para las opciones del usuario -->
                            </tr>
                          </thead>
                          <tbody id="boletos_aereos_tabla">
                            <!-- Aquí se mostrarán los registros de la tabla -->
                          </tbody>
                        </table>






                        <!-- este botono ya no se usara
                              <button style='float: inline-end;' type="button" class="btn btn-danger"  OnClick="nuevoBoletoAereo('nuevo')">
                                 Registrar Boleto A&eacute;reo
                              </button> -->

                        <button style='float: inline-end;' type="button" class="btn btn-danger" OnClick="nuevoBoletoAereoImagen(<?= $cotizacion->rowid ?>)">
                          Subir foto Boleto A&eacute;reo
                        </button>




                      </div>

                      <div id="home" class="tab-pane fade in active">
                        <h3>Paquetes Cotizados</h3>
                        <table id="listing-table" class="table table-striped" style="">
                          <thead>
                            <tr>
                              <th></th>
                              <th>Centro</th>
                              <th>Codigo</th>
                              <th>Servicio</th>
                              <th>Comentario</th>
                              <th>Activo</th>
                              <th>Precio</th>
                              <th>Moneda</th>
                              <th>Descuento</th>
                              <th>Precio Final</th>
                              <!-- Puedes agregar más columnas según sea necesario -->
                              <th>Opciones</th>
                            </tr>

                          </thead>
                          <tbody id="servicios_tabla">

                          </tbody>
                        </table>

 <!--
                        <button style='float: inline-end;' type="button" class="btn btn-danger" OnClick="nuevoServicio('nuevo')">
                          Nuevo servicio
                        </button>
-->


                      </div>







                      <div class="row">
                        <div class="col-md-3">
                        </div>
                        <br>
                      </div>

                      <div class="col-md-2"></div>

                    </div>
                  </div>









                </div>

                <div class="row">
                  <div class="col-md-12 col-xl-12">
                    <a class="btn btn-warning" style="cursor:pointer;" href="<?= ENLACE_WEB ?>dashboard.php?accion=cotizaciones_listado&tipo=proveedores">
                      Volver al Listado
                    </a>

                  
                    <button type="button" class="btn btn-info" onclick='ventanaPdf();'><i class='fa fa-file-pdf'></i> Generar PDF</button>
                    
                     <button type="button" class="btn btn-danger" onclick='abrir_email();'><i class='fa fa-envelope-o'></i> Enviar por email</button>
                    
                     
                    <button onclick='enviar_whatsapp_ventana(<?=$cotizacion->rowid?>)' type='button' class='btn btn-success'><i class='fa fa-phone'></i> Enviar por WhatsApp</button>

                    <a class="btn btn-danger" style="cursor:pointer;" href="<?= ENLACE_WEB ?>turistico_modificar_cotizacion/<?= $cotizacion->rowid ?>">
                      Modificar
                    </a>





                  </div>
                </div>


                <style>
                  .row {
                    margin-bottom: 10px;
                    /* Puedes ajustar este valor según tus necesidades */
                  }
                </style>



                <script>
                  boton_Cerrar = ' <button type="button" class="btn btn-dark" data-dismiss="modal">Cerrar</button>';

                  $.toast({
                    heading: 'Cotizacion <?php echo $cotizacion->number; ?>',
                    text: "Accediendo a detalles",
                    icon: 'success',
                    position: 'top-right',
                    bgColor: '#f00'
                  });
                </script>

                <!--- ---------------------------------------------------------------------------------------->
                <!--- ---------------------------------------------------------------------------------------->
                <!--- ---------------------------------------------------------------------------------------->
                <!--   Consideraciones                                                               --------->
                <!--- ---------------------------------------------------------------------------------------->
                <!--- ---------------------------------------------------------------------------------------->
                <!--- ---------------------------------------------------------------------------------------->

                <link href="https://facturacionpymes.tk/sistema/bootstrap/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css" rel="stylesheet" type="text/css" />
                <script src="https://facturacionpymes.tk/sistema/bootstrap/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js" type="text/javascript"></script>
                <script type="text/javascript">
                  $(function() {
                    $("#consideraciones").wysihtml5({

                      "font-styles": true, // Negrita, cursiva, subrayado, etc.
                      "emphasis": true, // Citas, cursiva, resaltado, etc.
                      "lists": true, // Listas ordenadas y no ordenadas
                      "html": false, // Ver HTML
                      "link": false, // Enlace
                      "image": false, // Imagen
                      "color": true, // Selector de color
                      "blockquote": true // Bloque de cita

                    });

                  });
                </script>














                <!--- ---------------------------------------------------------------------------------------->
                <!--- ---------------------------------------------------------------------------------------->
                <!--- ---------------------------------------------------------------------------------------->
                <!--   BOLETOS AEREOS                                                                --------->
                <!--- ---------------------------------------------------------------------------------------->
                <!--- ---------------------------------------------------------------------------------------->
                <!--- ---------------------------------------------------------------------------------------->

                <script>
                
                
                function abrir_email()
{


    largeur = 600;
    hauteur = 550;
    opt = 'width='+largeur+', height='+hauteur+', left='+(screen.width - largeur)/2+', top='+(screen.height-hauteur)/2+'';
    window.open ('<?php echo ENLACE_WEB ?>include/mail/enviar_email_cctravel.php?id=<?php echo $_REQUEST['id'] ?>&opcion=cotizacion', 'Enviar Email Cotizacion', opt);



}
                
                
                  function nuevoBoletoAereo_backEnd(rowid_boleto) {



                    var error = false;

                    // Recoge los valores de los campos
                    var aerolinea = $('#aerolinea').val();
                    var vuelo = $('#vuelo').val();
                    var origen = $('#origen').val();
                    var destino = $('#destino').val();
                    var fechaSaliendo = $('#fecha_saliendo').val();
                    var fechaLlegando = $('#fechaLlegando').val();
                    var vueloDuracion = $('#vueloDuracion').val();
                    var vueloEscalas = $('#vueloEscalas').val();

                    // Elimina clases de error
                    $("#aerolinea").removeClass("input_error");
                    $("#vuelo").removeClass("input_error");
                    $("#origen").removeClass("input_error");
                    $("#destino").removeClass("input_error");
                    $("#fecha_saliendo").removeClass("input_error");
                    $("#fechaLlegando").removeClass("input_error");
                    $("#vueloDuracion").removeClass("input_error");
                    $("#vueloEscalas").removeClass("input_error");

                    // Realiza las validaciones
                    if (aerolinea === '') {
                      $("#aerolinea").addClass("input_error");
                      error = true;
                    }
                    if (vuelo === '') {
                      $("#vuelo").addClass("input_error");
                      error = true;
                    }
                    if (origen === '') {
                      $("#origen").addClass("input_error");
                      error = true;
                    }
                    if (destino === '') {
                      $("#destino").addClass("input_error");
                      error = true;
                    }
                    if (fechaSaliendo === '') {
                      $("#fecha_saliendo").addClass("input_error");
                      error = true;
                    }
                    if (fechaLlegando === '') {
                      $("#fechaLlegando").addClass("input_error");
                      error = true;
                    }
                    if (vueloDuracion === '') {
                      $("#vueloDuracion").addClass("input_error");
                      error = true;
                    }
                    if (vueloEscalas === '') {
                      $("#vueloEscalas").addClass("input_error");
                      error = true;
                    }



                    if (error) {
                      $.toast({
                        heading: 'Faltan Datos',
                        text: "Por favor ingrese los datos faltantes para continuar",
                        icon: 'warning',
                        position: 'top-right',
                        bgColor: '#f00'
                      });


                      return false;
                    }


                    $.ajax({
                      method: "POST",
                      url: "<?= ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/class/clases.php",
                      beforeSend: function(xhr) {
                        $.toast({
                          heading: 'Cotizacion <?php echo $cotizacion->number; ?>',
                          text: "Creando Nuevo Boleto  ",
                          icon: 'warning',
                          position: 'top-right',
                          bgColor: '#f00'
                        });

                        $("#boletos_aereos_tabla").addClass('borroso');
                      },
                      data: {
                        action: "save_boleto",
                        id: <?= $cotizacion->rowid ?>,
                        rowid_boleto: rowid_boleto,
                        aerolinea: aerolinea,
                        vuelo: vuelo,
                        origen: origen,
                        destino: destino,
                        fechaSaliendo: fechaSaliendo,
                        fechaLlegando: fechaLlegando,
                        vueloDuracion: vueloDuracion,
                        vueloEscalas: vueloEscalas

                      }

                    }).done(function(resultado) {
                      console.log(resultado);

                      var jsonObject = JSON.parse(resultado);

                      if (jsonObject.error_agregado == 1) {
                        $.toast({
                          heading: 'Cotizacion <?php echo $cotizacion->number; ?>',
                          text: "Detalle " + jsonObject.error_agregado_txt,
                          icon: 'error',
                          position: 'top-right',
                          bgColor: '#f00'
                        });

                      } else {

                        $.toast({
                          heading: 'Cotizacion <?php echo $cotizacion->number; ?>',
                          text: "Detalle Boleto Agregado ",
                          icon: 'success',
                          position: 'top-right',
                          bgColor: '#f00'
                        });


                        $("#boletos_aereos_tabla").html(jsonObject.datos);
                        $("#boletos_aereos_tabla").removeClass('borroso');


                      }


                    });



                  }




                  function nuevoBoletoAereoImagen(id) {

                    titulo = (id == 'nuevo') ? 'Registrar Nuevo Boleto Aereo' : 'Editando Boleto';
                    accion = (id == 'nuevo') ? 'crear_boleto' : 'editar_boleto';
                    titulo_boton = (id == 'nuevo') ? 'Guardar foto' : 'Editar Boleto';
                    id_backend = (id == 'nuevo') ? '' : id;


                    $("#modal_titulo").empty().html(titulo);
                    $("#modal_body").addClass('borroso');

                    $.ajax({
                      type: "POST",
                      url: "<?php echo ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/ajax/cotizacion_ajax_detalle_boletos_imagen.php",
                      data: {
                        "cotizacion": '<?php echo $cotizacion->rowid; ?>',
                        "rowid": id,
                        "accion": accion,
                      },
                      success: function(html) {
                        $("#modal_body").empty().html(html).removeClass('borroso');;
                        $("#modal_completo").modal('show');

                        boton_editar = ' <button type="button" class="btn btn-danger" Onclick="guardarFotoBoleto(' + id_backend + ')" ><i class="fa fa-floppy-o" aria-hidden="true"></i> ' + titulo_boton + '</button>';

                        $("#modal_footer").empty().html(boton_Cerrar);


                      }
                    });


                  }

                  function nuevoBoletoAereo(id) {

                    titulo = (id == 'nuevo') ? 'Registrar Nuevo Boleto Aereo' : 'Editando Boleto';
                    accion = (id == 'nuevo') ? 'crear_boleto' : 'editar_boleto';
                    titulo_boton = (id == 'nuevo') ? 'Guardar Nuevo' : 'Editar Boleto';
                    id_backend = (id == 'nuevo') ? '' : id;


                    $("#modal_titulo").empty().html(titulo);
                    $("#modal_body").addClass('borroso');

                    $.ajax({
                      type: "POST",
                      url: "<?php echo ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/ajax/cotizacion_ajax_detalle_boletos.php",
                      data: {
                        "cotizacion": '<?php echo $cotizacion->rowid; ?>',
                        "id": id,
                        "accion": accion,
                      },
                      success: function(html) {
                        $("#modal_body").empty().html(html).removeClass('borroso');;
                        $("#modal_completo").modal('show');

                        boton_editar = ' <button type="button" class="btn btn-light" Onclick="nuevoBoletoAereo_backEnd(' + id_backend + ')" >' + titulo_boton + '</button>';

                        $("#modal_footer").empty().html(boton_editar + boton_Cerrar);


                      }
                    });


                  }

                  function borrar_boleto(id) {
                    $("#modal_completo").modal('show');
                    $("#modal_body").empty().html('Seguro de Eliminar El Boleto Aereo').removeClass('borroso');;
                    boton_eliminar = '<button type="button" class="btn btn-dark" data-dismiss="modal" OnClick="eliminarBoleto_backEnd(' + id + ')"><i class="fas fa-trash-alt"></i>  Confirmar Eliminar</button>';
                    $("#modal_footer").empty().html(boton_Cerrar + boton_eliminar);



                  }


                  function eliminarBoleto_backEnd(id) {

                    $.ajax({
                      method: "POST",
                      url: "<?= ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/class/clases.php",
                      beforeSend: function(xhr) {
                        $("#servicios_tabla").addClass('borroso');
                      },
                      data: {
                        action: "borrado_boleto",
                        id: <?= $cotizacion->rowid ?>,
                        rowid_boleto: id,
                      }

                    }).done(function(resultado) {
                      console.log(resultado);

                      var jsonObject = JSON.parse(resultado);

                      if (jsonObject.error_eliminado == 1) {
                        $.toast({
                          heading: 'Cotizacion <?php echo $cotizacion->number; ?>',
                          text: "Detalle " + jsonObject.error_eliminado_txt,
                          icon: 'error',
                          position: 'top-right',
                          bgColor: '#f00'
                        });

                      } else {

                        $.toast({
                          heading: 'Cotizacion <?php echo $cotizacion->number; ?>',
                          text: "Detalle Boleto  Eliminado con Exito ",
                          icon: 'success',
                          position: 'top-right',
                          bgColor: '#f00'
                        });

                        $("#boletos_aereos_tabla").html(jsonObject.datos);
                        $("#boletos_aereos_tabla").removeClass('borroso');
                      }


                    });
                  }




                  function traer_boletos_aereos() {


                    $.ajax({
                      method: "POST",
                      url: "<?= ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/class/clases.php",
                      beforeSend: function(xhr) {
                        $("#boletos_aereos_tabla").addClass('borroso');
                      },
                      data: {
                        action: "traer_boletos_aereos",
                        id: <?= $cotizacion->rowid ?>,
                      }

                    }).done(function(resultado) {
                      console.log(resultado);

                      var jsonObject = JSON.parse(resultado);

                      if (jsonObject.error == 1) {
                        $.toast({
                          heading: 'Cotizacion <?php echo $cotizacion->number; ?>',
                          text: "Detalle " + jsonObject.datos,
                          icon: 'error',
                          position: 'top-right',
                          bgColor: '#f00'
                        });

                      } else {
                        $("#boletos_aereos_tabla").html(jsonObject.datos);
                        $("#boletos_aereos_tabla").removeClass('borroso');


                      }


                    });

                  }

                  $(document).ready(function() {
                    traer_boletos_aereos();

                  });
                </script>



                <!--- ---------------------------------------------------------------------------------------->
                <!--- ---------------------------------------------------------------------------------------->
                <!--- ---------------------------------------------------------------------------------------->
                <!--  SERVICIOS                                                                       --------->
                <!--- ---------------------------------------------------------------------------------------->
                <!--- ---------------------------------------------------------------------------------------->
                <!--- ---------------------------------------------------------------------------------------->

                <script>
                  function nuevoServicio(id) {
                      boton_actualizar_servicio = ' <button type="button" onclick="actualizarServicio('+id+');" class="btn btn-success">Actualizar</button>';


                    titulo = (id == 'nuevo') ? 'Registrar Nuevo Servicio ' : 'Editando Servicio';
                    accion = (id == 'nuevo') ? 'crear_servicio' : 'editar_servicio';
                    titulo_boton = (id == 'nuevo') ? 'Guardar Nuevo' : 'Editar Boleto';

                    $("#modal_titulo").empty().html(titulo);
                    $("#modal_body").addClass('borroso');

                    $.ajax({
                      type: "POST",
                      url: "<?php echo ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/ajax/cotizacion_ajax_detalle_servicio.php",
                      data: {
                        "cotizacion": '<?php echo $cotizacion->rowid; ?>',
                        "id": id,
                        "accion": accion,

                      },
                      success: function(html) {
                        $("#modal_body").empty().html(html).removeClass('borroso');;
                        $("#modal_completo").modal('show');


                        $("#modal_footer").empty().html(boton_Cerrar+boton_actualizar_servicio);


                      }
                    });


                  }

                  function eliminarServicio(id) {
                    $("#modal_completo").modal('show');
                    $("#modal_body").empty().html('Seguro de Eliminar El Registro').removeClass('borroso');;
                    boton_eliminar = '<button type="button" class="btn btn-dark" data-dismiss="modal" OnClick="eliminarServicio_backEnd(' + id + ')"><i class="fas fa-trash-alt"></i>  Confirmar Eliminar</button>';
                    $("#modal_footer").empty().html(boton_Cerrar + boton_eliminar);

                  }
                
                  
                  
                    function enviar_whatsapp_ventana(id){
                      
                         
                          boton_enviar_whatsapp = ' <button type="button" onclick="enviar_whatsapp();" class="btn btn-success">Enviar</button>';


                    titulo = '<strong>Enviar Cotizacion por WhatsApp</strong>';
                    accion = (id == 'nuevo') ? 'crear_servicio' : 'editar_servicio';
                    titulo_boton = (id == 'nuevo') ? 'Guardar Nuevo' : 'Editar Boleto';

                    $("#modal_titulo").empty().html(titulo);
                    $("#modal_body").addClass('borroso');

                    $.ajax({
                      type: "POST",
                      url: "<?php echo ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/ajax/enviar_whatsapp_ventana.php",
                      data: {
                        "cotizacion": '<?php echo $cotizacion->rowid; ?>',
                        "id": id,
                        "accion": accion,

                      },
                      success: function(html) {
                        $("#modal_body").empty().html(html).removeClass('borroso');;
                        $("#modal_completo").modal('show');


                        $("#modal_footer").empty().html(boton_Cerrar+boton_enviar_whatsapp);


                      }
                    });
                  
                  }
                  
                  function actualizarServicio(id){
                   
                         $.ajax({
                      method: "POST",
                      url: "<?= ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/class/clases.php",
                      beforeSend: function(xhr) {
                        $("#servicios_tabla").addClass('borroso');
                      },
                      data: {
                        action: "actualizarServicio",
                        rowid: id,
                   
                         codigo: $("#codigo").val(),
                          comentario: $("#comentario_servicio").val(),
                           nombre_servicio: $("#nombre_servicio").val(),
                            activo: $("#activo").val(),
                             precio: $("#precio").val(),
                              moneda: $("#moneda").val(),
                               descuento: $("#descuento").val(),
                                precioFinal: $("#precioFinal").val(),
                      }

                    }).done(function(resultado) {
                     //   console.log(resultado);
                       $("#modal_completo").modal('hide');
                       traer_servicios();
                   
                    });
                  
                  }

                  function eliminarServicio_backEnd(id) {

                    $.ajax({
                      method: "POST",
                      url: "<?= ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/class/clases.php",
                      beforeSend: function(xhr) {
                        $("#servicios_tabla").addClass('borroso');
                      },
                      data: {
                        action: "borrado_servicio",
                        id: <?= $cotizacion->rowid ?>,
                        rowid_servicio: id,
                      }

                    }).done(function(resultado) {
                      console.log(resultado);

                      var jsonObject = JSON.parse(resultado);

                      if (jsonObject.error_eliminado == 1) {
                        $.toast({
                          heading: 'Cotizacion <?php echo $cotizacion->number; ?>',
                          text: "Detalle " + jsonObject.error_eliminado_txt,
                          icon: 'error',
                          position: 'top-right',
                          bgColor: '#f00'
                        });

                      } else {

                        $.toast({
                          heading: 'Cotizacion <?php echo $cotizacion->number; ?>',
                          text: "Detalle Servicio Eliminado con Exito ",
                          icon: 'success',
                          position: 'top-right',
                          bgColor: '#f00'
                        });

                        $("#servicios_tabla").html(jsonObject.datos);
                        $("#servicios_tabla").removeClass('borroso');
                      }


                    });
                  }


                  function traer_servicios() {


                    $.ajax({
                      method: "POST",
                      url: "<?= ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/class/clases.php",
                      beforeSend: function(xhr) {
                        $("#servicios_tabla").addClass('borroso');
                      },
                      data: {
                        action: "traer_servicios",
                        id: <?= $cotizacion->rowid ?>,
                      }

                    }).done(function(resultado) {
                      console.log(resultado);

                      var jsonObject = JSON.parse(resultado);

                      if (jsonObject.error == 1) {
                        $.toast({
                          heading: 'Cotizacion <?php echo $cotizacion->number; ?>',
                          text: "Detalle " + jsonObject.datos,
                          icon: 'error',
                          position: 'top-right',
                          bgColor: '#f00'
                        });

                      } else {
                        $("#servicios_tabla").html(jsonObject.datos);
                        $("#servicios_tabla").removeClass('borroso');
                      }


                    });

                  }

                  $(document).ready(function() {
                    traer_servicios();

                    var listaDeOpciones = <?= json_encode($arrayRecuperado) ?>;
                    var selectedOptions = <?= json_encode($arrayRecuperado) ?>;

                    // Initialize Select2 with options
                    $('#tags').select2({
                      data: listaDeOpciones,
                      multiple: true,
                      tags: true,
                      tokenSeparators: [',', ' ']
                    });

                    // Set selected options
                    $('#tags').val(selectedOptions);
                    $('#tags').trigger('change');

                    $('#tags').prop('disabled', true);
                    
                    
                     //conf servicios
    var listaDeOpciones = <?= json_encode($arrayRecuperado2) ?>;
    var selectedOptions = <?= json_encode($arrayRecuperado2) ?>;

    // Initialize Select2 with options
    $('#servicios').select2({
      data: listaDeOpciones,
      multiple: true,
      tokenSeparators: [',', ' ']
    });
    // Set selected options
    $('#servicios').val(selectedOptions);
    $('#servicios').trigger('change');
        $('#servicios').prop('disabled', true);
                    

                  });

                  function guardarFotoBoleto(int) {

                    alert(int);

                  }
                  
                  
                  
                  function ventanaPdf(){
                      
                      
                       var url = "<?= ENLACE_WEB ?>/include/pdflib/pdf_cotizacion_detalle.php?id=<?=$cotizacion->rowid?>";
    window.open(url, '_blank', 'height=400,width=400');
    
    
                  }
                  
                  
                  function actualizarConsideraciones(id){
                   
                         $.ajax({
                      method: "POST",
                      url: "<?= ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/class/clases.php",
                      beforeSend: function(xhr) {
                        $("#servicios_tabla").addClass('borroso');
                      },
                      data: {
                        action: "actualizarConsideraciones",
                        rowid: id,
                         consideraciones: $("#consideraciones").val(),
                      }

                    }).done(function(resultado) {
                   $.toast({
                          heading: 'Consideraciones actualizadas',
                          text: "Proceso de actualizaci&oacute;n exitoso ",
                          icon: 'success',
                          position: 'top-right',
                          bgColor: '#198754'
                        });
                   
                    });
                  
                  }
                  
                </script>

                <!-- The modal -->
                <div class="modal fade" id="modal_completo" tabindex="-1" role="dialog" aria-labelledby="modalLabelLarge" aria-hidden="true">
                  <div class="modal-dialog">
                    <div class="modal-content">

                      <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>

                        <h3 class="modal-title" id="modal_titulo"></h3>
                      </div>
                      <div class="modal-body" id="modal_body"></div>

                      <div class="modal-footer" id="modal_footer">
                        <button type="button" class="btn btn-dark" data-dismiss="modal">Cerrar</button>
                      </div>
                    </div>
                  </div>
                </div>