<?php

class ReservasV20
{
	private $dbh;
	public $rowid;
	public $nro_confirmacion;
	public $fecha_reservacion;
	public $fecha_ingreso;
	public $fecha_salida;
	public $servicio_turistico;
	public $observaciones;
	public $monto_rack;
	public $estado;
	public $fecha_limite_pago;
	public $fk_cotizacion;
	public $creado_fk_usuario;
	public $creado_fecha;
	public $borrado;
	public $borrado_fk_usuario;
	public $borrado_fecha;
	public $editado_fk_usuario;
	public $editado_fecha;

    public $siguiente_consecutivo;

	public function __construct($db)
	{
		$this->dbh = $db;
		    $currentYear = date('Y');

    // Consultar el número de cotizaciones para el año actual
    $query = "SELECT COUNT(*) as count FROM 	a_medida_cctravel_sitios_turisticos_cotizaciones_v20  WHERE YEAR(creado_fecha) = :year";
    $stmt = $this->dbh->prepare($query);
    $stmt->bindParam(':year', $currentYear, PDO::PARAM_INT);
    $stmt->execute();

    // Obtener el resultado
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // Calcular el siguiente consecutivo
    $this->siguiente_consecutivo = "Cot-".$currentYear."-".($result['count'] + 1);
	}

	public function fetch($id)
	{
		$query = "SELECT r.*,
		fu.usuario as usuario_creador,
    	concat(ft.nombre,' ', ft.apellidos) as nombre_cliente,
    	c.cantidad_adultos,
        c.cantidad_menores,
        c.moneda,
        c.destino,
        de.etiqueta,
        de.estilo,
        ft.email as correo_cliente,
        st.nombre as nombre_servicio,
        c.number,
        r.fk_cotizacion,
        c.consideraciones,
        c.vuelo_internacional
		FROM a_medida_cctravel_reservas_v20  r
	    INNER JOIN a_medida_cctravel_sitios_turisticos_cotizaciones_v20 c ON c.rowid = r.fk_cotizacion 
      left join fi_usuarios fu on fu.rowid = r.creado_fk_usuario
      INNER JOIN a_medida_cctravel_sitios_turisticos_diccionario_cotizaciones_v20 de ON r.estado =  de.rowid
      INNER JOIN a_medida_cctravel_sitios_turisticos st ON st.rowid = r.servicio_turistico
      INNER JOIN fi_terceros ft ON ft.rowid = c.fk_tercero
		WHERE r.rowid = :rowid";
		
		$stmt = $this->dbh->prepare($query);
	    $stmt->bindParam(':rowid', $id, PDO::PARAM_INT);
		$stmt->execute();
		$row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $this->rowid = $row['rowid'];
		$this->nro_confirmacion = $row['nro_confirmacion'];
		$this->fecha_reservacion = $row['fecha_reservacion'];
		$this->fecha_ingreso = $row['fecha_ingreso'];
		$this->fecha_salida = $row['fecha_salida'];
		$this->servicio_turistico = $row['servicio_turistico'];
		$this->observaciones = $row['observaciones'];
		$this->monto_rack = $row['monto_rack'];
		$this->estado = $row['estado'];
		$this->fecha_limite_pago = $row['fecha_limite_pago'];
		$this->fk_cotizacion = $row['fk_cotizacion'];
		$this->creado_fk_usuario = $row['creado_fk_usuario'];
		$this->creado_fecha = $row['creado_fecha'];
		$this->borrado_fk_usuario = $row['borrado_fk_usuario'];
		$this->borrado_fecha = $row['borrado_fecha'];
		$this->editado_fk_usuario = $row['editado_fk_usuario'];
		$this->editado_fecha = $row['editado_fecha'];
		
		$this->nombre_cliente = $row['nombre_cliente'];
		$this->correo_cliente = $row['correo_cliente'];
		$this->moneda = $row['moneda'];
		$this->cantidad_adultos = $row['cantidad_adultos'];
		$this->cantidad_menores = $row['cantidad_menores'];
		$this->nombre_servicio = $row['nombre_servicio'];
		$this->etiqueta = $row['etiqueta'];
		$this->estilo = $row['estilo'];
		$this->destino = $row['destino'];
		$this->number = $row['number'];
		$this->vuelo_internacional = $row['vuelo_internacional'];
		$this->consideraciones = $row['consideraciones'];
		
		
	}
	
				public function enviar_whatsapp()
	{
		$sql = "INSERT INTO facturac_Licencias.whatsapp_mensajes set texto = :texto,
		telefonos_destinatario = :telefonos_destinatario, 
		fk_reserva = :fk_reserva";
   try {
		$db = $this->dbh->prepare($sql);
		$db->bindParam(':texto', $this->texto, PDO::PARAM_STR);
		$db->bindParam(':telefonos_destinatario', $this->telefonos_destinatario, PDO::PARAM_STR);
		$db->bindParam(':fk_reserva', $this->fk_reserva, PDO::PARAM_STR);
		
		$result                              = $db->execute();

		if(!$result){
		       return $db->errorInfo();
		}else{
		    	return $result;
		}
		
		
   } catch (PDOException $e) {
        // Handle exception
        return "Error: " . $e->getMessage();
    }
	}

	public function obtenerEstadosReservas()
	{

		$sql = "SELECT * FROM a_medida_cctravel_sitios_turisticos_diccionario_reservas_v20  where activo = 1";

		$db = $this->dbh->prepare($sql);

		$db->execute();
		$data                              = $db->fetchAll(PDO::FETCH_OBJ);

		return $data;
	}
	
	
		public function obtenerServiciosTuristicos()
	{
	    $entidad = $_SESSION['Entidad'];

		$sql = "SELECT * FROM a_medida_cctravel_sitios_turisticos  where activo = 1 AND entidad = $entidad";

		$db = $this->dbh->prepare($sql);

		$db->execute();
		$data                              = $db->fetchAll(PDO::FETCH_OBJ);

		return $data;
	}
	


	public function guardarCliente()
	{
// metodo para guardar clientes en fi_terceros
		$sql = "INSERT INTO fi_terceros set entidad = :entidad,
		tipo = :tipo,
		nombre = :nombre,
		apellidos = :apellidos,
		fecha_nacimiento = :fecha_nacimiento,
		email = :email,
		telefono = :telefono";
   try {
		$db = $this->dbh->prepare($sql);
		$db->bindParam(':entidad', $this->entidad, PDO::PARAM_INT);
		$db->bindParam(':tipo', $this->tipo, PDO::PARAM_INT);
		$db->bindParam(':nombre', $this->nombre, PDO::PARAM_STR);
		$db->bindParam(':apellidos', $this->apellidos, PDO::PARAM_STR);
		$db->bindParam(':fecha_nacimiento', $this->fecha_nacimiento, PDO::PARAM_STR);
		$db->bindParam(':email', $this->email, PDO::PARAM_STR);
		$db->bindParam(':telefono', $this->telefono, PDO::PARAM_STR);
		$result                              = $db->execute();
  
	
		
		if(!$result){
		       return $db->errorInfo();
		}else{
		    	return $result;
		}
		
		
		
   } catch (PDOException $e) {
        // Handle exception
        return "Error: " . $e->getMessage();
    }
	}
	
	
	
		public function cancelarReserva()
	{

		$sql = "UPDATE a_medida_cctravel_reservas_v20 SET estado = 2 WHERE rowid = :rowid ";

		$db = $this->dbh->prepare($sql);
		$db->bindParam(':rowid', $this->rowid, PDO::PARAM_INT);
		$result                              = $db->execute();

		return $result;
	}
	

	public function guardarAdjunto()
	{

		$sql = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20 SET img_boleto = :img_boleto WHERE rowid = :rowid ";

		$db = $this->dbh->prepare($sql);
		$db->bindParam(':rowid', $this->rowid, PDO::PARAM_INT);
		$db->bindParam(':img_boleto', $this->img_boleto, PDO::PARAM_INT);
		$result                              = $db->execute();

		return $result;
	}
	
	
	
	
			public function delete_servicios($array, $record_id)
	{


foreach ($array as $item) {
    
    	$sql = "DELETE FROM a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios
WHERE fk_centro = :fk_centro AND fk_cotizacion = :fk_cotizacion";
		$db = $this->dbh->prepare($sql);
		$db->bindParam(':fk_cotizacion', $record_id, PDO::PARAM_INT);
		$db->bindParam(':fk_centro', $item, PDO::PARAM_INT);
	  $result =  $db->execute();
	  
	  if($result){
	      $borrados++;
	  }

}	    
	

	

		return $borrados;
	}
	
		public function copiar_servicios($array, $record_id)
	{


foreach ($array as $item) {
    
    	$sql = "INSERT INTO a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios
(fk_cotizacion, fk_centro, codigo, comentario, fk_servicio, activo, precio, moneda, descuento, precio_final, creado_fk_usuario, creado_fecha, borrado, borrado_fecha, borrado_fk_usuario, fk_icono, nombre_servicio)
SELECT :fk_cotizacion, fk_centro, codigo, comentario, fk_servicio, activo, precio, moneda, descuento, precio_final, creado_fk_usuario, creado_fecha, borrado, borrado_fecha, borrado_fk_usuario, fk_icono, nombre_servicio
FROM a_medida_cctravel_sitios_turisticos_servicios
WHERE fk_centro = :fk_centro";
		$db = $this->dbh->prepare($sql);
		$db->bindParam(':fk_cotizacion', $record_id, PDO::PARAM_INT);
		$db->bindParam(':fk_centro', $item, PDO::PARAM_INT);
	  $result =  $db->execute();
	  
	  if($result){
	      $clonados++;
	  }

}	    
	

	

		return $clonados;
	}
	
	
	public function save() {
    try {
        // SQL base para insertar o actualizar
        $sql = ($this->rowid === null ? "INSERT INTO" : "UPDATE") . " a_medida_cctravel_reservas_v20 SET 
            nro_confirmacion = :nro_confirmacion, 
            fecha_reservacion = :fecha_reservacion, 
            fecha_ingreso = :fecha_ingreso, 
            fecha_salida = :fecha_salida, 
            servicio_turistico = :servicio_turistico, 
            observaciones = :observaciones, 
            monto_rack = :monto_rack, 
            fecha_limite_pago = :fecha_limite_pago, 
            fk_cotizacion = :fk_cotizacion, 
            estado = :estado, 
            " . ($this->rowid === null ? "creado_fk_usuario = :creado_fk_usuario, 
            creado_fecha = now() " : "editado_fk_usuario = :editado_fk_usuario, 
            editado_fecha = now() ") . 
            ($this->rowid !== null ? " WHERE rowid = :rowid" : "");
            
            $editar = $this->rowid !== null? true: false;
            // var_dump($editar);
            // die();
        // Preparar la declaración SQL
        $stmt = $this->dbh->prepare($sql);

        // Vincular los parámetros
        $stmt->bindParam(':nro_confirmacion', $this->nro_confirmacion);
        $stmt->bindParam(':fecha_reservacion', $this->fecha_reservacion);
        $stmt->bindParam(':fecha_ingreso', $this->fecha_ingreso);
        $stmt->bindParam(':fecha_salida', $this->fecha_salida);
        $stmt->bindParam(':servicio_turistico', $this->servicio_turistico);
        $stmt->bindParam(':observaciones', $this->observaciones);
        $stmt->bindParam(':monto_rack', $this->monto_rack);
        $stmt->bindParam(':fecha_limite_pago', $this->fecha_limite_pago);
        $stmt->bindParam(':fk_cotizacion', $this->fk_cotizacion);
        $stmt->bindParam(':estado', $this->estado);
        if ($this->rowid === null) {
            $stmt->bindParam(':creado_fk_usuario', $this->creado_fk_usuario);
           
        } else {
            $stmt->bindParam(':editado_fk_usuario', $this->editado_fk_usuario);
           
            $stmt->bindParam(':rowid', $this->rowid);
        }

        // Ejecutar la declaración SQL
     $result =   $stmt->execute();
        
           // Get record ID
        $record_id = ($this->rowid > 0) ? $this->rowid : $this->dbh->lastInsertId();
       if($editar == false)
       {
           $this->aprobarCotizacion($this->fk_cotizacion);
       }
        
        // Return status and record ID
        return [
            'status' => $result,
            'id' => $record_id
            
        ];
        
    } catch (PDOException $e) {
        echo 'Error: ' . $e->getMessage();
    }
}


        /******************************************************************
         * *
         * 
         * 
         * 
         * 
         * Funciones para BOLETO AEREOS
        *
        * 
        * 
        ******************************************************************/
        public function fetch_boleto($id)
                {
                    $query = "SELECT *
                                FROM a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos
                                WHERE rowid = ?";
                    $stmt = $this->dbh->prepare($query);
                    $stmt->bindParam(1, $id);
                    $stmt->execute();
                    $row = $stmt->fetch(PDO::FETCH_ASSOC);
                
                    $this->rowid = $row['rowid'];
                    $this->fk_cotizacion = $row['fk_cotizacion'];
                    $this->aerolinea = $row['aerolinea'];
                    $this->vuelo = $row['vuelo'];
                    $this->origen = $row['origen'];
                    $this->destino = $row['destino'];
                    $this->fecha_saliendo = $row['fecha_saliendo'];
                    $this->fecha_llegando = $row['fecha_llegando'];
                    $this->vuelo_duracion_en_horas = $row['vuelo_duracion_en_horas'];
                    $this->vuelo_escalas = $row['vuelo_escalas'];
                    $this->creado_fecha = $row['creado_fecha'];
                    $this->creado_fk_usuario = $row['creado_fk_usuario'];
                    $this->borrado = $row['borrado'];
                    $this->borrado_fecha = $row['borrado_fecha'];
                    $this->borrado_fk_usuario = $row['borrado_fk_usuario'];
                }
                
                

          public function traer_boletos_aereos($id, $rowid = null )
            {     $where = ($rowid !== NULL) ? " AND b.rowid = :rowid" : "";
                  
                  $query = "SELECT b.* , c.number  from a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos b
                  left join a_medida_cctravel_sitios_turisticos_cotizaciones_v20 c on c.rowid = b.fk_cotizacion 
                  
                  where b.fk_cotizacion = :id and b.borrado = 0  $where  
               ";
                $stmt = $this->dbh->prepare($query);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                
                if ($rowid !== NULL){
                    $stmt->bindParam(':rowid', $rowid, PDO::PARAM_INT);
                }
                
                $accion=$stmt->execute();
        
                if ($accion){
                        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        $consulta['error'] = 0;
                        $consulta['datos'] = $result;
            
                    } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error'] = 1;
                        $consulta['datos'] = $a;

                }
                
               return $consulta;
            }
            
            
            
            
              public function borrado_boleto()
                {
                    $query = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos
                              SET borrado = 1 ,
                                  borrado_fecha =  NOW(),
                                  borrado_fk_usuario = :borrado_fk_usuario
                              WHERE rowid = :rowid";
                
                    $stmt = $this->dbh->prepare($query);
                
                    $stmt->bindParam(':rowid', $this->rowid_boleto);
                    $stmt->bindParam(':borrado_fk_usuario', $this->borrado_fk_usuario);
                
                    $accion = $stmt->execute();
                    
                    
               if ($accion){
                        $consulta['error_eliminado'] = 0;
             
                        } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error_eliminado'] = 1;
                        $consulta['error_eliminado_txt'] = $a;
                }
                
               return $consulta;
               
               
                }

            
            public function save_boleto()
{
        // Prepare query
        $query = ($this->rowid_boleto > 0) ?
            "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos SET 
                fk_cotizacion = :fk_cotizacion,
                aerolinea = :aerolinea,
                vuelo = :vuelo,
                origen = :origen,
                destino = :destino,
                fecha_saliendo = :fecha_saliendo,
                fecha_llegando = :fecha_llegando,
                vuelo_duracion_en_horas = :vuelo_duracion_en_horas,
                vuelo_escalas = :vuelo_escalas,
                creado_fecha = NOW(),
                creado_fk_usuario = :creado_fk_usuario
            WHERE rowid = :rowid" :
            "INSERT INTO a_medida_cctravel_sitios_turisticos_cotizaciones_v20_boletos SET 
                fk_cotizacion = :fk_cotizacion,
                aerolinea = :aerolinea,
                vuelo = :vuelo,
                origen = :origen,
                destino = :destino,
                fecha_saliendo = :fecha_saliendo,
                fecha_llegando = :fecha_llegando,
                vuelo_duracion_en_horas = :vuelo_duracion_en_horas,
                vuelo_escalas = :vuelo_escalas,
                creado_fecha = NOW(),
                creado_fk_usuario = :creado_fk_usuario";

        // Prepare statement
        $stmt = $this->dbh->prepare($query);

        // Bind parameters
        $stmt->bindParam(':fk_cotizacion', $this->fk_cotizacion, PDO::PARAM_INT);
        $stmt->bindParam(':aerolinea', $this->aerolinea, PDO::PARAM_STR);
        $stmt->bindParam(':vuelo', $this->vuelo, PDO::PARAM_STR);
        $stmt->bindParam(':origen', $this->origen, PDO::PARAM_STR);
        $stmt->bindParam(':destino', $this->destino, PDO::PARAM_STR);
        $stmt->bindParam(':fecha_saliendo', $this->fecha_saliendo, PDO::PARAM_STR);
        $stmt->bindParam(':fecha_llegando', $this->fecha_llegando, PDO::PARAM_STR);
        $stmt->bindParam(':vuelo_duracion_en_horas', $this->vuelo_duracion_en_horas, PDO::PARAM_INT);
        $stmt->bindParam(':vuelo_escalas', $this->vuelo_escalas, PDO::PARAM_INT);
        $stmt->bindParam(':creado_fk_usuario', $this->creado_fk_usuario, PDO::PARAM_INT);

        if ($this->rowid_boleto > 0) {
            $stmt->bindParam(':rowid', $this->rowid_boleto, PDO::PARAM_INT);
        }

        // Execute query
        $accion = $stmt->execute();

        // Get record ID
        $record_id = ($this->rowid_boleto > 0) ? $this->rowid_boleto : $this->dbh->lastInsertId();



            if ($accion){
                        $consulta['error_agregado'] = 0;
             
                        } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error_agregado'] = 1;
                        $consulta['error_agregado_txt'] = $a;
                }
                
                return $consulta;


    
}
            
            
            
            
            
            
            
            
            
            /*
            
             Funciones para los servicios de la cotizacion 
            
            */
            
          public function traer_servicios($id)
            {
                
                  $query = "SELECT b.* , c.nombre, c.descripcion  from a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios  b
                  left join a_medida_cctravel_sitios_turisticos c on c.rowid = b.fk_centro 
                  
                  where b.fk_cotizacion = :id  and b.borrado=  0
               ";
                $stmt = $this->dbh->prepare($query);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                $accion=$stmt->execute();
        
                if ($accion){
                        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        $consulta['error'] = 0;
                        $consulta['datos'] = $result;
            
                    } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error'] = 1;
                        $consulta['datos'] = $a;

                }
                
               return $consulta;
            }
            
            
            
            
            public function fetch_servicio($id)
                {
                    $query = "SELECT cs.*, c.nombre as nombre_sitio 
                    FROM a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios cs 
                    left JOIN a_medida_cctravel_sitios_turisticos c on c.rowid = cs.fk_centro 
                    WHERE cs.rowid = ?";
                    $stmt = $this->dbh->prepare($query);
                    $stmt->bindParam(1, $id);
                    $stmt->execute();
                    $row = $stmt->fetch(PDO::FETCH_ASSOC);
                    $this->rowid_servicio = $row['rowid'];
                    $this->fk_cotizacion = $row['fk_cotizacion'];
                    $this->fk_centro = $row['fk_centro'];
                    $this->nombre_sitio = $row['nombre_sitio'];
                    $this->codigo = $row['codigo'];
                    $this->comentario = $row['comentario'];
                    $this->fk_servicio = $row['fk_servicio'];
                    $this->activo = $row['activo'];
                    $this->precio = $row['precio'];
                    $this->moneda = $row['moneda'];
                    $this->descuento = $row['descuento'];
                    $this->precio_final = $row['precio_final'];
                    $this->creado_fk_usuario = $row['creado_fk_usuario'];
                    $this->creado_fecha = $row['creado_fecha'];
                    $this->borrado = $row['borrado'];
                    $this->borrado_fecha = $row['borrado_fecha'];
                     $this->nombre_servicio = $row['nombre_servicio'];
                    $this->borrado_fk_usuario = $row['borrado_fk_usuario'];
                }


                public function borrado_servicio()
                {
                    $query = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios
                              SET borrado = 1 ,
                                  borrado_fecha =  NOW(),
                                  borrado_fk_usuario = :borrado_fk_usuario
                              WHERE rowid = :rowid";
                
                    $stmt = $this->dbh->prepare($query);
                
                    $stmt->bindParam(':rowid', $this->rowid_servicio);
                    $stmt->bindParam(':borrado_fk_usuario', $this->borrado_fk_usuario);
                
                    $accion = $stmt->execute();
                    
                    
               if ($accion){
                        $consulta['error_eliminado'] = 0;
             
                        } else {
                        $a=implode('-',$stmt->errorInfo());
                        $a.=implode('-',$this->dbh->errorInfo());
                        $consulta['error_eliminado'] = 1;
                        $consulta['error_eliminado_txt'] = $a;
                }
                
               return $consulta;
               
               
                }
                
                
                
                
                public function actualizarServicio()
                {
                   
                     
                    $query = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20_servicios
                        
                          set
                              comentario = :comentario,
                              nombre_servicio = :nombre_servicio,
                              activo = :activo,
                              precio = :precio,
                              moneda = :moneda,
                              descuento = :descuento,
                              precio_final = :precio_final
                            
                              WHERE rowid = :rowid";
                
                    $stmt = $this->dbh->prepare($query);
                
            
                    $stmt->bindParam(':rowid', $this->rowid, PDO::PARAM_STR);
           
                
                    $stmt->bindParam(':comentario', $this->comentario, PDO::PARAM_STR);
                    $stmt->bindParam(':nombre_servicio', $this->nombre_servicio, PDO::PARAM_STR);
                    $stmt->bindParam(':activo', $this->activo, PDO::PARAM_INT);
                    $stmt->bindParam(':precio', $this->precio, PDO::PARAM_STR);
                    $stmt->bindParam(':moneda', $this->moneda, PDO::PARAM_STR);
                    $stmt->bindParam(':descuento', $this->descuento, PDO::PARAM_STR);
                    $stmt->bindParam(':precio_final', $this->precio_final, PDO::PARAM_STR);
             
                  
                
                    $accion = $stmt->execute();
                    
                    
                
               return $accion;
               
               
                }
                
                public function obtenerConsecutivo()
                {
                    $query = "SELECT MAX(nro_confirmacion) as consecutivo
                    FROM a_medida_cctravel_reservas_v20 r ";
                    $stmt = $this->dbh->prepare($query);
                    $stmt->execute();
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                    
                    return (int)$result['consecutivo']+1;
                }
                
                public function aprobarCotizacion($id)
                {
                    
                      $query = "UPDATE a_medida_cctravel_sitios_turisticos_cotizaciones_v20
                          set
                              fk_diccionario_cotizaciones_estado = 6
                              WHERE rowid = :rowid";
                
                    $stmt = $this->dbh->prepare($query);
                
                    $stmt->bindParam(':rowid', $id, PDO::PARAM_STR);
                    $stmt->execute();
                    return $result;
                }
                    
        


} // fin de la clase