<?php
// 12-01-2024 Julio Alvarado
//Esto es una vista para editar/crear cotizaciones
//incluir objeto
require_once(ENLACE_SERVIDOR . "mod_medida_cctravel_cotizaciones/object/cotizacion.object.php");
$cotizacion = new CotizacionesV20($dbh);

require_once(ENLACE_SERVIDOR . "mod_medida_cctravel_sitios_turisticos/object/sitios.object.php");
$SitioTuristico = new SitioTuristico($dbh);

require_once(ENLACE_SERVIDOR . "mod_medida_cctravel_reservas/object/reservas.object.php");
$reserva = new ReservasV20($dbh);


$cotizacion->fetch($_GET['id']);



$diccionario_estatus = $cotizacion->obtenerEstadosCotizacion();
$diccionario_servicios = $cotizacion->obtenerServiciosTuristicos();

if ($cotizacion->moneda == 1) {
  $selected_moneda_colones = '';
  $selected_moneda_dolares = 'selected';
} else {
  $selected_moneda_colones = 'selected';
  $selected_moneda_dolares = '';
}


if ($cotizacion->vuelo_internacional == 1) {
  $selected_si_internacional = 'selected';
  $selected_no_internacional = '';
} else {
  $selected_no_internacional = 'selected';
  $selected_si_internacional = '';
}

$consecutivo = $reserva->obtenerConsecutivo();


$editar = false;

foreach ($diccionario_estatus as $item) {
  if ($item->rowid == $cotizacion->fk_diccionario_cotizaciones_estado) {
    $opciones_estatus .= '
                        <option selected value="' . $item->rowid . '">' . $item->etiqueta . '</td>';
  } else {
    $opciones_estatus .= '
                        <option value="' . $item->rowid . '">' . $item->etiqueta . '</td>';
  }
}

foreach ($diccionario_servicios as $item) {
  $opciones_servicios .= '
                        <option value="' . $item->rowid . '">' . $item->nombre . '</td>';
}



//validar si estamos editando o creando
if ($cotizacion->rowid > 0) {
  $titulo = "Confirmar Reserva usando cotizacion ".$cotizacion->number;
  $editar = true;

  if ($cotizacion->monto_visible_pdf == 1) {
    $selected_visible = 'selected';
    $selected_no_visible = '';
  } else {
    $selected_visible = '';
    $selected_no_visible = 'selected';
  }



  $arrayRecuperado = explode(",", $cotizacion->tags);
  $arrayRecuperado2 = explode(",", $cotizacion->servicios_turisticos);
  
  $listaSitios = [];
  foreach ($arrayRecuperado2 as $item) {
      
      // nos traemos su detalle
         $SitioTuristico->fetch($item);
    // Añadir un nuevo elemento al array $listaSitios
    $listaSitios[] = ['rowid' => $SitioTuristico->rowid, 'nombre' => $SitioTuristico->nombre, 'descripcion' => $SitioTuristico->descripcion];
  }
  

  
  
} else {
  //estamos creando
  $titulo = "Nueva Reserva";
}

?>

<style>
  span.select2.select2-container.select2-container--default {
    z-index: auto;
  }
</style>
<form name="miFormulario" id="miFormulario">

  <div class="pcoded-inner-content">
    <div class="page-bar">
      <div class="page-title-breadcrumb">
        <div class=" pull-left">

          <div class="page-title">
            <h2><?php echo " " . $titulo;  ?></h2>
          </div>
          <?php

          ?>


        </div>
        <ol class="breadcrumb page-breadcrumb pull-right">
          <li><i class="fa fa-home"></i>&nbsp;<a class="parent-item" href="<?php echo ENLACE_WEB; ?>"><?php echo $Lan->lang('global.inicio'); ?></a>&nbsp;<i class="fa fa-angle-right"></i>
          </li>
          <li><a class="parent-item" href="<?php echo ENLACE_WEB; ?>cotizaciones_listado "> Cotizaciones </a>&nbsp;<i class="fa fa-angle-right"></i>
          </li>
          <li class="active"><?php echo $titulo; ?></li>
        </ol>
      </div>
    </div>


    <div class="row">
      <div class="col-md-12 col-xl-12">
        <div class="card sale-card">
          <div class="card-header">

            <div id="details" class="panel panel-default">



              <div class="panel-body">
                <div class="row">
                  <div class="col-md-10">
                    <input type="hidden" name="editar" value="1">
                    <input type="hidden" name="fk_cotizacion" value="<?php echo $cotizacion->rowid; ?>">
                    <input type="hidden" name="action" value="crearReserva">

                    <div class="row">
                      <div class="col-md-3">
                        Cotizacion utilizada :
                      </div>
                      <div class="col-md-3">

                        <label for=""><?php echo $cotizacion->number; ?></label>
                      </div>
                    </div>
                    
                    
                    <div class="row">
    <div class="col-md-3">
        Número de Confirmación:
    </div>
    <div class="col-md-3">
        <span><?php echo $editar=== 1 ? $cotizacion->nro_confirmacion : (int)$consecutivo ?></span>
        <input type="hidden" id="nro_confirmacion" name="nro_confirmacion" value="<?php echo $editar=== 1 ? $cotizacion->nro_confirmacion : (int)$consecutivo ?>" class="form-control">
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Fecha de Reservación:
    </div>
    <div class="col-md-3">
        
        <input  type="datetime-local" id="fecha_reservacion" name="fecha_reservacion" value="<?php echo date('Y-m-d\TH:i'); ?>" class="form-control">
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Fecha/Hora Entrada:
    </div>
    <div class="col-md-3">
        <input  type="datetime-local" id="fecha_ingreso" name="fecha_ingreso" value="<?php echo $cotizacion->fecha_entrada ?>" class="form-control">
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Fecha/Hora Salida:
    </div>
    <div class="col-md-3">
        <input  type="datetime-local" id="fecha_salida" name="fecha_salida" value="<?php echo $cotizacion->fecha_salida ?>" class="form-control">
    </div>
</div>

  <div class="col-md-3">
                        Servicios Turísticos
                      </div>
                      <div class="col-md-3">
                       <?php
                        // Iterar sobre el array de sitios turísticos
    foreach ($listaSitios as $item) {
        // Generar un checkbox HTML para cada sitio turístico
        echo '<input checked type="checkbox" id="'. $item['rowid'] .'" name="'. $item['rowid'] .'">';
        echo '<label> '. $item['nombre'] .'</label><br>';
        // Añadir la descripción del sitio turístico
        echo '<p>'. $item['descripcion'] .'</p>';
    }
    ?>
                    
                      </div>

<div class="row">
    <div class="col-md-3">
        Observaciones:
    </div>
    <div class="col-md-3">
        <textarea class="form-control" id="observaciones" name="observaciones"><?php echo $cotizacion->observaciones ?></textarea>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Monto Rack:
    </div>
    <div class="col-md-3">
        <input placeholder='Monto rack' type="number" id="monto_rack" name="monto_rack" value="<?php echo $cotizacion->monto_rack ?>" class="form-control">
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Fecha Límite de Pago:
    </div>
    <div class="col-md-3">
        <input type="date" id="fecha_limite_pago" name="fecha_limite_pago" value="<?php echo $cotizacion->fecha_limite_pago ?>" max="<?php echo date('Y-m-d', strtotime($cotizacion->fecha_entrada)) ?>" class="form-control">
    </div>
</div>

                    
                    
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-md-12 col-xl-12">
                <a class="btn btn-warning" style="cursor:pointer;" href="<?= ENLACE_WEB ?>dashboard.php?accion=cotizaciones_listado&tipo=proveedores">
                  Volver al Listado cotizaciones
                </a>
                <input type='Submit' class="btn btn-success" style="cursor:pointer;" value='Crear reserva'>

              </div>
            </div>
</form>

<style>
  .row {
    margin-bottom: 10px;
    /* Puedes ajustar este valor según tus necesidades */
  }
</style>



<script>
  $(document).ready(function() {

    calcularPrecio();

    $('#miFormulario').submit(function(event) {

      error = false;

      // Evitar el envío del formulario por defecto
      event.preventDefault();

      // Realizar validaciones aquí
      $("#monto_rack").removeClass("input_error");
      if ($("#monto_rack").val() == '') {
        $("#monto_rack").addClass("input_error");
        error = true;
      }

      $("#fecha_limite_pago").removeClass("input_error");
      if ($("#fecha_limite_pago").val() == '') {
        $("#fecha_limite_pago").addClass("input_error");
        error = true;
      }


      $("#cantidad_adultos").removeClass("input_error");
      if ($("#cantidad_adultos").val() == '') {
        $("#cantidad_adultos").addClass("input_error");
        error = true;
      }

      $("#cantidad_menores").removeClass("input_error");
      if ($("#cantidad_menores").val() == '') {
        $("#cantidad_menores").addClass("input_error");
        error = true;
      }


      $("#fecha_entrada").removeClass("input_error");
      if ($("#fecha_entrada").val() == '') {
        $("#fecha_entrada").addClass("input_error");
        error = true;
      }

      $("#fecha_salida").removeClass("input_error");
      if ($("#fecha_salida").val() == '') {
        $("#fecha_salida").addClass("input_error");
        error = true;
      }


      $("#monto_oferta").removeClass("input_error");
      if ($("#monto_oferta").val() == '') {
        $("#monto_oferta").addClass("input_error");
        error = true;
      }


      $("#descripcion").removeClass("input_error");
      if ($("#descripcion").val() == '') {
        $("#descripcion").addClass("input_error");
        error = true;
      }


      //fin validaciones




      if (error) {
        $.toast({
          heading: 'Error',
          text: "Faltan Datos para Actualizar",
          icon: 'error',
          position: 'top-right',
        });
        return false;
      }
      
       var selectedCheckboxes = [];

 // Iterar sobre todos los checkbox seleccionados
    $('input[type="checkbox"]:checked').each(function() {
        // Añadir el checkbox actual al array
        selectedCheckboxes.push($(this).attr('id'));
    });



      // Si las validaciones pasan, puedes enviar el formulario
      // Puedes agregar aquí tu lógica para enviar el formulario mediante AJAX o submit().

      $.ajax({
        url: '<?php echo ENLACE_WEB; ?>mod_medida_cctravel_reservas/class/clases.php',
        type: 'POST',
        data: $('#miFormulario').serialize() + "&etiquetas=" + encodeURIComponent($("#tags").val()) + "&servicios_turisticos=" + encodeURIComponent(selectedCheckboxes),
        success: function(response) {
          // Manejar la respuesta del servidor
        
          var objetoJSON = JSON.parse(response);
console.log(objetoJSON);

          if (objetoJSON.error == 1) {
            $.toast({
              heading: 'Error',
              text: objetoJSON.error_txt,
              icon: 'error',
              position: 'top-right',
            });

          } else {
                 $.toast({
              heading: 'Success',
              text: 'Reaserva #'+objetoJSON.id+' creada',
              icon: 'success',
              position: 'top-right',
            });
            window.location.href = '<?php echo ENLACE_WEB;  ?>ver_reserva/' + objetoJSON.id; // Reemplaza con la URL que desees

          }

        },
        error: function(error) {
          // Manejar errores
          alert(error);
        }
      });

    });
  });




  function traerRegiones(int) {


    // traerRegiones
    $.ajax({
      method: "POST",
      url: "<?= ENLACE_WEB ?>mod_medida_cctravel_sitios_turisticos/class/clases.php",
      beforeSend: function(xhr) {},
      data: {
        action: 'traerRegiones',
        ubicacionpaisid: int,

      },
    }).done(function(data) {
      //let respuesta = JSON.parse(data);
      console.log(data);

    });

  }




  $(document).ready(function() {

    //conf tags
    var listaDeOpciones = <?= json_encode($arrayRecuperado) ?>;
    var selectedOptions = <?= json_encode($arrayRecuperado) ?>;

    // Initialize Select2 with options
    $('#tags').select2({
      data: listaDeOpciones,
      multiple: true,
      tags: true,
      tokenSeparators: [',', ' ']
    });
    // Set selected options
    $('#tags').val(selectedOptions);
    $('#tags').trigger('change');


    //conf servicios
    var listaDeOpciones = <?= json_encode($arrayRecuperado2) ?>;
    var selectedOptions = <?= json_encode($arrayRecuperado2) ?>;

    // Initialize Select2 with options
    $('#servicios').select2({
      data: listaDeOpciones,
      multiple: true,
      tokenSeparators: [',', ' ']
    });
    // Set selected options
    $('#servicios').val(selectedOptions);
    $('#servicios').trigger('change');



  });


  $(document).ready(function() {
    $('#imagen').on('change', function() {
      var file_data = $('#imagen').prop('files')[0];
      var form_data = new FormData();
      form_data.append('file', file_data);
      $.ajax({
        url: '<?= ENLACE_WEB ?>mod_medida_cctravel_sitios_turisticos/ajax/upload_imagen.php',
        dataType: 'text',
        cache: false,
        contentType: false,
        processData: false,
        data: form_data,
        type: 'post',
        success: function(response) {

          data = JSON.parse(response);

          if (data.error == 1) {
            $.toast({
              heading: 'Error',
              text: "Ocurrio un error al subir la imagen",
              icon: 'warning',
              position: 'top-right',
              bgColor: '#f00'
            });
          } else {
            $("#preview_img").attr('src', data.message);
            $("#img_path").val(data.message);
          }


        }
      });
    });
  });


  $(document).ready(function() {
    $("#nombre_cliente").autocomplete({
      source: "<?= ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/ajax/autocompletado_tercero.ajax.php",
      minLength: 2,
      select: function(event, ui) {
        event.preventDefault();
        //    alert('Seleccionado: ' + ui.item.value); // Add this line
        $.toast({
          heading: 'Agregado',
          text: "Agregado cliente a cotización: " + ui.item.value,
          icon: 'success',
          position: 'top-right',
        });
        $("#nombre_cliente").val(ui.item.value);
        $("#fk_tercero").val(ui.item.id);
      }
    });
  });


  function calcularPrecio() {

    precio = $("#monto_oferta").val();
    descuento_porcentaje = $("#descuento_porcentaje").val();
    descuento = precio * (descuento_porcentaje / 100);
    precio_final = precio - descuento;

    $("#monto_final_txt").text(precio_final + ' ' + $("#moneda option:selected").text());
    $("#monto_final").val(precio_final);
  }



  function nuevoCliente() {


    event.preventDefault();

    $("#modal_cliente").addClass('borroso');

    $.ajax({
      type: "POST",
      url: "<?php echo ENLACE_WEB ?>mod_medida_cctravel_cotizaciones/ajax/cotizacion_ajax_nuevo_cliente.php",
      data: {

      },
      success: function(html) {

        $("#modal_cliente").empty().html(html).removeClass('borroso');
        $("#modal_cliente").modal('show');

      }
    });


  }
</script>


<!-- Modal clientes -->
<div class="modal fade" id="modal_cliente" tabindex="-1" role="dialog" aria-labelledby="modalLabelLarge" aria-hidden="true">

</div>


<!-- The modal -->
<div class="modal fade" id="modal_completo" tabindex="-1" role="dialog" aria-labelledby="modalLabelLarge" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>

        <h3 class="modal-title" id="modal_titulo"></h3>
      </div>
      <div class="modal-body" id="modal_body"></div>

      <div class="modal-footer" id="modal_footer">
        <button type="button" class="btn btn-dark" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>