<?php
// 12-01-2024 Julio Alvarado
//Esto es una vista para editar/crear reservas
//incluir objeto

require_once(ENLACE_SERVIDOR . "mod_medida_cctravel_reservas/object/reservas.object.php");
$reserva = new ReservasV20($dbh);
$reserva->fetch($_GET['id']);


$moneda = $reserva->moneda == 1? '$': '₡';
require_once(ENLACE_SERVIDOR . "mod_medida_cctravel_cotizaciones/object/cotizacion.object.php");
$cotizacion = new CotizacionesV20($dbh);

require_once(ENLACE_SERVIDOR . "mod_medida_cctravel_sitios_turisticos/object/sitios.object.php");
$SitioTuristico = new SitioTuristico($dbh);


$cotizacion->fetch($reserva->fk_cotizacion);
$diccionario_estatus = $cotizacion->obtenerEstadosCotizacion();
$diccionario_servicios = $cotizacion->obtenerServiciosTuristicos();

if ($cotizacion->moneda == 1) {
  $selected_moneda_colones = '';
  $selected_moneda_dolares = 'selected';
} else {
  $selected_moneda_colones = 'selected';
  $selected_moneda_dolares = '';
}


if ($cotizacion->vuelo_internacional == 1) {
  $selected_si_internacional = 'selected';
  $selected_no_internacional = '';
} else {
  $selected_no_internacional = 'selected';
  $selected_si_internacional = '';
}




$editar = false;

foreach ($diccionario_estatus as $item) {
  if ($item->rowid == $cotizacion->fk_diccionario_cotizaciones_estado) {
    $opciones_estatus .= '
                        <option selected value="' . $item->rowid . '">' . $item->etiqueta . '</td>';
  } else {
    $opciones_estatus .= '
                        <option value="' . $item->rowid . '">' . $item->etiqueta . '</td>';
  }
}

foreach ($diccionario_servicios as $item) {
  $opciones_servicios .= '
                        <option value="' . $item->rowid . '">' . $item->nombre . '</td>';
}


 
//validar si estamos editando o creando
if ($cotizacion->rowid > 0) {
  $titulo = "Reserva creada usando cotizacion ".$cotizacion->number;
  $editar = true;

  if ($cotizacion->monto_visible_pdf == 1) {
    $selected_visible = 'selected';
    $selected_no_visible = '';
  } else {
    $selected_visible = '';
    $selected_no_visible = 'selected';
  }



  $arrayRecuperado = explode(",", $cotizacion->tags);
  $arrayRecuperado2 = explode(",", $reserva->servicio_turistico);
  

  
  $listaSitios = [];
  foreach ($arrayRecuperado2 as $item) {
      
      // nos traemos su detalle
         $SitioTuristico->fetch($item);
    // Añadir un nuevo elemento al array $listaSitios
    $listaSitios[] = ['rowid' => $SitioTuristico->rowid, 'nombre' => $SitioTuristico->nombre, 'descripcion' => $SitioTuristico->descripcion];
  }
  


  
} else {
  //estamos creando
  $titulo = "Nueva Reserva";
}
?>

<style>
  span.select2.select2-container.select2-container--default {
    z-index: auto;
  }
</style>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<form name="miFormulario" id="miFormulario">

  <div class="pcoded-inner-content">
    <div class="page-bar">
      <div class="page-title-breadcrumb">
        <div class=" pull-left">

          <div class="page-title">
            <h2><?php echo " " . $titulo;  ?></h2>
          </div>
          <?php

          ?>


        </div>
        <ol class="breadcrumb page-breadcrumb pull-right">
          <li><i class="fa fa-home"></i>&nbsp;<a class="parent-item" href="<?php echo ENLACE_WEB; ?>"><?php echo $Lan->lang('global.inicio'); ?></a>&nbsp;<i class="fa fa-angle-right"></i>
          </li>
          <li><a class="parent-item" href="<?php echo ENLACE_WEB; ?>cotizaciones_listado "> Reservas </a>&nbsp;<i class="fa fa-angle-right"></i>
          </li>
          <li class="active"><?php echo $titulo; ?></li>
        </ol>
      </div>
    </div>


    <div class="row">
      <div class="col-md-12 col-xl-12">
        <div class="card sale-card">
          <div class="card-header">

            <div id="details" class="panel panel-default">



              <div class="panel-body">
                <div class="row">
                  <div class="col-md-10">
                    <input type="hidden" name="editar" value="1">
                    <input type="hidden" name="fk_cotizacion" value="<?php echo $reserva->fk_cotizacion; ?>">
                    <input type="hidden" name="action" value="crearReserva">

                    <div class="row">
                      <div class="col-md-3">
                        Cotizacion utilizada :
                      </div>
                      <div class="col-md-3">

                        <label for=""><?php echo $reserva->number; ?></label>
                      </div>
                    </div>
                    
                    
                    <div class="row">
    <div class="col-md-3">
        Número de Confirmación:
    </div>
    <div class="col-md-3">
        <span><?php echo $reserva->nro_confirmacion ?></span>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Fecha de Reservación:
    </div>
    <div class="col-md-3">
        <span><?php echo date("d/m/Y H:i",strtotime($reserva->fecha_reservacion)) ?></span>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Fecha/Hora Entrada:
    </div>
    <div class="col-md-3">
        <span><?php echo date("d/m/Y H:i",strtotime($reserva->fecha_ingreso)) ?></span>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Fecha/Hora Salida:
    </div>
    <div class="col-md-3">
        <span><?php echo date("d/m/Y H:i",strtotime($reserva->fecha_salida)) ?></span>
    </div>
</div>

  <div class="col-md-3">
                        Servicios Turísticos
                      </div>
                      <div class="col-md-3">
                       <?php
                        // Iterar sobre el array de sitios turísticos
    foreach ($listaSitios as $item) {
        // Generar un checkbox HTML para cada sitio turístico
        echo '<label> '. $item['nombre'] .'</label><br>';
        // Añadir la descripción del sitio turístico
        echo '<p>'. $item['descripcion'] .'</p>';
    }
    ?>
                    
                      </div>

<div class="row">
    <div class="col-md-3">
        Observaciones:
    </div>
    <div class="col-md-3">
        <span><?php echo $reserva->observaciones ?></span>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Monto Rack:
    </div>
    <div class="col-md-3">
         <span><?php echo $moneda.$reserva->monto_rack ?></span>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        Fecha Límite de Pago:
    </div>
    <div class="col-md-3">
          <span><?php echo date("d/m/Y",strtotime($reserva->fecha_limite_pago)) ?></span>
    </div>
</div>

                    
                    
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-md-12 col-xl-12">
                <a class="btn btn-warning" style="cursor:pointer;" href="<?= ENLACE_WEB ?>dashboard.php?accion=reservas">
                  Volver al Listado Reservas
                </a>
                  <a class="btn btn-info" style="cursor:pointer;" href="#" onclick='ventanaPdf();'>
                        <i class='fa fa-file-pdf'></i> Generar PDF
                    </a>
                    
                         <a class="btn btn-danger" style="cursor:pointer;" href="#" onclick='abrir_email();'>
                     <i class='fa fa-envelope-o'></i> Enviar por email
                    </a>
                    
                  
                    <button onclick='enviar_whatsapp_ventana(<?php echo $reserva->rowid?>)' type='button' class='btn btn-success'><i class='fa fa-phone'></i> Enviar por WhatsApp</button>
<?php

if($reserva->estado != 2){
?>    

<button type='button' onclick='cancelarReserva();' class="btn btn-danger"><i class="fa fa-ban" aria-hidden="true"></i> Cancelar Reserva</button>
<?php
}
?>
             
              </div>
            </div>
</form>

<style>
  .row {
    margin-bottom: 10px;
    /* Puedes ajustar este valor según tus necesidades */
  }
</style>



<script>
  $(document).ready(function() {

    
  });


          function abrir_email()
{


    largeur = 600;
    hauteur = 550;
    opt = 'width='+largeur+', height='+hauteur+', left='+(screen.width - largeur)/2+', top='+(screen.height-hauteur)/2+'';
    window.open ('<?php echo ENLACE_WEB ?>include/mail/enviar_email_reserva_cctravel.php?id=<?php echo $_REQUEST['id'] ?>&opcion=reserva', 'Enviar Email Reserva', opt);



}

function cancelarReserva() {
    if (confirm("¿Estás seguro de que quieres cancelar la reserva?")) {
        $.ajax({
            method: "POST",
            url: "<?= ENLACE_WEB ?>mod_medida_cctravel_reservas/class/clases.php",
            beforeSend: function(xhr) {},
            data: {
                action: 'cancelarReserva',
                rowid: <?=$reserva->rowid?>,
            },
        }).done(function(data) {
            console.log(data);
            if(data){
                 window.location.href = '<?php echo ENLACE_WEB;  ?>dashboard.php?accion=reservas';

            }
          
        });
    }
}

function cancelarReservaSW() {
    Swal.fire({
        title: '¿Estás seguro?',
        text: "¡No podrás revertir esto!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: '¡Sí, cancelar!'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: "POST",
                url: "<?= ENLACE_WEB ?>mod_medida_cctravel_sitios_turisticos/class/clases.php",
                beforeSend: function(xhr) {},
                data: {
                    action: 'cancelarReserva',
                    rowid: <?=$reserva->rowid?>,
                },
            }).done(function(data) {
                console.log(data);
                Swal.fire(
                    '¡Cancelado!',
                    'Tu reserva ha sido cancelada.',
                    'success'
                )
            });
        }
    })
}
    function ventanaPdf(){
                      
                      
                       var url = "<?= ENLACE_WEB ?>include/pdflib/pdf_reserva_cctravel.php?id=<?php echo $reserva->rowid?>";
    window.open(url, '_blank', 'height=400,width=400');
    
    
                  }



      
                    function enviar_whatsapp_ventana(id){
                      
                              boton_Cerrar = ' <button type="button" class="btn btn-dark" data-dismiss="modal">Cerrar</button>';
                          boton_enviar_whatsapp = '<button type="button" onclick="enviar_whatsapp();" class="btn btn-success">Enviar</button>';


                    titulo = '<strong>Enviar reserva por WhatsApp</strong>';
                    accion = (id == 'nuevo') ? 'crear_servicio' : 'editar_servicio';
                    titulo_boton = (id == 'nuevo') ? 'Guardar Nuevo' : 'Editar Boleto';

                    $("#modal_titulo").empty().html(titulo);
                    $("#modal_body").addClass('borroso');

                    $.ajax({
                      type: "POST",
                      url: "<?php echo ENLACE_WEB ?>mod_medida_cctravel_reservas/ajax/enviar_whatsapp_ventana.php",
                      data: {
                        "cotizacion": '<?php echo $cotizacion->rowid; ?>',
                        "id": id,
                        "accion": accion,

                      },
                      success: function(html) {
                        $("#modal_body").empty().html(html).removeClass('borroso');;
                        $("#modal_completo").modal('show');


                        $("#modal_footer").empty().html(boton_Cerrar+boton_enviar_whatsapp);


                      }
                    });
                  
                  }


</script>


<!-- Modal clientes -->
<div class="modal fade" id="modal_cliente" tabindex="-1" role="dialog" aria-labelledby="modalLabelLarge" aria-hidden="true">

</div>


<!-- The modal -->
<div class="modal fade" id="modal_completo" tabindex="-1" role="dialog" aria-labelledby="modalLabelLarge" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>

        <h3 class="modal-title" id="modal_titulo"></h3>
      </div>
      <div class="modal-body" id="modal_body"></div>

      <div class="modal-footer" id="modal_footer">
        <button type="button" class="btn btn-dark" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>