<?php


class SitioTuristico
{
    // Atributos que representan las columnas de la tabla
    public $rowid;
    public $tipo;
    public $nombre;
    public $descripcion;
    public $fk_estado;
    public $creado_fecha;
    public $creado_fk_usuario;
    public $borrado;
    public $borrado_fecha;
    public $borrado_fk_usuario;

    // Constructor que recibe la conexión a la base de datos
    public function __construct(PDO $db)
    {
        $this->db = $db;
    }

    // Función para obtener un registro por ID
    public function fetch($id)
    {
        $query = "SELECT tu.*, 
        pais.paisnombre,
        fu.usuario,
        estado.estadonombre,
        tipo.etiqueta as tipo_etiqueta,
        tipo.color as tipo_color, 
        tipo.icono as tipo_icono 
        FROM a_medida_cctravel_sitios_turisticos tu 
        left join  facturac_Licencias.pais pais on pais.id = tu.direccion_fk_pais
        left join  facturac_Licencias.estado estado on estado.id = tu.direccion_fk_estado
        left join a_medida_cctravel_sitios_turisticos_diccionarios   tipo on tipo.rowid   = tu.tipo
        LEFT JOIN fi_usuarios                                         fu  on fu.rowid     = tu.creado_fk_usuario
        WHERE tu.rowid = :id";
        $stmt = $this->db->prepare($query);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();

        // Fetch asociativo para obtener los resultados
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        // Volcar cada columna en el atributo correspondiente del objeto
        $this->rowid = $result['rowid'];
        $this->tipo = $result['tipo'];
        $this->nombre = $result['nombre'];
        $this->descripcion = $result['descripcion'];
        $this->fk_estado = $result['fk_estado'];
        $this->creado_fecha = $result['creado_fecha'];
        $this->creado_fk_usuario = $result['creado_fk_usuario'];
        $this->borrado = $result['borrado'];
        $this->borrado_fecha = $result['borrado_fecha'];
        $this->borrado_fk_usuario = $result['borrado_fk_usuario'];
        $this->paisnombre = $result['paisnombre'];
        $this->tipo_color = $result['tipo_color'];
        $this->tipo_icono = $result['tipo_icono'];
        $this->tipo_etiqueta = $result['tipo_etiqueta'];
        $this->contacto_nombre = $result['contacto_nombre'];
        $this->contacto_correo = $result['contacto_correo'];
        $this->contacto_telefono = $result['contacto_telefono'];
        $this->usuario = $result['usuario'];
        $this->activo = $result['activo'];
        $this->tags = $result['tags'];
        $this->img_path = $result['img_path'];
        $this->direccion_fk_pais = $result['direccion_fk_pais'];
        $this->direccion_fk_estado = $result['direccion_fk_estado'];
        $this->estadonombre = $result['estadonombre'];
        
        
    }
    
    
          public function fetch_servicio($id)
                {
                    $query = "SELECT cs.*, c.nombre as nombre_sitio 
                    FROM a_medida_cctravel_sitios_turisticos_servicios cs 
                    left JOIN a_medida_cctravel_sitios_turisticos c on c.rowid = cs.fk_centro 
                    WHERE cs.rowid = ?";
                    $stmt = $this->db->prepare($query);
                    $stmt->bindParam(1, $id);
                    $stmt->execute();
                    $row = $stmt->fetch(PDO::FETCH_ASSOC);
                    $this->rowid_servicio = $row['rowid'];
                    $this->fk_cotizacion = $row['fk_cotizacion'];
                    $this->fk_centro = $row['fk_centro'];
                    $this->nombre_sitio = $row['nombre_sitio'];
                    $this->codigo = $row['codigo'];
                    $this->comentario = $row['comentario'];
                    $this->fk_servicio = $row['fk_servicio'];
                     $this->fk_icono = $row['fk_icono'];
                    $this->activo = $row['activo'];
                    $this->precio = $row['precio'];
                    $this->moneda = $row['moneda'];
                    $this->descuento = $row['descuento'];
                    $this->precio_final = $row['precio_final'];
                    $this->creado_fk_usuario = $row['creado_fk_usuario'];
                    $this->creado_fecha = $row['creado_fecha'];
                    $this->borrado = $row['borrado'];
                    $this->borrado_fecha = $row['borrado_fecha'];
                     $this->nombre_servicio = $row['nombre_servicio'];
                      $this->nombre_sitio = $row['nombre_sitio'];
                    $this->borrado_fk_usuario = $row['borrado_fk_usuario'];
                }


  public function actualizarServicio()
                {
                   
                     
                    $query = "UPDATE a_medida_cctravel_sitios_turisticos_servicios
                        
                          set
                              comentario = :comentario,
                               codigo = :codigo,
                              nombre_servicio = :nombre_servicio,
                              activo = :activo,
                              precio = :precio,
                              moneda = :moneda,
                                fk_icono = :fk_icono,
                              descuento = :descuento,
                              precio_final = :precio_final
                            
                              WHERE rowid = :rowid";
                
                    $stmt = $this->db->prepare($query);
                
            
                    $stmt->bindParam(':rowid', $this->rowid, PDO::PARAM_STR);
            $stmt->bindParam(':codigo', $this->codigo, PDO::PARAM_STR);
                
                    $stmt->bindParam(':comentario', $this->comentario, PDO::PARAM_STR);
                    $stmt->bindParam(':nombre_servicio', $this->nombre_servicio, PDO::PARAM_STR);
                    $stmt->bindParam(':activo', $this->activo, PDO::PARAM_INT);
                    $stmt->bindParam(':precio', $this->precio, PDO::PARAM_STR);
                    $stmt->bindParam(':moneda', $this->moneda, PDO::PARAM_STR);
                    $stmt->bindParam(':descuento', $this->descuento, PDO::PARAM_STR);
                     $stmt->bindParam(':fk_icono', $this->fk_icono, PDO::PARAM_STR);
                    $stmt->bindParam(':precio_final', $this->precio_final, PDO::PARAM_STR);
             
                  
                
                    $accion = $stmt->execute();
                    
                    
                
               return $accion;
               
               
                }
    
     public function traerServicios($id)
    {
         try{
        $query = "SELECT tu.*, fp.label as nombre_servicio_label, fu.usuario as usuario_asignado, di.clase as icono 
        FROM a_medida_cctravel_sitios_turisticos_servicios tu 
         LEFT JOIN fi_usuarios fu  on fu.rowid     = tu.creado_fk_usuario
         LEFT JOIN fi_productos fp  on fp.rowid     = tu.fk_servicio
         LEFT JOIN a_medida_cctravel_diccionario_iconos di  on di.rowid = tu.fk_icono
            
        where tu.fk_centro = :id   AND tu.borrado = 0
       ";
        $stmt = $this->db->prepare($query);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();

        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $result;
        
         }catch(PDOException $e){

           return $e;
        }

    }
    
    
    
      public function diccionario_pais()
    {
         try{
        $query = "SELECT * FROM facturac_Licencias.pais order by paisnombre ASC";
        $stmt = $this->db->prepare($query);
        $stmt->execute();

        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $result;
        
         }catch(PDOException $e){

           return $e;
        }

    }
    
        public function obtenerSitios()
    {
         try{
        $query = "SELECT rowid, nombre FROM facturac_sistema_GeNeRaL.a_medida_cctravel_sitios_turisticos where activo = 1 AND entidad = 7";
        $stmt = $this->db->prepare($query);
        $stmt->execute();

        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $result;
        
         }catch(PDOException $e){

           return $e;
        }

    }
    
    
         public function obtenerServicios($id)
    {
        $entidad = $_SESSION['Entidad'];
         try{
        $query = "SELECT * FROM fi_productos WHERE entidad = $entidad";
        $stmt = $this->db->prepare($query);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        return $result;
        
         }catch(PDOException $e){

           return $e;
        }

    }
    
    
    public function eliminarServicioLogico()
{
    $sql = "";

    try {
        // QUERY
        $sql = "UPDATE a_medida_cctravel_sitios_turisticos_servicios
                SET borrado = 1, 
                borrado_fecha = NOW(), 
                borrado_fk_usuario = :borrado_fk_usuario
                WHERE rowid = :rowid";
        $db = $this->db->prepare($sql);
        $db->bindValue(":rowid", $this->rowid, PDO::PARAM_INT);
        $db->bindValue(":borrado_fk_usuario", $this->borrado_fk_usuario, PDO::PARAM_INT);
        $result = $db->execute();
        // RETURN
        return 1;
    } catch(PDOException $e) {
        return $e;
    }
}
   
      public function guardarAdjunto()
    {
        $sql="";


        try{

            // QUERY
            $sql = "UPDATE a_medida_cctravel_sitios_turisticos SET attach_patch =:attach_patch WHERE rowid =:rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $this->rowid, PDO::PARAM_INT);
            $db->bindValue(":attach_patch", $this->attach_patch, PDO::PARAM_STR);
            $result = $db->execute();
            // RETURN
            return 1;

        }catch(PDOException $e){

           return $e;
        }
    }
   
    public function cambiarEstatus($activo)
    {
        $sql="";


        try{

            // QUERY
            $sql = "UPDATE a_medida_cctravel_sitios_turisticos SET activo =:activo WHERE rowid =:rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $this->rowid, PDO::PARAM_INT);
            $db->bindValue(":activo", $activo, PDO::PARAM_INT);
            $result = $db->execute();
            // RETURN
            return 1;

        }catch(PDOException $e){

           return $e;
        }
    }

    
    
    
    
    /*
    *           
    *       Creando funcion Inser 
    *       Todo esto utilizando IA  
    */
    
    // Función para insertar un nuevo registro
    public function crear_sitio_turistico()
    {
        $query = "INSERT INTO a_medida_cctravel_sitios_turisticos 
SET tipo = :tipo, 
    nombre = :nombre, 
    descripcion = :descripcion, 
    activo = :activo, 
    creado_fecha = NOW(), 
    creado_fk_usuario = :creado_fk_usuario,
    entidad = :entidad,
    img_path = :img_path,
            tags = :tags    ,
     contacto_nombre = :contacto_nombre,
       contacto_correo = :contacto_correo,
                          contacto_telefono = :contacto_telefono,
                           direccion_fk_pais     =:direccion_fk_pais,
                              direccion_fk_estado     =:direccion_fk_estado";

        $stmt = $this->db->prepare($query);
        // Bind de cada parámetro
        $stmt->bindValue(':tipo', $this->tipo, PDO::PARAM_STR);
        $stmt->bindValue(':nombre', $this->nombre, PDO::PARAM_STR);
        $stmt->bindValue(':descripcion', $this->descripcion, PDO::PARAM_STR);
        $stmt->bindValue(':activo', $this->activo, PDO::PARAM_INT);
         $stmt->bindValue(':creado_fk_usuario', $this->creado_fk_usuario, PDO::PARAM_INT);
         $stmt->bindValue(':img_path', $this->img_path, PDO::PARAM_STR);
         $stmt->bindValue(':entidad', $this->entidad, PDO::PARAM_STR);
         $stmt->bindValue(':tags'     , $this->tags    , PDO::PARAM_STR);
         $stmt->bindValue(':contacto_nombre'     , $this->contacto_nombre    , PDO::PARAM_STR);
         $stmt->bindValue(':contacto_correo'     , $this->contacto_correo    , PDO::PARAM_STR);
         $stmt->bindValue(':contacto_telefono'   , $this->contacto_telefono  , PDO::PARAM_STR);
        $stmt->bindValue(':direccion_fk_pais'   , $this->direccion_fk_pais  , PDO::PARAM_STR);
        $stmt->bindValue(':direccion_fk_estado'   , $this->direccion_fk_estado  , PDO::PARAM_STR);
        // Ejecutar la consulta
        $result = $stmt->execute();

        // Verificar si hubo errores
        if (!$result) {
            return [
                'error' => 1,
                'error_txt' => $stmt->errorInfo()[2]  // Obtener el mensaje de error de la BD
            ];
        }

        // Obtener el ID generado
        $this->rowid = $this->db->lastInsertId();

        return [
            'error' => 0,
            'id' => $this->rowid
        ];
    } // fin del If 
    
    
   


    public function actualizar_sitio_turistico( ){
                $query = "update 
                            a_medida_cctravel_sitios_turisticos 
                            set 
                            nombre      = :nombre,
                           descripcion = :descripcion,
                          tipo = :tipo,
                          activo = :activo,
                          contacto_correo = :contacto_correo,
                          contacto_telefono = :contacto_telefono,
                           img_path = :img_path,
                          contacto_nombre = :contacto_nombre    ,
                           tags = :tags    ,
             
                   
                            direccion_fk_pais     =:direccion_fk_pais,
                              direccion_fk_estado     =:direccion_fk_estado
                          
                        
                            where rowid = :rowid 
                        ";

        $stmt = $this->db->prepare($query);
        // Bind de cada parámetro
        $stmt->bindValue(':rowid'       , $this->rowid      , PDO::PARAM_INT);
        $stmt->bindValue(':nombre'      , $this->nombre     , PDO::PARAM_STR);
        $stmt->bindValue(':descripcion' , $this->descripcion, PDO::PARAM_STR);
        $stmt->bindValue(':tipo'                , $this->tipo               , PDO::PARAM_INT);
        $stmt->bindValue(':activo'              , $this->activo             , PDO::PARAM_INT);
        $stmt->bindValue(':contacto_correo'     , $this->contacto_correo    , PDO::PARAM_STR);
        $stmt->bindValue(':tags'     , $this->tags    , PDO::PARAM_STR);
        $stmt->bindValue(':contacto_telefono'   , $this->contacto_telefono  , PDO::PARAM_STR);
        $stmt->bindValue(':contacto_nombre'     , $this->contacto_nombre    , PDO::PARAM_STR);
        $stmt->bindValue(':img_path'   , $this->img_path  , PDO::PARAM_STR);
        $stmt->bindValue(':direccion_fk_pais'   , $this->direccion_fk_pais  , PDO::PARAM_STR);
        $stmt->bindValue(':direccion_fk_estado'   , $this->direccion_fk_estado  , PDO::PARAM_STR);

        
        $result = $stmt->execute();

        // Verificar si hubo errores
        if (!$result) {
                    return [
                        'error' => 1,
                        'error_txt' => $stmt->errorInfo()[2]  // Obtener el mensaje de error de la BD
                    ];
        } else {
            
                return [
                    'error' => 0,
                    'id' => $this->rowid
                ];
        }
        
    } // fin de la Function
    
    
    
       // Función para insertar un nuevo servicio
    public function guardarServicio()
    {
        $query = "INSERT INTO a_medida_cctravel_sitios_turisticos_servicios 
                  SET fk_centro = :fk_centro, 
                  codigo = :codigo,
                  comentario = :comentario,
                  nombre_servicio = :nombre_servicio,
                  precio = :precio,
                    descuento = :descuento,
                      precio_final = :precio_final,
                  moneda = :moneda,
                  creado_fk_usuario = :creado_fk_usuario,
                  creado_fecha = now(),
                  fk_icono = :fk_icono";

        $stmt = $this->db->prepare($query);
        // Bind de cada parámetro
        $stmt->bindValue(':fk_centro', $this->fk_centro, PDO::PARAM_STR);
        $stmt->bindValue(':codigo', $this->codigo, PDO::PARAM_STR);
        $stmt->bindValue(':comentario', $this->comentario, PDO::PARAM_STR);
        $stmt->bindValue(':nombre_servicio', $this->nombre_servicio, PDO::PARAM_INT);
        $stmt->bindValue(':precio', $this->precio, PDO::PARAM_STR);
        $stmt->bindValue(':descuento', $this->descuento, PDO::PARAM_STR);
        $stmt->bindValue(':precio_final', $this->precio_final, PDO::PARAM_STR);
        $stmt->bindValue(':moneda', $this->moneda, PDO::PARAM_INT);
        $stmt->bindValue(':creado_fk_usuario', $_SESSION['usuario'], PDO::PARAM_INT);
        $stmt->bindValue(':fk_icono', $this->fk_icono, PDO::PARAM_INT);
 
        // Ejecutar la consulta
        $result = $stmt->execute();
    

        // Verificar si hubo errores
        if (!$result) {
            return [
                'error' => 1,
                'error_txt' => $stmt->errorInfo()[2]  // Obtener el mensaje de error de la BD
            ];
        }

        // Obtener el ID generado
        $this->rowid = $this->db->lastInsertId();

        return [
            'error' => 0,
            'id' => $this->rowid
        ];
    } // fin del If 
    
    public function diccionarioIconos()
    {
            $sql = "SELECT * FROM a_medida_cctravel_diccionario_iconos ORDER BY descripcion ASC;";
            $db  = $this->db->prepare($sql);
            $db->execute();
            
            $result = $db->fetchAll(PDO::FETCH_ASSOC);
            // RETURN
            return $result;
        }
        
        
            public function traerRegiones($fk_pais)
    {
            $sql = "SELECT * FROM facturac_Licencias.estado WHERE ubicacionpaisid = $fk_pais order by estadonombre ASC";
            $db  = $this->db->prepare($sql);
            $db->execute();
            
            $result = $db->fetchAll(PDO::FETCH_ASSOC);
            // RETURN
            return $result;
        }

} // fin de la clase 
 