<?php
require_once('../../conf/conf.php');
session_start();    
// VALID DEFINITION
$rowid = (!is_null($_POST['rowid']))? $_POST['rowid'] : 'null';
// VALID DEFINITION REQUEST ID
$title   = (($rowid) != 'null')? 'Modificación del Permiso' : 'Ingreso del Permiso';
?>
<div class="pcoded-inner-content">
    <div class="card-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <center><h4 class="strong"><?php echo $title; ?></h4></center>
    </div>
    <div class="card-body" id="bar-parent">
        <form class="form-horizontal" action="" novalidate="novalidate">
            <div class="form-body">
                <!-- NAME -->
                <div class="form-group row">
                    <label class="control-label col-md-4">Nombre
                        <span class="required" aria-required="true"> * </span>
                    </label>
                    <div class="col-md-7">
                        <input type="text" id="name" data-required="1" placeholder="Nombre" class="form-control input-height" value="" required="required"> 
                    </div>
                </div>
                <!-- TYPE -->
                <div class="form-group row">
                    <label class="control-label col-md-4">Tipo
                        <span class="required" aria-required="true"> * </span>
                    </label>
                    <div class="col-md-7">
                        <select class="form-control input-height" id="type" required="required">                        
                        <option value="ver">Ver</option>
                        <option value="insertar">Insertar</option>
                        <option value="modificar">Modificar</option>
                        <option value="eliminar">Eliminar</option>  
                      </select>
                    </div>
                </div>
                <!-- MODULE -->
                <div class="form-group row">
                    <label class="control-label col-md-4">Módulo
                        <span class="required" aria-required="true"> * </span>
                    </label>
                    <div class="col-md-7">
                        <select class="form-control input-height" id="module" required="required">                        
                        <?php
                        // QUERY
                        $sql = "SELECT rowid, nombre FROM fi_usuarios_modulos WHERE activo = 1 ORDER BY nombre;";
                        $db = $dbh->prepare($sql);
                        $db->execute();                                                             
                        // RUN RECORDS
                        while ($data = $db->fetch(PDO::FETCH_OBJ)):
                            echo '<option value="'.$data->rowid.'">'.$data->nombre.'</option>';
                        endwhile;
                        ?> 
                      </select>
                    </div>
                </div>
                <!-- NAME -->
                <div class="form-group row">
                    <label class="control-label col-md-4">Descripción</label>
                    <div class="col-md-7">
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-info-circle"></i></span>
                            <textarea id="description" placeholder="Descripción" class="form-control-textarea" rows="5"></textarea>
                        </div>
                </div>
            </div>
        </form>
    </div>
    <div class="form-actions">
        <div class="row">
            <div class="offset-md-4 col-md-12">
                <!-- SAVE -->
                <button class="btn btn-info" onclick="saveInfoPermission(<?php echo $rowid; ?>)">Guardar</button>
                <!-- CLOSE -->
                <button class="btn btn-default" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>


<!-- SCRIPT -->
<script type="text/javascript">
    // OPTION READY WINDOW
    $(document).ready(function() {
        var rowid = <?php echo $rowid; ?>;
        // // VALID DEFINITION
        if ((rowid) != null)
          loadInfoPermission(rowid);
    });
    // FUNCTION LOAD INFO PERMISSION
    function loadInfoPermission(rowid){
        // POST
        $.ajax({
            method: "POST",
            url: ENLACE_WEB+"mod_permisos/class/clases.php",
            beforeSend: function(xhr) { },
            data: 
            {  
                action : 'loadInfoPermission',
                rowid  : rowid
            },
        }).done(function(data) {
            data = JSON.parse(data);
            $("#name").val(data.name);
            $("#type").val(data.type);            
            $("#module").val(data.module);
            $('#description').val(data.description);
        });
    }
    // FUNCION VALID INFO FILEDS
    function validInfoPermiso(){
        var action = true;
        // VALID FIELDS
        if (action && ($('#name').val() == '')){  
          msj_alert('Debe definir la información del nombre.');
          action = false;
        }
        // VALID FIELDS
        if (action && ($('#type').val() == '')){  
          msj_alert('Debe definir la información del tipo.');
          action = false;
        }
        // VALID FIELDS
        if (action && ($('#module').val() == '')){  
          msj_alert('Debe definir la información del módulo.');
          action = false;
        }
        return action;
    }
   
    // FUNCTION SAVE INFO PERMISSION
    function saveInfoPermission(rowid){
        // VALID FIELDS
        if (validInfoPermiso()){
            // POST
            $.ajax({
                method: "POST",
                url: ENLACE_WEB+"mod_permisos/class/clases.php",
                beforeSend: function(xhr) { },
                data: 
                {  
                    action          : 'saveInfoPermission',
                    rowid           : rowid,                    
                    name            : $("#name").val(),
                    type            : $("#type").val(),
                    module          : $("#module").val(),
                    description     : $("#description").val()
                },
            }).done(function(result) {
                // VALID RESULT
                if (result){                
                    location.href = ENLACE_WEB+"permisos";
                    $.notify("Proceso de guardar la información del permiso, realizado con éxito.","success");
                } else
                    $.notify("Se presento un error en proceso de guarda la información del permiso.", "warn");
            });         
        }
    }
</script>