<?php
 
require_once ENLACE_SERVIDOR . "global/object/log.sistema.php";

class permiso extends log_sistema
{
    private $db;
    public $rowid;
    public $tipo;
    public $fk_modulo;
    public $nombre;
    public $descripcion;
    public $activo;

    public function __construct($db)
    {
        $this->db = $db;
        parent::__construct($db);
        $this->file=basename(__FILE__);
    }
 
    // FUNCTION FECTH
    public function fetch($rowid)
    {
        $sql="";
        $process = "Consultar los Permisos del Usuario";

        try{

            $sql = "SELECT rowid, tipo, fk_modulo, nombre, descripcion, activo FROM fi_usuarios_permisos WHERE rowid =: rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
            $db->execute();
            $data              = $db->fetch(PDO::FETCH_ASSOC);
            $this->rowid       = $data['rowid'];
            $this->tipo        = $data['tipo'];
            $this->fk_modulo   = $data['fk_modulo'];
            $this->nombre      = $data['nombre'];
            $this->descripcion = $data['descripcion'];
            $this->activo      = $data['activo'];

        //Registros en log success
        $record  = $rowid;
        $detail  =  'Registro ' . $record . ' consultado en la tabla fi_usuarios_permisos';
        $this->log_success(basename($this->file),$record,$process,$detail);
        
        }catch(PDOException  $e){
            //Registros en log error
            $this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process);
            return 0;    
            //0=error
        }
    }
    

    // FUNCTION GET INFO DATA
    /*
    public function loadArrayDatas($rowid)
    {
        $array = array();
        $sql   = "SELECT rowid, tipo, fk_modulo, nombre, descripcion, activo FROM fi_usuarios_permisos WHERE rowid =: rowid;";
        $db    = $this->db->prepare($sql);
        $db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
        $db->execute();
        $data  = $db->fetch(PDO::FETCH_ASSOC);
        $array = array(
            'rowid'       => $data['rowid'],
            'type'        => $data['tipo'],
            'module'      => $data['fk_modulo'],
            'name'        => $data['nombre'],
            'description' => $data['descripcion'],
        );
        // RETURN ARRAY
        return $array;
    }*/

    // FUNCTION SAVE INFO DATA
    public function saveInfoData()
    {
        $sql="";
        $process = (strlen($this->rowid) == 0) ? 'Ingreso del Registro Permisos' : 'Actualización del Registro Permisos';

    
        try{
        
            // COLUMNS
            $columns = "tipo =:tipo, fk_modulo =:fk_modulo, nombre =:nombre, descripcion =:descripcion";
            // QUERY
            $sql = (strlen($this->rowid) == 0) ? "INSERT INTO fi_usuarios_permisos SET " . $columns : "UPDATE fi_usuarios_permisos SET " . $columns . " WHERE rowid =:rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":tipo", $this->tipo, PDO::PARAM_INT);
            $db->bindValue(":fk_modulo", $this->fk_modulo, PDO::PARAM_INT);
            $db->bindValue(":nombre", $this->nombre, PDO::PARAM_STR);
            $db->bindValue(":descripcion", $this->descripcion, PDO::PARAM_STR);
            // VALID DEFINITION DOCTOR
            if (strlen($this->rowid) > 0):
                $db->bindValue(":rowid", $this->rowid, PDO::PARAM_INT);
            endif;
            // EXECUTE
            $result = $db->execute();

            //Registros en log success
            $record  = $this->rowid;
            $detail  = (strlen($this->rowid) == 0) ? 'Registro ' . $record . ' insertado en la tabla fi_usuarios_permisos' : 'Registro ' . $record . ' actualizado en la tabla fi_usuarios_permisos';
            $this->log_success($this->file,$record,$process,$detail);

            // RETURN
            return $result;

        }catch(PDOException $e){

            $this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
            return 0;
        }
    }

    // FUNCTION CHANGE STATUS PROFILE
    public function changeStatus($status)
    {
        $sql="";
        $process = "Actualización del Estado en el Registro Permisos";
    
        try{
            // QUERY
            $sql = "UPDATE fi_usuarios_permisos SET activo =:activo WHERE rowid =:rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $this->rowid, PDO::PARAM_INT);
            $db->bindValue(":activo", $status, PDO::PARAM_INT);
            $result = $db->execute();

            //Registros en log success
            $record  = $this->rowid;
            $detail  = 'Registro ' . $record . ' actualizado en la tabla fi_usuarios_permisos';
            $this->log_success($this->file,$record,$process,$detail);

            // RETURN
            return $result;
        }catch(PDOException $e){

            $this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
            return 0;
        }
    }

    // FUNCTION GET RECORD USER PROFILE
    public function getRecordProfilePermission($profile, $permission)
    {
        $sql="";
        $process = "Consulatr en el Registro Perfil y Permiso";
    
        try{
       
            // QUERY
            $sql    = "SELECT rowid FROM fi_usuarios_perfiles_permisos WHERE fk_perfil =" . $profile . " AND fk_permiso =" . $permission . " LIMIT 1;";
            $db     = $this->db->prepare($sql);
            $result = $db->execute();
            $data   = $db->fetch(PDO::FETCH_ASSOC);
            $rowid  = (($data) != '') ? $data['rowid'] : '';

            //Registros en log success
            $record  = $rowid;
            $detail  = 'Registro ' . $record . '  actualizado en la tabla fi_usuarios_perfiles_permisos';
         //   $this->log_success($this->file,$record,$process,$detail);

            // RETURN
            return $rowid;
        
        }catch(PDOException $e){

         //   $this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
            return 0;
        }
        
    }

    // FUNCTION DEFINITION PROFILE PERMISSION
    public function definitioProfilePermission($profile, $permission, $status)
    {   
         
        $sql="";
        $process = "Actualización del Estado en el Registro Perfil Permiso";
    
        try{

            // FUNCTION GET RECORD USER PROFILE
            $rowid = $this->getRecordProfilePermission($profile, $permission);
            // VALID ROWID
            $columns = "fk_perfil =:fk_perfil, fk_permiso =:fk_permiso, activo =:activo";
            // QUERY
            $sql = (strlen($rowid) == 0) ? "INSERT INTO fi_usuarios_perfiles_permisos SET " . $columns : "UPDATE fi_usuarios_perfiles_permisos SET " . $columns . " WHERE rowid =:rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":fk_perfil", $profile, PDO::PARAM_INT);
            $db->bindValue(":fk_permiso", $permission, PDO::PARAM_INT);
            $db->bindValue(":activo", $status, PDO::PARAM_INT);
            // VALID DEFINITION
            if (strlen($rowid) > 0):
                $db->bindValue(":rowid", $rowid, PDO::PARAM_INT);
            endif;
            // EXECUTE
            $result = $db->execute();

            //Registros en log success
            $record  = $rowid;
            $detail  = 'Registro ' . $record . ' actualizado en la tabla fi_usuarios_perfiles_permisos';
           // $this->log_success($this->file,$record,$process,$detail);


            // RETURN
            return 1;
        }catch(PDOException $e){

        //    $this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
            return 0;
        }
        
       
        
    }
}
 